/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import javax.baja.units.BUnit;

public class Property {
    private Group group_ref = null;
    private int group_id = -1;
    private EasSession session;
    private boolean removed;
    private String name;
    private String value;
    private double nvalue;
    private String vtype;
    private String vunit;

    public Property() {
    }

    public Property(Group group, String string, String string2, String string3, String string4) {
        this.setGroupField(group);
        this.name = string;
        this.value = string2;
        this.nvalue = 0.0;
        this.vtype = string3;
        this.vunit = string4;
        this.session = group.getSession();
    }

    public Property(Group group, String string, double d, String string2, String string3) {
        this.setGroupField(group);
        this.name = string;
        this.nvalue = d;
        this.vtype = string2;
        this.vunit = string3;
        this.session = group.getSession();
    }

    public Property(int n, String string, String string2, double d, String string3, String string4, EasSession easSession) {
        this.setGroupField(n);
        this.name = string;
        this.value = string4 == null || string4.equals("null") ? string2 : null;
        this.nvalue = d;
        this.vtype = string3;
        this.vunit = string4;
        this.session = easSession;
    }

    public Property(Group group, String string, String string2, double d, String string3, String string4) {
        this.setGroupField(group);
        this.name = string;
        this.value = string4 == null || string4.equals("null") ? string2 : null;
        this.nvalue = d;
        this.vtype = string3;
        this.vunit = string4;
        this.session = group.getSession();
    }

    public Group getGroup() throws EasException {
        if (this.group_ref != null) {
            return this.group_ref;
        }
        if (this.group_id != -1) {
            this.group_ref = Group.get(this.group_id, this.session);
        }
        return this.group_ref;
    }

    public int getGroupId() throws EasException {
        return this.group_id;
    }

    public void setGroup(Group group) throws EasException {
        if (group != null) {
            group.addProperty(this);
        } else {
            this.setGroupField(group);
        }
    }

    public void setGroup(Group group, Property property) {
        this.setGroupField(group);
    }

    public String getName() {
        this.assertValid();
        return this.name;
    }

    public String getValue() {
        this.assertValid();
        if (this.vunit == null || this.vunit.equals("null")) {
            return this.value;
        }
        return Double.toString(this.nvalue);
    }

    public double getDouble() {
        this.assertValid();
        return this.nvalue;
    }

    public String getType() {
        this.assertValid();
        return this.vtype;
    }

    public String getUnit() {
        this.assertValid();
        return this.vunit;
    }

    public BUnit getUnitObject() {
        this.assertValid();
        return BUnit.getUnit((String)this.getUnit());
    }

    public void setValue(String string) throws EasException {
        this.assertValid();
        string = string.trim();
        if (string == null && this.value != null || !string.equals(this.value)) {
            this.value = string;
            if (this.getGroup() != null) {
                this.getGroup().changeProperty(this);
            }
        }
    }

    public void setValue(double d) throws EasException {
        this.assertValid();
        if (this.nvalue != d) {
            this.nvalue = d;
            if (this.getGroup() != null) {
                this.getGroup().changeProperty(this);
            }
        }
    }

    public void setVType(String string) throws EasException {
        this.assertValid();
        if (this.vtype == null || !this.vtype.equals(string)) {
            this.vtype = string;
            if (this.getGroup() != null) {
                this.getGroup().changeProperty(this);
            }
        }
    }

    public void setUnit(String string) throws EasException {
        this.assertValid();
        if (!this.vunit.equals(string)) {
            this.vunit = string;
            if (this.getGroup() != null) {
                this.getGroup().changeProperty(this);
            }
        }
    }

    private void assertValid() throws IllegalStateException {
    }

    private void setGroupField(Group group) {
        if (group != null) {
            if (this.group_id != group.getId()) {
                this.group_ref = group;
                this.group_id = group.getId();
            }
        } else {
            this.group_ref = null;
            this.group_id = -1;
        }
    }

    private void setGroupField(int n) {
        if (this.group_id != n) {
            this.group_ref = null;
            this.group_id = n;
        }
    }
}

