/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataPointExec;
import com.tridium.eas.api.DynGroupExec;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.GroupExec;
import com.tridium.eas.api.MeterExec;
import com.tridium.eas.xml.XmlMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import javax.baja.user.BUser;

public abstract class EasSession {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ACCESS_DENIED = 1;
    public static final int STATUS_RESOURCE_NOT_FOUND = 2;
    public static final int STATUS_CONNECTION_FAILED = 3;
    private String serverDebugTag;
    private Random rand = new Random();

    public abstract int open() throws IOException;

    public abstract void close();

    public abstract GroupExec getGroupExec();

    public abstract DynGroupExec getDynGroupExec();

    public abstract DataPointExec getDataPointExec();

    public abstract MeterExec getMeterExec();

    public abstract BUser getUser();

    public abstract String getUserName();

    public abstract boolean hasAdminRead();

    public abstract boolean hasAdminWrite();

    public abstract boolean hasOperatorRead();

    public abstract boolean hasOperatorWrite();

    public int getNewId() {
        int n = 0;
        while (n > -2 && n < 2) {
            n = this.rand.nextInt();
        }
        return -Math.abs(n);
    }

    public EasObject get(EasObject easObject) {
        return easObject;
    }

    public void remove(EasObject easObject) {
    }

    public EasObject cached(EasObject easObject) {
        return null;
    }

    public void clear() {
    }

    public OutputStream put(String string) throws IOException {
        throw new IllegalStateException("Unsupported in " + this.getClass().getName());
    }

    public InputStream get(String string) throws IOException {
        throw new IllegalStateException("Unsupported in " + this.getClass().getName());
    }

    public String getText(String string) throws IOException {
        throw new IllegalStateException("Unsupported in " + this.getClass().getName());
    }

    public XmlMessage sendRequest(XmlMessage xmlMessage) {
        throw new IllegalStateException("Unsupported in " + this.getClass().getName());
    }

    public void setServerDebugTag(String string) {
        this.serverDebugTag = string;
    }

    public String getServerDebugTag() {
        return this.serverDebugTag;
    }

    public boolean isServerDebugEnabled() {
        return this.serverDebugTag != null;
    }
}

