/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DataPointExec;
import com.tridium.eas.api.DynGroupExec;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.GroupExec;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.MeterExec;
import com.tridium.eas.xml.XmlMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.baja.user.BUser;

public class EasCachedSession
extends EasSession {
    private EasSession session;
    private Hashtable allgroups = new Hashtable();
    private Hashtable alldatapoints = new Hashtable();
    private Hashtable allmeters = new Hashtable();

    public EasCachedSession(EasSession easSession) {
        this.session = easSession;
    }

    public int open() throws IOException {
        return this.session.open();
    }

    public void close() {
        this.session.close();
    }

    public GroupExec getGroupExec() {
        return this.session.getGroupExec();
    }

    public DynGroupExec getDynGroupExec() {
        return this.session.getDynGroupExec();
    }

    public DataPointExec getDataPointExec() {
        return this.session.getDataPointExec();
    }

    public MeterExec getMeterExec() {
        return this.session.getMeterExec();
    }

    public BUser getUser() {
        return this.session.getUser();
    }

    public final String getUserName() {
        return this.session.getUserName();
    }

    public final boolean hasAdminRead() {
        return this.session.hasAdminRead();
    }

    public final boolean hasAdminWrite() {
        return this.session.hasAdminWrite();
    }

    public final boolean hasOperatorRead() {
        return this.session.hasOperatorRead();
    }

    public final boolean hasOperatorWrite() {
        return this.session.hasOperatorWrite();
    }

    public int getNewId() {
        return this.session.getNewId();
    }

    public EasObject cached(EasObject easObject) {
        if (!easObject.isTemporary()) {
            Hashtable hashtable = this.getCache(easObject);
            if (hashtable == null) {
                return null;
            }
            return (EasObject)hashtable.get(easObject);
        }
        return null;
    }

    public void remove(EasObject easObject) {
        Hashtable hashtable = this.getCache(easObject);
        if (hashtable == null) {
            return;
        }
        hashtable.remove(easObject);
    }

    public EasObject get(EasObject easObject) {
        if (easObject == null || easObject.isTemporary() || !easObject.isInitialized()) {
            return easObject;
        }
        EasObject easObject2 = null;
        Hashtable hashtable = this.getCache(easObject);
        if (hashtable == null) {
            return easObject;
        }
        easObject2 = (EasObject)hashtable.get(easObject);
        if (easObject2 == null) {
            hashtable.put(easObject, easObject);
            easObject2 = easObject;
        }
        return easObject2;
    }

    public void clear() {
        this.allgroups.clear();
        this.alldatapoints.clear();
        this.allmeters.clear();
    }

    private Hashtable getCache(EasObject easObject) {
        Hashtable hashtable = null;
        if (easObject instanceof Group) {
            hashtable = this.allgroups;
        }
        if (easObject instanceof DataPoint) {
            hashtable = this.alldatapoints;
        }
        if (easObject instanceof Meter) {
            hashtable = this.allmeters;
        }
        return hashtable;
    }

    public OutputStream put(String string) throws IOException {
        return this.session.put(string);
    }

    public InputStream get(String string) throws IOException {
        return this.session.get(string);
    }

    public String getText(String string) throws IOException {
        return this.session.getText(string);
    }

    public XmlMessage sendRequest(XmlMessage xmlMessage) {
        return this.session.sendRequest(xmlMessage);
    }

    public void setServerDebugTag(String string) {
        this.session.setServerDebugTag(string);
    }

    public String getServerDebugTag() {
        return this.session.getServerDebugTag();
    }

    public boolean isServerDebugEnabled() {
        return this.session.getServerDebugTag() != null;
    }
}

