/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DPNormInfo;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DataPointExec;
import com.tridium.eas.api.DataSample;
import com.tridium.eas.api.DataSummaryElement;
import com.tridium.eas.api.EasClientSession;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ExceptionSummaryData;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.RestorationMethod;
import com.tridium.eas.api.RollupMethod;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.SiteSummary;
import com.tridium.eas.api.TSDataFloat;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.util.BoolArray;
import com.tridium.eas.util.CompoundUnitUtil;
import com.tridium.eas.xml.XmlMessage;
import com.tridium.eas.xml.XmlString;
import com.tridium.eas.xml.XmlSupport;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class DataPointExecCli
implements DataPointExec {
    private EasClientSession mgr;
    private UnitDatabase unitDatabase = null;

    public DataPointExecCli(EasClientSession easClientSession) {
        this.mgr = easClientSession;
    }

    public Vector getGroupDataPoints(int n) {
        XmlMessage xmlMessage = new XmlMessage("getGroupDataPoints");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getGroupDataPoints");
        xmlMessage.add("group", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n2 = xmlSupportArray != null ? xmlSupportArray.length : 0;
        Vector<DataPoint> vector = new Vector<DataPoint>();
        try {
            for (int i = 0; i < n2; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                int n3 = xmlMessage3.getInt("dpid");
                String string = xmlMessage3.getString("dpName");
                String string2 = xmlMessage3.getString("dpStationName");
                String string3 = xmlMessage3.getString("dpDescr");
                int n4 = xmlMessage3.getInt("dpRcType");
                int n5 = xmlMessage3.getInt("dpRcSubType");
                boolean bl = xmlMessage3.getBoolean("dpIsMain");
                String string4 = xmlMessage3.getString("dpVType");
                String string5 = xmlMessage3.getString("dpVUnit");
                int n6 = xmlMessage3.getInt("dpSite");
                int n7 = xmlMessage3.getInt("dpMeter");
                String string6 = xmlMessage3.getString("dpFAVUnit");
                double d = xmlMessage3.getDouble("dpFAValue");
                String string7 = xmlMessage3.getString("dpTZ");
                int n8 = xmlMessage3.getInt("dpFlags", 1);
                vector.addElement(DataPoint.get(n3, string, string2, string3, n8, n4, n5, bl, string4, string5, (Site)Site.get(n6, (EasSession)this.mgr), n7, string6, d, string7, true));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public Vector getAllDataPointNames() {
        XmlMessage xmlMessage = new XmlMessage("getAllDataPointNames");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getAllDataPointNames");
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n = xmlSupportArray != null ? xmlSupportArray.length : 0;
        Vector<String> vector = new Vector<String>();
        try {
            for (int i = 0; i < n; ++i) {
                vector.addElement(xmlMessage2.getString("dpName" + i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public Vector getDataPoints(int n) {
        return this.getDataPoints(n, null);
    }

    public Vector getDataPoints(Site site) {
        return this.getDataPoints(site == null ? -1 : site.getId(), site);
    }

    private Vector getDataPoints(int n, Site site) {
        XmlMessage xmlMessage = new XmlMessage("getDataPoints");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getDataPoints");
        xmlMessage.add("site", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n2 = xmlSupportArray != null ? xmlSupportArray.length : 0;
        Vector<DataPoint> vector = new Vector<DataPoint>();
        try {
            for (int i = 0; i < n2; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                int n3 = xmlMessage3.getInt("dpid");
                String string = xmlMessage3.getString("dpName");
                String string2 = xmlMessage3.getString("dpStationName");
                String string3 = xmlMessage3.getString("dpDescr");
                int n4 = xmlMessage3.getInt("dpRcType");
                int n5 = xmlMessage3.getInt("dpRcSubType");
                boolean bl = xmlMessage3.getBoolean("dpIsMain");
                String string4 = xmlMessage3.getString("dpVType");
                String string5 = xmlMessage3.getString("dpVUnit");
                int n6 = xmlMessage3.getInt("dpMeter");
                String string6 = xmlMessage3.getString("dpFAVUnit");
                double d = xmlMessage3.getDouble("dpFAValue");
                String string7 = xmlMessage3.getString("dpTZ");
                int n7 = xmlMessage3.getInt("dpFlags", 1);
                DataPoint dataPoint = site == null ? DataPoint.get(n3, string, string2, string3, n7, n4, n5, bl, string4, string5, (Site)Site.get(n, (EasSession)this.mgr), n6, string6, d, string7, true) : DataPoint.get(n3, string, string2, string3, n7, n4, n5, bl, string4, string5, site, n6, string6, d, string7, true);
                vector.addElement(dataPoint);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public Vector getMeterDPs(int n) {
        return this.getMeterDPs(n, null);
    }

    public Vector getMeterDPs(Meter meter) {
        return this.getMeterDPs(meter == null ? -1 : meter.getId(), meter);
    }

    private Vector getMeterDPs(int n, Meter meter) {
        XmlMessage xmlMessage = new XmlMessage("getMeterDPs");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getMeterDPs");
        xmlMessage.add("meter", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n2 = xmlSupportArray != null ? xmlSupportArray.length : 0;
        Vector<DataPoint> vector = new Vector<DataPoint>();
        try {
            for (int i = 0; i < n2; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                int n3 = xmlMessage3.getInt("dpid");
                String string = xmlMessage3.getString("dpName");
                String string2 = xmlMessage3.getString("dpStationName");
                String string3 = xmlMessage3.getString("dpDescr");
                int n4 = xmlMessage3.getInt("dpRcType");
                int n5 = xmlMessage3.getInt("dpRcSubType");
                boolean bl = xmlMessage3.getBoolean("dpIsMain");
                String string4 = xmlMessage3.getString("dpVType");
                String string5 = xmlMessage3.getString("dpVUnit");
                int n6 = xmlMessage3.getInt("dpSite");
                String string6 = xmlMessage3.getString("dpFAVUnit");
                double d = xmlMessage3.getDouble("dpFAValue");
                String string7 = xmlMessage3.getString("dpTZ");
                int n7 = xmlMessage3.getInt("dpFlags", 1);
                DataPoint dataPoint = meter == null ? DataPoint.get(n3, string, string2, string3, n7, n4, n5, bl, string4, string5, (Site)Site.get(n6, (EasSession)this.mgr), n, string6, d, string7, true) : DataPoint.get(n3, string, string2, string3, n7, n4, n5, bl, string4, string5, (Site)Site.get(n6, (EasSession)this.mgr), meter, string6, d, string7, true);
                vector.addElement(dataPoint);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public DataPoint load(int n) {
        XmlMessage xmlMessage = new XmlMessage("load");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "load");
        xmlMessage.add("dpid", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n2 = xmlSupportArray != null ? xmlSupportArray.length : 0;
        Vector<DataPoint> vector = new Vector<DataPoint>();
        try {
            for (int i = 0; i < n2; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                int n3 = xmlMessage3.getInt("dpid");
                String string = xmlMessage3.getString("dpName");
                String string2 = xmlMessage3.getString("dpStationName");
                String string3 = xmlMessage3.getString("dpDescr");
                int n4 = xmlMessage3.getInt("dpRcType");
                int n5 = xmlMessage3.getInt("dpRcSubType");
                boolean bl = xmlMessage3.getBoolean("dpIsMain");
                String string4 = xmlMessage3.getString("dpVType");
                String string5 = xmlMessage3.getString("dpVUnit");
                int n6 = xmlMessage3.getInt("dpSite");
                int n7 = xmlMessage3.getInt("dpMeter");
                String string6 = xmlMessage3.getString("dpFAVUnit");
                double d = xmlMessage3.getDouble("dpFAValue");
                String string7 = xmlMessage3.getString("dpTZ");
                int n8 = xmlMessage3.getInt("dpFlags", 1);
                vector.addElement(DataPoint.get(n3, string, string2, string3, n8, n4, n5, bl, string4, string5, (Site)Site.get(n6, (EasSession)this.mgr), n7, string6, d, string7, true));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector.size() > 0 ? (DataPoint)vector.elementAt(0) : null;
    }

    public Vector getDataPoints(String string) {
        XmlMessage xmlMessage = new XmlMessage("getDataPointsFromList");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getDataPointsFromList");
        xmlMessage.add("points", string);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n = xmlSupportArray != null ? xmlSupportArray.length : 0;
        Vector<DataPoint> vector = new Vector<DataPoint>();
        try {
            for (int i = 0; i < n; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                int n2 = xmlMessage3.getInt("dpid");
                String string2 = xmlMessage3.getString("dpName");
                String string3 = xmlMessage3.getString("dpStationName");
                String string4 = xmlMessage3.getString("dpDescr");
                int n3 = xmlMessage3.getInt("dpRcType");
                int n4 = xmlMessage3.getInt("dpRcSubType");
                boolean bl = xmlMessage3.getBoolean("dpIsMain");
                String string5 = xmlMessage3.getString("dpVType");
                String string6 = xmlMessage3.getString("dpVUnit");
                int n5 = xmlMessage3.getInt("dpSite");
                int n6 = xmlMessage3.getInt("dpMeter");
                String string7 = xmlMessage3.getString("dpFAVUnit");
                double d = xmlMessage3.getDouble("dpFAValue");
                String string8 = xmlMessage3.getString("dpTZ");
                int n7 = xmlMessage3.getInt("dpFlags", 1);
                vector.addElement(DataPoint.get(n2, string2, string3, string4, n7, n3, n4, bl, string5, string6, (Site)Site.get(n5, (EasSession)this.mgr), n6, string7, d, string8, true));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public boolean isMultistate(String string) {
        XmlMessage xmlMessage = new XmlMessage("isMultistate");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "isMultistate");
        xmlMessage.add("dpName", string);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        boolean bl = false;
        if (xmlMessage2 != null) {
            try {
                bl = xmlMessage2.getBoolean("multistate");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public final int getAvailableLicensedDataPointCount() {
        int n = 0;
        XmlMessage xmlMessage = new XmlMessage("availableLicensed");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "availableLicensed");
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 != null) {
            try {
                n = xmlMessage2.getInt("count");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public int remGroupLink(int n, int n2) {
        XmlMessage xmlMessage = new XmlMessage("remGroupLink");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "remGroupLink");
        xmlMessage.add("grpid", n2);
        xmlMessage.add("dpid", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        return 0;
    }

    public int addGroupLink(int n, int n2) {
        XmlMessage xmlMessage = new XmlMessage("addGroupLink");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "addGroupLink");
        xmlMessage.add("grpid", n2);
        xmlMessage.add("dpid", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        return 0;
    }

    public int create(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4, String string5, int n4, int n5, String string6, double d, String string7) {
        XmlMessage xmlMessage = new XmlMessage("create");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "create");
        xmlMessage.add("name", string);
        xmlMessage.add("station_name", string2);
        xmlMessage.add("descr", string3);
        xmlMessage.add("rc_type", n2);
        xmlMessage.add("rc_subtype", n3);
        xmlMessage.add("is_main", bl);
        xmlMessage.add("vtype", string4);
        xmlMessage.add("vunit", string5);
        xmlMessage.add("site", n4);
        xmlMessage.add("meter", n5);
        xmlMessage.add("floorarea_vunit", string6);
        xmlMessage.add("floorarea_value", d);
        xmlMessage.add("time_zone", string7);
        xmlMessage.add("flags", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return -1;
        }
        try {
            String string8 = xmlMessage2.getString("server exception", null);
            if (string8 != null) {
                System.out.println(string8);
                return -1;
            }
            return xmlMessage2.getInt("dpid");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public int update(int n, String string, String string2, String string3, int n2, int n3, int n4, boolean bl, String string4, String string5, int n5, int n6, String string6, double d, String string7) {
        XmlMessage xmlMessage = new XmlMessage("update");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "update");
        xmlMessage.add("dpid", n);
        xmlMessage.add("name", string);
        xmlMessage.add("station_name", string2);
        xmlMessage.add("descr", string3);
        xmlMessage.add("rc_type", n3);
        xmlMessage.add("rc_subtype", n4);
        xmlMessage.add("is_main", bl);
        xmlMessage.add("vtype", string4);
        xmlMessage.add("vunit", string5);
        xmlMessage.add("site", n5);
        xmlMessage.add("meter", n6);
        xmlMessage.add("floorarea_vunit", string6);
        xmlMessage.add("floorarea_value", d);
        xmlMessage.add("time_zone", string7);
        xmlMessage.add("flags", n2);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return -1;
        }
        try {
            return xmlMessage2.getInt("status");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public int erase(int n, String string) {
        XmlMessage xmlMessage = new XmlMessage("erase");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "erase");
        xmlMessage.add("dpid", n);
        xmlMessage.add("name", string);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return -1;
        }
        try {
            return xmlMessage2.getInt("status");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public double getTotal(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone) {
        XmlMessage xmlMessage = new XmlMessage("getTotal");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getTotal");
        xmlMessage.add("name", string);
        xmlMessage.add("first", easLocalTime.toSerializedLong());
        xmlMessage.add("last", easLocalTime2.toSerializedLong());
        xmlMessage.add("tz", bTimeZone.getId());
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 != null) {
            try {
                return xmlMessage2.getDouble("total");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0.0;
    }

    public DataSample[] getRawData(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, BUnit bUnit) throws EasException {
        XmlMessage xmlMessage = new XmlMessage("getRawData");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getRawData");
        xmlMessage.add("name", string);
        xmlMessage.add("first", easLocalTime.toSerializedLong());
        xmlMessage.add("last", easLocalTime2.toSerializedLong());
        xmlMessage.add("tz", bTimeZone.getId());
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        String string2 = null;
        string2 = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
        xmlMessage.add("vtype", string2);
        xmlMessage.add("vunit", bUnit.getUnitName());
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        String string3 = null;
        try {
            string3 = xmlMessage2.getString("server exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            String string4 = xmlMessage2.getString("lexiconModule", null);
            if (string4 != null) {
                String string5 = xmlMessage2.getString("lexiconKey", null);
                XmlSupport[] xmlSupportArray = xmlMessage2.list("lexiconArgument");
                int n = xmlSupportArray != null ? xmlSupportArray.length : 0;
                Object[] objectArray = n > 0 ? new String[n] : null;
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = ((XmlString)xmlSupportArray[i]).getValue();
                }
                throw new LocalizableRuntimeException(string4, string5, objectArray);
            }
            throw new EasException(string3);
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n = xmlSupportArray != null ? xmlSupportArray.length : 0;
        DataSample[] dataSampleArray = new DataSample[n];
        try {
            for (int i = 0; i < n; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                dataSampleArray[i] = new DataSample(xmlMessage3.getLong("timestamp"), xmlMessage3.getDouble("value"), xmlMessage3.getInt("status"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dataSampleArray;
    }

    public TSDataFloat getData(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, RestorationMethod restorationMethod, BUnit bUnit, TimeInterval timeInterval, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) throws EasException {
        XmlMessage xmlMessage;
        XmlMessage xmlMessage2 = new XmlMessage("getData");
        xmlMessage2.add("request", "eas");
        xmlMessage2.add("classname", "DataPoint");
        xmlMessage2.add("command", "getData");
        xmlMessage2.add("name", string);
        xmlMessage2.add("first", easLocalTime.toSerializedLong());
        xmlMessage2.add("last", easLocalTime2.toSerializedLong());
        xmlMessage2.add("tz", bTimeZone.getId());
        xmlMessage2.add("accum", restorationMethod.getId());
        xmlMessage2.add("interval", timeInterval.getNUnits());
        xmlMessage2.add("intl_unit", timeInterval.getUnit());
        xmlMessage2.add("incremental", true);
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        String string2 = null;
        string2 = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
        xmlMessage2.add("vtype", string2);
        xmlMessage2.add("vunit", bUnit.getUnitName());
        xmlMessage2.add("data_cleanse", bl);
        xmlMessage2.add("cleanse_w", n);
        xmlMessage2.add("cleanse_p", d);
        xmlMessage2.add("dpNormalization", bl2);
        if (bl2 && dataPoint != null) {
            xmlMessage2.add("normalizer", dataPoint.getId());
        }
        if ((xmlMessage = this.mgr.sendRequest(xmlMessage2)) == null) {
            return null;
        }
        String string3 = null;
        try {
            string3 = xmlMessage.getString("server exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            throw new EasException(string3);
        }
        try {
            XmlSupport[] xmlSupportArray = xmlMessage.getChildObjects();
            int n2 = xmlSupportArray != null ? xmlSupportArray.length : 0;
            double[] dArray = new double[n2];
            BoolArray boolArray = null;
            for (int i = 0; i < n2; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                dArray[i] = xmlMessage3.getDouble("value");
                boolean bl3 = xmlMessage3.getBoolean("valid");
                if (bl3) continue;
                if (boolArray == null) {
                    boolArray = new BoolArray(n2);
                    boolArray.setAll(true);
                }
                boolArray.setf(i);
            }
            if (bl2 && dataPoint != null) {
                bUnit = CompoundUnitUtil.make(bUnit, dataPoint.getUnit());
            }
            return new TSDataFloat(easLocalTime, bTimeZone, timeInterval, bUnit, dArray, boolArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public TSDataSummary getAggregatedSummaryNorm(DPNormInfo[] dPNormInfoArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, RestorationMethod restorationMethod, RollupMethod rollupMethod, BUnit bUnit, boolean bl, BUnit bUnit2, boolean bl2, double d, BUnit bUnit3, int n, int n2, TimeInterval timeInterval, int n3, boolean bl3, int n4, double d2, boolean bl4, DataPoint dataPoint) throws EasException {
        XmlMessage xmlMessage = new XmlMessage("getAggregatedSummaryNorm");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getAggregatedSummaryNorm");
        xmlMessage.add("first", easLocalTime.toSerializedLong());
        xmlMessage.add("last", easLocalTime2.toSerializedLong());
        xmlMessage.add("accum", restorationMethod.getId());
        xmlMessage.add("rollupMethod", rollupMethod.getId());
        xmlMessage.add("incl_wdays", n);
        xmlMessage.add("excl_wdays", n2);
        xmlMessage.add("rollup_intl", timeInterval.getNUnits());
        xmlMessage.add("rollup_unit", timeInterval.getUnit());
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        String string = null;
        string = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
        xmlMessage.add("ounit_tag", string);
        xmlMessage.add("ounit_id", bUnit.getUnitName());
        xmlMessage.add("cycle", n3);
        xmlMessage.add("doTemperature", bl2);
        xmlMessage.add("normTemperature", d);
        xmlMessage.add("temperatureUnitOutTag", bl2 ? this.unitDatabase.getQuantity(bUnit3).getName() : "misc");
        xmlMessage.add("temperatureUnitOutId", bl2 ? bUnit3.getUnitName() : "null");
        xmlMessage.add("normByFloorArea", bl);
        xmlMessage.add("floorAreaUnitTag", bl ? this.unitDatabase.getQuantity(bUnit2).getName() : "misc");
        xmlMessage.add("floorAreaUnitId", bl ? bUnit2.getUnitName() : "null");
        xmlMessage.add("data_cleanse", bl3);
        xmlMessage.add("cleanse_w", n4);
        xmlMessage.add("cleanse_p", d2);
        xmlMessage.add("dpNormalization", bl4);
        if (bl4 && dataPoint != null) {
            xmlMessage.add("normalizer", dataPoint.getId());
        }
        for (int i = 0; i < dPNormInfoArray.length; ++i) {
            xmlMessage.add("dps" + i, dPNormInfoArray[i].toXmlMessage());
        }
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return null;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n5 = xmlSupportArray != null ? xmlSupportArray.length : 0;
        try {
            DataSummaryElement[] dataSummaryElementArray = new DataSummaryElement[n5];
            for (int i = 0; i < n5; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                double d3 = xmlMessage3.getDouble("dtSumTotalConsumption");
                double d4 = xmlMessage3.getDouble("dtSumAvgDemand");
                double d5 = xmlMessage3.getDouble("dtSumMinDemand");
                long l = xmlMessage3.getLong("dtSumDateOfMinDemand");
                double d6 = xmlMessage3.getDouble("dtSumPeakDemand");
                long l2 = xmlMessage3.getLong("dtSumDateOfPeakDemand");
                int n6 = xmlMessage3.getInt("dtSumCount");
                int n7 = xmlMessage3.getInt("dtGoodCount");
                int n8 = xmlMessage3.getInt("dtSumNCycles");
                dataSummaryElementArray[i] = new DataSummaryElement(d3, d4, d5, l, d6, l2, n6, n7, n8);
            }
            if (bl4 && dataPoint != null) {
                bUnit = CompoundUnitUtil.make(bUnit, dataPoint.getUnit());
            }
            if (bl) {
                bUnit = CompoundUnitUtil.make(bUnit, bUnit2);
            }
            return new TSDataSummary(easLocalTime, dPNormInfoArray[0].tz, timeInterval, bUnit, dataSummaryElementArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public TSDataSummary getAggregatedSummary(String[] stringArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone[] bTimeZoneArray, RestorationMethod restorationMethod, int n, int n2, TimeInterval timeInterval, int n3, double[] dArray, BUnit[] bUnitArray, BUnit bUnit, int n4, TimeInterval timeInterval2, boolean bl, int n5, double d, boolean bl2, DataPoint dataPoint) {
        Object object;
        XmlMessage xmlMessage;
        XmlMessage xmlMessage2 = new XmlMessage("getAggregatedSummary");
        xmlMessage2.add("request", "eas");
        xmlMessage2.add("classname", "DataPoint");
        xmlMessage2.add("command", "getAggregatedSummary");
        for (int i = 0; i < stringArray.length; ++i) {
            xmlMessage = new XmlMessage("row" + i);
            xmlMessage.add("names", stringArray[i]);
            xmlMessage.add("coeffs", dArray[i]);
            if (this.unitDatabase == null) {
                this.unitDatabase = UnitDatabase.getDefault();
            }
            if (bUnitArray[i] == null) {
                bUnitArray[i] = BUnit.NULL;
            }
            object = null;
            object = this.unitDatabase.getQuantity(bUnitArray[i]) != null ? this.unitDatabase.getQuantity(bUnitArray[i]).getName() : "";
            xmlMessage.add("unit_tag", (String)object);
            xmlMessage.add("unit_id", bUnitArray[i].getUnitName());
            xmlMessage.add("tz", bTimeZoneArray[i].getId());
            xmlMessage2.add("row" + i, xmlMessage);
        }
        xmlMessage2.add("first", easLocalTime.toSerializedLong());
        xmlMessage2.add("last", easLocalTime2.toSerializedLong());
        xmlMessage2.add("accum", restorationMethod.getId());
        xmlMessage2.add("incl_wdays", n);
        xmlMessage2.add("excl_wdays", n2);
        xmlMessage2.add("aggregation_method", n4);
        xmlMessage2.add("rollup_intl", timeInterval.getNUnits());
        xmlMessage2.add("rollup_unit", timeInterval.getUnit());
        xmlMessage2.add("interval", timeInterval2.getNUnits());
        xmlMessage2.add("intl_unit", timeInterval2.getUnit());
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        String string = null;
        string = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
        xmlMessage2.add("ounit_tag", string);
        xmlMessage2.add("ounit_id", bUnit.getUnitName());
        xmlMessage2.add("cycle", n3);
        xmlMessage2.add("data_cleanse", bl);
        xmlMessage2.add("cleanse_w", n5);
        xmlMessage2.add("cleanse_p", d);
        xmlMessage2.add("dpNormalization", bl2);
        if (bl2 && dataPoint != null) {
            xmlMessage2.add("normalizer", dataPoint.getId());
        }
        if ((xmlMessage = this.mgr.sendRequest(xmlMessage2)) == null) {
            return null;
        }
        object = xmlMessage.getChildObjects();
        int n6 = object != null ? ((XmlSupport[])object).length : 0;
        try {
            DataSummaryElement[] dataSummaryElementArray = new DataSummaryElement[n6];
            for (int i = 0; i < n6; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)object[i];
                double d2 = xmlMessage3.getDouble("dtSumTotalConsumption");
                double d3 = xmlMessage3.getDouble("dtSumAvgDemand");
                double d4 = xmlMessage3.getDouble("dtSumMinDemand");
                long l = xmlMessage3.getLong("dtSumDateOfMinDemand");
                double d5 = xmlMessage3.getDouble("dtSumPeakDemand");
                long l2 = xmlMessage3.getLong("dtSumDateOfPeakDemand");
                int n7 = xmlMessage3.getInt("dtSumCount");
                int n8 = xmlMessage3.getInt("dtGoodCount");
                int n9 = xmlMessage3.getInt("dtSumNCycles");
                dataSummaryElementArray[i] = new DataSummaryElement(d2, d3, d4, l, d5, l2, n7, n8, n9);
            }
            if (bl2 && dataPoint != null) {
                bUnit = CompoundUnitUtil.make(bUnit, dataPoint.getUnit());
            }
            return new TSDataSummary(easLocalTime, bTimeZoneArray[0], timeInterval, bUnit, dataSummaryElementArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public TSDataSummary getDataSummary(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, RestorationMethod restorationMethod, int n, int n2, BUnit bUnit, BUnit bUnit2, TimeInterval timeInterval, int n3, double d, BUnit bUnit3, String string2, BUnit bUnit4, double d2, TimeInterval timeInterval2, boolean bl, int n4, double d3, boolean bl2, DataPoint dataPoint) throws EasException {
        XmlMessage xmlMessage;
        XmlMessage xmlMessage2 = new XmlMessage("getDataSummary");
        xmlMessage2.add("request", "eas");
        xmlMessage2.add("classname", "DataPoint");
        xmlMessage2.add("command", "getDataSummary");
        xmlMessage2.add("name", string);
        xmlMessage2.add("first", easLocalTime.toSerializedLong());
        xmlMessage2.add("last", easLocalTime2.toSerializedLong());
        xmlMessage2.add("tz", bTimeZone.getId());
        xmlMessage2.add("accum", restorationMethod.getId());
        xmlMessage2.add("incl_wdays", n);
        xmlMessage2.add("excl_wdays", n2);
        xmlMessage2.add("rollup_intl", timeInterval.getNUnits());
        xmlMessage2.add("rollup_unit", timeInterval.getUnit());
        xmlMessage2.add("cycle", n3);
        xmlMessage2.add("interval", timeInterval2.getNUnits());
        xmlMessage2.add("intl_unit", timeInterval2.getUnit());
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        String string3 = null;
        string3 = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
        xmlMessage2.add("vtype", string3);
        xmlMessage2.add("vunit", bUnit.getUnitName());
        if (bUnit2 == null) {
            bUnit2 = BUnit.NULL;
        }
        string3 = this.unitDatabase.getQuantity(bUnit2) != null ? this.unitDatabase.getQuantity(bUnit2).getName() : "";
        xmlMessage2.add("otype", string3);
        xmlMessage2.add("ounit", bUnit2.getUnitName());
        xmlMessage2.add("normCoeff", d);
        if (string2 != null) {
            xmlMessage2.add("doWeather", true);
            xmlMessage2.add("temperatureLog", string2);
            xmlMessage2.add("temperatureUnitTag", this.unitDatabase.getQuantity(bUnit4).getName());
            xmlMessage2.add("temperatureUnitId", bUnit4.getUnitName());
            xmlMessage2.add("normTemperature", d2);
        } else {
            xmlMessage2.add("doWeather", false);
        }
        if (d != 1.0 && d != 0.0) {
            if (bUnit3 == null) {
                bUnit3 = BUnit.NULL;
            }
            string3 = this.unitDatabase.getQuantity(bUnit3) != null ? this.unitDatabase.getQuantity(bUnit3).getName() : "";
            xmlMessage2.add("normUnitTag", string3);
            xmlMessage2.add("normUnitId", bUnit3.getUnitName());
        }
        xmlMessage2.add("data_cleanse", bl);
        xmlMessage2.add("cleanse_w", n4);
        xmlMessage2.add("cleanse_p", d3);
        xmlMessage2.add("dpNormalization", bl2);
        if (bl2 && dataPoint != null) {
            xmlMessage2.add("normalizer", dataPoint.getId());
        }
        if ((xmlMessage = this.mgr.sendRequest(xmlMessage2)) == null) {
            return null;
        }
        String string4 = null;
        try {
            string4 = xmlMessage.getString("server exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 != null) {
            throw new EasException(string4);
        }
        XmlSupport[] xmlSupportArray = xmlMessage.getChildObjects();
        int n5 = xmlSupportArray != null ? xmlSupportArray.length : 0;
        try {
            DataSummaryElement[] dataSummaryElementArray = new DataSummaryElement[n5];
            for (int i = 0; i < n5; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                double d4 = xmlMessage3.getDouble("dtSumTotalConsumption");
                double d5 = xmlMessage3.getDouble("dtSumAvgDemand");
                double d6 = xmlMessage3.getDouble("dtSumMinDemand");
                long l = xmlMessage3.getLong("dtSumDateOfMinDemand");
                double d7 = xmlMessage3.getDouble("dtSumPeakDemand");
                long l2 = xmlMessage3.getLong("dtSumDateOfPeakDemand");
                int n6 = xmlMessage3.getInt("dtSumCount");
                int n7 = xmlMessage3.getInt("dtGoodCount");
                int n8 = xmlMessage3.getInt("dtSumNCycles");
                dataSummaryElementArray[i] = new DataSummaryElement(d4, d5, d6, l, d7, l2, n6, n7, n8);
            }
            if (bl2 && dataPoint != null) {
                bUnit2 = CompoundUnitUtil.make(bUnit2, dataPoint.getUnit());
            }
            if (d != 1.0 && d != 0.0 && bUnit3 != null) {
                bUnit2 = CompoundUnitUtil.make(bUnit2, bUnit3);
            }
            return new TSDataSummary(easLocalTime, bTimeZone, timeInterval, bUnit2, dataSummaryElementArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public SiteSummary[] getRankedSummaries(String string, int n, int n2, boolean bl, int n3, String string2, int[] nArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n4, int n5, boolean bl2, double d, BUnit bUnit, TimeInterval timeInterval, boolean bl3, int n6, double d2, boolean[] blArray, DataPoint[] dataPointArray) throws EasException {
        int n7;
        XmlMessage xmlMessage = new XmlMessage("getRankedSummaries");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "DataPoint");
        xmlMessage.add("command", "getRankedSummaries");
        int n8 = nArray == null ? 0 : nArray.length;
        for (n7 = 0; n7 < n8; ++n7) {
            XmlMessage xmlMessage2 = new XmlMessage("row" + n7);
            xmlMessage2.add("value", (long)nArray[n7]);
            xmlMessage2.add("what", false);
            xmlMessage.add("row" + n7, xmlMessage2);
        }
        xmlMessage.add("sites", string);
        xmlMessage.add("rc_type", n);
        xmlMessage.add("rc_subtype", n2);
        xmlMessage.add("is_main", bl);
        xmlMessage.add("maxSites", n3);
        xmlMessage.add("normPropName", string2);
        xmlMessage.add("interval", timeInterval.getNUnits());
        xmlMessage.add("intl_unit", timeInterval.getUnit());
        xmlMessage.add("first", easLocalTime.toSerializedLong());
        xmlMessage.add("last", easLocalTime2.toSerializedLong());
        xmlMessage.add("incl_wdays", n4);
        xmlMessage.add("excl_wdays", n5);
        xmlMessage.add("nfields", n8);
        xmlMessage.add("weatherNorm", bl2);
        xmlMessage.add("normTemperature", d);
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        xmlMessage.add("temperatureUnitTag", bl2 ? this.unitDatabase.getQuantity(bUnit).getName() : "misc");
        xmlMessage.add("temperatureUnitId", bl2 ? bUnit.getUnitName() : "null");
        xmlMessage.add("data_cleanse", bl3);
        xmlMessage.add("cleanse_w", n6);
        xmlMessage.add("cleanse_p", d2);
        n7 = blArray != null ? blArray.length : 0;
        xmlMessage.add("dpNormSize", n7);
        for (int i = 0; i < n7; ++i) {
            xmlMessage.add("dpNormalization" + i, blArray[i]);
            if (!blArray[i] || dataPointArray[i] == null) continue;
            xmlMessage.add("normalizer" + i, dataPointArray[i].getId());
        }
        XmlMessage xmlMessage3 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage3 == null) {
            return null;
        }
        String string3 = null;
        try {
            string3 = xmlMessage3.getString("server exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            throw new EasException(string3);
        }
        try {
            Object object;
            String string4 = xmlMessage3.getString("unitTag");
            String string5 = xmlMessage3.getString("unitId");
            BUnit bUnit2 = BUnit.getUnit((String)string5);
            BUnit bUnit3 = null;
            if (string2 != null && string2.length() != 0) {
                object = xmlMessage3.getString("normUnitTag");
                String string6 = xmlMessage3.getString("normUnitId");
                bUnit3 = BUnit.getUnit((String)string6);
            }
            int n9 = (object = xmlMessage3.getChildObjects()) != null ? ((XmlSupport[])object).length - 4 : 0;
            SiteSummary[] siteSummaryArray = new SiteSummary[n9];
            for (int i = 0; i < n9; ++i) {
                XmlMessage xmlMessage4 = xmlMessage3.getMessage("row" + i);
                double d3 = xmlMessage4.getDouble("dtSumTotalConsumption");
                double d4 = xmlMessage4.getDouble("dtSumAvgDemand");
                double d5 = xmlMessage4.getDouble("dtSumMinDemand");
                long l = xmlMessage4.getLong("dtSumDateOfMinDemand");
                double d6 = xmlMessage4.getDouble("dtSumPeakDemand");
                long l2 = xmlMessage4.getLong("dtSumDateOfPeakDemand");
                int n10 = xmlMessage4.getInt("dtSumCount");
                int n11 = xmlMessage4.getInt("dtGoodCount");
                int n12 = xmlMessage4.getInt("dtSumNCycles");
                int n13 = xmlMessage4.getInt("dtSiteId");
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n14 = 0;
                while (stringTokenizer.hasMoreElements() && Integer.valueOf(stringTokenizer.nextToken()) != n13) {
                    ++n14;
                }
                if (n14 < blArray.length && blArray[n14] && dataPointArray[n14] != null) {
                    bUnit2 = CompoundUnitUtil.make(bUnit2, dataPointArray[n14].getUnit());
                }
                siteSummaryArray[i] = new SiteSummary(n13, bUnit2, bUnit3, d3, d4, d5, l, d6, l2, n10, n11, n12);
            }
            return siteSummaryArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ExceptionSummaryData getExceptionSummaryData(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, TimeInterval timeInterval, BUnit bUnit, boolean bl2, String string2, int n7, EasLocalTime easLocalTime3, int n8, int n9, double d, double d2, int n10, int n11, RestorationMethod restorationMethod, TimeInterval timeInterval2, boolean bl3, int n12, double d3, boolean bl4, DataPoint dataPoint) throws EasException {
        XmlMessage xmlMessage;
        XmlMessage xmlMessage2 = new XmlMessage("getExceptionSummary");
        xmlMessage2.add("request", "eas");
        xmlMessage2.add("classname", "DataPoint");
        xmlMessage2.add("command", "getExceptionSummary");
        xmlMessage2.add("name", string);
        xmlMessage2.add("data_start", easLocalTime.toSerializedLong());
        xmlMessage2.add("data_end", easLocalTime2.toSerializedLong());
        xmlMessage2.add("tz", bTimeZone.getId());
        xmlMessage2.add("incl_wdays", n);
        xmlMessage2.add("excl_wdays", n2);
        xmlMessage2.add("startHr", n3);
        xmlMessage2.add("startMin", n4);
        xmlMessage2.add("endHr", n5);
        xmlMessage2.add("endMin", n6);
        xmlMessage2.add("exclusive", bl);
        xmlMessage2.add("rollup_n_units", timeInterval.getNUnits());
        xmlMessage2.add("rollup_unit", timeInterval.getUnit());
        xmlMessage2.add("weather_norm", bl2);
        xmlMessage2.add("temp_log_name", string2);
        xmlMessage2.add("rollup_method", n7);
        xmlMessage2.add("base_start", easLocalTime3.toSerializedLong());
        xmlMessage2.add("base_len", n8);
        xmlMessage2.add("limit_type", n9);
        xmlMessage2.add("upper_limit", d);
        xmlMessage2.add("lower_limit", d2);
        xmlMessage2.add("max_ex", n10);
        xmlMessage2.add("rules", n11);
        xmlMessage2.add("send_summary", true);
        xmlMessage2.add("accum", restorationMethod.getId());
        xmlMessage2.add("interval", timeInterval2.getNUnits());
        xmlMessage2.add("intl_unit", timeInterval2.getUnit());
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        String string3 = null;
        string3 = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
        xmlMessage2.add("vtype", string3);
        xmlMessage2.add("vunit", bUnit.getUnitName());
        xmlMessage2.add("data_cleanse", bl3);
        xmlMessage2.add("cleanse_w", n12);
        xmlMessage2.add("cleanse_p", d3);
        xmlMessage2.add("dpNormalization", bl4);
        if (bl4 && dataPoint != null) {
            xmlMessage2.add("normalizer", dataPoint.getId());
        }
        if ((xmlMessage = this.mgr.sendRequest(xmlMessage2)) == null) {
            return null;
        }
        String string4 = null;
        try {
            string4 = xmlMessage.getString("server exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 != null) {
            throw new EasException(string4);
        }
        try {
            int n13 = xmlMessage.getInt("violationsAbove");
            int n14 = xmlMessage.getInt("violationsBelow");
            int n15 = xmlMessage.getInt("total_count");
            double d4 = xmlMessage.getDouble("total");
            double d5 = xmlMessage.getDouble("total_diff");
            double d6 = xmlMessage.getDouble("positive_diff");
            double d7 = xmlMessage.getDouble("spc_upper");
            double d8 = xmlMessage.getDouble("spc_lower");
            XmlSupport[] xmlSupportArray = xmlMessage.getChildObjects();
            int n16 = xmlSupportArray != null ? xmlSupportArray.length - 8 : 0;
            int[] nArray = new int[n16];
            for (int i = 0; i < n16; ++i) {
                XmlMessage xmlMessage3 = xmlMessage.getMessage("row" + i);
                nArray[i] = xmlMessage3.getInt("violation");
            }
            return new ExceptionSummaryData(n13, n14, nArray, n15, d4, d5, d6, d7, d8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public TSDataFloat getExceptionSeries(String string, boolean bl, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, int n, int n2, int n3, int n4, int n5, int n6, boolean bl2, TimeInterval timeInterval, BUnit bUnit, boolean bl3, String string2, int n7, EasLocalTime easLocalTime3, int n8, RestorationMethod restorationMethod, TimeInterval timeInterval2, boolean bl4, int n9, double d, boolean bl5, DataPoint dataPoint) throws EasException {
        XmlMessage xmlMessage;
        XmlMessage xmlMessage2 = new XmlMessage("getExceptionSummary");
        xmlMessage2.add("request", "eas");
        xmlMessage2.add("classname", "DataPoint");
        xmlMessage2.add("command", "getExceptionSummary");
        xmlMessage2.add("name", string);
        xmlMessage2.add("current", bl);
        xmlMessage2.add("data_start", easLocalTime.toSerializedLong());
        xmlMessage2.add("data_end", easLocalTime2.toSerializedLong());
        xmlMessage2.add("tz", bTimeZone.getId());
        xmlMessage2.add("incl_wdays", n);
        xmlMessage2.add("excl_wdays", n2);
        xmlMessage2.add("startHr", n3);
        xmlMessage2.add("startMin", n4);
        xmlMessage2.add("endHr", n5);
        xmlMessage2.add("endMin", n6);
        xmlMessage2.add("exclusive", bl2);
        xmlMessage2.add("rollup_n_units", timeInterval.getNUnits());
        xmlMessage2.add("rollup_unit", timeInterval.getUnit());
        xmlMessage2.add("rollup_method", n7);
        xmlMessage2.add("weather_norm", bl3);
        xmlMessage2.add("temp_log_name", string2);
        xmlMessage2.add("base_start", easLocalTime3.toSerializedLong());
        xmlMessage2.add("base_len", n8);
        xmlMessage2.add("limit_type", 0);
        xmlMessage2.add("upper_limit", 0.0);
        xmlMessage2.add("lower_limit", 0.0);
        xmlMessage2.add("max_ex", 0);
        xmlMessage2.add("rules", 0);
        xmlMessage2.add("send_summary", false);
        xmlMessage2.add("accum", restorationMethod.getId());
        xmlMessage2.add("interval", timeInterval2.getNUnits());
        xmlMessage2.add("intl_unit", timeInterval2.getUnit());
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        if (bUnit == null) {
            bUnit = BUnit.NULL;
        }
        String string3 = null;
        string3 = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
        xmlMessage2.add("vtype", string3);
        xmlMessage2.add("vunit", bUnit.getUnitName());
        xmlMessage2.add("data_cleanse", bl4);
        xmlMessage2.add("cleanse_w", n9);
        xmlMessage2.add("cleanse_p", d);
        xmlMessage2.add("dpNormalization", bl5);
        if (bl5 && dataPoint != null) {
            xmlMessage2.add("normalizer", dataPoint.getId());
        }
        if ((xmlMessage = this.mgr.sendRequest(xmlMessage2)) == null) {
            return null;
        }
        String string4 = null;
        try {
            string4 = xmlMessage.getString("server exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 != null) {
            throw new EasException(string4);
        }
        try {
            XmlSupport[] xmlSupportArray = xmlMessage.getChildObjects();
            int n10 = xmlSupportArray != null ? xmlSupportArray.length : 0;
            double[] dArray = new double[n10];
            BoolArray boolArray = null;
            for (int i = 0; i < n10; ++i) {
                dArray[i] = ((XmlMessage)xmlSupportArray[i]).getDouble("value");
                boolean bl6 = ((XmlMessage)xmlSupportArray[i]).getBoolean("valid");
                if (bl6) continue;
                if (boolArray == null) {
                    boolArray = new BoolArray(n10);
                    boolArray.setAll(true);
                }
                boolArray.setf(i);
            }
            if (bl5 && dataPoint != null) {
                bUnit = CompoundUnitUtil.make(bUnit, dataPoint.getUnit());
            }
            return new TSDataFloat(easLocalTime, bTimeZone, timeInterval, bUnit, dArray, boolArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

