/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.util.Comparable;
import com.tridium.eas.xml.XmlMessage;
import java.io.IOException;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class DPNormInfo
implements Comparable {
    public String dataLog;
    public BTimeZone tz;
    public double normCoeff;
    public BUnit dataUnit;
    public TimeInterval dataSampling;
    public String temperatureLog;
    public BUnit temperatureUnit = null;
    public TimeInterval temperatureSampling = null;
    private UnitDatabase unitDatabase = null;

    public DPNormInfo(String string, BTimeZone bTimeZone, double d, BUnit bUnit, TimeInterval timeInterval, String string2, BUnit bUnit2, TimeInterval timeInterval2) {
        this.dataLog = string;
        this.tz = bTimeZone;
        this.normCoeff = d;
        this.dataUnit = bUnit;
        this.dataSampling = timeInterval;
        this.temperatureLog = string2;
        this.temperatureUnit = bUnit2;
        this.temperatureSampling = timeInterval2;
    }

    public int compareTo(Object object) {
        return this.temperatureLog.compareTo(((DPNormInfo)object).temperatureLog);
    }

    private DPNormInfo() {
    }

    public static DPNormInfo fromXmlMessage(XmlMessage xmlMessage) throws IOException {
        DPNormInfo dPNormInfo = new DPNormInfo();
        dPNormInfo.dataLog = xmlMessage.getString("dataLog");
        dPNormInfo.normCoeff = xmlMessage.getDouble("normCoeff");
        dPNormInfo.dataUnit = BUnit.getUnit((String)xmlMessage.getString("dataUnitId"));
        dPNormInfo.tz = BTimeZone.getTimeZone((String)xmlMessage.getString("tz"));
        dPNormInfo.dataSampling = new TimeInterval(xmlMessage.getLong("dataSamplingNUnits"), xmlMessage.getInt("dataSamplingUnit"));
        dPNormInfo.temperatureLog = xmlMessage.getString("temperatureLog");
        if (dPNormInfo.temperatureLog != null && dPNormInfo.temperatureLog.length() != 0) {
            dPNormInfo.temperatureUnit = BUnit.getUnit((String)xmlMessage.getString("temperatureUnitId"));
            dPNormInfo.temperatureSampling = new TimeInterval(xmlMessage.getLong("temperatureSamplingNUnits"), xmlMessage.getInt("temperatureSamplingUnit"));
        }
        return dPNormInfo;
    }

    public XmlMessage toXmlMessage() {
        XmlMessage xmlMessage = new XmlMessage("DPNormInfo");
        xmlMessage.add("dataLog", this.dataLog);
        xmlMessage.add("normCoeff", this.normCoeff);
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        String string = null;
        string = this.dataUnit != null && this.unitDatabase.getQuantity(this.dataUnit) != null ? this.unitDatabase.getQuantity(this.dataUnit).getName() : "";
        xmlMessage.add("dataUnitTag", string);
        xmlMessage.add("dataUnitId", this.dataUnit == null ? "null" : this.dataUnit.getUnitName());
        xmlMessage.add("tz", this.tz.getId());
        xmlMessage.add("dataSamplingNUnits", this.dataSampling.getNUnits());
        xmlMessage.add("dataSamplingUnit", this.dataSampling.getUnit());
        xmlMessage.add("temperatureLog", this.temperatureLog);
        xmlMessage.add("temperatureUnitTag", this.temperatureUnit == null ? "misc" : this.unitDatabase.getQuantity(this.temperatureUnit).getName());
        xmlMessage.add("temperatureUnitId", this.temperatureUnit == null ? "null" : this.temperatureUnit.getUnitName());
        xmlMessage.add("temperatureSamplingNUnits", this.temperatureSampling == null ? 0L : this.temperatureSampling.getNUnits());
        xmlMessage.add("temperatureSamplingUnit", this.temperatureSampling == null ? 0 : this.temperatureSampling.getUnit());
        return xmlMessage;
    }
}

