/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas;

import com.tridium.eas.BEasService;
import com.tridium.eas.enums.BDatabaseTypeEnum;
import com.tridium.eas.util.ConnectionPool;
import com.tridium.eas.util.MSSqlServer;
import com.tridium.eas.util.SqlUtil;
import com.tridium.sys.Nre;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import net.sourceforge.jtds.jdbcx.JtdsDataSource;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;

public class BDatabaseConfiguration
extends BComponent {
    public static final Property databaseConnected = BDatabaseConfiguration.newProperty((int)3, (boolean)false, null);
    public static final Property databaseProductName = BDatabaseConfiguration.newProperty((int)3, (String)"-", null);
    public static final Property databaseProductVersion = BDatabaseConfiguration.newProperty((int)3, (String)"-", null);
    public static final Property databaseDriverName = BDatabaseConfiguration.newProperty((int)3, (String)"-", null);
    public static final Property databaseDriverVersion = BDatabaseConfiguration.newProperty((int)3, (String)"-", null);
    public static final Property databaseType = BDatabaseConfiguration.newProperty((int)0, (BValue)BDatabaseTypeEnum.sqlServer, null);
    public static final Property hostAddress = BDatabaseConfiguration.newProperty((int)0, (BValue)BOrd.make((String)"ip:localhost"), (BFacets)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE, (String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:HostOrdFE")));
    public static final Property port = BDatabaseConfiguration.newProperty((int)0, (int)1433, null);
    public static final Property databaseUser = BDatabaseConfiguration.newProperty((int)0, (String)"sa", null);
    public static final Property databasePassword = BDatabaseConfiguration.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property sqlServerCreateNewDatabase = BDatabaseConfiguration.newProperty((int)0, (boolean)true, null);
    public static final Property sqlServerDatabaseName = BDatabaseConfiguration.newProperty((int)0, (String)"", null);
    public static final Property sqlServerDbDataFilename = BDatabaseConfiguration.newProperty((int)71, (String)"", null);
    public static final Property sqlServerDbLogFilename = BDatabaseConfiguration.newProperty((int)71, (String)"", null);
    public static final Property oracleServiceName = BDatabaseConfiguration.newProperty((int)0, (String)"ORCL", null);
    public static final Action openDatabase = BDatabaseConfiguration.newAction((int)16, null);
    public static final Action closeDatabase = BDatabaseConfiguration.newAction((int)16, null);
    public static final Action deleteEasTables = BDatabaseConfiguration.newAction((int)148, null);
    public static final Action createEasTables = BDatabaseConfiguration.newAction((int)148, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$eas$BDatabaseConfiguration == null ? (class$com$tridium$eas$BDatabaseConfiguration = BDatabaseConfiguration.class$("com.tridium.eas.BDatabaseConfiguration")) : class$com$tridium$eas$BDatabaseConfiguration));
    private static final BIcon icon = BIcon.std((String)"database.png");
    private BDatabaseTypeEnum currentDatabaseType = null;
    private ConnectionPool connectionPool = null;
    private static final Log log = Log.getLog((String)"eas");
    public static Context noDbDisconnect = new BasicContext(){

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return "Eas:noDbDisconnect";
        }
    };
    static /* synthetic */ Class class$com$tridium$eas$BDatabaseConfiguration;

    public boolean getDatabaseConnected() {
        return this.getBoolean(databaseConnected);
    }

    public void setDatabaseConnected(boolean bl) {
        this.setBoolean(databaseConnected, bl, null);
    }

    public String getDatabaseProductName() {
        return this.getString(databaseProductName);
    }

    public void setDatabaseProductName(String string) {
        this.setString(databaseProductName, string, null);
    }

    public String getDatabaseProductVersion() {
        return this.getString(databaseProductVersion);
    }

    public void setDatabaseProductVersion(String string) {
        this.setString(databaseProductVersion, string, null);
    }

    public String getDatabaseDriverName() {
        return this.getString(databaseDriverName);
    }

    public void setDatabaseDriverName(String string) {
        this.setString(databaseDriverName, string, null);
    }

    public String getDatabaseDriverVersion() {
        return this.getString(databaseDriverVersion);
    }

    public void setDatabaseDriverVersion(String string) {
        this.setString(databaseDriverVersion, string, null);
    }

    public BDatabaseTypeEnum getDatabaseType() {
        return (BDatabaseTypeEnum)this.get(databaseType);
    }

    public void setDatabaseType(BDatabaseTypeEnum bDatabaseTypeEnum) {
        this.set(databaseType, (BValue)bDatabaseTypeEnum, null);
    }

    public BOrd getHostAddress() {
        return (BOrd)this.get(hostAddress);
    }

    public void setHostAddress(BOrd bOrd) {
        this.set(hostAddress, (BValue)bOrd, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public String getDatabaseUser() {
        return this.getString(databaseUser);
    }

    public void setDatabaseUser(String string) {
        this.setString(databaseUser, string, null);
    }

    public BPassword getDatabasePassword() {
        return (BPassword)this.get(databasePassword);
    }

    public void setDatabasePassword(BPassword bPassword) {
        this.set(databasePassword, (BValue)bPassword, null);
    }

    public boolean getSqlServerCreateNewDatabase() {
        return this.getBoolean(sqlServerCreateNewDatabase);
    }

    public void setSqlServerCreateNewDatabase(boolean bl) {
        this.setBoolean(sqlServerCreateNewDatabase, bl, null);
    }

    public String getSqlServerDatabaseName() {
        return this.getString(sqlServerDatabaseName);
    }

    public void setSqlServerDatabaseName(String string) {
        this.setString(sqlServerDatabaseName, string, null);
    }

    public String getSqlServerDbDataFilename() {
        return this.getString(sqlServerDbDataFilename);
    }

    public void setSqlServerDbDataFilename(String string) {
        this.setString(sqlServerDbDataFilename, string, null);
    }

    public String getSqlServerDbLogFilename() {
        return this.getString(sqlServerDbLogFilename);
    }

    public void setSqlServerDbLogFilename(String string) {
        this.setString(sqlServerDbLogFilename, string, null);
    }

    public String getOracleServiceName() {
        return this.getString(oracleServiceName);
    }

    public void setOracleServiceName(String string) {
        this.setString(oracleServiceName, string, null);
    }

    public void openDatabase() {
        this.invoke(openDatabase, null, null);
    }

    public void closeDatabase() {
        this.invoke(closeDatabase, null, null);
    }

    public void deleteEasTables() {
        this.invoke(deleteEasTables, null, null);
    }

    public void createEasTables() {
        this.invoke(createEasTables, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (Nre.getPlatform().isFlashFileSystem()) {
            throw new IllegalStateException("EAS Database Configuration may not be run on a flash file system.");
        }
    }

    public void stopped() throws Exception {
        this.doCloseDatabase();
    }

    public boolean isParentLegal(BComponent bComponent) {
        return false;
    }

    private BEasService getEasService() {
        return (BEasService)this.getParent();
    }

    public void doOpenDatabase() {
        this.openDatabase(true);
    }

    private void openDatabase(boolean bl) {
        block12: {
            BDatabaseTypeEnum bDatabaseTypeEnum = this.getDatabaseType();
            try {
                Wrapper wrapper;
                Wrapper wrapper2;
                if (Nre.getPlatform().isFlashFileSystem()) {
                    throw new IllegalStateException("EAS Database Configuration may not be run on a flash file system.");
                }
                this.doCloseDatabase();
                this.setDatabaseProductName("Opening connection...");
                if (bDatabaseTypeEnum == BDatabaseTypeEnum.sqlServer) {
                    wrapper2 = new JtdsDataSource();
                    ((JtdsDataSource)wrapper2).setServerName(this.getHostname());
                    ((JtdsDataSource)wrapper2).setPortNumber(this.getPort());
                    ((JtdsDataSource)wrapper2).setUser(this.getDatabaseUser());
                    ((JtdsDataSource)wrapper2).setPassword(this.getDatabasePassword().getString());
                    this.connectionPool = new ConnectionPool((JtdsDataSource)wrapper2, 10);
                } else if (bDatabaseTypeEnum == BDatabaseTypeEnum.oracle) {
                    wrapper2 = new OracleConnectionPoolDataSource();
                    String string = "jdbc:oracle:thin:@//" + this.getHostname() + ":" + this.getPort() + "/" + this.getOracleServiceName();
                    ((OracleDataSource)wrapper2).setURL(string);
                    ((OracleDataSource)wrapper2).setUser(this.getDatabaseUser());
                    ((OracleDataSource)wrapper2).setPassword(this.getDatabasePassword().getString());
                    this.connectionPool = new ConnectionPool((OracleConnectionPoolDataSource)wrapper2, 10);
                }
                wrapper2 = this.connectionPool.get();
                SqlUtil.initDatabaseParameters(this, (Connection)wrapper2);
                boolean bl2 = false;
                if (bDatabaseTypeEnum == BDatabaseTypeEnum.sqlServer) {
                    if (this.getSqlServerCreateNewDatabase()) {
                        wrapper = this.getConnection();
                        MSSqlServer.createDatabase((Connection)wrapper);
                        wrapper.close();
                        bl2 = true;
                    }
                    MSSqlServer.setDatabaseFilenames(this, (Connection)wrapper2);
                }
                wrapper = wrapper2.getMetaData();
                this.setDatabaseProductName(wrapper.getDatabaseProductName());
                String string = wrapper.getDatabaseProductVersion();
                this.setDatabaseProductVersion(string);
                this.setDatabaseDriverName(wrapper.getDriverName());
                this.setDatabaseDriverVersion(wrapper.getDriverVersion());
                this.setDatabaseConnected(true);
                if (this.connectionPool != null) {
                    this.connectionPool.free((Connection)wrapper2);
                }
                if (this.getDatabaseConnected()) {
                    this.getEasService().getDatabase().open();
                    this.currentDatabaseType = bDatabaseTypeEnum;
                }
                if (bl2) {
                    this.setBoolean(sqlServerCreateNewDatabase, false, noDbDisconnect);
                }
                this.getEasService().configOk();
            }
            catch (Exception exception) {
                this.doCloseDatabase();
                log.error("Could not open database connection", (Throwable)exception);
                this.getEasService().configFail("Could not open database connection: " + exception);
                if (!(exception instanceof SQLException)) break block12;
                for (SQLException sQLException = (SQLException)exception; sQLException != null; sQLException = sQLException.getNextException()) {
                    log.error("  ", (Throwable)sQLException);
                }
            }
        }
    }

    public void doCloseDatabase() {
        try {
            this.setDatabaseConnected(false);
            this.setDatabaseProductName("-");
            this.setDatabaseProductVersion("-");
            this.setDatabaseDriverName("-");
            this.setDatabaseDriverVersion("-");
            this.getEasService().configFail("Database Closed");
            if (this.connectionPool != null) {
                this.connectionPool.closeAll();
                this.connectionPool = null;
            }
        }
        catch (Exception exception) {
            this.connectionPool = null;
            log.error("Could not close database connection", (Throwable)exception);
        }
    }

    public Connection getConnection() throws SQLException, InterruptedException {
        this.checkConnected();
        return this.connectionPool.get();
    }

    public void freeConnection(Connection connection) {
        try {
            if (this.connectionPool != null) {
                this.connectionPool.free(connection);
            }
        }
        catch (Exception exception) {
            log.error("Could not free connection", (Throwable)exception);
        }
    }

    private void checkConnected() {
        if (this.connectionPool == null) {
            throw new IllegalStateException("Database not connected!");
        }
    }

    public String getDatabaseName() {
        if (this.getDatabaseType() == BDatabaseTypeEnum.sqlServer) {
            return this.getSqlServerDatabaseName();
        }
        return "";
    }

    private static final String replace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        int n = string2.length();
        int n2 = string.length();
        int n3 = string.indexOf(string2);
        if (n3 < 0) {
            return string;
        }
        n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n2) {
            if (string.regionMatches(n3, string2, 0, n)) {
                stringBuffer.append(string3);
                n3 += n;
                continue;
            }
            stringBuffer.append(string.charAt(n3));
            ++n3;
        }
        string = stringBuffer.toString();
        return string;
    }

    private String getHostname() {
        if (this.getHostAddress().isNull()) {
            return "";
        }
        return ((BHost)this.getHostAddress().get()).getHostname();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == databaseType && this.getDatabaseConnected()) {
            if (this.getDatabaseType() != this.currentDatabaseType) {
                this.doCloseDatabase();
            }
        } else if (context != noDbDisconnect && (property == sqlServerDatabaseName || property == sqlServerCreateNewDatabase)) {
            if (this.getDatabaseConnected() && this.getDatabaseType() == BDatabaseTypeEnum.sqlServer) {
                this.doCloseDatabase();
            }
            if (property == sqlServerDatabaseName) {
                this.setSqlServerDbLogFilename("");
                this.setSqlServerDbDataFilename("");
            }
        } else if (property == oracleServiceName && this.getDatabaseConnected()) {
            if (this.getDatabaseType() == BDatabaseTypeEnum.oracle) {
                this.doCloseDatabase();
            }
        } else if (this.getDatabaseConnected() && (property == hostAddress || property == port || property == databaseUser || property == databasePassword)) {
            this.doCloseDatabase();
        }
    }

    public void doDeleteEasTables() {
        try {
            if (this.getDatabaseConnected()) {
                this.getEasService().getDatabase().dropTables();
                this.doCloseDatabase();
            } else {
                log.error("Could not delete EAS tables because the database connection is closed.");
            }
        }
        catch (Exception exception) {
            log.error("Encountered a problem deleting EAS tables", (Throwable)exception);
        }
    }

    public void doCreateEasTables() {
        try {
            if (!this.getDatabaseConnected()) {
                this.doOpenDatabase();
            } else {
                log.error("Could not create EAS tables because the database is already open.");
            }
        }
        catch (Exception exception) {
            log.error("Encountered a problem creating EAS tables", (Throwable)exception);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

