/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BDefaultBattery;
import com.tridium.platPower.BIPowerService;
import com.tridium.platPower.BNpm2NimhBattery;
import com.tridium.platPower.BPowerState;
import com.tridium.platPower.PowerdQnx;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BPowerMonitorPlatformService
extends BPlatformService
implements BIAlarmablePlatformService,
BIPowerService {
    public static final Property primaryPowerPresent = BPowerMonitorPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property shutdownDelay = BPowerMonitorPlatformService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)10), (BFacets)BFacets.make((String[])new String[]{"showSeconds", "min"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0)}));
    public static final Property powerAlarmSupport = BPowerMonitorPlatformService.newProperty((int)0, (BValue)BPowerMonitorPlatformService.initPowerAlarmSupport(), null);
    public static final Property powerAlarmProxy = BPowerMonitorPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property battery = BPowerMonitorPlatformService.newProperty((int)3, (BValue)new BDefaultBattery(), null);
    public static final Property batteryGood = BPowerMonitorPlatformService.newProperty((int)1, (boolean)false, null);
    public static final Property timeOfLastTest = BPowerMonitorPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property batteryAlarmSupport = BPowerMonitorPlatformService.newProperty((int)0, (BValue)BPowerMonitorPlatformService.initBatteryAlarmSupport(), null);
    public static final Property batteryAlarmProxy = BPowerMonitorPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action primaryTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Action pollTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Action shutdownTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Action dischargeTimerExpired = BPowerMonitorPlatformService.newAction((int)4, null);
    public static final Topic powerState = BPowerMonitorPlatformService.newTopic((int)8, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private static final String ALARM_TYPE_PRIMARY_POWER = "primaryPower";
    private static final String ALARM_TYPE_BATTERY = "battery";
    int handle;
    private Clock.Ticket primaryTicket;
    private Clock.Ticket pollTicket;
    private Clock.Ticket shutdownTicket;
    private Clock.Ticket dischargeTicket;
    int lastChargeLevel;
    private boolean firstPass;
    static /* synthetic */ Class class$com$tridium$platPower$BPowerMonitorPlatformService;

    public boolean getPrimaryPowerPresent() {
        return this.getBoolean(primaryPowerPresent);
    }

    public void setPrimaryPowerPresent(boolean bl) {
        this.setBoolean(primaryPowerPresent, bl, null);
    }

    public BRelTime getShutdownDelay() {
        return (BRelTime)this.get(shutdownDelay);
    }

    public void setShutdownDelay(BRelTime bRelTime) {
        this.set(shutdownDelay, (BValue)bRelTime, null);
    }

    public BPlatformAlarmSupport getPowerAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(powerAlarmSupport);
    }

    public void setPowerAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(powerAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getPowerAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(powerAlarmProxy);
    }

    public void setPowerAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(powerAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BBattery getBattery() {
        return (BBattery)this.get(battery);
    }

    public void setBattery(BBattery bBattery) {
        this.set(battery, (BValue)bBattery, null);
    }

    public boolean getBatteryGood() {
        return this.getBoolean(batteryGood);
    }

    public void setBatteryGood(boolean bl) {
        this.setBoolean(batteryGood, bl, null);
    }

    public BAbsTime getTimeOfLastTest() {
        return (BAbsTime)this.get(timeOfLastTest);
    }

    public void setTimeOfLastTest(BAbsTime bAbsTime) {
        this.set(timeOfLastTest, (BValue)bAbsTime, null);
    }

    public BPlatformAlarmSupport getBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(batteryAlarmSupport);
    }

    public void setBatteryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(batteryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(batteryAlarmProxy);
    }

    public void setBatteryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(batteryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public void primaryTimerExpired() {
        this.invoke(primaryTimerExpired, null, null);
    }

    public void pollTimerExpired() {
        this.invoke(pollTimerExpired, null, null);
    }

    public void shutdownTimerExpired() {
        this.invoke(shutdownTimerExpired, null, null);
    }

    public void dischargeTimerExpired() {
        this.invoke(dischargeTimerExpired, null, null);
    }

    public void firePowerState(BPowerState bPowerState) {
        this.fire(powerState, (BValue)bPowerState, null);
    }

    public Type getType() {
        return TYPE;
    }

    public abstract BBattery getBatteryInstance();

    public abstract boolean isPrimaryPresent();

    public void doStationStarted(BStation bStation) {
        BComponent bComponent;
        BIDataRecoveryService bIDataRecoveryService;
        Object object;
        super.doStationStarted(bStation);
        try {
            object = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (object instanceof BSystemPlatformServiceQnx) {
                BSystemPlatformServiceQnx bSystemPlatformServiceQnx = (BSystemPlatformServiceQnx)object;
                bSystemPlatformServiceQnx.checkPropertiesLoaded();
                if (!bSystemPlatformServiceQnx.getIsBatteryPresent()) {
                    return;
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {}
        this.loadLibraries();
        object = this.getBatteryInstance();
        this.setBattery((BBattery)((Object)object));
        this.getBatteryAlarmProxy().setAlarmSupport(this.getBatteryAlarmSupport());
        this.getPowerAlarmProxy().setAlarmSupport(this.getPowerAlarmSupport());
        boolean bl = false;
        try {
            Property property;
            BFrozenEnum bFrozenEnum;
            bIDataRecoveryService = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (bIDataRecoveryService.isEnabled() && (bFrozenEnum = (BFrozenEnum)(bComponent = (BComponent)bIDataRecoveryService).get(property = bComponent.getProperty("dataRecoveryStatus"))) != null && bFrozenEnum.getOrdinal() != 8) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        if (!bl && this.getBatteryInstance() instanceof BNpm2NimhBattery && this.getShutdownDelay().getMillis() > BRelTime.makeMinutes((int)1).getMillis()) {
            this.setShutdownDelay(BRelTime.makeMinutes((int)1));
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
        }
        if (!(bComponent = ((BBattery)((Object)object)).validateShutdownDelay((BRelTime)(bIDataRecoveryService = this.getShutdownDelay()))).equals((Object)bIDataRecoveryService)) {
            log.warning("Invalid shutdown delay detected, setting to default");
            this.setShutdownDelay((BRelTime)bComponent);
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
        }
        this.doPrimaryTimerExpired();
        this.doPollTimerExpired();
        this.primaryTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)primaryTimerExpired, null);
        this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollTimerExpired, null);
    }

    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.primaryTicket != null) {
            this.primaryTicket.cancel();
        }
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        BRelTime bRelTime;
        BBattery bBattery;
        BRelTime bRelTime2;
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == shutdownDelay && !(bRelTime2 = (bBattery = this.getBattery()).validateShutdownDelay(bRelTime = this.getShutdownDelay())).equals((Object)bRelTime)) {
            log.warning("Invalid shutdown delay detected, setting to default");
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
            this.setShutdownDelay(bRelTime2);
        }
    }

    public void doPrimaryTimerExpired() {
        boolean bl = this.isPrimaryPresent();
        boolean bl2 = this.getPrimaryPowerPresent();
        this.setPrimaryPowerPresent(bl);
        if (!bl) {
            if (bl2 || this.firstPass) {
                log.message("Primary power lost");
                this.firePowerState(BPowerState.lost);
                if (!this.getBattery().isBatteryGood()) {
                    log.message("Battery bad, shutting down immediately");
                    this.doShutdownTimerExpired();
                    return;
                }
                if (this.shutdownTicket != null) {
                    this.shutdownTicket.cancel();
                }
                this.shutdownTicket = Clock.schedule((BComponent)this, (BRelTime)this.getShutdownDelay(), (Action)shutdownTimerExpired, null);
                try {
                    if (this.getBatteryInstance() instanceof BNpm2NimhBattery) {
                        this.lastChargeLevel = PowerdQnx.getBatteryCharge();
                        this.dischargeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)dischargeTimerExpired, null);
                    }
                }
                catch (Exception exception) {}
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeNewFaultAlarm();
                this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
        } else if (bl && !bl2) {
            log.message("Primary power restored");
            this.firePowerState(BPowerState.restored);
            if (this.shutdownTicket != null) {
                this.shutdownTicket.cancel();
            }
            if (this.dischargeTicket != null) {
                this.dischargeTicket.cancel();
            }
            BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeToNormal();
            this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
        }
        this.firstPass = false;
    }

    public void doPollTimerExpired() {
        if (!this.getPrimaryPowerPresent()) {
            return;
        }
        BBattery bBattery = this.getBattery();
        boolean bl = bBattery.isBatteryGood();
        boolean bl2 = this.getBatteryGood();
        this.setTimeOfLastTest(bBattery.getTestTime());
        this.setBatteryGood(bl);
        if (bl != bl2) {
            if (!bl && bl2) {
                log.message("Battery test failed");
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getBatteryAlarmSupport().makeNewFaultAlarm();
                this.getBatteryAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            } else if (bl && !bl2) {
                log.message("Battery test passed");
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getBatteryAlarmSupport().makeToNormal();
                this.getBatteryAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
        }
        bBattery.refresh();
    }

    public void doDischargeTimerExpired() {
        if (this.getBatteryInstance() instanceof BNpm2NimhBattery) {
            try {
                int n = PowerdQnx.getBatteryCharge();
                if (n == 0) {
                    log.message("NiMH battery discharged, shutting down");
                    this.doShutdownTimerExpired();
                } else if (n != this.lastChargeLevel) {
                    log.message("NiMH charge was ~" + this.lastChargeLevel + " %, now ~" + n + '%');
                    this.lastChargeLevel = n;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void doShutdownTimerExpired() {
        log.message("Primary power loss shutdown timer expired, saving database, shutting down");
        if (this.dischargeTicket != null) {
            this.dischargeTicket.cancel();
        }
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            bSystemPlatformService.reboot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBatteryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getBatteryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initBatteryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:batteryTestFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:batteryTestPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_BATTERY));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initPowerAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:primaryPowerLost)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:primaryPowerRestored)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_PRIMARY_POWER));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    protected abstract void loadLibraries();

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastChargeLevel = -1;
        this.firstPass = true;
    }

    public BPowerMonitorPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("PowerMonitorPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platPower$BPowerMonitorPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platPower$BPowerMonitorPlatformService = BPowerMonitorPlatformService.class("[Lcom.tridium.platPower.BPowerMonitorPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"batteryFull.png");
        log = Log.getLog((String)"power");
    }
}

