/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BIPowerService;
import com.tridium.platPower.BNpm2NimhBattery;
import com.tridium.platPower.BNpmExternalSlaBattery;
import com.tridium.platPower.PowerdQnx;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNpmDualBatteryPlatformService
extends BPlatformService
implements BIAlarmablePlatformService,
BIPowerService {
    public static final Property primaryPowerPresent = BNpmDualBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property shutdownDelay = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)10), (BFacets)BFacets.make((String[])new String[]{"showSeconds", "min"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0)}));
    public static final Property powerAlarmSupport = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BNpmDualBatteryPlatformService.initPowerAlarmSupport(), null);
    public static final Property powerAlarmProxy = BNpmDualBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property nimhBattery = BNpmDualBatteryPlatformService.newProperty((int)3, (BValue)new BNpm2NimhBattery(), null);
    public static final Property nimhBatteryGood = BNpmDualBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property nimhBatteryTimeOfLastTest = BNpmDualBatteryPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property nimhBatteryAlarmSupport = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BNpmDualBatteryPlatformService.initNimhBatteryAlarmSupport(), null);
    public static final Property nimhBatteryAlarmProxy = BNpmDualBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property slaBatteryPresent = BNpmDualBatteryPlatformService.newProperty((int)0, (boolean)false, null);
    public static final Property slaBattery = BNpmDualBatteryPlatformService.newProperty((int)3, (BValue)new BNpmExternalSlaBattery(), null);
    public static final Property slaBatteryGood = BNpmDualBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property slaBatteryTimeOfLastTest = BNpmDualBatteryPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property slaBatteryAlarmSupport = BNpmDualBatteryPlatformService.newProperty((int)0, (BValue)BNpmDualBatteryPlatformService.initSlaBatteryAlarmSupport(), null);
    public static final Property slaBatteryAlarmProxy = BNpmDualBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action primaryTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Action pollTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Action shutdownTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Action dischargeTimerExpired = BNpmDualBatteryPlatformService.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private static final String ALARM_TYPE_PRIMARY_POWER = "primaryPower";
    private static final String ALARM_TYPE_NIMH_BATTERY = "nimhBattery";
    private static final String ALARM_TYPE_SLA_BATTERY = "slaBattery";
    int handle;
    private Clock.Ticket primaryTicket;
    private Clock.Ticket pollTicket;
    private Clock.Ticket shutdownTicket;
    private Clock.Ticket dischargeTicket;
    int lastChargeLevel;
    boolean firstPass;
    static /* synthetic */ Class class$com$tridium$platPower$BNpmDualBatteryPlatformService;

    public boolean getPrimaryPowerPresent() {
        return this.getBoolean(primaryPowerPresent);
    }

    public void setPrimaryPowerPresent(boolean bl) {
        this.setBoolean(primaryPowerPresent, bl, null);
    }

    public BRelTime getShutdownDelay() {
        return (BRelTime)this.get(shutdownDelay);
    }

    public void setShutdownDelay(BRelTime bRelTime) {
        this.set(shutdownDelay, (BValue)bRelTime, null);
    }

    public BPlatformAlarmSupport getPowerAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(powerAlarmSupport);
    }

    public void setPowerAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(powerAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getPowerAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(powerAlarmProxy);
    }

    public void setPowerAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(powerAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BBattery getNimhBattery() {
        return (BBattery)this.get(nimhBattery);
    }

    public void setNimhBattery(BBattery bBattery) {
        this.set(nimhBattery, (BValue)bBattery, null);
    }

    public boolean getNimhBatteryGood() {
        return this.getBoolean(nimhBatteryGood);
    }

    public void setNimhBatteryGood(boolean bl) {
        this.setBoolean(nimhBatteryGood, bl, null);
    }

    public BAbsTime getNimhBatteryTimeOfLastTest() {
        return (BAbsTime)this.get(nimhBatteryTimeOfLastTest);
    }

    public void setNimhBatteryTimeOfLastTest(BAbsTime bAbsTime) {
        this.set(nimhBatteryTimeOfLastTest, (BValue)bAbsTime, null);
    }

    public BPlatformAlarmSupport getNimhBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(nimhBatteryAlarmSupport);
    }

    public void setNimhBatteryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(nimhBatteryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getNimhBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(nimhBatteryAlarmProxy);
    }

    public void setNimhBatteryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(nimhBatteryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public boolean getSlaBatteryPresent() {
        return this.getBoolean(slaBatteryPresent);
    }

    public void setSlaBatteryPresent(boolean bl) {
        this.setBoolean(slaBatteryPresent, bl, null);
    }

    public BBattery getSlaBattery() {
        return (BBattery)this.get(slaBattery);
    }

    public void setSlaBattery(BBattery bBattery) {
        this.set(slaBattery, (BValue)bBattery, null);
    }

    public boolean getSlaBatteryGood() {
        return this.getBoolean(slaBatteryGood);
    }

    public void setSlaBatteryGood(boolean bl) {
        this.setBoolean(slaBatteryGood, bl, null);
    }

    public BAbsTime getSlaBatteryTimeOfLastTest() {
        return (BAbsTime)this.get(slaBatteryTimeOfLastTest);
    }

    public void setSlaBatteryTimeOfLastTest(BAbsTime bAbsTime) {
        this.set(slaBatteryTimeOfLastTest, (BValue)bAbsTime, null);
    }

    public BPlatformAlarmSupport getSlaBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(slaBatteryAlarmSupport);
    }

    public void setSlaBatteryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(slaBatteryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getSlaBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(slaBatteryAlarmProxy);
    }

    public void setSlaBatteryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(slaBatteryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public void primaryTimerExpired() {
        this.invoke(primaryTimerExpired, null, null);
    }

    public void pollTimerExpired() {
        this.invoke(pollTimerExpired, null, null);
    }

    public void shutdownTimerExpired() {
        this.invoke(shutdownTimerExpired, null, null);
    }

    public void dischargeTimerExpired() {
        this.invoke(dischargeTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return false;
    }

    protected void loadLibraries() {
        log.trace("Loading libPower.so...");
        PowerdQnx.loadLibraries();
        PowerdQnx.open();
    }

    public boolean isPrimaryPresent() {
        return PowerdQnx.isPrimaryPresent();
    }

    public void doStationStarted(BStation bStation) {
        BSystemPlatformServiceQnx bSystemPlatformServiceQnx;
        super.doStationStarted(bStation);
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (bSystemPlatformService instanceof BSystemPlatformServiceQnx) {
                bSystemPlatformServiceQnx = (BSystemPlatformServiceQnx)bSystemPlatformService;
                bSystemPlatformServiceQnx.checkPropertiesLoaded();
                if (!bSystemPlatformServiceQnx.getIsBatteryPresent()) {
                    return;
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {}
        this.loadLibraries();
        this.getNimhBatteryAlarmProxy().setAlarmSupport(this.getNimhBatteryAlarmSupport());
        this.getSlaBatteryAlarmProxy().setAlarmSupport(this.getSlaBatteryAlarmSupport());
        this.getPowerAlarmProxy().setAlarmSupport(this.getPowerAlarmSupport());
        boolean bl = false;
        try {
            Property property;
            BComponent bComponent;
            BFrozenEnum bFrozenEnum;
            bSystemPlatformServiceQnx = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (bSystemPlatformServiceQnx.isEnabled() && (bFrozenEnum = (BFrozenEnum)(bComponent = (BComponent)bSystemPlatformServiceQnx).get(property = bComponent.getProperty("dataRecoveryStatus"))) != null && bFrozenEnum.getOrdinal() != 8) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        if (!bl && !this.getSlaBatteryPresent() && this.getShutdownDelay().getMillis() > BRelTime.makeMinutes((int)1).getMillis()) {
            this.setShutdownDelay(BRelTime.makeMinutes((int)1));
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
        }
        this.doPrimaryTimerExpired();
        this.doPollTimerExpired();
        this.primaryTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)primaryTimerExpired, null);
        this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollTimerExpired, null);
    }

    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.primaryTicket != null) {
            this.primaryTicket.cancel();
        }
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
    }

    public void doPrimaryTimerExpired() {
        boolean bl = this.isPrimaryPresent();
        boolean bl2 = this.getPrimaryPowerPresent();
        this.setPrimaryPowerPresent(bl);
        if (!bl) {
            if (bl2 || this.firstPass) {
                log.message("Primary power lost");
                if (this.getSlaBatteryPresent()) {
                    if (!this.getNimhBattery().isBatteryGood() || !this.getSlaBattery().isBatteryGood()) {
                        log.message("Batteries bad, shutting down immediately");
                        this.doShutdownTimerExpired();
                        return;
                    }
                } else if (!this.getNimhBattery().isBatteryGood()) {
                    log.message("Battery bad, shutting down immediately");
                    this.doShutdownTimerExpired();
                    return;
                }
                if (this.shutdownTicket != null) {
                    this.shutdownTicket.cancel();
                }
                this.shutdownTicket = Clock.schedule((BComponent)this, (BRelTime)this.getShutdownDelay(), (Action)shutdownTimerExpired, null);
                this.lastChargeLevel = PowerdQnx.getBatteryCharge();
                this.dischargeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)dischargeTimerExpired, null);
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeNewFaultAlarm();
                this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
        } else if (bl && !bl2) {
            log.message("Primary power restored");
            if (this.shutdownTicket != null) {
                this.shutdownTicket.cancel();
            }
            if (this.dischargeTicket != null) {
                this.dischargeTicket.cancel();
            }
            BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeToNormal();
            this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
        }
        this.firstPass = false;
    }

    public boolean checkBattery(BBattery bBattery, String string, boolean bl, BPlatformAlarmSupport bPlatformAlarmSupport, BPlatformAlarmProxy bPlatformAlarmProxy) {
        boolean bl2 = bBattery.isBatteryGood();
        if (bl2 != bl) {
            if (!bl2 && bl) {
                log.message(string + " battery test failed");
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = bPlatformAlarmSupport.makeNewFaultAlarm();
                bPlatformAlarmProxy.firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            } else if (bl2 && !bl) {
                log.message(string + " battery test passed");
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = bPlatformAlarmSupport.makeToNormal();
                bPlatformAlarmProxy.firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
        }
        return bl2;
    }

    public void doPollTimerExpired() {
        if (!this.isPrimaryPresent()) {
            return;
        }
        BBattery bBattery = this.getNimhBattery();
        boolean bl = this.checkBattery(this.getNimhBattery(), "NiMH", this.getNimhBatteryGood(), this.getNimhBatteryAlarmSupport(), this.getNimhBatteryAlarmProxy());
        this.setNimhBatteryTimeOfLastTest(bBattery.getTestTime());
        this.setNimhBatteryGood(bl);
        bBattery.refresh();
        if (this.getSlaBatteryPresent()) {
            BBattery bBattery2 = this.getSlaBattery();
            boolean bl2 = this.checkBattery(this.getSlaBattery(), "SLA", this.getSlaBatteryGood(), this.getSlaBatteryAlarmSupport(), this.getSlaBatteryAlarmProxy());
            this.setSlaBatteryTimeOfLastTest(bBattery2.getTestTime());
            this.setSlaBatteryGood(bl2);
            bBattery2.refresh();
        }
    }

    public void doDischargeTimerExpired() {
        int n = PowerdQnx.getBatteryCharge();
        if (n == 0) {
            log.message("NiMH battery discharged, shutting down");
            this.doShutdownTimerExpired();
        } else if (n != this.lastChargeLevel) {
            log.message("NiMH charge was ~" + this.lastChargeLevel + " %, now ~" + n + '%');
            this.lastChargeLevel = n;
        }
    }

    public void doShutdownTimerExpired() {
        log.message("Primary power loss shutdown timer expired, saving database, shutting down");
        if (this.dischargeTicket != null) {
            this.dischargeTicket.cancel();
        }
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            bSystemPlatformService.reboot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getNimhBatteryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSlaBatteryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getNimhBatteryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSlaBatteryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initNimhBatteryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:nimhBatteryTestFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:nimhBatteryTestPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_NIMH_BATTERY));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initSlaBatteryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:slaBatteryTestFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:slaBatteryTestPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_SLA_BATTERY));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initPowerAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:primaryPowerLost)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:primaryPowerRestored)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_PRIMARY_POWER));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastChargeLevel = -1;
        this.firstPass = true;
    }

    public BNpmDualBatteryPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("PowerMonitorPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platPower$BNpmDualBatteryPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platPower$BNpmDualBatteryPlatformService = BNpmDualBatteryPlatformService.class("[Lcom.tridium.platPower.BNpmDualBatteryPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"batteryFull.png");
        log = Log.getLog((String)"power");
    }
}

