/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BExternalSlaBattery;
import com.tridium.platPower.BIPowerService;
import com.tridium.platPower.BNimhBattery;
import com.tridium.platPower.BUpsBattery;
import com.tridium.platPower.PowerdQnx;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BIAlarmablePlatformService;
import com.tridium.platform.alarm.BPlatformAlarmProxy;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.PlatformServiceAlarmListener;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJavelinaBatteryPlatformService
extends BPlatformService
implements BIAlarmablePlatformService,
BIPowerService {
    public static final Property primaryPowerPresent = BJavelinaBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property shutdownDelay = BJavelinaBatteryPlatformService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)10), (BFacets)BFacets.make((String[])new String[]{"showSeconds", "min"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BRelTime.makeMinutes((int)0)}));
    public static final Property powerAlarmSupport = BJavelinaBatteryPlatformService.newProperty((int)0, (BValue)BJavelinaBatteryPlatformService.initPowerAlarmSupport(), null);
    public static final Property powerAlarmProxy = BJavelinaBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property nimhBattery = BJavelinaBatteryPlatformService.newProperty((int)3, (BValue)new BNimhBattery(), null);
    public static final Property nimhBatteryGood = BJavelinaBatteryPlatformService.newProperty((int)1, (boolean)true, null);
    public static final Property nimhBatteryTimeOfLastTest = BJavelinaBatteryPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property nimhBatteryAlarmSupport = BJavelinaBatteryPlatformService.newProperty((int)0, (BValue)BJavelinaBatteryPlatformService.initNimhBatteryAlarmSupport(), null);
    public static final Property nimhBatteryAlarmProxy = BJavelinaBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property slaBatteryPresent = BJavelinaBatteryPlatformService.newProperty((int)0, (boolean)false, null);
    public static final Property slaBattery = BJavelinaBatteryPlatformService.newProperty((int)3, (BValue)new BExternalSlaBattery(), null);
    public static final Property slaBatteryGood = BJavelinaBatteryPlatformService.newProperty((int)1, (boolean)false, null);
    public static final Property slaBatteryTimeOfLastTest = BJavelinaBatteryPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property useDisplayWithSlaBattery = BJavelinaBatteryPlatformService.newProperty((int)4, (boolean)false, null);
    public static final Property slaBatteryAlarmSupport = BJavelinaBatteryPlatformService.newProperty((int)0, (BValue)BJavelinaBatteryPlatformService.initSlaBatteryAlarmSupport(), null);
    public static final Property slaBatteryAlarmProxy = BJavelinaBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property upsPresent = BJavelinaBatteryPlatformService.newProperty((int)0, (boolean)false, null);
    public static final Property upsAcPowerPresent = BJavelinaBatteryPlatformService.newProperty((int)1, (boolean)false, null);
    public static final Property upsPowerAlarmSupport = BJavelinaBatteryPlatformService.newProperty((int)0, (BValue)BJavelinaBatteryPlatformService.initUpsPowerAlarmSupport(), null);
    public static final Property upsPowerAlarmProxy = BJavelinaBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Property upsBattery = BJavelinaBatteryPlatformService.newProperty((int)3, (BValue)new BUpsBattery(), null);
    public static final Property upsBatteryGood = BJavelinaBatteryPlatformService.newProperty((int)1, (boolean)false, null);
    public static final Property upsBatteryTimeOfLastTest = BJavelinaBatteryPlatformService.newProperty((int)1, (BValue)BAbsTime.make(), null);
    public static final Property upsBatteryAlarmSupport = BJavelinaBatteryPlatformService.newProperty((int)0, (BValue)BJavelinaBatteryPlatformService.initUpsBatteryAlarmSupport(), null);
    public static final Property upsBatteryAlarmProxy = BJavelinaBatteryPlatformService.newProperty((int)6, (BValue)new BPlatformAlarmProxy(), null);
    public static final Action primaryTimerExpired = BJavelinaBatteryPlatformService.newAction((int)4, null);
    public static final Action pollTimerExpired = BJavelinaBatteryPlatformService.newAction((int)4, null);
    public static final Action shutdownTimerExpired = BJavelinaBatteryPlatformService.newAction((int)4, null);
    public static final Action dischargeTimerExpired = BJavelinaBatteryPlatformService.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static Log log;
    private static final String ALARM_TYPE_PRIMARY_POWER = "primaryPower";
    private static final String ALARM_TYPE_NIMH_BATTERY = "nimhBattery";
    private static final String ALARM_TYPE_SLA_BATTERY = "slaBattery";
    private static final String ALARM_TYPE_UPS_POWER = "upsPower";
    private static final String ALARM_TYPE_UPS_BATTERY = "upsBattery";
    int handle;
    private Clock.Ticket primaryTicket;
    private Clock.Ticket pollTicket;
    private Clock.Ticket shutdownTicket;
    private Clock.Ticket dischargeTicket;
    int lastChargeLevel;
    boolean firstPass;
    static /* synthetic */ Class class$com$tridium$platPower$BJavelinaBatteryPlatformService;

    public boolean getPrimaryPowerPresent() {
        return this.getBoolean(primaryPowerPresent);
    }

    public void setPrimaryPowerPresent(boolean bl) {
        this.setBoolean(primaryPowerPresent, bl, null);
    }

    public BRelTime getShutdownDelay() {
        return (BRelTime)this.get(shutdownDelay);
    }

    public void setShutdownDelay(BRelTime bRelTime) {
        this.set(shutdownDelay, (BValue)bRelTime, null);
    }

    public BPlatformAlarmSupport getPowerAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(powerAlarmSupport);
    }

    public void setPowerAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(powerAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getPowerAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(powerAlarmProxy);
    }

    public void setPowerAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(powerAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BBattery getNimhBattery() {
        return (BBattery)this.get(nimhBattery);
    }

    public void setNimhBattery(BBattery bBattery) {
        this.set(nimhBattery, (BValue)bBattery, null);
    }

    public boolean getNimhBatteryGood() {
        return this.getBoolean(nimhBatteryGood);
    }

    public void setNimhBatteryGood(boolean bl) {
        this.setBoolean(nimhBatteryGood, bl, null);
    }

    public BAbsTime getNimhBatteryTimeOfLastTest() {
        return (BAbsTime)this.get(nimhBatteryTimeOfLastTest);
    }

    public void setNimhBatteryTimeOfLastTest(BAbsTime bAbsTime) {
        this.set(nimhBatteryTimeOfLastTest, (BValue)bAbsTime, null);
    }

    public BPlatformAlarmSupport getNimhBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(nimhBatteryAlarmSupport);
    }

    public void setNimhBatteryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(nimhBatteryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getNimhBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(nimhBatteryAlarmProxy);
    }

    public void setNimhBatteryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(nimhBatteryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public boolean getSlaBatteryPresent() {
        return this.getBoolean(slaBatteryPresent);
    }

    public void setSlaBatteryPresent(boolean bl) {
        this.setBoolean(slaBatteryPresent, bl, null);
    }

    public BBattery getSlaBattery() {
        return (BBattery)this.get(slaBattery);
    }

    public void setSlaBattery(BBattery bBattery) {
        this.set(slaBattery, (BValue)bBattery, null);
    }

    public boolean getSlaBatteryGood() {
        return this.getBoolean(slaBatteryGood);
    }

    public void setSlaBatteryGood(boolean bl) {
        this.setBoolean(slaBatteryGood, bl, null);
    }

    public BAbsTime getSlaBatteryTimeOfLastTest() {
        return (BAbsTime)this.get(slaBatteryTimeOfLastTest);
    }

    public void setSlaBatteryTimeOfLastTest(BAbsTime bAbsTime) {
        this.set(slaBatteryTimeOfLastTest, (BValue)bAbsTime, null);
    }

    public boolean getUseDisplayWithSlaBattery() {
        return this.getBoolean(useDisplayWithSlaBattery);
    }

    public void setUseDisplayWithSlaBattery(boolean bl) {
        this.setBoolean(useDisplayWithSlaBattery, bl, null);
    }

    public BPlatformAlarmSupport getSlaBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(slaBatteryAlarmSupport);
    }

    public void setSlaBatteryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(slaBatteryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getSlaBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(slaBatteryAlarmProxy);
    }

    public void setSlaBatteryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(slaBatteryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public boolean getUpsPresent() {
        return this.getBoolean(upsPresent);
    }

    public void setUpsPresent(boolean bl) {
        this.setBoolean(upsPresent, bl, null);
    }

    public boolean getUpsAcPowerPresent() {
        return this.getBoolean(upsAcPowerPresent);
    }

    public void setUpsAcPowerPresent(boolean bl) {
        this.setBoolean(upsAcPowerPresent, bl, null);
    }

    public BPlatformAlarmSupport getUpsPowerAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(upsPowerAlarmSupport);
    }

    public void setUpsPowerAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(upsPowerAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getUpsPowerAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(upsPowerAlarmProxy);
    }

    public void setUpsPowerAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(upsPowerAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public BBattery getUpsBattery() {
        return (BBattery)this.get(upsBattery);
    }

    public void setUpsBattery(BBattery bBattery) {
        this.set(upsBattery, (BValue)bBattery, null);
    }

    public boolean getUpsBatteryGood() {
        return this.getBoolean(upsBatteryGood);
    }

    public void setUpsBatteryGood(boolean bl) {
        this.setBoolean(upsBatteryGood, bl, null);
    }

    public BAbsTime getUpsBatteryTimeOfLastTest() {
        return (BAbsTime)this.get(upsBatteryTimeOfLastTest);
    }

    public void setUpsBatteryTimeOfLastTest(BAbsTime bAbsTime) {
        this.set(upsBatteryTimeOfLastTest, (BValue)bAbsTime, null);
    }

    public BPlatformAlarmSupport getUpsBatteryAlarmSupport() {
        return (BPlatformAlarmSupport)this.get(upsBatteryAlarmSupport);
    }

    public void setUpsBatteryAlarmSupport(BPlatformAlarmSupport bPlatformAlarmSupport) {
        this.set(upsBatteryAlarmSupport, (BValue)bPlatformAlarmSupport, null);
    }

    public BPlatformAlarmProxy getUpsBatteryAlarmProxy() {
        return (BPlatformAlarmProxy)this.get(upsBatteryAlarmProxy);
    }

    public void setUpsBatteryAlarmProxy(BPlatformAlarmProxy bPlatformAlarmProxy) {
        this.set(upsBatteryAlarmProxy, (BValue)bPlatformAlarmProxy, null);
    }

    public void primaryTimerExpired() {
        this.invoke(primaryTimerExpired, null, null);
    }

    public void pollTimerExpired() {
        this.invoke(pollTimerExpired, null, null);
    }

    public void shutdownTimerExpired() {
        this.invoke(shutdownTimerExpired, null, null);
    }

    public void dischargeTimerExpired() {
        this.invoke(dischargeTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return false;
    }

    protected void loadLibraries() {
        log.trace("Loading libPower.so...");
        PowerdQnx.loadLibraries();
        PowerdQnx.open();
    }

    public boolean isPrimaryPresent() {
        return PowerdQnx.isPrimaryPresent();
    }

    public void doStationStarted(BStation bStation) {
        Object object;
        Object object2;
        super.doStationStarted(bStation);
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            if (bSystemPlatformService instanceof BSystemPlatformServiceQnx) {
                object2 = (BSystemPlatformServiceQnx)bSystemPlatformService;
                object2.checkPropertiesLoaded();
                if (!object2.getIsBatteryPresent()) {
                    return;
                }
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {}
        this.loadLibraries();
        this.getNimhBatteryAlarmProxy().setAlarmSupport(this.getNimhBatteryAlarmSupport());
        this.getSlaBatteryAlarmProxy().setAlarmSupport(this.getSlaBatteryAlarmSupport());
        this.getPowerAlarmProxy().setAlarmSupport(this.getPowerAlarmSupport());
        this.getUpsPowerAlarmProxy().setAlarmSupport(this.getUpsPowerAlarmSupport());
        this.getUpsBatteryAlarmProxy().setAlarmSupport(this.getUpsBatteryAlarmSupport());
        this.doPrimaryTimerExpired();
        this.doPollTimerExpired();
        boolean bl = false;
        try {
            Property property;
            BFrozenEnum bFrozenEnum;
            object2 = (BIDataRecoveryService)Sys.getService((Type)BIDataRecoveryService.TYPE);
            if (object2.isEnabled() && (bFrozenEnum = (BFrozenEnum)(object = (BComponent)object2).get(property = object.getProperty("dataRecoveryStatus"))) != null && bFrozenEnum.getOrdinal() != 8) {
                bl = true;
            }
        }
        catch (Exception exception) {}
        if (!bl && !this.getSlaBatteryPresent() && this.getShutdownDelay().getMillis() > BRelTime.makeMinutes((int)1).getMillis()) {
            this.setShutdownDelay(BRelTime.makeMinutes((int)1));
            ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
        }
        this.primaryTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)primaryTimerExpired, null);
        this.pollTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollTimerExpired, null);
        if (this.getSlaBatteryPresent() && this.getUseDisplayWithSlaBattery()) {
            try {
                log.trace("setting to use display on external battery");
                object2 = "DISPLAY USEBATTERY TRUE";
                object = new FileWriter("/dev/uicmd", true);
                ((Writer)object).write((String)object2);
                ((OutputStreamWriter)object).close();
            }
            catch (Exception exception) {
                log.error("Unable to set uicmd to keep display on/off", (Throwable)exception);
            }
        }
    }

    public final void serviceStopped() throws Exception {
        super.serviceStopped();
        if (this.primaryTicket != null) {
            this.primaryTicket.cancel();
        }
        if (this.pollTicket != null) {
            this.pollTicket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == useDisplayWithSlaBattery || property == slaBatteryPresent) {
            String string;
            if (this.getSlaBatteryPresent()) {
                if (this.getUseDisplayWithSlaBattery()) {
                    log.trace("setting to use display on external battery");
                    string = "DISPLAY USEBATTERY TRUE";
                } else {
                    string = "DISPLAY USEBATTERY FALSE";
                }
            } else {
                string = "DISPLAY USEBATTERY FALSE";
            }
            try {
                FileWriter fileWriter = new FileWriter("/dev/uicmd", true);
                fileWriter.write(string);
                fileWriter.close();
            }
            catch (Exception exception) {
                log.error("Unable to set uicmd to keep display on/off", (Throwable)exception);
            }
        }
    }

    public void doPrimaryTimerExpired() {
        boolean bl = this.isPrimaryPresent();
        boolean bl2 = this.getPrimaryPowerPresent();
        this.setPrimaryPowerPresent(bl);
        if (!bl) {
            if (bl2 || this.firstPass) {
                log.message("Primary power lost");
                if (this.getSlaBatteryPresent()) {
                    if (!this.getNimhBattery().isBatteryGood() || !this.getSlaBattery().isBatteryGood()) {
                        log.message("Batteries bad, shutting down immediately");
                        this.doShutdownTimerExpired();
                        return;
                    }
                } else if (!this.getNimhBattery().isBatteryGood()) {
                    log.message("Battery bad, shutting down immediately");
                    this.doShutdownTimerExpired();
                    return;
                }
                if (this.shutdownTicket != null) {
                    this.shutdownTicket.cancel();
                }
                this.shutdownTicket = Clock.schedule((BComponent)this, (BRelTime)this.getShutdownDelay(), (Action)shutdownTimerExpired, null);
                this.lastChargeLevel = PowerdQnx.getBatteryCharge();
                this.dischargeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)dischargeTimerExpired, null);
                BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeNewFaultAlarm();
                this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
            }
        } else if (bl && !bl2) {
            log.message("Primary power restored");
            if (this.shutdownTicket != null) {
                this.shutdownTicket.cancel();
            }
            if (this.dischargeTicket != null) {
                this.dischargeTicket.cancel();
            }
            BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = this.getPowerAlarmSupport().makeToNormal();
            this.getPowerAlarmProxy().firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
        }
        this.firstPass = false;
        if (this.getUpsPresent()) {
            this.setUpsAcPowerPresent(PowerdQnx.isUpsPowerPresent());
        }
    }

    public boolean checkBattery(BBattery bBattery, String string, boolean bl, BPlatformAlarmSupport bPlatformAlarmSupport, BPlatformAlarmProxy bPlatformAlarmProxy) {
        try {
            boolean bl2 = bBattery.isBatteryGood();
            log.trace("checking battery " + string + '[' + (Object)((Object)bBattery) + "] -> batteryOk = " + bl2);
            if (bl2 != bl) {
                if (!bl2 && bl) {
                    log.message(string + " battery test failed");
                    BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = bPlatformAlarmSupport.makeNewFaultAlarm();
                    bPlatformAlarmProxy.firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                } else if (bl2 && !bl) {
                    log.message(string + " battery test passed");
                    BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord = bPlatformAlarmSupport.makeToNormal();
                    bPlatformAlarmProxy.firePlatformServiceAlarmEvent(bPlatformServiceAlarmRecord);
                }
            }
            return bl2;
        }
        catch (Exception exception) {
            log.error("problem checking battery " + string, (Throwable)exception);
            return false;
        }
    }

    public void doPollTimerExpired() {
        boolean bl;
        BBattery bBattery;
        if (!this.isPrimaryPresent()) {
            return;
        }
        BBattery bBattery2 = this.getNimhBattery();
        boolean bl2 = this.checkBattery(this.getNimhBattery(), "NiMH", this.getNimhBatteryGood(), this.getNimhBatteryAlarmSupport(), this.getNimhBatteryAlarmProxy());
        this.setNimhBatteryTimeOfLastTest(bBattery2.getTestTime());
        this.setNimhBatteryGood(bl2);
        bBattery2.refresh();
        if (this.getSlaBatteryPresent()) {
            bBattery = this.getSlaBattery();
            bl = this.checkBattery(this.getSlaBattery(), "SLA", this.getSlaBatteryGood(), this.getSlaBatteryAlarmSupport(), this.getSlaBatteryAlarmProxy());
            this.setSlaBatteryTimeOfLastTest(bBattery.getTestTime());
            this.setSlaBatteryGood(bl);
            bBattery.refresh();
        }
        if (this.getUpsPresent()) {
            bBattery = this.getUpsBattery();
            bl = this.checkBattery(this.getUpsBattery(), "UPS", this.getUpsBatteryGood(), this.getUpsBatteryAlarmSupport(), this.getUpsBatteryAlarmProxy());
            this.setUpsBatteryTimeOfLastTest(bBattery.getTestTime());
            this.setUpsBatteryGood(bl);
            bBattery.refresh();
        }
    }

    public void doDischargeTimerExpired() {
        int n = PowerdQnx.getBatteryCharge();
        if (n == 0) {
            log.message("NiMH battery discharged, shutting down");
            this.doShutdownTimerExpired();
        } else if (n != this.lastChargeLevel) {
            log.message("NiMH charge was ~" + this.lastChargeLevel + " %, now ~" + n + '%');
            this.lastChargeLevel = n;
        }
    }

    public void doShutdownTimerExpired() {
        log.message("Primary power loss shutdown timer expired, saving database, shutting down");
        if (this.dischargeTicket != null) {
            this.dischargeTicket.cancel();
        }
        try {
            BSystemPlatformService bSystemPlatformService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            bSystemPlatformService.reboot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public void addPlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getNimhBatteryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSlaBatteryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getUpsPowerAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getUpsBatteryAlarmProxy().addPlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void removePlatformServiceAlarmListener(PlatformServiceAlarmListener platformServiceAlarmListener) {
        this.getPowerAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getNimhBatteryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getSlaBatteryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getUpsPowerAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
        this.getUpsBatteryAlarmProxy().removePlatformServiceAlarmListener(platformServiceAlarmListener);
    }

    public void firePlatformServiceAlarmEvent(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    public BBoolean ackAlarm(BPlatformServiceAlarmRecord bPlatformServiceAlarmRecord) {
        throw new IllegalStateException();
    }

    static BPlatformAlarmSupport initNimhBatteryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:nimhBatteryTestFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:nimhBatteryTestPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_NIMH_BATTERY));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initSlaBatteryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:slaBatteryTestFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:slaBatteryTestPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_SLA_BATTERY));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initPowerAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:primaryPowerLost)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:primaryPowerRestored)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_PRIMARY_POWER));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initUpsPowerAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:upsPrimaryPowerLost)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:upsPrimaryPowerRestored)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_UPS_POWER));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    static BPlatformAlarmSupport initUpsBatteryAlarmSupport() {
        BPlatformAlarmSupport bPlatformAlarmSupport = new BPlatformAlarmSupport();
        bPlatformAlarmSupport.setSourceName(BFormat.make((String)"%parent.displayName%"));
        bPlatformAlarmSupport.setToFaultText(BFormat.make((String)"%lexicon(platPower:upsBatteryTestFail)%"));
        bPlatformAlarmSupport.setToNormalText(BFormat.make((String)"%lexicon(platPower:upsBatteryTestPassed)%"));
        HashMap<String, BString> hashMap = new HashMap<String, BString>();
        hashMap.put("alarmType", BString.make((String)ALARM_TYPE_UPS_BATTERY));
        bPlatformAlarmSupport.setMetaData(BFacets.make(hashMap));
        return bPlatformAlarmSupport;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastChargeLevel = -1;
        this.firstPass = true;
    }

    public BJavelinaBatteryPlatformService() {
        this.this();
        this.setPlatformServiceDescription(this.getLexicon().getText("PowerMonitorPlatformService.description"));
    }

    static {
        Class clazz = class$com$tridium$platPower$BJavelinaBatteryPlatformService;
        if (clazz == null) {
            clazz = class$com$tridium$platPower$BJavelinaBatteryPlatformService = BJavelinaBatteryPlatformService.class("[Lcom.tridium.platPower.BJavelinaBatteryPlatformService;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"batteryFull.png");
        log = Log.getLog((String)"power");
    }
}

