/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciSupport;

import com.jci.jciSupport.ReflectUtils;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;

public class BJciMakeTuningPolicies {
    public static final int DEFAULT = 0;
    public static final int JCI_BACNET_PERSISTED_SLOW = 0;
    public static final int JCI_BACNET_HARDWARE_NORMAL = 1;
    public static final int JCI_BACNET_HARDWARE_FAST = 2;
    public static final int JCI_BACNET_NETWORK_INPUT = 3;
    public static final int JCI_BACNET_NETWORK_INPUT_PEER = 4;
    public static final int JCI_NUMBER_OF_BACNET_TUNING_POLICIES = 5;
    public static final int JCI_N2_SLAVE = 5;

    public static BComponent makePolicy(int n) {
        BComponent bComponent;
        switch (n) {
            case 0: {
                bComponent = BJciMakeTuningPolicies.makeBacnetPersistedSlow();
                break;
            }
            case 1: {
                bComponent = BJciMakeTuningPolicies.makeBacnetHWNormal();
                break;
            }
            case 2: {
                bComponent = BJciMakeTuningPolicies.makeBacnetHWFast();
                break;
            }
            case 3: {
                bComponent = BJciMakeTuningPolicies.makeBacnetNetworkInput();
                break;
            }
            case 4: {
                bComponent = BJciMakeTuningPolicies.makeBacnetNetworkInputPeer();
                break;
            }
            case 5: {
                bComponent = BJciMakeTuningPolicies.makeJciN2Slave();
                break;
            }
            default: {
                bComponent = null;
            }
        }
        return bComponent;
    }

    public static BComponent makeBacnetPersistedSlow() {
        BComponent bComponent = null;
        try {
            bComponent = BJciMakeTuningPolicies.newInstance("bacnet:BacnetTuningPolicy");
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnStart", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnUp", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnEnabled", (BValue)BBoolean.make((boolean)false));
            BPollFrequency bPollFrequency = BPollFrequency.slow;
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "pollFrequency", (BValue)bPollFrequency);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bComponent;
    }

    public static BComponent makeBacnetHWNormal() {
        BComponent bComponent = null;
        try {
            bComponent = BJciMakeTuningPolicies.newInstance("bacnet:BacnetTuningPolicy");
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnStart", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnUp", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnEnabled", (BValue)BBoolean.make((boolean)false));
            BPollFrequency bPollFrequency = BPollFrequency.normal;
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "pollFrequency", (BValue)bPollFrequency);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bComponent;
    }

    public static BComponent makeBacnetHWFast() {
        BComponent bComponent = null;
        try {
            bComponent = BJciMakeTuningPolicies.newInstance("bacnet:BacnetTuningPolicy");
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnStart", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnUp", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnEnabled", (BValue)BBoolean.make((boolean)false));
            BPollFrequency bPollFrequency = BPollFrequency.fast;
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "pollFrequency", (BValue)bPollFrequency);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bComponent;
    }

    public static BComponent makeBacnetNetworkInput() {
        BComponent bComponent = null;
        try {
            bComponent = BJciMakeTuningPolicies.newInstance("bacnet:BacnetTuningPolicy");
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnStart", (BValue)BBoolean.make((boolean)true));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnUp", (BValue)BBoolean.make((boolean)true));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnEnabled", (BValue)BBoolean.make((boolean)true));
            BPollFrequency bPollFrequency = BPollFrequency.normal;
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "pollFrequency", (BValue)bPollFrequency);
            BRelTime bRelTime = BRelTime.makeMinutes((int)10);
            BRelTime bRelTime2 = BRelTime.makeMinutes((int)1);
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "maxWriteTime", (BValue)bRelTime);
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "minWriteTime", (BValue)bRelTime2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bComponent;
    }

    public static BComponent makeBacnetNetworkInputPeer() {
        BComponent bComponent = null;
        try {
            bComponent = BJciMakeTuningPolicies.newInstance("bacnet:BacnetTuningPolicy");
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnStart", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnUp", (BValue)BBoolean.make((boolean)false));
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "writeOnEnabled", (BValue)BBoolean.make((boolean)false));
            BPollFrequency bPollFrequency = BPollFrequency.normal;
            ReflectUtils.setPropertyGeneralValue((BComplex)bComponent, "pollFrequency", (BValue)bPollFrequency);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bComponent;
    }

    public static BComponent makeJciN2Slave() {
        BComponent bComponent = null;
        try {
            bComponent = BJciMakeTuningPolicies.newInstance("jcin2:JciN2SlaveTuningPolicy");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bComponent;
    }

    public static boolean equalPolicy(BComponent bComponent, int n, BComponent bComponent2) {
        if (n >= 0 && n < 5) {
            return BJciMakeTuningPolicies.equalBacnetPolicy(bComponent, n, bComponent2);
        }
        return BJciMakeTuningPolicies.equalN2Policy(bComponent, n, bComponent2);
    }

    public static boolean equalN2Policy(BComponent bComponent, int n, BComponent bComponent2) {
        boolean bl = false;
        if (bComponent2 == null) {
            bComponent2 = BJciMakeTuningPolicies.makePolicy(n);
        }
        if (bComponent2 != null) {
            try {
                BRelTime bRelTime = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "maxWriteTime");
                BRelTime bRelTime2 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "maxWriteTime");
                BRelTime bRelTime3 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "minWriteTime");
                BRelTime bRelTime4 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "minWriteTime");
                BRelTime bRelTime5 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "staleTime");
                BRelTime bRelTime6 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "staleTime");
                BBoolean bBoolean = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "writeOnStart");
                BBoolean bBoolean2 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "writeOnUp");
                BBoolean bBoolean3 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "writeOnEnabled");
                BBoolean bBoolean4 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "writeOnStart");
                BBoolean bBoolean5 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "writeOnUp");
                BBoolean bBoolean6 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "writeOnEnabled");
                if (bRelTime.equals((Object)bRelTime2) && bRelTime3.equals((Object)bRelTime4) && bRelTime5.equals((Object)bRelTime6) && bBoolean.equals((Object)bBoolean4) && bBoolean2.equals((Object)bBoolean5) && bBoolean3.equals((Object)bBoolean6)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static boolean equalBacnetPolicy(BComponent bComponent, int n, BComponent bComponent2) {
        boolean bl = false;
        if (bComponent2 == null) {
            bComponent2 = BJciMakeTuningPolicies.makePolicy(n);
        }
        if (bComponent2 != null) {
            try {
                BRelTime bRelTime = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "maxWriteTime");
                BRelTime bRelTime2 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "maxWriteTime");
                BRelTime bRelTime3 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "minWriteTime");
                BRelTime bRelTime4 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "minWriteTime");
                BRelTime bRelTime5 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "staleTime");
                BRelTime bRelTime6 = (BRelTime)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "staleTime");
                BBoolean bBoolean = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "writeOnStart");
                BBoolean bBoolean2 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "writeOnUp");
                BBoolean bBoolean3 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "writeOnEnabled");
                BBoolean bBoolean4 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "writeOnStart");
                BBoolean bBoolean5 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "writeOnUp");
                BBoolean bBoolean6 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "writeOnEnabled");
                BPollFrequency bPollFrequency = (BPollFrequency)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "pollFrequency");
                BPollFrequency bPollFrequency2 = (BPollFrequency)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "pollFrequency");
                BBoolean bBoolean7 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "useCov");
                BBoolean bBoolean8 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "useCov");
                BBoolean bBoolean9 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent, "useConfirmedCov");
                BBoolean bBoolean10 = (BBoolean)ReflectUtils.getPropertyGeneralValue((BComplex)bComponent2, "useConfirmedCov");
                BInteger bInteger = BInteger.make((int)ReflectUtils.getPropertyIntegerValue((BComplex)bComponent, "covSubscriptionLifetime"));
                BInteger bInteger2 = BInteger.make((int)ReflectUtils.getPropertyIntegerValue((BComplex)bComponent2, "covSubscriptionLifetime"));
                if (bRelTime.equals((Object)bRelTime2) && bRelTime3.equals((Object)bRelTime4) && bRelTime5.equals((Object)bRelTime6) && bBoolean.equals((Object)bBoolean4) && bBoolean2.equals((Object)bBoolean5) && bBoolean3.equals((Object)bBoolean6) && bPollFrequency.equals((Object)bPollFrequency2) && bBoolean7.equals((Object)bBoolean8) && bBoolean9.equals((Object)bBoolean10) && bInteger.equals((Object)bInteger2)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private static final BComponent newInstance(String string) throws Exception {
        return (BComponent)Sys.getType((String)string).getInstance();
    }
}

