/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay.point;

import com.tridium.mcquay.BMcQuayDevice;
import com.tridium.mcquay.BMcQuayNetwork;
import com.tridium.mcquay.messages.McQuayReadResponse;
import com.tridium.mcquay.messages.McQuayWriteRequest;
import com.tridium.mcquay.point.BMcQuayProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMcQuayAnalogProxyExt
extends BMcQuayProxyExt {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$mcquay$point$BMcQuayAnalogProxyExt;

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            System.out.println("The control point is not running - return");
            return;
        }
    }

    public void setOutValue(McQuayReadResponse mcQuayReadResponse) {
        if (!mcQuayReadResponse.isError()) {
            try {
                int n = mcQuayReadResponse.getValue();
                BStatusNumeric bStatusNumeric = new BStatusNumeric();
                bStatusNumeric.setValue((double)n);
                bStatusNumeric.setStatusFault(false);
                bStatusNumeric.setStatusDown(false);
                this.readOk((BStatusValue)bStatusNumeric);
            }
            catch (Exception exception) {
                this.mcQuayReadLog.error("Exception in McQuayAnalogProxyExt-->setOutValue()");
            }
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        super.doWrite(bStatusValue);
        try {
            McQuayWriteRequest mcQuayWriteRequest;
            BMcQuayDevice bMcQuayDevice = this.getMcQuayDevice();
            BMcQuayNetwork bMcQuayNetwork = this.getMcQuayNetwork();
            if (bMcQuayNetwork.isDisabled() || bMcQuayDevice.isDown()) {
                return;
            }
            double d = ((BStatusNumeric)bStatusValue).getNumeric();
            int n = bMcQuayDevice.getMasterNodeL2Addr();
            int n2 = bMcQuayDevice.getSlaveNodeL3Addr();
            String string = this.getRegister();
            McQuayReadResponse mcQuayReadResponse = null;
            boolean bl = true;
            if (string.startsWith("-")) {
                return;
            }
            String string2 = bMcQuayNetwork.getPassword();
            if (!bMcQuayDevice.isDown()) {
                this.mcQuayWriteLog.trace("***** McQuay writing " + d + " *******");
            }
            if (this.getDataLenRegisters() == 1) {
                mcQuayWriteRequest = new McQuayWriteRequest(n, n2, string, string2, (int)d);
                mcQuayReadResponse = (McQuayReadResponse)bMcQuayNetwork.sendSync(mcQuayWriteRequest);
            }
            if (this.getDataLenRegisters() == 2) {
                mcQuayWriteRequest = new McQuayWriteRequest(n, n2, string, string2, (int)d / 256);
                mcQuayReadResponse = (McQuayReadResponse)bMcQuayNetwork.sendSync(mcQuayWriteRequest);
                String string3 = Integer.toHexString(Integer.parseInt(string, 16) + 1);
                while (string3.length() < 4) {
                    string3 = "0" + string3;
                }
                mcQuayWriteRequest = new McQuayWriteRequest(n, n2, string3, string2, (int)d & 0xFF);
                mcQuayReadResponse = (McQuayReadResponse)bMcQuayNetwork.sendSync(mcQuayWriteRequest);
            }
            if (mcQuayReadResponse == null) {
                mcQuayReadResponse = new McQuayReadResponse();
                mcQuayReadResponse.exceptionCode = 9;
                bl = false;
                return;
            }
            if (mcQuayReadResponse.exceptionCode == 2) {
                this.mcQuayWriteLog.error("Write Request Received Negative Acknowledgement");
                bl = false;
                return;
            }
            if (mcQuayReadResponse.isError()) {
                bl = false;
                return;
            }
            bl = true;
            if (bl) {
                this.writeOk((BStatusValue)new BStatusNumeric(d));
            }
        }
        catch (Exception exception) {
            this.mcQuayWriteLog.error("Exception in McQuayAnalogProxyExt-->doWrite()");
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$mcquay$point$BMcQuayAnalogProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$mcquay$point$BMcQuayAnalogProxyExt = BMcQuayAnalogProxyExt.class("[Lcom.tridium.mcquay.point.BMcQuayAnalogProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

