/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mcquay;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.mcquay.BMcQuayDevice;
import com.tridium.mcquay.BMcQuayDeviceFolder;
import com.tridium.mcquay.comm.BMcQuayUnsolicitedReceive;
import com.tridium.mcquay.comm.McQuayComm;
import com.tridium.mcquay.comm.McQuayCommReceiver;
import com.tridium.mcquay.comm.McQuayCommTransmitter;
import com.tridium.mcquay.messages.McQuayReadRequest;
import com.tridium.mcquay.messages.McQuayReadResponse;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BMcQuayNetwork
extends BSerialNetwork {
    public static final Property unsolicitedReceiveHandler = BMcQuayNetwork.newProperty((int)0, (BValue)new BMcQuayUnsolicitedReceive(), null);
    public static final Property tuningPolicies = BMcQuayNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property sitePasswordHex = BMcQuayNetwork.newProperty((int)0, (String)"", null);
    public static final Action upload = BMcQuayNetwork.newAction((int)20, (BValue)new BUploadParameters(), null);
    public static final Action download = BMcQuayNetwork.newAction((int)20, (BValue)new BDownloadParameters(), null);
    public static final Type TYPE;
    private String password;
    private McQuayComm mcquayComm;
    Log mcQuayLog;
    static /* synthetic */ Class class$com$tridium$mcquay$BMcQuayNetwork;

    public BMcQuayUnsolicitedReceive getUnsolicitedReceiveHandler() {
        return (BMcQuayUnsolicitedReceive)this.get(unsolicitedReceiveHandler);
    }

    public void setUnsolicitedReceiveHandler(BMcQuayUnsolicitedReceive bMcQuayUnsolicitedReceive) {
        this.set(unsolicitedReceiveHandler, (BValue)bMcQuayUnsolicitedReceive, null);
    }

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public String getSitePasswordHex() {
        return this.getString(sitePasswordHex);
    }

    public void setSitePasswordHex(String string) {
        this.setString(sitePasswordHex, string, null);
    }

    public void upload(BUploadParameters bUploadParameters) {
        this.invoke(upload, (BValue)bUploadParameters, null);
    }

    public void download(BDownloadParameters bDownloadParameters) {
        this.invoke(download, (BValue)bDownloadParameters, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BMcQuayDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BMcQuayDeviceFolder.TYPE;
    }

    public void started() throws Exception {
        super.started();
        BSerialHelper bSerialHelper = ((BSerialNetwork)this.getNetwork()).getSerialPortConfig();
        try {
            bSerialHelper.setBaudRate((BBaudRate)BSerialBaudRate.baud9600);
            bSerialHelper.setDataBits(BSerialDataBits.dataBits7);
            bSerialHelper.setStopBits(BSerialStopBits.stopBit1);
            bSerialHelper.setParity(BSerialParity.even);
            bSerialHelper.setFlowControlMode(BSerialFlowControlMode.none);
            ((BSerialNetwork)this.getNetwork()).setSerialPortConfig(bSerialHelper);
        }
        catch (Exception exception) {
            this.mcQuayLog.error("Exception in McQuayNetwork-->started()");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public boolean isParentLegal(BComponent bComponent) throws LocalizableRuntimeException {
        super.isParentLegal(bComponent);
        if (!(bComponent instanceof BDriverContainer)) {
            throw new LocalizableRuntimeException("mcquay", "Only allowed as child of a station");
        }
        return true;
    }

    public boolean isChildLegal(BComponent bComponent) throws LocalizableRuntimeException {
        if (bComponent instanceof BMcQuayNetwork) {
            throw new LocalizableRuntimeException("mcquay", "Cannot add McQuayNetwork under a McQuayNetwork");
        }
        return true;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
    }

    protected Comm makeComm() {
        this.mcquayComm = new McQuayComm(this, new McQuayCommReceiver(), new McQuayCommTransmitter());
        return this.mcquayComm;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "mcquay");
    }

    public String getPassword() {
        this.password = this.getSitePasswordHex();
        if (this.password.length() != 8) {
            this.password = "FFFFFFFF";
        }
        return this.password;
    }

    public boolean initPassword() {
        this.password = "";
        McQuayReadRequest mcQuayReadRequest = new McQuayReadRequest(1, 0, 255, "802A", "86672775");
        McQuayReadResponse mcQuayReadResponse = (McQuayReadResponse)this.sendSync(mcQuayReadRequest);
        mcQuayReadRequest = new McQuayReadRequest(1, 0, 255, "802E", "86672775");
        McQuayReadResponse mcQuayReadResponse2 = (McQuayReadResponse)this.sendSync(mcQuayReadRequest);
        mcQuayReadRequest = new McQuayReadRequest(1, 0, 255, "8032", "86672775");
        McQuayReadResponse mcQuayReadResponse3 = (McQuayReadResponse)this.sendSync(mcQuayReadRequest);
        mcQuayReadRequest = new McQuayReadRequest(1, 0, 255, "8036", "86672775");
        McQuayReadResponse mcQuayReadResponse4 = (McQuayReadResponse)this.sendSync(mcQuayReadRequest);
        if (!(mcQuayReadResponse == null || mcQuayReadResponse2 == null || mcQuayReadResponse3 == null || mcQuayReadResponse4 == null || mcQuayReadResponse.isError() || mcQuayReadResponse2.isError() || mcQuayReadResponse3.isError() || mcQuayReadResponse4.isError())) {
            this.password = Integer.toHexString((mcQuayReadResponse.data & 0xF0) >> 4) + Integer.toHexString(mcQuayReadResponse.data & 0xF) + Integer.toHexString((mcQuayReadResponse2.data & 0xF0) >> 4) + Integer.toHexString(mcQuayReadResponse2.data & 0xF) + Integer.toHexString((mcQuayReadResponse3.data & 0xF0) >> 4) + Integer.toHexString(mcQuayReadResponse3.data & 0xF) + Integer.toHexString((mcQuayReadResponse4.data & 0xF0) >> 4) + Integer.toHexString(mcQuayReadResponse4.data & 0xF);
            return true;
        }
        this.password = "FFFFFFFF";
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.password = "";
        this.mcquayComm = null;
        this.mcQuayLog = Log.getLog((String)"McQuayLog");
    }

    public BMcQuayNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$mcquay$BMcQuayNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$mcquay$BMcQuayNetwork = BMcQuayNetwork.class("[Lcom.tridium.mcquay.BMcQuayNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

