/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.camera.controlHelper;

import com.tridium.nvideo.BVideoNetwork;
import com.tridium.nvideo.camera.BVideoCamera;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BCameraControlHelper
extends BComponent
implements Runnable {
    public static final Type TYPE;
    protected Object controlReference;
    protected final Object doneReference;
    protected long keepAliveTimeStamp;
    protected boolean done;
    protected boolean beenDone;
    protected boolean scheduled;
    protected BVideoCamera camera;
    Clock.Ticket ticket;
    protected boolean inQ;
    static /* synthetic */ Class class$com$tridium$nvideo$camera$controlHelper$BCameraControlHelper;

    public Type getType() {
        return TYPE;
    }

    public void doReevaluate() {
        this.enqueue();
    }

    private final synchronized void enqueue() {
        if (this.inQ) {
            return;
        }
        this.inQ = true;
        ((BVideoNetwork)this.camera.getNetwork()).getAsync().post((Runnable)this);
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void controlCamera(Object object) {
        this.keepAlive();
        this.done = false;
        this.controlReference = object;
        if (object != this.doneReference) {
            this.beenDone = false;
        }
        this.enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        BCameraControlHelper bCameraControlHelper = this;
        synchronized (bCameraControlHelper) {
            this.inQ = false;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            if (this.isDone()) {
                if (this.beenDone) return;
                this.onStopControlling();
                this.beenDone = true;
                return;
            }
        }
        this.onControlling();
        BRelTime bRelTime = this.getResendInterval();
        if (bRelTime.getMillis() <= 0L) return;
        this.ticket = Clock.schedule((BComponent)this.camera, (BRelTime)bRelTime, (Action)BVideoCamera.reevaluate, (BValue)this);
    }

    public void keepAlive() {
        this.keepAliveTimeStamp = Clock.ticks();
    }

    public boolean isDone() {
        boolean bl = false;
        if (this.done || this.controlReference == this.doneReference || Clock.ticks() - this.keepAliveTimeStamp > this.getWatchdogTimeout().getMillis()) {
            bl = true;
        }
        return bl;
    }

    public void stopControlling() {
        this.done = true;
    }

    public abstract BRelTime getResendInterval();

    public abstract BRelTime getWatchdogTimeout();

    protected abstract void onStopControlling();

    protected abstract void onControlling();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ticket = null;
    }

    public BCameraControlHelper() {
        this.this();
        this.camera = null;
        this.doneReference = null;
    }

    public BCameraControlHelper(BVideoCamera bVideoCamera, Object object) {
        this.this();
        this.camera = bVideoCamera;
        this.doneReference = object;
        this.keepAliveTimeStamp = Clock.ticks();
        this.done = false;
    }

    static {
        Class clazz = class$com$tridium$nvideo$camera$controlHelper$BCameraControlHelper;
        if (clazz == null) {
            clazz = class$com$tridium$nvideo$camera$controlHelper$BCameraControlHelper = BCameraControlHelper.class("[Lcom.tridium.nvideo.camera.controlHelper.BCameraControlHelper;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

