/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.retention;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.job.BJobState;
import javax.baja.retention.BIDomainRetentionPolicy;
import javax.baja.retention.BIRetentionPolicyDomain;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BKeepNExecutionsRetentionPolicy
extends BRetentionPolicy
implements BIDomainRetentionPolicy {
    private int numberToRetain = 10;
    private boolean countOnlySuccessful = true;
    public static final BKeepNExecutionsRetentionPolicy DEFAULT = new BKeepNExecutionsRetentionPolicy(10, true);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$retention$BKeepNExecutionsRetentionPolicy == null ? (class$javax$baja$batchJob$retention$BKeepNExecutionsRetentionPolicy = BKeepNExecutionsRetentionPolicy.class$("javax.baja.batchJob.retention.BKeepNExecutionsRetentionPolicy")) : class$javax$baja$batchJob$retention$BKeepNExecutionsRetentionPolicy));
    static /* synthetic */ Class class$javax$baja$batchJob$retention$BKeepNExecutionsRetentionPolicy;

    public BKeepNExecutionsRetentionPolicy(int n, boolean bl) {
        this.numberToRetain = n;
        this.countOnlySuccessful = bl;
    }

    public int getNumberToRetain() {
        return this.numberToRetain;
    }

    public boolean getCountOnlySuccessful() {
        return this.countOnlySuccessful;
    }

    public Type[] getApplicableDomainTypes() {
        return new Type[]{BBatchJobPrototype.TYPE};
    }

    public void executePolicy(BIRetentionPolicyDomain bIRetentionPolicyDomain) {
        TreeSet<BBatchJob> treeSet = new TreeSet<BBatchJob>(new ExecutionDateComparator());
        Object object = bIRetentionPolicyDomain.getRetainables();
        while (object.next()) {
            BBatchJob bBatchJob = (BBatchJob)object.get();
            bBatchJob.lease();
            if (this.getCountOnlySuccessful()) {
                if (bBatchJob.getJobState() != BJobState.success) continue;
                treeSet.add(bBatchJob);
                continue;
            }
            if (!bBatchJob.getJobState().isComplete()) continue;
            treeSet.add(bBatchJob);
        }
        if (treeSet.size() > this.getNumberToRetain()) {
            object = treeSet.iterator();
            for (int i = 0; i < this.getNumberToRetain(); ++i) {
                object.next();
            }
            while (object.hasNext()) {
                ((BBatchJob)object.next()).dispose();
            }
        }
    }

    public boolean equals(Object object) {
        return object instanceof BKeepNExecutionsRetentionPolicy && ((BKeepNExecutionsRetentionPolicy)object).getNumberToRetain() == this.getNumberToRetain() && ((BKeepNExecutionsRetentionPolicy)object).getCountOnlySuccessful() == this.getCountOnlySuccessful();
    }

    public int hashCode() {
        return this.numberToRetain * 2 + (this.countOnlySuccessful ? 1 : 0);
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(String.valueOf(this.getNumberToRetain()));
        stringBuffer.append(',');
        stringBuffer.append(String.valueOf(this.getCountOnlySuccessful()));
        return stringBuffer.toString();
    }

    public BObject decodeFromString(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        return new BKeepNExecutionsRetentionPolicy(Integer.parseInt(stringTokenizer.nextToken()), Boolean.valueOf(stringTokenizer.nextToken()));
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ExecutionDateComparator
    implements Comparator {
        private ExecutionDateComparator() {
        }

        public int compare(Object object, Object object2) {
            BBatchJob bBatchJob = (BBatchJob)object;
            BBatchJob bBatchJob2 = (BBatchJob)object2;
            if (bBatchJob.getEndTime().isNull() || bBatchJob2.getEndTime().isNull()) {
                return -1 * bBatchJob.getStartTime().compareTo((Object)bBatchJob2.getStartTime());
            }
            return -1 * bBatchJob.getEndTime().compareTo((Object)bBatchJob2.getEndTime());
        }
    }
}

