/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import java.io.IOException;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.BNetworkJobStage;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BNetworkStepDetails
extends BJobStepDetails {
    public static final Property networkType = BNetworkStepDetails.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property networkOrd = BNetworkStepDetails.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property devicesToProcess = BNetworkStepDetails.newProperty((int)1, (BValue)BValueList.DEFAULT, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$driver$BNetworkStepDetails == null ? (class$javax$baja$batchJob$driver$BNetworkStepDetails = BNetworkStepDetails.class$("javax.baja.batchJob.driver.BNetworkStepDetails")) : class$javax$baja$batchJob$driver$BNetworkStepDetails));
    private BBatchJobStepLogFile logFile = null;
    static /* synthetic */ Class class$javax$baja$batchJob$driver$BNetworkStepDetails;

    public BTypeSpec getNetworkType() {
        return (BTypeSpec)this.get(networkType);
    }

    public void setNetworkType(BTypeSpec bTypeSpec) {
        this.set(networkType, (BValue)bTypeSpec, null);
    }

    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    public void setNetworkOrd(BOrd bOrd) {
        this.set(networkOrd, (BValue)bOrd, null);
    }

    public BValueList getDevicesToProcess() {
        return (BValueList)this.get(devicesToProcess);
    }

    public void setDevicesToProcess(BValueList bValueList) {
        this.set(devicesToProcess, (BValue)bValueList, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNetworkStepDetails() {
    }

    public BNetworkStepDetails(BNetworkJobStep bNetworkJobStep, BDevice[] bDeviceArray) {
        super(bNetworkJobStep);
        this.setNetwork(((BDeviceNetworkJob)bNetworkJobStep.getJob()).getNetwork());
        if (bDeviceArray.length > 0) {
            BNetworkBatchAgent bNetworkBatchAgent = BNetworkBatchAgent.get(bDeviceArray[0]);
            BSimple[] bSimpleArray = new BSimple[bDeviceArray.length];
            for (int i = 0; i < bSimpleArray.length; ++i) {
                bSimpleArray[i] = bNetworkBatchAgent.getBatchDeviceId(bDeviceArray[i]);
            }
            this.setDevicesToProcess(BValueList.make((BValue[])bSimpleArray));
        }
    }

    public void setNetwork(BDeviceNetwork bDeviceNetwork) {
        this.setNetworkType(bDeviceNetwork.getType().getTypeSpec());
        this.setNetworkOrd(bDeviceNetwork.getOrdInSpace());
    }

    public BDeviceNetwork getNetwork() {
        return this.step == null ? (BDeviceNetwork)this.getNetworkOrd().get() : ((BDeviceNetworkJob)this.step.getJob()).getNetwork();
    }

    public BNetworkJobStage getNetworkJobStage() {
        return (BNetworkJobStage)this.getStage();
    }

    public BNetworkJobStage getNetworkJobStage(BDeviceNetworkJob bDeviceNetworkJob) {
        return (BNetworkJobStage)this.getStage(bDeviceNetworkJob);
    }

    public void doCancel() {
        BJobState bJobState = this.getState();
        if (bJobState.isRunning()) {
            this.setState(BJobState.canceling);
        } else if (bJobState != BJobState.success && bJobState != BJobState.failed) {
            this.setState(BJobState.canceled);
        }
    }

    public void doDispose() throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        super.doDispose();
        try {
            BBatchJobStepLogFile bBatchJobStepLogFile = BBatchJobStepLogFile.find(this, null);
            try {
                Log.getLog((String)"batchJob").trace("Deleting log file " + bBatchJobStepLogFile.getFilePath().getBody());
                bBatchJobStepLogFile.delete();
            }
            catch (IOException iOException) {
                Log.getLog((String)"batchJob").error("Error deleting log file " + bBatchJobStepLogFile.getFilePath().getBody(), (Throwable)iOException);
            }
        }
        catch (UnresolvedException unresolvedException) {
            unresolvedException.printStackTrace();
            Log.getLog((String)"batchJob").trace("Log file not found", (Throwable)unresolvedException);
        }
    }

    public void setLogFile(BIFile bIFile) {
        this.logFile = (BBatchJobStepLogFile)bIFile;
    }

    public BIFile getLogFile() {
        if (this.logFile == null) {
            this.logFile = BBatchJobStepLogFile.find(this, null);
        }
        return this.logFile;
    }

    public BIFile findLogFile(BObject bObject) throws Exception {
        return BBatchJobStepLogFile.find(this.getStepType(), this.getLocalStartTime(), bObject);
    }

    public BString doReadLog() {
        if (this.log == null) {
            BBatchJobStepLogFile bBatchJobStepLogFile = this.logFile;
            if (bBatchJobStepLogFile == null) {
                bBatchJobStepLogFile = (BBatchJobStepLogFile)this.getLogFile();
            }
            if (bBatchJobStepLogFile == null) {
                return BString.DEFAULT;
            }
            try {
                return bBatchJobStepLogFile.getLogContents();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException();
            }
        }
        return BString.make((String)this.log.encode());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

