/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFolder;

public class BNetworkJobStage
extends BJobStage {
    public static final Property steps = BNetworkJobStage.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$driver$BNetworkJobStage == null ? (class$javax$baja$batchJob$driver$BNetworkJobStage = BNetworkJobStage.class$("javax.baja.batchJob.driver.BNetworkJobStage")) : class$javax$baja$batchJob$driver$BNetworkJobStage));
    static /* synthetic */ Class class$javax$baja$batchJob$driver$BNetworkJobStage;
    static /* synthetic */ Class class$javax$baja$driver$BDevice;
    static /* synthetic */ Class class$javax$baja$batchJob$driver$BNetworkJobStep;

    public BFolder getSteps() {
        return (BFolder)this.get(steps);
    }

    public void setSteps(BFolder bFolder) {
        this.set(steps, (BValue)bFolder, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNetworkJobStage() {
    }

    public BNetworkJobStage(String string) {
        super(string);
    }

    public BDevice[] getDevices() {
        return ((BDeviceNetworkJob)this.getJob()).getDevices();
    }

    public BDeviceNetwork getNetwork() {
        return ((BDeviceNetworkJob)this.getJob()).getNetwork();
    }

    public BJobState doRun(BBatchJobService bBatchJobService, BBatchJob bBatchJob, BatchJobOp batchJobOp) {
        int n;
        DeviceNetworkJobOp deviceNetworkJobOp = (DeviceNetworkJobOp)batchJobOp;
        BNetworkJobStep[] bNetworkJobStepArray = this.getCombinedSteps();
        BDeviceNetwork bDeviceNetwork = this.getNetwork();
        BDevice[] bDeviceArray = this.getDevices();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < bNetworkJobStepArray.length; ++n) {
            try {
                bNetworkJobStepArray[n].doInit(bBatchJobService, deviceNetworkJobOp);
                continue;
            }
            catch (Exception exception) {
                this.getJob().log().failed("batchJob", "NetworkJobStage.initializationFailed", (Throwable)exception);
                return BJobState.failed;
            }
        }
        for (n = 0; n < bNetworkJobStepArray.length; ++n) {
            Array array = new Array(class$javax$baja$driver$BDevice == null ? BNetworkJobStage.class$("javax.baja.driver.BDevice") : class$javax$baja$driver$BDevice);
            for (int i = 0; i < bDeviceArray.length; ++i) {
                if (deviceNetworkJobOp.deviceFailed(bDeviceArray[i])) continue;
                array.add((Object)bDeviceArray[i]);
            }
            BNetworkStepDetails bNetworkStepDetails = bNetworkJobStepArray[n].run(bBatchJobService, bDeviceNetwork, (BDevice[])array.trim(), deviceNetworkJobOp);
            BJobState bJobState = bNetworkStepDetails.getState();
            if (bJobState == BJobState.failed) {
                this.stepComplete(bBatchJobService, bNetworkStepDetails, deviceNetworkJobOp);
                bl = true;
                break;
            }
            if (bJobState == BJobState.canceled || bJobState == BJobState.canceling) {
                if (bJobState == BJobState.canceling) {
                    bJobState = BJobState.canceled;
                    bNetworkStepDetails.setState(bJobState);
                }
                this.stepComplete(bBatchJobService, bNetworkStepDetails, deviceNetworkJobOp);
                bl2 = true;
                break;
            }
            this.stepComplete(bBatchJobService, bNetworkStepDetails, deviceNetworkJobOp);
        }
        for (n = 0; n < bNetworkJobStepArray.length; ++n) {
            try {
                bNetworkJobStepArray[n].jobComplete(deviceNetworkJobOp);
                continue;
            }
            catch (Exception exception) {
                this.getJob().log().failed("batchJob", "NetworkJobStage.cleanupFailed", (Throwable)exception);
            }
        }
        if (bl) {
            return BJobState.failed;
        }
        if (bl2) {
            return BJobState.canceled;
        }
        return BJobState.success;
    }

    public void addStep(BJobStep bJobStep) {
        this.getSteps().add("step?", (BValue)((BNetworkJobStep)bJobStep));
    }

    public void removeAllSteps() {
        this.getSteps().removeAll();
    }

    public BJobStep[] getAllSteps() {
        Array array = new Array(class$javax$baja$batchJob$driver$BNetworkJobStep == null ? (class$javax$baja$batchJob$driver$BNetworkJobStep = BNetworkJobStage.class$("javax.baja.batchJob.driver.BNetworkJobStep")) : class$javax$baja$batchJob$driver$BNetworkJobStep);
        SlotCursor slotCursor = this.getSteps().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$driver$BNetworkJobStep == null ? BNetworkJobStage.class$("javax.baja.batchJob.driver.BNetworkJobStep") : class$javax$baja$batchJob$driver$BNetworkJobStep)) {
            array.add((Object)slotCursor.get());
        }
        return (BNetworkJobStep[])array.trim();
    }

    protected BNetworkJobStep[] getCombinedSteps() {
        Array array = new Array(class$javax$baja$batchJob$driver$BNetworkJobStep == null ? (class$javax$baja$batchJob$driver$BNetworkJobStep = BNetworkJobStage.class$("javax.baja.batchJob.driver.BNetworkJobStep")) : class$javax$baja$batchJob$driver$BNetworkJobStep);
        BNetworkJobStep bNetworkJobStep = null;
        SlotCursor slotCursor = this.getSteps().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$driver$BNetworkJobStep == null ? BNetworkJobStage.class$("javax.baja.batchJob.driver.BNetworkJobStep") : class$javax$baja$batchJob$driver$BNetworkJobStep)) {
            BNetworkJobStep bNetworkJobStep2 = (BNetworkJobStep)slotCursor.get();
            if (bNetworkJobStep != null && bNetworkJobStep.canCombine(bNetworkJobStep2) && bNetworkJobStep2.canCombine(bNetworkJobStep2)) {
                bNetworkJobStep.combine(bNetworkJobStep2);
                continue;
            }
            array.add((Object)bNetworkJobStep2);
            bNetworkJobStep = bNetworkJobStep2;
        }
        return (BNetworkJobStep[])array.trim();
    }

    public void prepareStage(BObject bObject) throws Exception {
        SlotCursor slotCursor = this.getSteps().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$driver$BNetworkJobStep == null ? BNetworkJobStage.class$("javax.baja.batchJob.driver.BNetworkJobStep") : class$javax$baja$batchJob$driver$BNetworkJobStep)) {
            ((BNetworkJobStep)slotCursor.get()).prepareStep(bObject);
        }
    }

    protected void stepComplete(BBatchJobService bBatchJobService, BNetworkStepDetails bNetworkStepDetails, DeviceNetworkJobOp deviceNetworkJobOp) {
        try {
            BBatchJobStepLogFile bBatchJobStepLogFile = BBatchJobStepLogFile.create(bNetworkStepDetails, this.getJob().getStartTime());
            if ((bNetworkStepDetails.getState() == BJobState.failed || bNetworkStepDetails.getState() == BJobState.canceled) && this.getJob().getAlertOnStepFailure()) {
                bBatchJobService.newAlert(bNetworkStepDetails.getFailureAlarmMessage(null), bBatchJobStepLogFile.getOrdInSession());
            }
            bNetworkStepDetails.resetLog();
        }
        catch (Exception exception) {
            Log.getLog((String)"batchJob").error("error persisting job step", (Throwable)exception);
        }
    }

    protected final synchronized void checkCanceled() {
        this.getJob().checkCanceled();
    }

    public void doDispose(Context context) {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        BJobStepDetails[] bJobStepDetailsArray = this.getJobStepDetails();
        for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
            try {
                bJobStepDetailsArray[i].dispose();
                continue;
            }
            catch (Exception exception) {
                Log.getLog((String)"batchJob").error("Error disposing step record", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

