/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import com.tridium.batchJob.BBatchJobHousekeepingJob;
import com.tridium.batchJob.BBatchJobLogFile;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BIJobSummaryManager;
import javax.baja.batchJob.BThreadPoolJobQueue;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BBatchJobService
extends BAbstractService
implements BIAlarmSource {
    public static final Property jobQueue = BBatchJobService.newProperty((int)0, (BValue)new BThreadPoolJobQueue(1), null);
    public static final Property alarmClass = BBatchJobService.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property summaryManagerType = BBatchJobService.newProperty((int)1, (BValue)BTypeSpec.make((String)"batchJob", (String)"HistoryJobSummaryManager"), null);
    public static final Property initialSummaryManagerType = BBatchJobService.newProperty((int)5, (BValue)BTypeSpec.make((String)"batchJob", (String)"HistoryJobSummaryManager"), null);
    public static final Action submitJobAction = BBatchJobService.newAction((int)4, (BValue)new BBatchJob(), null);
    public static final Action makeTempFilePath = BBatchJobService.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action disposeJob = BBatchJobService.newAction((int)4, (BValue)BAbsTime.NULL, null);
    public static final Action ackAlarm = BBatchJobService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action purgeDisposedHistory = BBatchJobService.newAction((int)4, null);
    public static final Action performHousekeeping = BBatchJobService.newAction((int)4, null);
    public static final Topic jobDisposed = BBatchJobService.newTopic((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$BBatchJobService == null ? (class$javax$baja$batchJob$BBatchJobService = BBatchJobService.class$("javax.baja.batchJob.BBatchJobService")) : class$javax$baja$batchJob$BBatchJobService));
    private static final Type[] serviceTypes = new Type[]{TYPE};
    public static final Log log = Log.getLog((String)"batchJob");
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private static final FilePath BASE_DIR = new FilePath("^batchJob");
    private AlarmSupport alarmSupport = null;
    private int oldStatus = -1;
    private boolean serviceStarted = false;
    private Clock.Ticket purgeTicket;
    private BIJobSummaryManager summaryManager = null;
    static /* synthetic */ Class class$javax$baja$batchJob$BBatchJobService;

    public BThreadPoolJobQueue getJobQueue() {
        return (BThreadPoolJobQueue)this.get(jobQueue);
    }

    public void setJobQueue(BThreadPoolJobQueue bThreadPoolJobQueue) {
        this.set(jobQueue, (BValue)bThreadPoolJobQueue, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public BTypeSpec getSummaryManagerType() {
        return (BTypeSpec)this.get(summaryManagerType);
    }

    public void setSummaryManagerType(BTypeSpec bTypeSpec) {
        this.set(summaryManagerType, (BValue)bTypeSpec, null);
    }

    public BTypeSpec getInitialSummaryManagerType() {
        return (BTypeSpec)this.get(initialSummaryManagerType);
    }

    public void setInitialSummaryManagerType(BTypeSpec bTypeSpec) {
        this.set(initialSummaryManagerType, (BValue)bTypeSpec, null);
    }

    public BOrd submitJobAction(BBatchJob bBatchJob) {
        return (BOrd)this.invoke(submitJobAction, (BValue)bBatchJob, null);
    }

    public BString makeTempFilePath(BString bString) {
        return (BString)this.invoke(makeTempFilePath, (BValue)bString, null);
    }

    public void disposeJob(BAbsTime bAbsTime) {
        this.invoke(disposeJob, (BValue)bAbsTime, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public void purgeDisposedHistory() {
        this.invoke(purgeDisposedHistory, null, null);
    }

    public void performHousekeeping() {
        this.invoke(performHousekeeping, null, null);
    }

    public void fireJobDisposed(BAbsTime bAbsTime) {
        this.fire(jobDisposed, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIFile makeTempFile(String string) {
        BFileSpace bFileSpace = (BFileSpace)BOrd.make((String)"file:").get((BObject)this);
        return bFileSpace.findFile(new FilePath(this.makeTempFilePath(BString.make((String)string)).toString()));
    }

    public void started() throws Exception {
        this.purgeTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeHours((int)1), (Action)performHousekeeping, null);
    }

    public void stopped() {
        if (this.purgeTicket != null) {
            this.purgeTicket.cancel();
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        } else if (property == alarmClass) {
            this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() {
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        BIJobSummaryManager bIJobSummaryManager = this.getJobSummaryManager();
        String string = bIJobSummaryManager.batchJobServiceStarted();
        if (string == null && !this.getInitialSummaryManagerType().equals((Object)this.getSummaryManagerType())) {
            try {
                BIJobSummaryManager bIJobSummaryManager2 = (BIJobSummaryManager)this.getInitialSummaryManagerType().getInstance();
                bIJobSummaryManager.importSummaries(bIJobSummaryManager2);
                bIJobSummaryManager2.removeSummaryManager();
                this.setInitialSummaryManagerType(this.getSummaryManagerType());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string = "Job summary import failed";
            }
        }
        if (string != null) {
            this.configFail(string);
        }
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        this.updateStatus();
    }

    public void serviceStopped() {
        this.serviceStarted = false;
    }

    public void doPurgeDisposedHistory(Context context) throws Exception {
        new BBatchJobHousekeepingJob().submit(context);
    }

    public void doPerformHousekeeping(Context context) throws Exception {
        new BBatchJobHousekeepingJob().submit(context);
    }

    public void updateStatus() {
        int n = this.getStatus().getBits();
        n = !this.getEnabled() ? (n |= 1) : (n &= 0xFFFFFFFE);
        n = this.isFatalFault() ? (n |= 2) : (n &= 0xFFFFFFFD);
        if (this.oldStatus == n) {
            return;
        }
        this.setStatus(BStatus.make((int)n));
        this.oldStatus = n;
    }

    public BBatchJob submitJob(BBatchJob bBatchJob, Context context) throws Exception {
        bBatchJob.prepareJob((BObject)this);
        BOrd bOrd = (BOrd)this.invoke(submitJobAction, (BValue)bBatchJob, context);
        this.getComponentSpace().sync();
        return (BBatchJob)bOrd.get((BObject)this);
    }

    public BOrd doSubmitJobAction(BBatchJob bBatchJob, Context context) throws Exception {
        bBatchJob.clearHandles();
        bBatchJob.submit(context);
        return bBatchJob.getHandleOrd();
    }

    public void doDisposeJob(BAbsTime bAbsTime) throws Exception {
        BJobService bJobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        BJob[] bJobArray = bJobService.getJobs();
        for (int i = 0; i < bJobArray.length; ++i) {
            if (!(bJobArray[i] instanceof BBatchJob) || !bAbsTime.equals((Object)bJobArray[i].getStartTime())) continue;
            bJobArray[i].dispose();
            return;
        }
        try {
            BBatchJobLogFile bBatchJobLogFile = BBatchJobLogFile.findLocal(bAbsTime);
            BBatchJob bBatchJob = bBatchJobLogFile.getJob();
            bBatchJob.dispose();
            return;
        }
        catch (UnresolvedException unresolvedException) {
            unresolvedException.printStackTrace();
            return;
        }
    }

    public void notifyDisposed(BBatchJob bBatchJob) {
        this.fireJobDisposed(bBatchJob.getStartTime());
    }

    public synchronized BString doMakeTempFilePath(BString bString) {
        int n = 0;
        while (true) {
            FilePath filePath;
            BIFile bIFile;
            if ((bIFile = BFileSystem.INSTANCE.findFile(filePath = BASE_DIR.merge("tmp" + n + "." + bString.toString()))) == null) {
                try {
                    BFileSystem.INSTANCE.makeFile(filePath);
                    return BString.make((String)filePath.getBody());
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    throw runtimeException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
            ++n;
        }
    }

    public static BIJobQueryManager getQueryManager(BIBatchJobSummary bIBatchJobSummary) throws Exception {
        AgentList agentList = Sys.getRegistry().getAgents(bIBatchJobSummary.getType().getTypeInfo()).filter(AgentFilter.is((Type)BIJobQueryManager.TYPE));
        return agentList.size() == 0 ? null : (BIJobQueryManager)agentList.getDefault().getAgentType().getInstance();
    }

    public static BIJobQueryManager getQueryManager(BIJobStepSummary bIJobStepSummary) throws Exception {
        AgentList agentList = Sys.getRegistry().getAgents(bIJobStepSummary.getType().getTypeInfo()).filter(AgentFilter.is((Type)BIJobQueryManager.TYPE));
        return agentList.size() == 0 ? null : (BIJobQueryManager)agentList.getDefault().getAgentType().getInstance();
    }

    public BIJobSummaryManager getJobSummaryManager() {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("getJobSummaryManager must be called from the supervisor VM");
        }
        return (BIJobSummaryManager)this.getJobQueryManager();
    }

    public BIJobQueryManager getJobQueryManager() {
        if (this.summaryManager == null) {
            this.summaryManager = (BIJobSummaryManager)this.getSummaryManagerType().getInstance();
        }
        return this.summaryManager;
    }

    public void newAlert(String string, BOrd bOrd) {
        if (this.alarmSupport != null) {
            try {
                this.alarmSupport.newAlert(BFacets.make((String[])new String[]{"msgText", "hyperlinkOrd"}, (BIDataValue[])new BString[]{BString.make((String)string), BString.make((String)bOrd.toString())}));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        try {
            if (this.alarmSupport != null) {
                this.alarmSupport.ackAlarm(bAlarmRecord);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BBoolean.TRUE;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

