/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import java.util.HashSet;
import java.util.Set;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BDeviceNetworkJobView
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$driver$BDeviceNetworkJobView == null ? (class$com$tridium$batchJob$ui$driver$BDeviceNetworkJobView = BDeviceNetworkJobView.class$("com.tridium.batchJob.ui.driver.BDeviceNetworkJobView")) : class$com$tridium$batchJob$ui$driver$BDeviceNetworkJobView));
    private BLabel userLabel;
    private BLabel startedLabel;
    private BLabel endedLabel;
    private BLabel stateLabel;
    private BTable table;
    protected Model model;
    private BDeviceNetworkJob job = null;
    private CancelJobCommand cancelJobCommand;
    private CancelDeviceCommand cancelDeviceCommand;
    private DisposeCommand disposeCommand;
    private OpenCommand openCommand;
    private static final Lexicon lex = Lexicon.make((String)"batchJob");
    public static final int COL_DEVICE = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_START = 2;
    public static final int COL_END = 3;
    public static final int COL_BUTTONS = 4;
    private static int COLUMN_OFFSET = 0;
    static /* synthetic */ Class class$com$tridium$batchJob$ui$driver$BDeviceNetworkJobView;
    static /* synthetic */ Class class$javax$baja$batchJob$BJobStepDetails;

    public Type getType() {
        return TYPE;
    }

    public BDeviceNetworkJobView() {
        this.autoRegisterForComponentEvents = false;
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        this.userLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.user"), (BWidget)this.userLabel);
        this.startedLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.started"), (BWidget)this.startedLabel);
        this.endedLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.ended"), (BWidget)this.endedLabel);
        this.stateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceNetworkJobView.state"), (BWidget)this.stateLabel);
        CommandBindings commandBindings = new CommandBindings();
        this.openCommand = new OpenCommand();
        commandBindings.addCommand((Command)this.openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelDeviceCommand = new CancelDeviceCommand();
        commandBindings.addCommand((Command)this.cancelDeviceCommand, BCommandEnablePolicy.singleSelection);
        commandBindings.setSupport((CommandBindings.Support)this);
        COLUMN_OFFSET = this.getColumnOffset();
        this.model = new Model();
        this.table = JobTable.makeListTable(this.model, commandBindings, 4 + COLUMN_OFFSET, this.openCommand, null);
        BButtonPane bButtonPane = new BButtonPane();
        bButtonPane.add((Command)new ViewLogCommand());
        if (this.getJobListOrd() != null) {
            bButtonPane.add((Command)new JobListCommand());
        }
        this.cancelJobCommand = new CancelJobCommand();
        bButtonPane.add((Command)this.cancelJobCommand);
        bButtonPane.add((Command)this.cancelDeviceCommand);
        this.disposeCommand = new DisposeCommand();
        bButtonPane.add((Command)this.disposeCommand);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)bButtonPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.table), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.job = (BDeviceNetworkJob)bObject;
        this.job.lease(Integer.MAX_VALUE);
        this.userLabel.setText(this.job.getSubmitUser());
        this.startedLabel.setText(this.job.getStartTime().toString());
        this.endedLabel.setText(this.job.getEndTime().toString());
        this.stateLabel.setText(this.job.getJobState().toString());
        this.model.load(this.job);
        this.cancelJobCommand.checkEnabled();
        this.disposeCommand.checkEnabled();
        this.registerForComponentEvents((BComponent)this.job, Integer.MAX_VALUE);
    }

    protected BOrd getJobListOrd() {
        return null;
    }

    public BDeviceNetworkJob getDeviceNetworkJob() {
        BObject bObject = this.getCurrentValue();
        return (BDeviceNetworkJob)bObject;
    }

    public BObject getOrdBase() {
        return this.getDeviceNetworkJob().getOrdBase();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        block8: {
            block6: {
                String string;
                Property property;
                block10: {
                    block9: {
                        block7: {
                            if (!(bComponentEvent.getSourceComponent() instanceof BDeviceNetworkJob) || !bComponentEvent.getSlot().isProperty()) break block6;
                            property = (Property)bComponentEvent.getSlot();
                            string = bComponentEvent.getValue().toString();
                            if (property != BDeviceNetworkJob.submitUser) break block7;
                            this.userLabel.setText(string);
                            break block8;
                        }
                        if (property != BDeviceNetworkJob.startTime) break block9;
                        this.startedLabel.setText(string);
                        break block8;
                    }
                    if (property != BDeviceNetworkJob.endTime) break block10;
                    this.endedLabel.setText(string);
                    break block8;
                }
                if (property != BDeviceNetworkJob.jobState) break block8;
                this.stateLabel.setText(string);
                this.cancelJobCommand.checkEnabled();
                this.disposeCommand.checkEnabled();
                break block8;
            }
            if (bComponentEvent.getSourceComponent() instanceof BJobStepDetails) {
                this.model.updateDetails((BJobStepDetails)bComponentEvent.getSourceComponent());
            } else if (bComponentEvent.getId() == 1 && bComponentEvent.getValue() instanceof BJobStepDetails) {
                this.model.updateDetails((BJobStepDetails)bComponentEvent.getValue());
                this.registerForComponentEvents((BComponent)bComponentEvent.getValue(), Integer.MAX_VALUE);
            } else if (bComponentEvent.getId() == 1 && bComponentEvent.getValue() instanceof BJobStep) {
                BJobStep bJobStep = (BJobStep)bComponentEvent.getValue();
                this.registerForComponentEvents(bJobStep, Integer.MAX_VALUE);
                BJobStepDetails[] bJobStepDetailsArray = (BJobStepDetails[])bJobStep.getChildren(class$javax$baja$batchJob$BJobStepDetails == null ? (class$javax$baja$batchJob$BJobStepDetails = BDeviceNetworkJobView.class$("javax.baja.batchJob.BJobStepDetails")) : class$javax$baja$batchJob$BJobStepDetails);
                for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
                    this.model.updateDetails(bJobStepDetailsArray[i]);
                }
            }
        }
    }

    protected void setModel(Model model) {
        this.model = model;
        this.table.setModel((TableModel)model);
        model.updateTable(true);
    }

    protected int getColumnOffset() {
        return 0;
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command == this.cancelDeviceCommand && bl) {
            BJobStepDetails bJobStepDetails = this.model.details(this.model.getTable().getSelection().getRow());
            if (bJobStepDetails instanceof BDeviceStepDetails) {
                BDeviceStepDetails bDeviceStepDetails = (BDeviceStepDetails)bJobStepDetails;
                BJobState bJobState = bDeviceStepDetails.getForEachDeviceStage(this.job).getDeviceState(bDeviceStepDetails.getDeviceId());
                if (bJobState.isComplete() || bJobState == BJobState.canceling) {
                    command.setEnabled(false);
                    return;
                }
            } else {
                command.setEnabled(false);
                return;
            }
        }
        command.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.disposeCommand");
            this.setEnabled(false);
        }

        public void checkEnabled() {
            this.setEnabled(!(BDeviceNetworkJobView.this.getCurrentValue() instanceof BDeviceNetworkJob) || BDeviceNetworkJobView.this.getDeviceNetworkJob().getJobState().isComplete());
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BDeviceNetworkJobView.this.model.getTable(), (String)lex.getText("DeviceNetworkJobView.disposeCommand.dlgTitle"), (Object)lex.getText("DeviceNetworkJobView.disposeCommand.dlgMessage"))) {
                    BBatchJobService bBatchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(BDeviceNetworkJobView.this.getOrdBase());
                    if (BDeviceNetworkJobView.this.getJobListOrd() != null) {
                        BDeviceNetworkJobView.this.getWbShell().hyperlink(BOrd.make((BOrd)bBatchJobService.getAbsoluteOrd(), (BOrd)BDeviceNetworkJobView.this.getJobListOrd()));
                    }
                    bBatchJobService.disposeJob(BDeviceNetworkJobView.this.job.getStartTime());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class CancelDeviceCommand
    extends Command {
        public CancelDeviceCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.cancelDeviceCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BDeviceNetworkJobView.this.model.details(BDeviceNetworkJobView.this.model.getSelection().getRow()).cancel();
                BDeviceNetworkJobView.this.model.getSelection().deselectAll();
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class CancelJobCommand
    extends Command {
        public CancelJobCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.cancelJobCommand");
            this.setEnabled(false);
        }

        public void checkEnabled() {
            try {
                this.setEnabled(BDeviceNetworkJobView.this.getDeviceNetworkJob().getJobState() == BJobState.running);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public CommandArtifact doInvoke() {
            try {
                BDeviceNetworkJobView.this.job.cancel();
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class JobListCommand
    extends Command {
        public JobListCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.jobListCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd = BOrd.make((BOrd)BOrd.toSession((BObject)BDeviceNetworkJobView.this.getOrdBase()).getAbsoluteOrd(), (BOrd)BDeviceNetworkJobView.this.getJobListOrd());
                BDeviceNetworkJobView.this.getWbShell().hyperlink(bOrd);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class ViewLogCommand
    extends Command {
        public ViewLogCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.viewLogCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                JobTable.showLogDialog((BWidget)BDeviceNetworkJobView.this.model.getTable(), BDeviceNetworkJobView.this.job);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BDeviceNetworkJobView.this, lex, "DeviceNetworkJobView.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetails bJobStepDetails = BDeviceNetworkJobView.this.model.details(BDeviceNetworkJobView.this.model.getTable().getSelection().getRow());
                if (bJobStepDetails.getState().isComplete()) {
                    BIFile bIFile = bJobStepDetails.findLogFile(BDeviceNetworkJobView.this.getOrdBase());
                    BOrd bOrd = BOrd.make((BOrd)((BINavNode)BDeviceNetworkJobView.this.getOrdBase()).getNavOrd(), (BOrd)bIFile.getOrdInSession());
                    bOrd = BOrd.make((BOrd)bOrd, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)bJobStepDetails.getStartTime().getTimeZone().getId()))));
                    BDeviceNetworkJobView.this.getWbShell().hyperlink(bOrd);
                } else {
                    BDeviceNetworkJobView.this.getWbShell().hyperlink(bJobStepDetails.getNavOrd());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    protected class Model
    extends TableModel {
        protected Array rows = new Array(class$javax$baja$batchJob$BJobStepDetails == null ? (class$javax$baja$batchJob$BJobStepDetails = BDeviceNetworkJobView.class$("javax.baja.batchJob.BJobStepDetails")) : class$javax$baja$batchJob$BJobStepDetails);
        protected Set startTimes = new HashSet();

        protected Model() {
        }

        public synchronized void updateDetails(BJobStepDetails bJobStepDetails) {
            if (!this.startTimes.contains(bJobStepDetails.getStartTime())) {
                this.rows.add((Object)bJobStepDetails);
                this.startTimes.add(bJobStepDetails.getStartTime());
            }
            this.updateTable(true);
        }

        public synchronized void load(BDeviceNetworkJob bDeviceNetworkJob) throws Exception {
            BJobStepDetails[] bJobStepDetailsArray = bDeviceNetworkJob.getJobStepDetails();
            HashSet<BAbsTime> hashSet = new HashSet<BAbsTime>();
            for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
                hashSet.add(bJobStepDetailsArray[i].getStartTime());
            }
            this.rows = new Array((Object[])bJobStepDetailsArray);
            this.startTimes = hashSet;
            this.updateTable(true);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("DeviceNetworkJobView.col.device");
                }
                case 1: {
                    return lex.getText("DeviceNetworkJobView.col.type");
                }
                case 2: {
                    return lex.getText("DeviceNetworkJobView.col.start");
                }
                case 3: {
                    return lex.getText("DeviceNetworkJobView.col.end");
                }
                case 4: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (this.details(n) instanceof BDeviceStepDetails) {
                        String string = ((BDeviceStepDetails)this.details(n)).getDeviceDisplayName();
                        return string.length() == 0 ? ((BDeviceStepDetails)this.details(n)).getDeviceId().toString() : string;
                    }
                    return lex.getText("DeviceNetworkJobView.col.device.none");
                }
                case 1: {
                    return this.details(n).getStepDescription();
                }
                case 2: {
                    return this.details(n).getStartTime().toString();
                }
                case 3: {
                    return this.details(n).getEndTime().isNull() ? "" : this.details(n).getEndTime().toString();
                }
                case 4: {
                    return this.details(n).getState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BJobStepDetails details(int n) {
            return (BJobStepDetails)((Object)this.rows.get(n));
        }

        public BImage getRowIcon(int n) {
            return JobTable.stateToIcon(this.details(n).getState());
        }
    }
}

