/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BIDeviceStepSummary;
import javax.baja.batchJob.driver.BINetworkStepSummary;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.BNetworkJobStep;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public abstract class BDeviceJobList
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$driver$BDeviceJobList == null ? (class$com$tridium$batchJob$ui$driver$BDeviceJobList = BDeviceJobList.class$("com.tridium.batchJob.ui.driver.BDeviceJobList")) : class$com$tridium$batchJob$ui$driver$BDeviceJobList));
    private Model model;
    private LogCommand logCommand;
    private BSimple deviceId = null;
    private BDeviceNetwork network = null;
    private BBatchJobService batchJobSvc = null;
    private static Lexicon lex = Lexicon.make((String)"batchJob");
    public static final int COL_STEP_DESC = 0;
    public static final int COL_STEP_START = 1;
    public static final int COL_STEP_END = 2;
    public static final int COL_BUTTONS = 3;
    static /* synthetic */ Class class$com$tridium$batchJob$ui$driver$BDeviceJobList;
    static /* synthetic */ Class class$javax$baja$batchJob$BIJobStepSummary;
    static /* synthetic */ Class class$javax$baja$batchJob$driver$BDeviceNetworkJob;

    public Type getType() {
        return TYPE;
    }

    public BDeviceJobList() {
        this.autoRegisterForComponentEvents = false;
        CommandBindings commandBindings = new CommandBindings();
        this.logCommand = new LogCommand();
        commandBindings.addCommand((Command)this.logCommand, BCommandEnablePolicy.singleSelection);
        StepCommand stepCommand = new StepCommand();
        commandBindings.addCommand((Command)stepCommand, BCommandEnablePolicy.singleSelection);
        commandBindings.addCommand((Command)new JobCommand(), BCommandEnablePolicy.singleSelection);
        commandBindings.setDoubleClickCommand((Command)this.logCommand);
        this.model = new Model();
        BCommandBoundTable bCommandBoundTable = JobTable.makeListTable(this.model, commandBindings, 3, stepCommand, null);
        bCommandBoundTable.setMultipleSelection(false);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)new BButtonPane(commandBindings.getCommands()), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)bCommandBoundTable), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.model.load();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BBatchJobService) {
            if (bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == BBatchJobService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)bComponentEvent.getValue());
            }
        } else if (bComponentEvent.getId() == 1) {
            if (bComponentEvent.getValue() instanceof BDeviceNetworkJob) {
                BJobStepDetails[] bJobStepDetailsArray = ((BDeviceNetworkJob)bComponentEvent.getValue()).getJobStepDetails();
                for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
                    try {
                        this.model.updateDetails(bJobStepDetailsArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.registerForComponentEvents((BComponent)((BDeviceNetworkJob)bComponentEvent.getValue()), Integer.MAX_VALUE);
            } else if (bComponentEvent.getValue() instanceof BJobStep) {
                BJobStep bJobStep = (BJobStep)bComponentEvent.getValue();
                BJobStepDetails[] bJobStepDetailsArray = bJobStep.getJobStepDetails();
                for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
                    try {
                        this.model.updateDetails(bJobStepDetailsArray[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.registerForComponentEvents(bJobStep, Integer.MAX_VALUE);
            } else if (bComponentEvent.getValue() instanceof BJobStepDetails) {
                BJobStepDetails bJobStepDetails = (BJobStepDetails)bComponentEvent.getValue();
                try {
                    this.model.updateDetails(bJobStepDetails);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.registerForComponentEvents(bJobStepDetails, Integer.MAX_VALUE);
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BJobStepDetails) {
            try {
                this.model.updateDetails((BJobStepDetails)bComponentEvent.getSourceComponent());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected BSimple getDeviceId() {
        if (this.deviceId == null) {
            this.deviceId = BNetworkBatchAgent.get(this.getDevice()).getBatchDeviceId(this.getDevice());
        }
        return this.deviceId;
    }

    protected BDeviceNetwork getNetwork() {
        if (this.network == null) {
            this.network = BNetworkBatchAgent.get(this.getDevice()).getDeviceNetwork(this.getDevice());
        }
        return this.network;
    }

    protected abstract BDevice getDevice();

    protected BDeviceNetworkJob getJob(BJobStepDetails bJobStepDetails) {
        BJobStep bJobStep;
        if (bJobStepDetails.getParent() instanceof BJobStep && (bJobStep = (BJobStep)bJobStepDetails.getParent()).getJob() instanceof BDeviceNetworkJob) {
            return (BDeviceNetworkJob)bJobStep.getJob();
        }
        return null;
    }

    protected BBatchJobService getBatchJobService() throws Exception {
        if (this.batchJobSvc == null) {
            this.batchJobSvc = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)((BComponent)this.getCurrentValue()));
        }
        return this.batchJobSvc;
    }

    protected BIJobQueryManager getQueryManager() throws Exception {
        return this.getBatchJobService().getJobQueryManager();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Key {
        private BSimple deviceId;
        private BAbsTime stepStart;
        private BTypeSpec stepType;

        public Key(BJobStepDetails bJobStepDetails) {
            this.deviceId = bJobStepDetails instanceof BDeviceStepDetails ? ((BDeviceStepDetails)bJobStepDetails).getDeviceId() : BString.DEFAULT;
            this.stepStart = bJobStepDetails.getStartTime();
            this.stepType = bJobStepDetails.getStepType();
        }

        public Key(BIJobStepSummary bIJobStepSummary) {
            this.deviceId = bIJobStepSummary instanceof BIDeviceStepSummary ? ((BIDeviceStepSummary)bIJobStepSummary).getDeviceId() : BString.DEFAULT;
            this.stepStart = bIJobStepSummary.getStartTime();
            this.stepType = bIJobStepSummary.getStepType();
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return key.deviceId.equals((Object)this.deviceId) && key.stepStart.equals((Object)this.stepStart) && key.stepType.equals((Object)this.stepType);
            }
            return false;
        }

        public String toString() {
            return this.deviceId + ":" + this.stepStart + ":" + this.stepType;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BDeviceJobList.this, lex, "DeviceJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetails bJobStepDetails = BDeviceJobList.this.model.summary(BDeviceJobList.this.model.getTable().getSelection().getRow()).getStepDetails(BDeviceJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BDeviceJobList.this.model.getTable(), bJobStepDetails.readLog().toString());
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class JobCommand
    extends Command {
        public JobCommand() {
            super((BWidget)BDeviceJobList.this, lex, "DeviceJobList.jobCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd;
                BIJobStepSummary bIJobStepSummary = BDeviceJobList.this.model.summary(BDeviceJobList.this.model.getTable().getSelection().getRow());
                BDeviceNetworkJob bDeviceNetworkJob = (BDeviceNetworkJob)bIJobStepSummary.getJob(BDeviceJobList.this.getCurrentValue());
                if (bDeviceNetworkJob.getParent() instanceof BJobService) {
                    bOrd = bDeviceNetworkJob.getAbsoluteOrd();
                } else {
                    BBatchJobLogFile bBatchJobLogFile = BBatchJobLogFile.find(bDeviceNetworkJob, BDeviceJobList.this.getCurrentValue());
                    bOrd = bBatchJobLogFile.getAbsoluteOrd();
                    bOrd = BOrd.make((BOrd)bOrd, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)bDeviceNetworkJob.getStartTime().getTimeZone().getId()))));
                }
                if (bDeviceNetworkJob != null) {
                    BDeviceJobList.this.getWbShell().hyperlink(bOrd);
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class StepCommand
    extends Command {
        public StepCommand() {
            super((BWidget)BDeviceJobList.this, lex, "DeviceJobList.stepCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd;
                BIJobStepSummary bIJobStepSummary = BDeviceJobList.this.model.summary(BDeviceJobList.this.model.getTable().getSelection().getRow());
                BJobStepDetails bJobStepDetails = bIJobStepSummary.getStepDetails(BDeviceJobList.this.getCurrentValue());
                if (bJobStepDetails.getParent() instanceof BJobStep) {
                    bOrd = BOrd.make((BOrd)((BComponent)BDeviceJobList.this.getCurrentValue()).getAbsoluteOrd(), (BOrd)bJobStepDetails.getHandleOrd());
                } else {
                    BBatchJobStepLogFile bBatchJobStepLogFile = BBatchJobStepLogFile.find(bIJobStepSummary.getStepType(), bIJobStepSummary.getLocalStartTime(), BDeviceJobList.this.getCurrentValue());
                    bOrd = BOrd.make((BOrd)((BComponent)BDeviceJobList.this.getCurrentValue()).getAbsoluteOrd(), (BOrd)bBatchJobStepLogFile.getOrdInSession());
                    bOrd = BOrd.make((BOrd)bOrd, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)bIJobStepSummary.getStartTime().getTimeZone().getId()))));
                }
                BDeviceJobList.this.getWbShell().hyperlink(bOrd);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class Model
    extends TableModel {
        private Array rows = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? (class$javax$baja$batchJob$BIJobStepSummary = BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary")) : class$javax$baja$batchJob$BIJobStepSummary);
        private Map summaryByKey = new HashMap();
        private Map summariesByJobStartTime = new HashMap();

        private Model() {
        }

        public synchronized void updateDetails(BJobStepDetails bJobStepDetails) throws Exception {
            if (bJobStepDetails instanceof BDeviceStepDetails) {
                this.updateDeviceStepDetails((BDeviceStepDetails)bJobStepDetails);
            } else if (bJobStepDetails instanceof BNetworkStepDetails) {
                this.updateNetworkStepDetails((BNetworkStepDetails)bJobStepDetails);
            }
        }

        public synchronized void updateNetworkStepDetails(BNetworkStepDetails bNetworkStepDetails) throws Exception {
            BNetworkJobStep bNetworkJobStep;
            BDeviceNetworkJob bDeviceNetworkJob;
            Key key;
            BIJobStepSummary bIJobStepSummary;
            if (bNetworkStepDetails.getNetworkOrd().equals((Object)BDeviceJobList.this.getNetwork().getOrdInSpace()) && (bIJobStepSummary = (BIJobStepSummary)this.summaryByKey.get(key = new Key(bNetworkStepDetails))) == null && bNetworkStepDetails.getParent() instanceof BNetworkJobStep && (bDeviceNetworkJob = (BDeviceNetworkJob)(bNetworkJobStep = (BNetworkJobStep)bNetworkStepDetails.getParent()).getJob()) != null) {
                bIJobStepSummary = BDeviceJobList.this.getQueryManager().makeStepSummary(bNetworkStepDetails, bDeviceNetworkJob.getStartTime());
                Array array = (Array)this.summariesByJobStartTime.get(bDeviceNetworkJob.getStartTime());
                if (array == null) {
                    array = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? (class$javax$baja$batchJob$BIJobStepSummary = BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary")) : class$javax$baja$batchJob$BIJobStepSummary);
                    this.summariesByJobStartTime.put(bDeviceNetworkJob.getStartTime(), array);
                }
                array.add((Object)bIJobStepSummary);
                this.rows.add(0, (Object)bIJobStepSummary);
                this.summaryByKey.put(key, bIJobStepSummary);
                this.updateTable(true);
            }
        }

        public synchronized void updateDeviceStepDetails(BDeviceStepDetails bDeviceStepDetails) throws Exception {
            if (bDeviceStepDetails.getDeviceId().equals((Object)BDeviceJobList.this.getDeviceId())) {
                Key key = new Key(bDeviceStepDetails);
                BIJobStepSummary bIJobStepSummary = (BIJobStepSummary)this.summaryByKey.get(key);
                if (bIJobStepSummary == null) {
                    BDeviceJobStep bDeviceJobStep;
                    BDeviceNetworkJob bDeviceNetworkJob;
                    if (bDeviceStepDetails.getParent() instanceof BDeviceJobStep && (bDeviceNetworkJob = (BDeviceNetworkJob)(bDeviceJobStep = (BDeviceJobStep)bDeviceStepDetails.getParent()).getJob()) != null) {
                        bIJobStepSummary = BDeviceJobList.this.getQueryManager().makeStepSummary(bDeviceStepDetails, bDeviceNetworkJob.getStartTime());
                        Array array = (Array)this.summariesByJobStartTime.get(bDeviceNetworkJob.getStartTime());
                        if (array == null) {
                            array = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? (class$javax$baja$batchJob$BIJobStepSummary = BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary")) : class$javax$baja$batchJob$BIJobStepSummary);
                            this.summariesByJobStartTime.put(bDeviceNetworkJob.getStartTime(), array);
                        }
                        array.add((Object)bIJobStepSummary);
                        this.rows.add(0, (Object)bIJobStepSummary);
                        this.summaryByKey.put(key, bIJobStepSummary);
                        this.updateTable(true);
                    }
                } else {
                    bIJobStepSummary.update(bDeviceStepDetails);
                    this.updateTable(true);
                }
            }
        }

        public synchronized void handleJobDisposed(BAbsTime bAbsTime) {
            Array array = (Array)this.summariesByJobStartTime.get(bAbsTime);
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    BIJobStepSummary bIJobStepSummary = (BIJobStepSummary)array.get(i);
                    this.rows.remove((Object)bIJobStepSummary);
                    this.summaryByKey.remove(new Key(bIJobStepSummary));
                }
                this.summariesByJobStartTime.remove(bAbsTime);
                this.updateTable(false);
            }
        }

        public synchronized void load() throws Exception {
            Array array;
            Object object;
            BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)((BComponent)BDeviceJobList.this.getCurrentValue()));
            BBatchJobService bBatchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)((BComponent)BDeviceJobList.this.getCurrentValue()));
            Array array2 = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? (class$javax$baja$batchJob$BIJobStepSummary = BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary")) : class$javax$baja$batchJob$BIJobStepSummary);
            HashMap<BAbsTime, Array> hashMap = new HashMap<BAbsTime, Array>();
            HashMap<Key, BIJobStepSummary> hashMap2 = new HashMap<Key, BIJobStepSummary>();
            SlotCursor slotCursor = bJobService.getProperties();
            while (slotCursor.next(class$javax$baja$batchJob$driver$BDeviceNetworkJob == null ? BDeviceJobList.class$("javax.baja.batchJob.driver.BDeviceNetworkJob") : class$javax$baja$batchJob$driver$BDeviceNetworkJob)) {
                object = (BDeviceNetworkJob)slotCursor.get();
                if (object.getJobState().isComplete()) continue;
                array = null;
                BJobStepDetails[] bJobStepDetailsArray = ((BBatchJob)object).getJobStepDetails();
                for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
                    BIJobStepSummary bIJobStepSummary;
                    BJobStepDetails bJobStepDetails;
                    if (bJobStepDetailsArray[i] instanceof BDeviceStepDetails) {
                        bJobStepDetails = (BDeviceStepDetails)bJobStepDetailsArray[i];
                        if (!((BDeviceStepDetails)bJobStepDetails).getDeviceId().equals((Object)BDeviceJobList.this.getDeviceId())) continue;
                        bIJobStepSummary = BDeviceJobList.this.getQueryManager().makeStepSummary(bJobStepDetails, object.getStartTime());
                        if (array == null) {
                            array = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary") : class$javax$baja$batchJob$BIJobStepSummary);
                        }
                        array.add((Object)bIJobStepSummary);
                        hashMap2.put(new Key(bJobStepDetails), bIJobStepSummary);
                        array2.add((Object)bIJobStepSummary);
                        continue;
                    }
                    if (!(bJobStepDetailsArray[i] instanceof BNetworkStepDetails) || !((BNetworkStepDetails)(bJobStepDetails = (BNetworkStepDetails)bJobStepDetailsArray[i])).getNetworkOrd().equals((Object)BDeviceJobList.this.getNetwork().getOrdInSpace())) continue;
                    bIJobStepSummary = BDeviceJobList.this.getQueryManager().makeStepSummary(bJobStepDetails, object.getStartTime());
                    if (array == null) {
                        array = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary") : class$javax$baja$batchJob$BIJobStepSummary);
                    }
                    array.add((Object)bIJobStepSummary);
                    hashMap2.put(new Key(bJobStepDetails), bIJobStepSummary);
                    array2.add((Object)bIJobStepSummary);
                }
                if (array == null) continue;
                hashMap.put(object.getStartTime(), array);
            }
            slotCursor = BDeviceJobList.this.getQueryManager().listStepSummaries(BDeviceJobStep.TYPE, "deviceId", BDeviceJobList.this.getDeviceId(), (BObject)BDeviceJobList.this.getDevice());
            while (slotCursor.next(class$javax$baja$batchJob$BIJobStepSummary == null ? BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary") : class$javax$baja$batchJob$BIJobStepSummary)) {
                object = (BIJobStepSummary)slotCursor.get();
                array2.add(object);
                this.summaryByKey.put(new Key((BIJobStepSummary)object), object);
                array = (Array)this.summariesByJobStartTime.get(object.getJobStartTime());
                if (array == null) {
                    array = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary") : class$javax$baja$batchJob$BIJobStepSummary);
                    this.summariesByJobStartTime.put(object.getJobStartTime(), array);
                }
                array.add(object);
            }
            slotCursor = BDeviceJobList.this.getQueryManager().listStepSummaries(BNetworkJobStep.TYPE, (BObject)BDeviceJobList.this.getDevice());
            while (slotCursor.next(class$javax$baja$batchJob$BIJobStepSummary == null ? BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary") : class$javax$baja$batchJob$BIJobStepSummary)) {
                object = (BINetworkStepSummary)slotCursor.get();
                if (!object.getDevicesToProcess().contains((BValue)BDeviceJobList.this.getDeviceId())) continue;
                array2.add(object);
                this.summaryByKey.put(new Key((BIJobStepSummary)object), object);
                array = (Array)hashMap.get(object.getJobStartTime());
                if (array == null) {
                    array = new Array(class$javax$baja$batchJob$BIJobStepSummary == null ? BDeviceJobList.class$("javax.baja.batchJob.BIJobStepSummary") : class$javax$baja$batchJob$BIJobStepSummary);
                    hashMap.put(object.getJobStartTime(), array);
                }
                array.add(object);
            }
            array2 = array2.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    BIJobStepSummary bIJobStepSummary = (BIJobStepSummary)object;
                    BIJobStepSummary bIJobStepSummary2 = (BIJobStepSummary)object2;
                    return -1 * bIJobStepSummary.getStartTime().compareTo((Object)bIJobStepSummary2.getStartTime());
                }
            });
            this.summaryByKey = hashMap2;
            this.rows = array2;
            this.summariesByJobStartTime = hashMap;
            this.updateTable(true);
            BDeviceJobList.this.registerForComponentEvents((BComponent)bJobService, Integer.MAX_VALUE);
            BDeviceJobList.this.registerForComponentEvents((BComponent)bBatchJobService, Integer.MAX_VALUE);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("DeviceJobList.col.stepDesc");
                }
                case 1: {
                    return lex.getText("DeviceJobList.col.stepStart");
                }
                case 2: {
                    return lex.getText("DeviceJobList.col.stepEnd");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.summary(n).getStepDescription();
                }
                case 1: {
                    return this.summary(n).getStartTime().toString();
                }
                case 2: {
                    return this.summary(n).getEndTime() == null ? "" : this.summary(n).getEndTime().toString();
                }
                case 3: {
                    return this.summary(n).getStepState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BIJobStepSummary summary(int n) {
            return (BIJobStepSummary)this.rows.get(n);
        }

        public BImage getRowIcon(int n) {
            return JobTable.stateToIcon(this.summary(n).getStepState());
        }
    }
}

