/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.retention.ui.BRetentionPolicyFE;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BPrototypeJobList
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$BPrototypeJobList == null ? (class$com$tridium$batchJob$ui$BPrototypeJobList = BPrototypeJobList.class$("com.tridium.batchJob.ui.BPrototypeJobList")) : class$com$tridium$batchJob$ui$BPrototypeJobList));
    protected Model model;
    protected LogCommand logCommand;
    protected DisposeCommand disposeCommand;
    protected CancelCommand cancelCommand;
    protected BBatchJobService batchJobService = null;
    protected BButtonPane lowerButtons;
    protected BWbFieldEditor checkFrequencyFe;
    protected BRetentionPolicyFE retentionPolicyFe;
    protected static final Lexicon LEX = Lexicon.make((String)"batchJob");
    public static final int COL_JOB_START = 0;
    public static final int COL_JOB_END = 1;
    public static final int COL_JOB_USER = 2;
    public static final int COL_BUTTONS = 3;
    static /* synthetic */ Class class$com$tridium$batchJob$ui$BPrototypeJobList;
    static /* synthetic */ Class class$javax$baja$batchJob$BIBatchJobSummary;
    static /* synthetic */ Class class$javax$baja$batchJob$BBatchJob;

    public Type getType() {
        return TYPE;
    }

    public BPrototypeJobList() {
        this.autoRegisterForComponentEvents = false;
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        this.retentionPolicyFe = new BRetentionPolicyFE();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"PrototypeJobList.retentionPolicy"), (BWidget)this.retentionPolicyFe);
        this.checkFrequencyFe = BWbFieldEditor.makeFor((BObject)BRelTime.HOUR);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"PrototypeJobList.checkFrequency"), (BWidget)this.checkFrequencyFe);
        this.linkTo(null, (BComponent)this.retentionPolicyFe, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.checkFrequencyFe, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        CommandBindings commandBindings = new CommandBindings();
        commandBindings.setSupport((CommandBindings.Support)this);
        this.logCommand = new LogCommand();
        commandBindings.addCommand((Command)this.logCommand, BCommandEnablePolicy.singleSelection);
        OpenCommand openCommand = new OpenCommand();
        commandBindings.addCommand((Command)openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelCommand = new CancelCommand();
        commandBindings.addCommand((Command)this.cancelCommand, BCommandEnablePolicy.anySelection);
        this.disposeCommand = new DisposeCommand();
        commandBindings.addCommand((Command)this.disposeCommand, BCommandEnablePolicy.anySelection);
        commandBindings.setDoubleClickCommand((Command)this.logCommand);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setValign(BValign.top);
        bGridPane2.setColumnAlign(BHalign.fill);
        bGridPane2.setRowGap(4.0);
        BButton bButton = new BButton((Command)new SubmitCommand(), true, false);
        bGridPane2.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bButton = new BButton((Command)this.logCommand, true, false);
        bGridPane2.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bButton = new BButton((Command)openCommand, true, false);
        bGridPane2.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bButton = new BButton((Command)this.cancelCommand, true, false);
        bGridPane2.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        bButton = new BButton((Command)this.disposeCommand, true, false);
        bGridPane2.add(null, (BValue)bButton);
        bButton.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        this.model = new Model();
        BCommandBoundTable bCommandBoundTable = JobTable.makeListTable(this.model, commandBindings, 3, openCommand, this.disposeCommand);
        bCommandBoundTable.setMultipleSelection(true);
        this.lowerButtons = new BButtonPane();
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)this.lowerButtons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, (BWidget)new BBorderPane((BWidget)bGridPane2, 0.0, 0.0, 0.0, 3.0), (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)bCommandBoundTable), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BBatchJobPrototype bBatchJobPrototype = (BBatchJobPrototype)bObject;
        this.retentionPolicyFe.loadValue((BObject)bBatchJobPrototype.getRetentionPolicy(), this.makePropertyContext(bBatchJobPrototype, BBatchJobPrototype.retentionPolicy, context));
        this.checkFrequencyFe.loadValue((BObject)bBatchJobPrototype.getRetentionPolicyCheckFrequency(), this.makePropertyContext(bBatchJobPrototype, BBatchJobPrototype.retentionPolicyCheckFrequency, context));
        this.model.load(bBatchJobPrototype);
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell != null) {
            this.lowerButtons.add(bWbShell.getRefreshCommand(), true, true);
            this.lowerButtons.add(bWbShell.getSaveCommand(), true, true);
        }
    }

    private Context makePropertyContext(BBatchJobPrototype bBatchJobPrototype, Property property, Context context) {
        if (context == null) {
            return bBatchJobPrototype.getSlotFacets((Slot)property);
        }
        return new BasicContext(context, bBatchJobPrototype.getSlotFacets((Slot)property));
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        BBatchJobPrototype bBatchJobPrototype = (BBatchJobPrototype)bObject;
        bBatchJobPrototype.setRetentionPolicy((BRetentionPolicy)this.retentionPolicyFe.saveValue((BObject)bBatchJobPrototype.getRetentionPolicy(), context));
        bBatchJobPrototype.setRetentionPolicyCheckFrequency((BRelTime)this.checkFrequencyFe.saveValue((BObject)bBatchJobPrototype.getRetentionPolicyCheckFrequency(), context));
        return bBatchJobPrototype;
    }

    protected BBatchJobPrototype getPrototype() {
        return (BBatchJobPrototype)this.getCurrentValue();
    }

    protected BBatchJobService getBatchJobService() {
        if (this.batchJobService == null) {
            this.batchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this.getPrototype());
        }
        return this.batchJobService;
    }

    protected BIJobQueryManager getQueryManager() {
        return this.getBatchJobService().getJobQueryManager();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BBatchJobService) {
            if (bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == BBatchJobService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)bComponentEvent.getValue());
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BJobService) {
            if (bComponentEvent.getId() == 1 && bComponentEvent.getValue() instanceof BBatchJob) {
                BBatchJob bBatchJob = (BBatchJob)bComponentEvent.getValue();
                this.model.updateJob(bBatchJob);
                this.registerForComponentEvents((BComponent)bBatchJob, 1);
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BBatchJob) {
            this.model.updateJob((BBatchJob)bComponentEvent.getSourceComponent());
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command == this.disposeCommand) {
            int[] nArray = this.model.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.model.summary(nArray[i]).getJobState().isComplete()) continue;
                command.setEnabled(false);
                return;
            }
        } else if (command == this.cancelCommand) {
            int[] nArray = this.model.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.model.summary(nArray[i]).getJobState() == BJobState.running || this.model.summary(nArray[i]).getJobState() == BJobState.unknown) continue;
                command.setEnabled(false);
                return;
            }
        }
        command.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class CancelCommand
    extends Command {
        public CancelCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.cancelCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BPrototypeJobList.this.model.getTable(), (String)LEX.getText("BatchJobList.cancelCommand.dlgTitle"), (Object)LEX.getText("BatchJobList.cancelCommand.dlgMessage"))) {
                    BPrototypeJobList.this.model.cancel(BPrototypeJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    protected class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.disposeCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BPrototypeJobList.this.model.getTable(), (String)LEX.getText("BatchJobList.disposeCommand.dlgTitle"), (Object)LEX.getText("BatchJobList.disposeCommand.dlgMessage"))) {
                    BPrototypeJobList.this.model.dispose(BPrototypeJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    protected class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BBatchJob bBatchJob = BPrototypeJobList.this.model.summary(BPrototypeJobList.this.model.getTable().getSelection().getRow()).getJob(BPrototypeJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BPrototypeJobList.this.model.getTable(), bBatchJob);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    protected class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "BatchJobList.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd;
                BIBatchJobSummary bIBatchJobSummary = BPrototypeJobList.this.model.summary(BPrototypeJobList.this.model.getTable().getSelection().getRow());
                BBatchJob bBatchJob = bIBatchJobSummary.getJob(BPrototypeJobList.this.getCurrentValue());
                if (bBatchJob.getParent() instanceof BJobService) {
                    bOrd = BOrd.make((BOrd)BPrototypeJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)bBatchJob.getHandleOrd());
                } else {
                    BBatchJobLogFile bBatchJobLogFile = BBatchJobLogFile.find(bBatchJob, BPrototypeJobList.this.getCurrentValue());
                    bOrd = BOrd.make((BOrd)BPrototypeJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)bBatchJobLogFile.getOrdInSession());
                    bOrd = BOrd.make((BOrd)bOrd, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)bIBatchJobSummary.getStartTime().getTimeZone().getId()))));
                }
                BPrototypeJobList.this.getWbShell().hyperlink(bOrd);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    protected class SubmitCommand
    extends Command {
        public SubmitCommand() {
            super((BWidget)BPrototypeJobList.this, LEX, "PrototypeJobList.submitCommand");
        }

        public CommandArtifact doInvoke() {
            ((BBatchJobPrototype)BPrototypeJobList.this.getCurrentValue()).submitJob();
            return null;
        }
    }

    protected class Model
    extends TableModel {
        private Array rows = new Array(class$javax$baja$batchJob$BIBatchJobSummary == null ? (class$javax$baja$batchJob$BIBatchJobSummary = BPrototypeJobList.class$("javax.baja.batchJob.BIBatchJobSummary")) : class$javax$baja$batchJob$BIBatchJobSummary);
        private Map summaryByStartTime = new HashMap();

        public synchronized void updateJob(BBatchJob bBatchJob) {
            if (bBatchJob.getPrototypeOrd().equals((Object)BPrototypeJobList.this.getPrototype().getOrdInSpace())) {
                BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)this.summaryByStartTime.get(bBatchJob.getStartTime());
                if (bIBatchJobSummary == null) {
                    this.getSelection().deselectAll();
                    bIBatchJobSummary = BPrototypeJobList.this.getQueryManager().makeJobSummary(bBatchJob);
                    this.rows.add(0, (Object)bIBatchJobSummary);
                    this.summaryByStartTime.put(bBatchJob.getStartTime(), bIBatchJobSummary);
                } else {
                    bIBatchJobSummary.updateJob(bBatchJob);
                }
                this.updateTable(true);
            }
        }

        public synchronized void handleJobDisposed(BAbsTime bAbsTime) {
            BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)this.summaryByStartTime.get(bAbsTime);
            if (bIBatchJobSummary != null) {
                this.getSelection().deselectAll();
                this.rows.remove((Object)bIBatchJobSummary);
                this.summaryByStartTime.remove(bAbsTime);
                this.updateTable(false);
            }
        }

        public synchronized void dispose(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                BPrototypeJobList.this.getBatchJobService().disposeJob(this.summary(nArray[i]).getStartTime());
            }
        }

        public synchronized void cancel(int[] nArray) throws Exception {
            for (int i = 0; i < nArray.length; ++i) {
                this.summary(nArray[i]).getJob(BPrototypeJobList.this.getCurrentValue()).cancel();
            }
        }

        public synchronized void load(BBatchJobPrototype bBatchJobPrototype) throws Exception {
            Object object;
            BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)bBatchJobPrototype);
            bJobService.lease(2);
            BOrd bOrd = bBatchJobPrototype.getOrdInSpace();
            Array array = new Array(class$javax$baja$batchJob$BIBatchJobSummary == null ? (class$javax$baja$batchJob$BIBatchJobSummary = BPrototypeJobList.class$("javax.baja.batchJob.BIBatchJobSummary")) : class$javax$baja$batchJob$BIBatchJobSummary);
            HashMap<BAbsTime, Object> hashMap = new HashMap<BAbsTime, Object>();
            SlotCursor slotCursor = bJobService.getProperties();
            while (slotCursor.next(class$javax$baja$batchJob$BBatchJob == null ? BPrototypeJobList.class$("javax.baja.batchJob.BBatchJob") : class$javax$baja$batchJob$BBatchJob)) {
                object = (BBatchJob)slotCursor.get();
                if (!((BBatchJob)object).getPrototypeOrd().equals((Object)bOrd) || object.getJobState().isComplete()) continue;
                BIBatchJobSummary bIBatchJobSummary = BPrototypeJobList.this.getQueryManager().makeJobSummary((BBatchJob)object);
                array.add((Object)bIBatchJobSummary);
                hashMap.put(object.getStartTime(), bIBatchJobSummary);
            }
            slotCursor = bBatchJobPrototype.listBatchJobSummaries();
            while (slotCursor.next()) {
                object = (BIBatchJobSummary)slotCursor.get();
                array.add(object);
                hashMap.put(object.getStartTime(), object);
            }
            array = array.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)object;
                    BIBatchJobSummary bIBatchJobSummary2 = (BIBatchJobSummary)object2;
                    return -1 * bIBatchJobSummary.getStartTime().compareTo((Object)bIBatchJobSummary2.getStartTime());
                }
            });
            this.summaryByStartTime = hashMap;
            this.rows = array;
            this.getSelection().deselectAll();
            this.updateTable(true);
            BPrototypeJobList.this.registerForComponentEvents((BComponent)bJobService, 2);
            BPrototypeJobList.this.registerForComponentEvents((BComponent)BPrototypeJobList.this.getBatchJobService(), 1);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return LEX.getText("BatchJobList.col.jobStart");
                }
                case 1: {
                    return LEX.getText("BatchJobList.col.jobEnd");
                }
                case 2: {
                    return LEX.getText("BatchJobList.col.user");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.summary(n).getStartTime().toString();
                }
                case 1: {
                    return this.summary(n).getEndTime() == null ? "" : this.summary(n).getEndTime().toString();
                }
                case 2: {
                    return this.summary(n).getSubmitUser();
                }
                case 3: {
                    return this.summary(n).getJobState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BIBatchJobSummary summary(int n) {
            return (BIBatchJobSummary)this.rows.get(n);
        }

        public BImage getRowIcon(int n) {
            return JobTable.stateToIcon(this.summary(n).getJobState());
        }
    }
}

