/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.ui.JobTable;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.gx.BInsets;
import javax.baja.job.BJobState;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

public class BJobStepDetailsView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$BJobStepDetailsView == null ? (class$com$tridium$batchJob$ui$BJobStepDetailsView = BJobStepDetailsView.class$("com.tridium.batchJob.ui.BJobStepDetailsView")) : class$com$tridium$batchJob$ui$BJobStepDetailsView));
    protected JobTable.LogModel model;
    protected BGridPane upperPane;
    protected BButtonPane buttons;
    protected Command refreshLogCommand;
    private BLabel typeLabel;
    private BLabel startedLabel;
    private BLabel endedLabel;
    private BLabel stateLabel;
    private static final Lexicon lex = Lexicon.make((String)"batchJob");
    static /* synthetic */ Class class$com$tridium$batchJob$ui$BJobStepDetailsView;

    public Type getType() {
        return TYPE;
    }

    public BJobStepDetailsView() {
        this.autoRegisterForComponentEvents = false;
        this.upperPane = new BGridPane(2);
        this.upperPane.setHalign(BHalign.left);
        this.buttons = new BButtonPane();
        BTable bTable = JobTable.makeLogDisplay();
        this.model = (JobTable.LogModel)bTable.getModel();
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)this.upperPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)this.buttons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)bTable), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.upperPane.removeAll();
        this.buttons.removeAll();
        BJobStepDetails bJobStepDetails = (BJobStepDetails)bObject;
        for (BComplex bComplex = bJobStepDetails.getParent(); bComplex != null; bComplex = bComplex.getParent()) {
            if (!(bComplex instanceof BBatchJob)) continue;
            this.buttons.add((Command)new GoJobCommand((BBatchJob)bComplex));
            break;
        }
        this.loadDetails((BWidget)this, bObject, bJobStepDetails, this.upperPane, this.buttons, this.model);
    }

    public void loadDetails(BWidget bWidget, BObject bObject, BJobStepDetails bJobStepDetails, BGridPane bGridPane, BButtonPane bButtonPane, JobTable.LogModel logModel) throws Exception {
        this.typeLabel = new BLabel();
        this.startedLabel = new BLabel();
        this.endedLabel = new BLabel();
        this.stateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.type"), (BWidget)this.typeLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.started"), (BWidget)this.startedLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.ended"), (BWidget)this.endedLabel);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.state"), (BWidget)this.stateLabel);
        this.typeLabel.setText(bJobStepDetails.getStepDescription());
        this.startedLabel.setText(bJobStepDetails.getStartTime().toString());
        this.endedLabel.setText(bJobStepDetails.getStartTime().toString());
        this.stateLabel.setText(bJobStepDetails.getState().toString());
        logModel.load(bJobStepDetails.readLog().toString());
        this.refreshLogCommand = new RefreshLogCommand(bJobStepDetails);
        this.refreshLogCommand.setEnabled(!bJobStepDetails.getState().isComplete());
        bButtonPane.add(this.refreshLogCommand);
        if (bJobStepDetails.isMounted() && !bJobStepDetails.getState().isComplete()) {
            this.registerForComponentEvents(bJobStepDetails, Integer.MAX_VALUE);
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BJobStepDetails && bComponentEvent.getId() == 0) {
            if (bComponentEvent.getSlot() == BJobStepDetails.startTime) {
                this.startedLabel.setText(bComponentEvent.getValue().toString());
            } else if (bComponentEvent.getSlot() == BJobStepDetails.endTime) {
                this.endedLabel.setText(bComponentEvent.getValue().toString());
            } else if (bComponentEvent.getSlot() == BJobStepDetails.state) {
                if (((BJobState)bComponentEvent.getValue()).isComplete()) {
                    try {
                        this.model.load(((BJobStepDetails)bComponentEvent.getSourceComponent()).readLog().toString());
                        this.refreshLogCommand.setEnabled(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stateLabel.setText(bComponentEvent.getValue().toString());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class RefreshLogCommand
    extends Command {
        private BJobStepDetails details;

        public RefreshLogCommand(BJobStepDetails bJobStepDetails) {
            super((BWidget)BJobStepDetailsView.this, lex, "JobStepDetailsView.refreshLogCommand");
            this.details = bJobStepDetails;
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetailsView.this.model.load(this.details.readLog().toString());
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    protected class GoJobCommand
    extends Command {
        private BBatchJob job;

        public GoJobCommand(BBatchJob bBatchJob) {
            super((BWidget)BJobStepDetailsView.this, lex, "JobStepDetailsView.goJobCommand");
            this.job = bBatchJob;
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetailsView.this.getWbShell().hyperlink(this.job.getNavOrd());
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }
}

