/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.ui.JobStepChooser;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.ui.BJobStepFactory;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;

public class BJobStageBuilder
extends BList
implements CommandBindings.Support {
    public static final Topic listUpdated = BJobStageBuilder.newTopic((int)0, null);
    public static final Topic transferWidgetFocusGained = BJobStageBuilder.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$BJobStageBuilder == null ? (class$com$tridium$batchJob$ui$BJobStageBuilder = BJobStageBuilder.class$("com.tridium.batchJob.ui.BJobStageBuilder")) : class$com$tridium$batchJob$ui$BJobStageBuilder));
    private BObject jobTarget = null;
    private BBatchJob currentBatchJob = null;
    private JobStepChooser chooser;
    private BWidget container;
    private Model model;
    private AddStep addStep;
    private MoveStepUp moveStepUp;
    private MoveStepDown moveStepDown;
    private RemoveStep removeStep;
    private ViewStepDetails viewStepDetails;
    private static final ExcludeGenericAgents EXCLUDE_GENERIC = new ExcludeGenericAgents();
    public static final Lexicon lex = Lexicon.make((String)"batchJob");
    static /* synthetic */ Class class$com$tridium$batchJob$ui$BJobStageBuilder;
    static /* synthetic */ Class class$javax$baja$batchJob$BJobStep;

    public void fireListUpdated(BWidgetEvent bWidgetEvent) {
        this.fire(listUpdated, (BValue)bWidgetEvent, null);
    }

    public void fireTransferWidgetFocusGained(BFocusEvent bFocusEvent) {
        this.fire(transferWidgetFocusGained, (BValue)bFocusEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BJobStageBuilder() {
        throw new UnsupportedOperationException();
    }

    public BJobStageBuilder(String string, Type type) {
        this.chooser = new JobStepChooser(type);
        CommandBindings commandBindings = new CommandBindings();
        commandBindings.setSupport((CommandBindings.Support)this);
        this.addStep = new AddStep();
        commandBindings.addCommand((Command)this.addStep, BCommandEnablePolicy.always);
        this.moveStepUp = new MoveStepUp();
        commandBindings.addCommand((Command)this.moveStepUp, BCommandEnablePolicy.singleSelection);
        this.moveStepDown = new MoveStepDown();
        commandBindings.addCommand((Command)this.moveStepDown, BCommandEnablePolicy.singleSelection);
        this.removeStep = new RemoveStep();
        commandBindings.addCommand((Command)this.removeStep, BCommandEnablePolicy.anySelection);
        this.viewStepDetails = new ViewStepDetails();
        commandBindings.addCommand((Command)this.viewStepDetails, BCommandEnablePolicy.singleSelection);
        commandBindings.setDoubleClickCommand((Command)this.viewStepDetails);
        this.setController((ListController)new Controller(commandBindings));
        this.setSelection((ListSelection)new CommandBindings.ListSelection(commandBindings));
        this.model = new Model();
        this.setModel(this.model);
        BBorderPane bBorderPane = new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BButtonPane(BButtonStyle.toolBar, new Command[]{this.addStep, this.moveStepUp, this.moveStepDown, this.removeStep}, false, true), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this, BBorder.inset, BInsets.DEFAULT), 4.0, 0.0, 4.0, 0.0)));
        bBorderPane.setBorder(BBorder.solid);
        bBorderPane.setLabel((BWidget)new BLabel(string));
        bBorderPane.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
        this.container = bBorderPane;
    }

    public BWidget getContainer() {
        return this.container;
    }

    public BJobStep[] getJobSteps() {
        BJobStep[] bJobStepArray = new BJobStep[this.model.getItemCount()];
        for (int i = 0; i < bJobStepArray.length; ++i) {
            bJobStepArray[i] = this.model.getJobStep(i);
        }
        return bJobStepArray;
    }

    public void addJobStep(BJobStep bJobStep) {
        this.model.addItem(null, (Object)bJobStep);
    }

    public void load(BJobStage bJobStage, BObject bObject) {
        this.currentBatchJob = bJobStage == null ? null : bJobStage.getJob();
        this.jobTarget = bObject;
        this.model.removeAllItems();
        if (bJobStage != null) {
            BJobStep[] bJobStepArray = bJobStage.getAllSteps();
            for (int i = 0; i < bJobStepArray.length; ++i) {
                this.addJobStep(bJobStepArray[i]);
            }
        }
    }

    public void saveToStage(BJobStage bJobStage) {
        bJobStage.removeAllSteps();
        BJobStep[] bJobStepArray = this.getJobSteps();
        for (int i = 0; i < bJobStepArray.length; ++i) {
            bJobStage.addStep(bJobStepArray[i]);
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command instanceof StepListCommand) {
            ((StepListCommand)command).checkEnabled(bl);
        } else {
            command.setEnabled(bl);
        }
    }

    public int dragOver(TransferContext transferContext) {
        if (this.jobTarget == null) {
            return 0;
        }
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            try {
                if (bObjectArray.length == 1) {
                    if (bObjectArray[0] instanceof BJobStepFactory && ((BJobStepFactory)bObjectArray[0]).isValidFor(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), bObjectArray[0])) {
                        return 16;
                    }
                    AgentList agentList = bObjectArray[0].getAgents().filter(AgentFilter.is((Type)BJobStepFactory.TYPE)).filter((AgentFilter)new ValidFactory(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), bObjectArray[0]));
                    if (agentList.size() > 0) {
                        return 16;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (this.jobTarget == null) {
            return null;
        }
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            int n = this.getItemIndexAt(transferContext.getX(), transferContext.getY());
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            if (bObjectArray.length == 1) {
                Object object;
                BJobStepFactory bJobStepFactory = null;
                if (bObjectArray[0] instanceof BJobStepFactory && ((BJobStepFactory)bObjectArray[0]).isValidFor(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), bObjectArray[0])) {
                    bJobStepFactory = (BJobStepFactory)bObjectArray[0];
                } else {
                    object = bObjectArray[0].getAgents().filter(AgentFilter.is((Type)BJobStepFactory.TYPE)).filter((AgentFilter)new ValidFactory(this.currentBatchJob, this.jobTarget, this.chooser.getStageType(), bObjectArray[0]));
                    if (object.size() > 0) {
                        Array array = new Array();
                        for (int i = 0; i < object.size(); ++i) {
                            array.add((Object)object.get(i).getInstance());
                        }
                        bJobStepFactory = this.chooser.chooseFactory((BWidget)this, this.currentBatchJob, this.jobTarget, array, (Context)transferContext);
                    }
                }
                if (bJobStepFactory != null && (object = bJobStepFactory.makeStep((BWidget)this, this.currentBatchJob, this.jobTarget, bObjectArray[0], (Context)transferContext)) != null) {
                    if (n < 0) {
                        this.model.addItem(null, object);
                    } else {
                        this.model.insertItem(n, null, object);
                    }
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SaveEditorCommand
    extends DialogCommand {
        private BWbEditor editor;

        public SaveEditorCommand(BWidget bWidget, BWbEditor bWbEditor) {
            super(bWidget, 1, UiLexicon.bajaui.getText("commands.save.label"), null, null, null);
            this.editor = bWbEditor;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.editor.saveValue();
            return super.doInvoke();
        }
    }

    private static class ValidFactory
    extends AgentFilter {
        private BBatchJob currentBatchJob;
        private BObject jobTarget;
        private Type stageType;
        private BObject source;

        public ValidFactory(BBatchJob bBatchJob, BObject bObject, Type type, BObject bObject2) {
            this.currentBatchJob = bBatchJob;
            this.jobTarget = bObject;
            this.stageType = type;
            this.source = bObject2;
        }

        public boolean include(AgentInfo agentInfo) {
            try {
                return ((BJobStepFactory)agentInfo.getInstance()).isValidFor(this.currentBatchJob, this.jobTarget, this.stageType, this.source);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
    }

    private static class ExcludeGenericAgents
    extends AgentFilter {
        private AgentList agents = new BComponent().getAgents();

        public boolean include(AgentInfo agentInfo) {
            return this.agents.indexOf(agentInfo) == -1;
        }
    }

    private class Controller
    extends CommandBindings.ListController {
        public Controller(CommandBindings commandBindings) {
            super(commandBindings);
        }

        public void focusGained(BFocusEvent bFocusEvent) {
            BJobStageBuilder.this.fireTransferWidgetFocusGained(bFocusEvent);
        }
    }

    private class Model
    extends ListModel {
        private Array steps = new Array(class$javax$baja$batchJob$BJobStep == null ? (class$javax$baja$batchJob$BJobStep = BJobStageBuilder.class$("javax.baja.batchJob.BJobStep")) : class$javax$baja$batchJob$BJobStep);

        private Model() {
        }

        public synchronized void swapItems(int n, int n2) {
            this.steps.swap(n, n2);
            this.updateList();
        }

        public synchronized void addItem(BImage bImage, Object object) {
            this.steps.add(object);
            this.updateList();
        }

        public synchronized void insertItem(int n, BImage bImage, Object object) {
            this.steps.add(n, object);
            this.updateList();
        }

        public synchronized void removeItem(Object object) {
            this.steps.remove(object);
            this.updateList();
        }

        public void removeItem(int n) {
            this.removeItem((Object)this.getJobStep(n));
        }

        public synchronized void removeAllItems() {
            this.steps.clear();
            this.updateList();
        }

        public int getItemCount() {
            return this.steps.size();
        }

        public void updateList() {
            super.updateList();
            BJobStageBuilder.this.fireListUpdated(new BWidgetEvent(1, (BWidget)this.getList()));
        }

        public BImage getItemIcon(int n) {
            return BImage.make((BIcon)this.getJobStep(n).getIcon());
        }

        public BJobStep getJobStep(int n) {
            return (BJobStep)((Object)this.steps.get(n));
        }

        public Object getItem(int n) {
            return this.getJobStep(n).toString(null);
        }
    }

    private class RemoveStep
    extends StepListCommand {
        public RemoveStep() {
            super("JobStageBuilder.remove");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BJobStageBuilder.this.model.getSelection().getItems();
            for (int i = nArray.length; i > 0; --i) {
                BJobStageBuilder.this.model.removeItem(nArray[i - 1]);
            }
            BJobStageBuilder.this.model.getSelection().deselectAll();
            return null;
        }
    }

    private class MoveStepDown
    extends StepListCommand {
        public MoveStepDown() {
            super("JobStageBuilder.moveDown");
        }

        public CommandArtifact doInvoke() {
            int n = BJobStageBuilder.this.model.getSelection().getItems()[0];
            BJobStageBuilder.this.model.swapItems(n, n + 1);
            BJobStageBuilder.this.model.getSelection().select(n + 1, true);
            return null;
        }

        public void checkEnabled(boolean bl) {
            if (bl) {
                int n = BJobStageBuilder.this.model.getSelection().getItems()[0];
                if (n == BJobStageBuilder.this.model.getModel().getItemCount() - 1) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bl);
                }
            } else {
                this.setEnabled(bl);
            }
        }
    }

    private class MoveStepUp
    extends StepListCommand {
        public MoveStepUp() {
            super("JobStageBuilder.moveUp");
        }

        public CommandArtifact doInvoke() {
            int n = BJobStageBuilder.this.model.getSelection().getItems()[0];
            BJobStageBuilder.this.model.swapItems(n, n - 1);
            BJobStageBuilder.this.model.getSelection().select(n - 1, true);
            return null;
        }

        public void checkEnabled(boolean bl) {
            if (bl) {
                int n = BJobStageBuilder.this.model.getSelection().getItems()[0];
                if (n == 0) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bl);
                }
            } else {
                this.setEnabled(bl);
            }
        }
    }

    private class AddStep
    extends StepListCommand {
        public AddStep() {
            super("JobStageBuilder.add");
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStep bJobStep = BJobStageBuilder.this.chooser.choose((BWidget)BJobStageBuilder.this, BJobStageBuilder.this.currentBatchJob, BJobStageBuilder.this.jobTarget, null);
                if (bJobStep != null) {
                    BJobStageBuilder.this.model.addItem(null, (Object)bJobStep);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class ViewStepDetails
    extends StepListCommand {
        public ViewStepDetails() {
            super("JobStageBuilder.details");
        }

        public void checkEnabled(boolean bl) {
            BJobStep bJobStep;
            AgentList agentList;
            if (bl && (agentList = (bJobStep = BJobStageBuilder.this.model.getJobStep(BJobStageBuilder.this.model.getSelection().getItems()[0])).getAgents().filter(AgentFilter.is((Type)BWbEditor.TYPE)).filter((AgentFilter)EXCLUDE_GENERIC)).size() > 0) {
                this.setEnabled(true);
            }
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStep bJobStep = BJobStageBuilder.this.model.getJobStep(BJobStageBuilder.this.model.getSelection().getItems()[0]);
                AgentList agentList = bJobStep.getAgents().filter(AgentFilter.is((Type)BWbEditor.TYPE)).filter((AgentFilter)EXCLUDE_GENERIC);
                if (agentList.size() > 0) {
                    BWbEditor bWbEditor = (BWbEditor)agentList.getDefault().getInstance();
                    bWbEditor.loadValue((BObject)bJobStep);
                    BCommandDialog.open((BWidget)BJobStageBuilder.this, (String)bJobStep.toString(null), (Object)bWbEditor, (DialogCommand[])new DialogCommand[]{new SaveEditorCommand((BWidget)BJobStageBuilder.this, bWbEditor), DialogCommand.makeCancel((BWidget)BJobStageBuilder.this)}, null);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private abstract class StepListCommand
    extends Command {
        public StepListCommand(String string) {
            super((BWidget)BJobStageBuilder.this, lex, string);
        }

        public void checkEnabled(boolean bl) {
            this.setEnabled(bl);
        }
    }
}

