/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

public abstract class BBatchJobList
extends BWbComponentView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$BBatchJobList == null ? (class$com$tridium$batchJob$ui$BBatchJobList = BBatchJobList.class$("com.tridium.batchJob.ui.BBatchJobList")) : class$com$tridium$batchJob$ui$BBatchJobList));
    private Model model;
    private BTable table;
    private LogCommand logCommand;
    private DisposeCommand disposeCommand;
    private CancelCommand cancelCommand;
    private BBatchJobService batchJobService = null;
    private static Lexicon lex = Lexicon.make((String)"batchJob");
    public static final int COL_JOB_START = 0;
    public static final int COL_JOB_END = 1;
    public static final int COL_JOB_USER = 2;
    public static final int COL_BUTTONS = 3;
    private static int COLUMN_OFFSET = 0;
    static /* synthetic */ Class class$com$tridium$batchJob$ui$BBatchJobList;
    static /* synthetic */ Class class$javax$baja$batchJob$BIBatchJobSummary;

    public Type getType() {
        return TYPE;
    }

    public BBatchJobList() {
        this.autoRegisterForComponentEvents = false;
        CommandBindings commandBindings = new CommandBindings();
        commandBindings.setSupport((CommandBindings.Support)this);
        this.logCommand = new LogCommand();
        commandBindings.addCommand((Command)this.logCommand, BCommandEnablePolicy.singleSelection);
        OpenCommand openCommand = new OpenCommand();
        commandBindings.addCommand((Command)openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelCommand = new CancelCommand();
        commandBindings.addCommand((Command)this.cancelCommand, BCommandEnablePolicy.anySelection);
        this.disposeCommand = new DisposeCommand();
        commandBindings.addCommand((Command)this.disposeCommand, BCommandEnablePolicy.singleSelection);
        commandBindings.setDoubleClickCommand((Command)this.logCommand);
        COLUMN_OFFSET = this.getColumnOffset();
        this.model = new Model();
        this.table = JobTable.makeListTable(this.model, commandBindings, 3 + COLUMN_OFFSET, openCommand, this.disposeCommand);
        this.table.setMultipleSelection(true);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)new BButtonPane(commandBindings.getCommands()), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.table), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.model.load();
    }

    protected abstract Type getJobType();

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BBatchJobService) {
            if (bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == BBatchJobService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)bComponentEvent.getValue());
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BJobService) {
            if (bComponentEvent.getId() == 1 && bComponentEvent.getValue().getType().equals(this.getJobType())) {
                BBatchJob bBatchJob = (BBatchJob)bComponentEvent.getValue();
                this.model.updateJob(bBatchJob);
                this.registerForComponentEvents((BComponent)bBatchJob, 1);
            }
        } else if (bComponentEvent.getSourceComponent().getType().equals(this.getJobType())) {
            this.model.updateJob((BBatchJob)bComponentEvent.getSourceComponent());
        }
    }

    public BBatchJobService getBatchJobService() {
        if (this.batchJobService == null) {
            this.batchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(this.getCurrentValue());
        }
        return this.batchJobService;
    }

    public BIJobQueryManager getQueryManager() {
        return this.getBatchJobService().getJobQueryManager();
    }

    protected void setModel(Model model) {
        this.model = model;
        this.table.setModel((TableModel)model);
        model.updateTable(true);
    }

    protected int getColumnOffset() {
        return 0;
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command == this.disposeCommand) {
            int[] nArray = this.model.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.model.summary(nArray[i]).getJobState().isComplete()) continue;
                command.setEnabled(false);
                return;
            }
        } else if (command == this.cancelCommand) {
            int[] nArray = this.model.getSelection().getRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.model.summary(nArray[i]).getJobState() == BJobState.running || this.model.summary(nArray[i]).getJobState() == BJobState.unknown) continue;
                command.setEnabled(false);
                return;
            }
        }
        command.setEnabled(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CancelCommand
    extends Command {
        public CancelCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.cancelCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BBatchJobList.this.model.getTable(), (String)lex.getText("BatchJobList.cancelCommand.dlgTitle"), (Object)lex.getText("BatchJobList.cancelCommand.dlgMessage"))) {
                    BBatchJobList.this.model.cancel(BBatchJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.disposeCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BBatchJobList.this.model.getTable(), (String)lex.getText("BatchJobList.disposeCommand.dlgTitle"), (Object)lex.getText("BatchJobList.disposeCommand.dlgMessage"))) {
                    BBatchJobList.this.model.dispose(BBatchJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BBatchJob bBatchJob = BBatchJobList.this.model.summary(BBatchJobList.this.model.getTable().getSelection().getRow()).getJob(BBatchJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BBatchJobList.this.model.getTable(), bBatchJob);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    private class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd bOrd;
                BIBatchJobSummary bIBatchJobSummary = BBatchJobList.this.model.summary(BBatchJobList.this.model.getTable().getSelection().getRow());
                BBatchJob bBatchJob = bIBatchJobSummary.getJob(BBatchJobList.this.getCurrentValue());
                if (bBatchJob.getParent() instanceof BJobService) {
                    bOrd = BOrd.make((BOrd)BBatchJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)bBatchJob.getHandleOrd());
                } else {
                    BBatchJobLogFile bBatchJobLogFile = BBatchJobLogFile.find(bBatchJob, BBatchJobList.this.getCurrentValue());
                    bOrd = BOrd.make((BOrd)BBatchJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)bBatchJobLogFile.getOrdInSession());
                    bOrd = BOrd.make((BOrd)bOrd, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)bBatchJob.getStartTime().getTimeZone().getId()))));
                }
                BBatchJobList.this.getWbShell().hyperlink(bOrd);
            }
            catch (Exception exception) {
                CommandUtil.error((Command)this, (Throwable)exception);
            }
            return null;
        }
    }

    protected class Model
    extends TableModel {
        protected Array rows = new Array(class$javax$baja$batchJob$BIBatchJobSummary == null ? (class$javax$baja$batchJob$BIBatchJobSummary = BBatchJobList.class$("javax.baja.batchJob.BIBatchJobSummary")) : class$javax$baja$batchJob$BIBatchJobSummary);
        protected Map summaryByStartTime = new HashMap();

        protected Model() {
        }

        public synchronized void updateJob(BBatchJob bBatchJob) {
            BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)this.summaryByStartTime.get(bBatchJob.getStartTime());
            if (bIBatchJobSummary == null) {
                this.getSelection().deselectAll();
                bIBatchJobSummary = BBatchJobList.this.getQueryManager().makeJobSummary(bBatchJob);
                this.rows.add(0, (Object)bIBatchJobSummary);
                this.summaryByStartTime.put(bBatchJob.getStartTime(), bIBatchJobSummary);
            } else {
                bIBatchJobSummary.updateJob(bBatchJob);
            }
            this.updateTable(true);
        }

        public synchronized void handleJobDisposed(BAbsTime bAbsTime) {
            BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)this.summaryByStartTime.get(bAbsTime);
            if (bIBatchJobSummary != null) {
                this.getSelection().deselectAll();
                this.rows.remove((Object)bIBatchJobSummary);
                this.summaryByStartTime.remove(bAbsTime);
                this.updateTable(false);
            }
        }

        public synchronized void dispose(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                BBatchJobList.this.getBatchJobService().disposeJob(this.summary(nArray[i]).getStartTime());
            }
        }

        public synchronized void cancel(int[] nArray) throws Exception {
            for (int i = 0; i < nArray.length; ++i) {
                this.summary(nArray[i]).getJob(BBatchJobList.this.getCurrentValue()).cancel();
            }
        }

        public synchronized void load() throws Exception {
            Object object;
            this.getSelection().deselectAll();
            BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get(BBatchJobList.this.getCurrentValue());
            bJobService.lease(2);
            Array array = new Array(class$javax$baja$batchJob$BIBatchJobSummary == null ? (class$javax$baja$batchJob$BIBatchJobSummary = BBatchJobList.class$("javax.baja.batchJob.BIBatchJobSummary")) : class$javax$baja$batchJob$BIBatchJobSummary);
            HashMap<BAbsTime, Object> hashMap = new HashMap<BAbsTime, Object>();
            Class clazz = BBatchJobList.this.getJobType().getTypeClass();
            SlotCursor slotCursor = bJobService.getProperties();
            while (slotCursor.next(clazz)) {
                object = (BBatchJob)slotCursor.get();
                if (object.getJobState().isComplete()) continue;
                BIBatchJobSummary bIBatchJobSummary = BBatchJobList.this.getQueryManager().makeJobSummary((BBatchJob)object);
                array.add((Object)bIBatchJobSummary);
                hashMap.put(object.getStartTime(), bIBatchJobSummary);
            }
            slotCursor = BBatchJobList.this.getQueryManager().listJobSummaries(BBatchJobList.this.getJobType(), BBatchJobList.this.getCurrentValue());
            while (slotCursor.next(class$javax$baja$batchJob$BIBatchJobSummary == null ? BBatchJobList.class$("javax.baja.batchJob.BIBatchJobSummary") : class$javax$baja$batchJob$BIBatchJobSummary)) {
                object = (BIBatchJobSummary)slotCursor.get();
                array.add(object);
                hashMap.put(object.getStartTime(), object);
            }
            array = array.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)object;
                    BIBatchJobSummary bIBatchJobSummary2 = (BIBatchJobSummary)object2;
                    return -1 * bIBatchJobSummary.getStartTime().compareTo((Object)bIBatchJobSummary2.getStartTime());
                }
            });
            this.summaryByStartTime = hashMap;
            this.rows = array;
            this.updateTable(true);
            BBatchJobList.this.registerForComponentEvents((BComponent)bJobService, 2);
            BBatchJobList.this.registerForComponentEvents((BComponent)BBatchJobList.this.getBatchJobService(), 1);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("BatchJobList.col.jobStart");
                }
                case 1: {
                    return lex.getText("BatchJobList.col.jobEnd");
                }
                case 2: {
                    return lex.getText("BatchJobList.col.user");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.summary(n).getStartTime().toString();
                }
                case 1: {
                    return this.summary(n).getEndTime() == null ? "" : this.summary(n).getEndTime().toString();
                }
                case 2: {
                    return this.summary(n).getSubmitUser();
                }
                case 3: {
                    return this.summary(n).getJobState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BIBatchJobSummary summary(int n) {
            return (BIBatchJobSummary)this.rows.get(n);
        }

        public BImage getRowIcon(int n) {
            return JobTable.stateToIcon(this.summary(n).getJobState());
        }
    }
}

