/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.history;

import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BIBatchHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.history.BHistoryRecord;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public abstract class BBatchJobHistoryRecord
extends BHistoryRecord
implements BIBatchJobSummary,
BIBatchHistoryRecord {
    public static final Property jobType = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property jobState = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BJobState.unknown, null);
    public static final Property prototypeOrd = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Property endTime = BBatchJobHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property submitUser = BBatchJobHistoryRecord.newProperty((int)1, (String)"unknown", null);
    public static final Property disposed = BBatchJobHistoryRecord.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$history$BBatchJobHistoryRecord == null ? (class$com$tridium$batchJob$history$BBatchJobHistoryRecord = BBatchJobHistoryRecord.class$("com.tridium.batchJob.history.BBatchJobHistoryRecord")) : class$com$tridium$batchJob$history$BBatchJobHistoryRecord));
    private BBatchJob job;
    private BTimeZone localTz = BTimeZone.NULL;
    static /* synthetic */ Class class$com$tridium$batchJob$history$BBatchJobHistoryRecord;

    public BTypeSpec getJobType() {
        return (BTypeSpec)this.get(jobType);
    }

    public void setJobType(BTypeSpec bTypeSpec) {
        this.set(jobType, (BValue)bTypeSpec, null);
    }

    public BJobState getJobState() {
        return (BJobState)this.get(jobState);
    }

    public void setJobState(BJobState bJobState) {
        this.set(jobState, (BValue)bJobState, null);
    }

    public BOrd getPrototypeOrd() {
        return (BOrd)this.get(prototypeOrd);
    }

    public void setPrototypeOrd(BOrd bOrd) {
        this.set(prototypeOrd, (BValue)bOrd, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime bAbsTime) {
        this.set(endTime, (BValue)bAbsTime, null);
    }

    public String getSubmitUser() {
        return this.getString(submitUser);
    }

    public void setSubmitUser(String string) {
        this.setString(submitUser, string, null);
    }

    public boolean getDisposed() {
        return this.getBoolean(disposed);
    }

    public void setDisposed(boolean bl) {
        this.setBoolean(disposed, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBatchJobHistoryRecord() {
    }

    protected BBatchJobHistoryRecord(BBatchJob bBatchJob) throws UnresolvedException {
        this.updateJob(bBatchJob);
    }

    public void updateJob(BBatchJob bBatchJob) {
        this.job = bBatchJob;
        this.setSubmitUser(bBatchJob.getSubmitUser());
        this.setJobType(bBatchJob.getType().getTypeSpec());
        this.setJobState(bBatchJob.getJobState());
        this.setStartTime(bBatchJob.getStartTime());
        this.setEndTime(bBatchJob.getEndTime());
        this.setPrototypeOrd(bBatchJob.getPrototypeOrd());
    }

    public BBatchJob getJob(BObject bObject) throws Exception {
        if (this.job == null) {
            this.job = BBatchJob.find(BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.localTz), bObject);
            this.job.setStartTimeLocalZone(this.localTz);
            if (!this.job.isMounted()) {
                this.job.setDisplayTimeZone(this.getStartTime().getTimeZone());
            }
        }
        return this.job;
    }

    public void setStartTime(BAbsTime bAbsTime) {
        this.setTimestamp(bAbsTime);
    }

    public BAbsTime getStartTime() {
        return this.getTimestamp();
    }

    public void setLocalTimeZone(BTimeZone bTimeZone) {
        if (!this.localTz.equals((Object)bTimeZone)) {
            this.localTz = bTimeZone;
        }
    }

    public BAbsTime getLocalStartTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.localTz);
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput dataInput) throws IOException {
        this.localTz = BTimeZone.NULL;
        this.setJobType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(dataInput.readUTF()));
        this.setJobState((BJobState)BJobState.unknown.decodeFromString(dataInput.readUTF()));
        this.setPrototypeOrd((BOrd)BOrd.DEFAULT.decodeFromString(dataInput.readUTF()));
        this.setEndTime((BAbsTime)BAbsTime.DEFAULT.decodeFromString(dataInput.readUTF()));
        this.setSubmitUser(dataInput.readUTF());
        this.setDisposed(dataInput.readBoolean());
    }

    protected void doWrite(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getJobType().encodeToString());
        dataOutput.writeUTF(this.getJobState().encodeToString());
        dataOutput.writeUTF(this.getPrototypeOrd().encodeToString());
        dataOutput.writeUTF(this.getEndTime().encodeToString());
        dataOutput.writeUTF(this.getSubmitUser());
        dataOutput.writeBoolean(this.getDisposed());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

