/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.GregorianCalendar;
import javax.baja.file.BIFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public final class BLocalTimeUtil
extends BSimple {
    public static final BLocalTimeUtil DEFAULT = new BLocalTimeUtil();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$BLocalTimeUtil == null ? (class$com$tridium$batchJob$BLocalTimeUtil = BLocalTimeUtil.class$("com.tridium.batchJob.BLocalTimeUtil")) : class$com$tridium$batchJob$BLocalTimeUtil));
    public static final ValueDocDecoder.BogTypeResolver TYPE_RESOLVER = new ValueDocDecoder.BogTypeResolver(){

        public BValue newInstance(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, Property property, String string2) {
            BValue bValue = super.newInstance(valueDocDecoder, bComplex, string, property, string2);
            if (bValue instanceof BAbsTime && valueDocDecoder.getPlugin().getClass() == (class$javax$baja$io$ValueDocDecoder$BogDecoderPlugin == null ? (class$javax$baja$io$ValueDocDecoder$BogDecoderPlugin = BLocalTimeUtil.class$("javax.baja.io.ValueDocDecoder$BogDecoderPlugin")) : class$javax$baja$io$ValueDocDecoder$BogDecoderPlugin)) {
                return DEFAULT;
            }
            return bValue;
        }
    };
    static /* synthetic */ Class class$com$tridium$batchJob$BLocalTimeUtil;
    static /* synthetic */ Class class$javax$baja$io$ValueDocDecoder$BogDecoderPlugin;

    public Type getType() {
        return TYPE;
    }

    private BLocalTimeUtil() {
    }

    public static void updateAbsTimeZone(BComponent bComponent, Property property, BTimeZone bTimeZone) {
        if (bTimeZone == null || bTimeZone.isNull()) {
            return;
        }
        BAbsTime bAbsTime = BLocalTimeUtil.getAdjustedTimeZone((BAbsTime)bComponent.get(property), bTimeZone);
        bComponent.set(property, (BValue)BAbsTime.NULL);
        if (bComponent.getSpace() != null && bComponent.getSpace() instanceof BComponentSpace) {
            try {
                ((BComponentSpace)bComponent.getSpace()).sync();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        bComponent.set(property, (BValue)bAbsTime);
    }

    public static BValue decodeBogFile(BIFile bIFile) throws Exception {
        ValueDocDecoder.BogDecoderPlugin bogDecoderPlugin = new ValueDocDecoder.BogDecoderPlugin(bIFile);
        bogDecoderPlugin.setTypeResolver((ValueDocDecoder.ITypeResolver)TYPE_RESOLVER);
        ValueDocDecoder valueDocDecoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)bogDecoderPlugin);
        return valueDocDecoder.decodeDocument();
    }

    public static BAbsTime getAdjustedTimeZone(BAbsTime bAbsTime, BTimeZone bTimeZone) {
        if (bTimeZone == null || bTimeZone.isNull() || BLocalTimeUtil.hasEquivalentUtcOffset(bAbsTime, bTimeZone)) {
            return bAbsTime;
        }
        return BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone);
    }

    public static int getUtcOffset(BAbsTime bAbsTime) {
        return bAbsTime.getTimeZone().getUtcOffset(bAbsTime.getMillis());
    }

    public static boolean hasEquivalentUtcOffset(BAbsTime bAbsTime, BTimeZone bTimeZone) {
        return BLocalTimeUtil.getUtcOffset(bAbsTime) == bTimeZone.getUtcOffset(bAbsTime.getMillis());
    }

    public BObject decode(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException();
    }

    public BObject decodeFromString(String string) throws IOException {
        char[] cArray = string.toCharArray();
        try {
            int n = 0;
            int n2 = (cArray[n++] - 48) * 1000 + (cArray[n++] - 48) * 100 + (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n3 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != '-') {
                throw new Exception();
            }
            int n4 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != 'T') {
                throw new Exception();
            }
            int n5 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n6 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n7 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48) * 1;
            int n8 = 0;
            if (cArray[n] == '.') {
                int n9 = ++n;
                n8 = (cArray[n9] - 48) * 100;
                if ('0' <= cArray[++n] && cArray[n] <= '9') {
                    n8 += (cArray[n++] - 48) * 10;
                }
                if ('0' <= cArray[n] && cArray[n] <= '9') {
                    n8 += (cArray[n++] - 48) * 1;
                }
                while (n < cArray.length && '0' <= cArray[n] && cArray[n] <= '9') {
                    ++n;
                }
            }
            int n10 = 0;
            char c = cArray[n++];
            StringBuffer stringBuffer = new StringBuffer("UTC");
            if (c != 'Z') {
                if (c != '+' && c != '-') {
                    throw new Exception();
                }
                stringBuffer.append(c);
                stringBuffer.append(cArray[n]);
                int n11 = cArray[n++] - 48;
                if (n < cArray.length && cArray[n] != ':') {
                    stringBuffer.append(cArray[n]);
                    n11 = n11 * 10 + (cArray[n++] - 48);
                }
                int n12 = 0;
                if (n < cArray.length) {
                    if (cArray[n++] != ':') {
                        throw new Exception();
                    }
                    stringBuffer.append(':');
                    stringBuffer.append(cArray[n]);
                    stringBuffer.append(cArray[n + 1]);
                    n12 = 10 * (cArray[n++] - 48) + (cArray[n++] - 48);
                }
                n10 = n11 * 3600000 + n12 * 60000;
                if (c == '-') {
                    n10 *= -1;
                }
            }
            BTimeZone bTimeZone = n10 == 0 ? BTimeZone.UTC : BTimeZone.make((String)stringBuffer.toString(), (int)n10);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(bTimeZone.getJavaTimeZone());
            gregorianCalendar.set(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.set(14, n8);
            return BAbsTime.make((long)gregorianCalendar.getTime().getTime(), (BTimeZone)bTimeZone);
        }
        catch (Exception exception) {
            throw new IOException("Invalid BAbsTime: " + string);
        }
    }

    public void encode(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String encodeToString() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

