/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob;

import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BHistoryJobSummaryManager;
import com.tridium.util.TimeFormat;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.baja.batchJob.BBatchJob;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BBatchJobLogFile
extends BAbstractFile {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$BBatchJobLogFile == null ? (class$com$tridium$batchJob$BBatchJobLogFile = BBatchJobLogFile.class$("com.tridium.batchJob.BBatchJobLogFile")) : class$com$tridium$batchJob$BBatchJobLogFile));
    private BBatchJob job = null;
    private BString logContents = null;
    public static final String JOB_FILENAME_FORMAT = "yyyyMMdd_HHmmss.SSS.'bjl'";
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});
    static /* synthetic */ Class class$com$tridium$batchJob$BBatchJobLogFile;

    public Type getType() {
        return TYPE;
    }

    public BBatchJobLogFile(BIFileStore bIFileStore) {
        super(bIFileStore);
    }

    public BBatchJobLogFile() {
    }

    public static BBatchJobLogFile find(BAbsTime bAbsTime, BObject bObject) {
        return BBatchJobLogFile.find(null, bAbsTime, bObject);
    }

    public static BBatchJobLogFile find(Type type, BAbsTime bAbsTime, BObject bObject) {
        if (bAbsTime.isNull()) {
            throw new UnresolvedException();
        }
        BFileSpace bFileSpace = (BFileSpace)BOrd.make((String)"file:").get(bObject);
        if (type == null) {
            TypeInfo[] typeInfoArray = Sys.getRegistry().getTypes(BBatchJob.TYPE.getTypeInfo());
            for (int i = 0; i < typeInfoArray.length; ++i) {
                BBatchJobLogFile bBatchJobLogFile;
                FilePath filePath = BBatchJobLogFile.pathFor(typeInfoArray[i], bAbsTime, bObject);
                if (filePath == null || (bBatchJobLogFile = (BBatchJobLogFile)bFileSpace.findFile(filePath)) == null) continue;
                return bBatchJobLogFile;
            }
            throw new UnresolvedException();
        }
        BBatchJobLogFile bBatchJobLogFile = (BBatchJobLogFile)bFileSpace.findFile(BBatchJobLogFile.pathFor(type.getTypeInfo(), bAbsTime, bObject));
        if (bBatchJobLogFile == null) {
            throw new UnresolvedException();
        }
        return bBatchJobLogFile;
    }

    public static BBatchJobLogFile findLocal(BAbsTime bAbsTime) {
        return BBatchJobLogFile.findLocal(null, bAbsTime);
    }

    public static BBatchJobLogFile findLocal(Type type, BAbsTime bAbsTime) {
        if (bAbsTime.isNull()) {
            throw new UnresolvedException();
        }
        if (type == null) {
            TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BBatchJob.TYPE.getTypeInfo());
            for (int i = 0; i < typeInfoArray.length; ++i) {
                BBatchJobLogFile bBatchJobLogFile;
                FilePath filePath = BBatchJobLogFile.pathFor(typeInfoArray[i], bAbsTime, null);
                if (filePath == null || (bBatchJobLogFile = (BBatchJobLogFile)BFileSystem.INSTANCE.findFile(filePath)) == null) continue;
                return bBatchJobLogFile;
            }
            throw new UnresolvedException();
        }
        BBatchJobLogFile bBatchJobLogFile = (BBatchJobLogFile)BFileSystem.INSTANCE.findFile(BBatchJobLogFile.pathFor(type.getTypeInfo(), bAbsTime, null));
        if (bBatchJobLogFile == null) {
            throw new UnresolvedException();
        }
        return bBatchJobLogFile;
    }

    public static BBatchJobLogFile find(BBatchJob bBatchJob, BObject bObject) throws UnresolvedException {
        if (bBatchJob.getStartTime().isNull()) {
            throw new UnresolvedException();
        }
        return BBatchJobLogFile.find(bBatchJob.getType(), bBatchJob.getLocalStartTime(), bObject);
    }

    public static BBatchJobLogFile create(BBatchJob bBatchJob) throws Exception {
        BBatchJobLogFile bBatchJobLogFile = (BBatchJobLogFile)BFileSystem.INSTANCE.makeFile(BBatchJobLogFile.pathFor(bBatchJob.getType().getTypeInfo(), bBatchJob.getLocalStartTime(), null));
        OutputStream outputStream = bBatchJobLogFile.getOutputStream();
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(outputStream);
        valueDocEncoder.setEncodeTransients(true);
        valueDocEncoder.setZipped(true);
        BComponent bComponent = new BComponent();
        bComponent.add("job", bBatchJob.newCopy());
        bComponent.add("logContents", (BValue)BString.make((String)bBatchJob.log().encode()));
        valueDocEncoder.encodeDocument((BValue)bComponent);
        valueDocEncoder.close();
        outputStream.close();
        return bBatchJobLogFile;
    }

    public BBatchJob getJob() throws Exception {
        this.parse();
        return this.job;
    }

    public BString getLogContents() throws Exception {
        this.parse();
        return this.logContents;
    }

    private void parse() throws Exception {
        if (this.job == null) {
            BComponent bComponent = (BComponent)BLocalTimeUtil.decodeBogFile((BIFile)this);
            this.job = (BBatchJob)bComponent.get("job");
            this.job.setLogFile((BIFile)this);
            this.logContents = (BString)bComponent.get("logContents");
            if (this.logContents == null) {
                this.logContents = BString.DEFAULT;
            }
        }
    }

    public BAbsTime getFilenameTime() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(JOB_FILENAME_FORMAT);
            simpleDateFormat.setTimeZone(BTimeZone.getLocal().getJavaTimeZone());
            return BAbsTime.make((long)simpleDateFormat.parse(this.getFileName()).getTime());
        }
        catch (ParseException parseException) {
            throw new BajaRuntimeException("Invalid log file name");
        }
    }

    public void setStore(BIFileStore bIFileStore) {
        super.setStore(bIFileStore);
        this.job = null;
    }

    public String getMimeType() {
        return "application/niagara-batch-job-log";
    }

    public String getNavDescription(Context context) {
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public BINavNode getNavChild(String string) {
        return null;
    }

    private static FilePath pathFor(TypeInfo typeInfo, BAbsTime bAbsTime, BObject bObject) {
        TypeInfo typeInfo2 = BHistoryJobSummaryManager.getJobHistoryRecordType(typeInfo);
        if (typeInfo2 == null) {
            return null;
        }
        FilePath filePath = new FilePath("^batchJob/logs");
        filePath = filePath.merge(typeInfo2.getModuleName() + "_" + typeInfo2.getTypeName());
        filePath = filePath.merge(TimeFormat.format((BAbsTime)bAbsTime, (Context)TIMESTAMP_FORMAT) + ".bjl");
        return filePath;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

