/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.upgrade;

import com.tridium.driver.upgrade.Upgrade;
import com.tridium.nmilestone.BMilestoneCamera;
import com.tridium.nmilestone.BMilestoneCameraDeviceId;
import com.tridium.nmilestone.BMilestoneDvr;
import com.tridium.nmilestone.BMilestoneNetwork;
import com.tridium.nmilestone.util.BMilestoneImageServerUserNameAndPassword;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.nvideo.upgrade.NVideoUpgrade;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;

public class MilestoneUpgrade
extends Upgrade {
    public String[] upgradableClasses() {
        return new String[]{"milestone:MilestoneCamera", "milestone:MilestoneDeviceExt", "milestone:MilestoneCameraDeviceExt", "milestone:MilestoneCameraDiscoveryLeaf", "milestone:MilestoneCameraDiscoveryPreferences", "milestone:DeviceFolder", "milestone:MilestoneDvr", "milestone:MilestoneNetwork", "milestone:MilestoneVideoSourcePreferences", "milestone:MilestoneStopRecordingModeEnum", "milestone:MilestoneEventCameraExt", "milestone:MilestoneEventDiscoveryLeaf", "milestone:MilestoneEventDiscoveryList", "milestone:MilestoneEventDiscoveryPreferences", "milestone:MilestoneEventFolder", "milestone:MilestoneEventPointId", "milestone:MilestoneEventProxyExt", "milestone:MilestoneEventTypeEnum", "milestone:MilestoneCameraInfoFE", "milestone:MilestoneEventPointIdFE", "milestone:MilestoneImageServerUserNameAndPassword", "milestone:MilestoneVideoCameraInfo"};
    }

    public BValue upgrade(BValue bValue, BValue bValue2) {
        Type type = bValue.getType();
        if (!type.getModule().getModuleName().equals("milestone")) {
            return null;
        }
        if (type.getTypeName().equals("MilestoneNetwork")) {
            return this.upgradeNetwork((BComplex)bValue);
        }
        if (type.getTypeName().equals("MilestoneCamera")) {
            return this.upgradeCamera((BComplex)bValue);
        }
        if (type.getTypeName().equals("MilestoneDvr")) {
            return this.upgradeDvr((BComplex)bValue);
        }
        if (type.getTypeName().equals("MilestoneImageServerUserNameAndPassword")) {
            return this.upgradeCred((BComplex)bValue);
        }
        return MilestoneUpgrade.getInstance((String)"nmilestone", (String)type.getTypeName());
    }

    private BValue upgradeNetwork(BComplex bComplex) {
        BMilestoneNetwork bMilestoneNetwork = new BMilestoneNetwork();
        return bMilestoneNetwork;
    }

    private BValue upgradeCamera(BComplex bComplex) {
        BMilestoneCamera bMilestoneCamera = new BMilestoneCamera();
        String string = MilestoneUpgrade.getString((BComplex)bComplex, (String[])new String[]{"deviceId", "description"});
        bMilestoneCamera.getVideoDeviceId().setDescription(string);
        String string2 = MilestoneUpgrade.getString((BComplex)bComplex, (String[])new String[]{"deviceId", "cameraId"});
        ((BMilestoneCameraDeviceId)bMilestoneCamera.getVideoDeviceId()).setCameraId(string2);
        BValue bValue = MilestoneUpgrade.getValue((BComplex)bComplex, (String[])new String[]{"pingParameters"});
        BVideoCameraInfo bVideoCameraInfo = NVideoUpgrade.upgradeCameraInfo((BComplex)((BComplex)bValue), null);
        bMilestoneCamera.setPtzSupport(bVideoCameraInfo);
        return bMilestoneCamera;
    }

    private BValue upgradeDvr(BComplex bComplex) {
        BMilestoneDvr bMilestoneDvr = new BMilestoneDvr();
        String string = MilestoneUpgrade.getString((BComplex)bComplex, (String[])new String[]{"communicator", "milestoneEngineIpAddress"});
        bMilestoneDvr.setMilestoneEngineIpAddress(string);
        int n = MilestoneUpgrade.getInt((BComplex)bComplex, (String[])new String[]{"communicator", "milestoneImageServerPort"});
        bMilestoneDvr.setMilestoneImageServerPort(n);
        int n2 = MilestoneUpgrade.getInt((BComplex)bComplex, (String[])new String[]{"communicator", "milestoneCentralPort"});
        bMilestoneDvr.setMilestoneImageServerPort(n2);
        int n3 = MilestoneUpgrade.getInt((BComplex)bComplex, (String[])new String[]{"communicator", "uploadEventsPort"});
        bMilestoneDvr.setMilestoneImageServerPort(n3);
        String string2 = MilestoneUpgrade.getString((BComplex)bComplex, (String[])new String[]{"communicator", "httpCommunicator", "credentials", "username"});
        BPassword bPassword = (BPassword)MilestoneUpgrade.getValue((BComplex)bComplex, (String[])new String[]{"communicator", "httpCommunicator", "credentials", "password"});
        BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword();
        bUsernameAndPassword.setUsername(string2);
        bUsernameAndPassword.setPassword(bPassword);
        bMilestoneDvr.setCredentials(bUsernameAndPassword);
        BValue bValue = MilestoneUpgrade.getValue((BComplex)bComplex, (String[])new String[]{"communicator", "tcpCommunicator", "milestoneCentralCredentials"});
        bMilestoneDvr.setMilestoneCentralCredentials((BMilestoneImageServerUserNameAndPassword)this.upgrade(bValue, null));
        return bMilestoneDvr;
    }

    private BValue upgradeCred(BComplex bComplex) {
        BMilestoneImageServerUserNameAndPassword bMilestoneImageServerUserNameAndPassword = new BMilestoneImageServerUserNameAndPassword();
        String string = MilestoneUpgrade.getString((BComplex)bComplex, (String[])new String[]{"username"});
        BPassword bPassword = (BPassword)MilestoneUpgrade.getValue((BComplex)bComplex, (String[])new String[]{"password"});
        bMilestoneImageServerUserNameAndPassword.setUsername(string);
        bMilestoneImageServerUserNameAndPassword.setPassword(bPassword);
        return bMilestoneImageServerUserNameAndPassword;
    }
}

