/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nmilestone.messages;

import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.nmilestone.messages.MilestoneCameraConnectRsp;
import com.tridium.nmilestone.messages.MilestoneEventRefreshAroundRsp;
import com.tridium.nmilestone.messages.MilestoneTcpLinkMessage;
import com.tridium.nmilestone.messages.MilestoneUnsolicitedMessage;
import com.tridium.nmilestone.util.MilestoneReqUtil;
import java.io.InputStream;
import javax.baja.xml.XElem;

public class MilestoneMessageFactory
implements IMessageFactory {
    public Object syncObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NMessage makeMessage(LinkMessage linkMessage) throws Exception {
        Object object = this.syncObj;
        synchronized (object) {
            MilestoneTcpLinkMessage milestoneTcpLinkMessage = (MilestoneTcpLinkMessage)linkMessage;
            if (this.isCameraConnectRsp(milestoneTcpLinkMessage.getInputStream())) {
                milestoneTcpLinkMessage.getInputStream().reset();
                MilestoneCameraConnectRsp milestoneCameraConnectRsp = new MilestoneCameraConnectRsp(milestoneTcpLinkMessage.getInputStream());
                milestoneCameraConnectRsp.setAddress((BAddress)milestoneTcpLinkMessage.address);
                return milestoneCameraConnectRsp;
            }
            milestoneTcpLinkMessage.getInputStream().reset();
            if (this.isEventRefreshAroundResp(milestoneTcpLinkMessage.getInputStream())) {
                MilestoneEventRefreshAroundRsp milestoneEventRefreshAroundRsp = new MilestoneEventRefreshAroundRsp(milestoneTcpLinkMessage.getInputStream());
                milestoneEventRefreshAroundRsp.setAddress((BAddress)milestoneTcpLinkMessage.address);
                return milestoneEventRefreshAroundRsp;
            }
            milestoneTcpLinkMessage.getInputStream().reset();
            MilestoneUnsolicitedMessage milestoneUnsolicitedMessage = new MilestoneUnsolicitedMessage(milestoneTcpLinkMessage.getInputStream());
            milestoneUnsolicitedMessage.setAddress((BAddress)milestoneTcpLinkMessage.address);
            return milestoneUnsolicitedMessage;
        }
    }

    boolean isCameraConnectRsp(InputStream inputStream) {
        try {
            XElem xElem = MilestoneReqUtil.getElem(inputStream, "methodresponse");
            String string = MilestoneReqUtil.getText(xElem, "methodname");
            return string.equalsIgnoreCase("connect");
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isEventRefreshAroundResp(InputStream inputStream) {
        try {
            XElem xElem = MilestoneReqUtil.getMilestoneMethodResponseElem(inputStream);
            String string = MilestoneReqUtil.getText(xElem, "methodname");
            return "alarms".equals(string);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

