/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.SearchResult;
import com.tridium.help.Searcher;
import com.tridium.help.ui.SearchNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.baja.file.types.text.BHtmlFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;

public class SearchTreeModel
extends TreeModel {
    private SearchNode[] roots = new SearchNode[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String string) {
        this.getTree().enterBusy();
        try {
            SearchResult[] searchResultArray = Searcher.getInstance().search(string);
            if (searchResultArray.length == 0) {
                this.roots = new SearchNode[1];
                this.roots[0] = new SearchNode(this, BOrd.NULL, "(none found)", SearchNode.NONE);
            } else {
                this.roots = new SearchNode[searchResultArray.length];
                for (int i = 0; i < searchResultArray.length; ++i) {
                    BOrd bOrd = searchResultArray[i].ord();
                    String string2 = bOrd.toString();
                    BImage bImage = SearchNode.NONE;
                    if (string2.endsWith("package-index.bajadoc")) {
                        bImage = SearchNode.BAJADOC;
                        int n = (string2 = string2.substring("module://".length())).indexOf("/doc/");
                        if (n != -1) {
                            string2 = string2.substring(n + "/doc/".length());
                        }
                        if ((n = string2.lastIndexOf(47)) != -1) {
                            string2 = string2.substring(0, n);
                        }
                        string2 = string2.replace('/', '.') + " Package";
                    } else if (string2.endsWith("module-index.bajadoc")) {
                        bImage = SearchNode.BAJADOC;
                        int n = (string2 = string2.substring("module://".length())).indexOf(47);
                        if (n != -1) {
                            string2 = string2.substring(0, n);
                        }
                        string2 = TextUtil.capitalize((String)string2) + " Module";
                    } else if (string2.endsWith(".bajadoc")) {
                        bImage = SearchNode.BAJADOC;
                        int n = (string2 = string2.substring(0, string2.length() - ".bajadoc".length())).lastIndexOf(47);
                        if (n != -1) {
                            string2 = string2.substring(n + 1);
                        }
                    } else {
                        String string3 = null;
                        if (string2.endsWith(".html")) {
                            bImage = SearchNode.HTML;
                            string3 = SearchTreeModel.htmlTitle(bOrd);
                        } else if (string2.endsWith(".java")) {
                            bImage = SearchNode.JAVA;
                        }
                        if (string3 == null) {
                            int n = string2.lastIndexOf(47);
                            if (n != -1) {
                                string2 = string2.substring(n + 1);
                            }
                        } else {
                            string2 = string3;
                        }
                    }
                    this.roots[i] = new SearchNode(this, bOrd, string2, bImage);
                }
            }
            this.getTree().relayout();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.getTree().exitBusy();
        }
    }

    private static String htmlTitle(BOrd bOrd) {
        BObject bObject = bOrd.get();
        if (!(bObject instanceof BHtmlFile)) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((BHtmlFile)bObject).getInputStream()));
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2 = TextUtil.toLowerCase((String)string);
                int n = string2.indexOf("<title>");
                if (n != -1) {
                    int n2 = string2.indexOf("</title>");
                    if (n2 != -1 && n < n2) {
                        return string.substring(n + "<title>".length(), n2).trim();
                    }
                    return null;
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public int getRootCount() {
        return this.roots.length;
    }

    public TreeNode getRoot(int n) {
        return this.roots[n];
    }
}

