/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.Parameter;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.ui.DocClassMemberNode;
import com.tridium.help.ui.HelpTreeNode;
import java.util.ArrayList;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;

public class DocClassNode
extends HelpTreeNode {
    private BImage icon;
    private String name;

    public DocClassNode(HelpTreeNode helpTreeNode, BOrd bOrd, String string, BImage bImage) {
        super(helpTreeNode, bOrd);
        this.name = string;
        this.icon = bImage;
    }

    public String getText() {
        return this.name;
    }

    public BImage getIcon() {
        return this.icon;
    }

    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    private void populate() {
        this.kids = new HelpTreeNode[0];
        try {
            ArrayList arrayList = new ArrayList();
            BIFile bIFile = (BIFile)this.getContentOrd().resolve().get();
            BajadocParser bajadocParser = new BajadocParser();
            ClassDoc classDoc = (ClassDoc)bajadocParser.parse(bIFile.getInputStream());
            this.loadProperties(classDoc, arrayList);
            this.loadActions(classDoc, arrayList);
            this.loadTopics(classDoc, arrayList);
            this.loadConstructors(classDoc, arrayList);
            this.loadMethods(classDoc, arrayList);
            this.loadFields(classDoc, arrayList);
            this.kids = new HelpTreeNode[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.kids[i] = (HelpTreeNode)((Object)arrayList.get(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadProperties(ClassDoc classDoc, ArrayList arrayList) {
        PropertyDoc[] propertyDocArray = classDoc.propertiesSorted();
        if (propertyDocArray.length > 0) {
            BImage bImage = BImage.make((BIcon)propertyDocArray[0].icon());
            for (int i = 0; i < propertyDocArray.length; ++i) {
                PropertyDoc propertyDoc = propertyDocArray[i];
                arrayList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + propertyDoc.anchor())), propertyDoc.name(), bImage));
            }
        }
    }

    private void loadActions(ClassDoc classDoc, ArrayList arrayList) {
        ActionDoc[] actionDocArray = classDoc.actionsSorted();
        if (actionDocArray.length > 0) {
            BImage bImage = BImage.make((BIcon)actionDocArray[0].icon());
            for (int i = 0; i < actionDocArray.length; ++i) {
                ActionDoc actionDoc = actionDocArray[i];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(actionDoc.name());
                stringBuffer.append(this.resolveParameter(actionDoc.parameter()));
                arrayList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + actionDoc.anchor())), stringBuffer.toString(), bImage));
            }
        }
    }

    private void loadTopics(ClassDoc classDoc, ArrayList arrayList) {
        TopicDoc[] topicDocArray = classDoc.topicsSorted();
        if (topicDocArray.length > 0) {
            BImage bImage = BImage.make((BIcon)topicDocArray[0].icon());
            for (int i = 0; i < topicDocArray.length; ++i) {
                TopicDoc topicDoc = topicDocArray[i];
                arrayList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + topicDoc.name())), topicDoc.name(), bImage));
            }
        }
    }

    private void loadConstructors(ClassDoc classDoc, ArrayList arrayList) {
        ConstructorDoc[] constructorDocArray = classDoc.constructors();
        if (constructorDocArray.length > 0) {
            BImage bImage = BImage.make((BIcon)constructorDocArray[0].icon());
            for (int i = 0; i < constructorDocArray.length; ++i) {
                ConstructorDoc constructorDoc = constructorDocArray[i];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(constructorDoc.name());
                stringBuffer.append(DocClassNode.resolveParameters(constructorDoc.parameters()));
                arrayList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + constructorDoc.anchor())), stringBuffer.toString(), bImage));
            }
        }
    }

    private void loadMethods(ClassDoc classDoc, ArrayList arrayList) {
        MethodDoc[] methodDocArray = classDoc.methodsSorted();
        if (methodDocArray.length > 0) {
            BImage bImage = BImage.make((BIcon)methodDocArray[0].icon());
            for (int i = 0; i < methodDocArray.length; ++i) {
                MethodDoc methodDoc = methodDocArray[i];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(methodDoc.name());
                stringBuffer.append(DocClassNode.resolveParameters(methodDoc.parameters()));
                arrayList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + methodDoc.anchor())), stringBuffer.toString(), bImage));
            }
        }
    }

    private void loadFields(ClassDoc classDoc, ArrayList arrayList) {
        FieldDoc[] fieldDocArray = classDoc.fieldsSorted();
        if (fieldDocArray.length > 0) {
            BImage bImage = BImage.make((BIcon)fieldDocArray[0].icon());
            for (int i = 0; i < fieldDocArray.length; ++i) {
                FieldDoc fieldDoc = fieldDocArray[i];
                arrayList.add(new DocClassMemberNode(this, BOrd.make((String)(this.getContentOrd().toString() + "#" + fieldDoc.anchor())), fieldDoc.name(), bImage));
            }
        }
    }

    private String resolveParameter(Parameter parameter) {
        if (parameter == null) {
            return DocClassNode.resolveParameters(new Parameter[0]);
        }
        return DocClassNode.resolveParameters(new Parameter[]{parameter});
    }

    public static String resolveParameters(Parameter[] parameterArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (parameterArray != null && parameterArray.length > 0) {
            stringBuffer.append(parameterArray[0].type().displayName());
            stringBuffer.append(" ");
            stringBuffer.append(parameterArray[0].name());
            for (int i = 1; i < parameterArray.length; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(parameterArray[i].type().displayName());
                stringBuffer.append(" ");
                stringBuffer.append(parameterArray[i].name());
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String makeFragment(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c != '(' && c != ')' && c != '[' && c != ']' && c != ',' && c != ' ') continue;
            stringBuffer.setCharAt(i, '_');
        }
        return stringBuffer.toString();
    }
}

