/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.HelpSystem;
import com.tridium.help.ui.DocTreeModel;
import com.tridium.help.ui.HelpTreeController;
import com.tridium.help.ui.SearchTreeModel;
import com.tridium.help.ui.TocTreeModel;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.BMiniTabbedPane;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BHelpSideBar
extends BWbSideBar {
    public static final Action loadHelp = BHelpSideBar.newAction((int)0, null);
    public static final Action search = BHelpSideBar.newAction((int)0, null);
    public static final Action tabChanged = BHelpSideBar.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$help$ui$BHelpSideBar == null ? (class$com$tridium$help$ui$BHelpSideBar = BHelpSideBar.class$("com.tridium.help.ui.BHelpSideBar")) : class$com$tridium$help$ui$BHelpSideBar));
    private BEdgePane edge;
    private BMiniTabbedPane tabs = new BMiniTabbedPane(BValign.top);
    private BTextField searchText;
    private SearchTreeModel searchModel;
    static /* synthetic */ Class class$com$tridium$help$ui$BHelpSideBar;

    public void loadHelp() {
        this.invoke(loadHelp, null, null);
    }

    public void search() {
        this.invoke(search, null, null);
    }

    public void tabChanged() {
        this.invoke(tabChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BHelpSideBar() {
        this.edge = new BEdgePane();
        this.setContent((BWidget)this.edge);
        this.buildUI();
    }

    public static void loadHelp(BWidget bWidget) {
        HelpSystem.load(bWidget);
        if (HelpSystem.exists()) {
            BHelpSideBar.reloadSideBars();
        }
    }

    private static void reloadSideBars() {
        BWidgetShell[] bWidgetShellArray = BHelpSideBar.getApplication().getShells();
        for (int i = 0; i < bWidgetShellArray.length; ++i) {
            if (!(bWidgetShellArray[i] instanceof BNiagaraWbShell)) continue;
            BWbSideBar[] bWbSideBarArray = ((BNiagaraWbShell)bWidgetShellArray[i]).pane.getSideBar().list();
            for (int j = 0; j < bWbSideBarArray.length; ++j) {
                if (!(bWbSideBarArray[j] instanceof BHelpSideBar)) continue;
                ((BHelpSideBar)bWbSideBarArray[j]).reinit();
            }
        }
    }

    protected final void reinit() {
        this.buildUI();
        this.relayoutSync();
        this.repaint();
    }

    public void doLoadHelp() {
        BHelpSideBar.loadHelp((BWidget)this);
    }

    public void doSearch() {
        this.searchModel.search(this.searchText.getText());
    }

    public void doTabChanged() {
        String string;
        BLabelPane bLabelPane = this.tabs.getSelectedLabelPane();
        if (bLabelPane != null && (string = bLabelPane.getLabel().getText()).equals(BHelpSideBar.text("help.search"))) {
            this.searchText.requestFocus();
        }
    }

    private void buildUI() {
        this.edge.setBottom((BWidget)new BNullWidget());
        this.edge.setCenter((BWidget)new BNullWidget());
        if (this.get("lnkTabs") != null) {
            this.remove("lnkTabs");
        }
        if (this.get("lnkLoadHelp") != null) {
            this.remove("lnkLoadHelp");
        }
        if (HelpSystem.exists()) {
            this.tabs.removeAll();
            this.tabs.addPane(BHelpSideBar.text("help.toc"), this.buildToc());
            this.tabs.addPane(BHelpSideBar.text("help.api"), this.buildApi());
            this.tabs.addPane(BHelpSideBar.text("help.search"), this.buildSearch());
            this.edge.setCenter((BWidget)this.tabs);
            this.linkTo("lnkTabs", (BComponent)this.tabs, (Slot)BMiniTabbedPane.selectionModified, (Slot)tabChanged);
            if (!HelpSystem.upToDate()) {
                BButton bButton = new BButton(BHelpSideBar.text("help.load"));
                this.linkTo("lnkLoadHelp", (BComponent)bButton, (Slot)BButton.actionPerformed, (Slot)loadHelp);
                BLabel bLabel = new BLabel(BHelpSideBar.text("help.load.outOfDate"), BHalign.left);
                BEdgePane bEdgePane = new BEdgePane();
                bEdgePane.setLeft((BWidget)new BBorderPane((BWidget)bButton, 3.0, 6.0, 3.0, 3.0));
                bEdgePane.setCenter((BWidget)bLabel);
                this.edge.setBottom((BWidget)bEdgePane);
            }
        } else {
            BButton bButton = new BButton(BHelpSideBar.text("help.load"));
            this.linkTo("lnkLoadHelp", (BComponent)bButton, (Slot)BButton.actionPerformed, (Slot)loadHelp);
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setColumnAlign(BHalign.center);
            bGridPane.add(null, (BValue)new BLabel(BImage.make((String)"module://icons/x32/question.png")));
            bGridPane.add(null, (BValue)bButton);
            this.edge.setCenter((BWidget)bGridPane);
        }
    }

    private BWidget buildSearch() {
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BLabel(BHelpSideBar.text("help.find")));
        this.searchText = new BTextField("", 20, true);
        bEdgePane.setCenter((BWidget)this.searchText);
        BButton bButton = new BButton(BHelpSideBar.text("help.search"));
        bEdgePane.setRight((BWidget)bButton);
        this.searchModel = new SearchTreeModel();
        BTree bTree = new BTree((TreeModel)this.searchModel, (TreeController)new HelpTreeController());
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)new BBorderPane((BWidget)bEdgePane, 2.0, 1.0, 1.0, 2.0));
        bEdgePane2.setCenter((BWidget)new BTreePane(bTree));
        if (this.get("lnkSearch") != null) {
            this.remove("lnkSearch");
        }
        this.linkTo("lnkSearch", (BComponent)this.searchText, (Slot)BTextField.actionPerformed, (Slot)search);
        bButton.setCommand(new Command((BWidget)this, BHelpSideBar.text("help.search")){

            public CommandArtifact doInvoke() {
                ((BHelpSideBar)this.getOwner()).doSearch();
                return null;
            }
        }, false, false);
        BImage bImage = BImage.make((String)"module://icons/x16/magnifyingGlass.png");
        return bEdgePane2;
    }

    private BWidget buildToc() {
        String[] stringArray = HelpSystem.getModulesHavingFile("doc/toc.xml");
        TocTreeModel tocTreeModel = new TocTreeModel(stringArray);
        HelpTreeController helpTreeController = new HelpTreeController();
        BTree bTree = new BTree((TreeModel)tocTreeModel, (TreeController)helpTreeController);
        BImage bImage = BImage.make((String)"module://icons/x16/book.png");
        return new BTreePane(bTree);
    }

    private BWidget buildApi() {
        String[] stringArray = HelpSystem.getModulesHavingFile("doc/module-index.bajadoc");
        DocTreeModel docTreeModel = new DocTreeModel(stringArray);
        HelpTreeController helpTreeController = new HelpTreeController();
        BTree bTree = new BTree((TreeModel)docTreeModel, (TreeController)helpTreeController);
        BImage bImage = BImage.make((String)"module://icons/x16/files/bajadoc.png");
        return new BTreePane(bTree);
    }

    private static String text(String string) {
        return UiLexicon.bajaui.getText(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

