/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.html.canvas.BHtmlCanvas;
import com.tridium.html.canvas.HtmlController;
import java.util.ArrayList;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

class Segment {
    private static Lexicon lex = Lexicon.make((String)"help");
    private static BFont font = BFont.make((String)lex.getText("bajadoc.font"));
    static final int BOLD = 1;
    static final int LARGE = 2;
    private final String text;
    private final int mask;
    private final BOrd ord;

    Segment(String string, int n, BOrd bOrd) {
        this.text = string;
        this.mask = n;
        this.ord = bOrd;
    }

    Segment(String string, int n) {
        this(string, n, null);
    }

    static BHtmlCanvas makeCanvas(ArrayList arrayList, BWbShell bWbShell, BOrd bOrd) {
        return Segment.makeCanvas(arrayList.toArray(new Segment[arrayList.size()]), bWbShell, bOrd);
    }

    static BHtmlCanvas makeCanvas(Segment[] segmentArray, BWbShell bWbShell, BOrd bOrd) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PRE>");
        stringBuffer.append("<FONT NAME=\"" + font.getName() + "\">");
        for (int i = 0; i < segmentArray.length; ++i) {
            Segment segment = segmentArray[i];
            if (segment.ord != null) {
                stringBuffer.append("<A HREF=\"" + segment.ord + "\">");
            }
            if (segment.isLarge()) {
                stringBuffer.append("<FONT SIZE=5>");
            }
            if (segment.isBold()) {
                stringBuffer.append("<B>");
            }
            stringBuffer.append(segment.text);
            if (segment.isBold()) {
                stringBuffer.append("</B>");
            }
            if (segment.isLarge()) {
                stringBuffer.append("</FONT>");
            }
            if (segment.ord == null) continue;
            stringBuffer.append("</A>");
        }
        stringBuffer.append("</FONT>");
        stringBuffer.append("</PRE>");
        BHtmlCanvas bHtmlCanvas = new BHtmlCanvas(stringBuffer.toString(), new HtmlController(bWbShell, bOrd));
        bHtmlCanvas.useInsets(false);
        return bHtmlCanvas;
    }

    private boolean isBold() {
        return (this.mask & 1) != 0;
    }

    private boolean isLarge() {
        return (this.mask & 2) != 0;
    }
}

