/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.Hierarchy;
import com.tridium.help.ui.HelpTreeNode;
import java.util.Arrays;
import javax.baja.gx.BImage;
import javax.baja.ui.tree.TreeModel;

public class HierarchyNode
extends HelpTreeNode
implements Comparable {
    private static BImage icon = BImage.make((String)"module://icons/x16/object.png");
    private static Hierarchy hierarchy = Hierarchy.instance();
    private Hierarchy.Entry entry;
    private boolean hasChildren;

    public HierarchyNode(TreeModel treeModel, Hierarchy.Entry entry) {
        super(treeModel, entry.bajadocOrd());
        this.entry = entry;
        this.hasChildren = hierarchy.hasSubEntries(entry);
    }

    private HierarchyNode(HierarchyNode hierarchyNode, Hierarchy.Entry entry) {
        super(hierarchyNode, entry.bajadocOrd());
        this.entry = entry;
        this.hasChildren = hierarchy.hasSubEntries(entry);
    }

    public String getText() {
        return this.entry.name();
    }

    public BImage getIcon() {
        return icon;
    }

    protected HelpTreeNode[] buildChildNodes() {
        if (this.kids == null) {
            this.populate();
        }
        return this.kids;
    }

    public boolean hasChildren() {
        if (this.kids == null) {
            return this.hasChildren;
        }
        return this.kids.length > 0;
    }

    public int compareTo(Object object) {
        return this.getText().compareTo(((HierarchyNode)object).getText());
    }

    private void populate() {
        Hierarchy.Entry[] entryArray = hierarchy.getSubEntries(this.entry);
        if (entryArray == null) {
            this.kids = new HierarchyNode[0];
        } else {
            this.kids = new HierarchyNode[entryArray.length];
            for (int i = 0; i < entryArray.length; ++i) {
                this.kids[i] = new HierarchyNode(this, entryArray[i]);
            }
            Arrays.sort((Object[])this.kids);
        }
    }
}

