/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;

public class Flattener {
    ClassDoc target;
    HashMap types = new HashMap();
    HashMap properties = new HashMap();
    HashMap actions = new HashMap();
    HashMap topics = new HashMap();
    HashMap fields = new HashMap();
    HashMap methods = new HashMap();

    public ClassDoc flatten(ClassDoc classDoc) throws Exception {
        this.target = classDoc;
        this.register(classDoc);
        this.register(classDoc.superClass());
        JavaType[] javaTypeArray = classDoc.interfaces();
        for (int i = 0; i < javaTypeArray.length; ++i) {
            this.register(javaTypeArray[i]);
        }
        return new ClassDoc(classDoc.module(), classDoc.qualifiedName(), classDoc.modifiers(), classDoc.superClass(), classDoc.interfaces(), classDoc.ancestors(), classDoc.extenders(), classDoc.implementors(), this.properties.values().toArray(new PropertyDoc[this.properties.size()]), this.actions.values().toArray(new ActionDoc[this.actions.size()]), this.topics.values().toArray(new TopicDoc[this.topics.size()]), this.fields.values().toArray(new FieldDoc[this.fields.size()]), classDoc.constructors(), this.methods.values().toArray(new MethodDoc[this.methods.size()]), new ClassDoc[0], classDoc.classCategory(), classDoc.isInnerClass(), classDoc.description(), classDoc.tags());
    }

    private boolean register(JavaType javaType) throws Exception {
        if (javaType == null) {
            return false;
        }
        String string = javaType.qualifiedName();
        if (this.types.get(string) != null) {
            return false;
        }
        this.types.put(string, "marker");
        BOrd bOrd = BOrd.make((String)javaType.ord("bajadoc"));
        BIFile bIFile = null;
        try {
            bIFile = (BIFile)bOrd.resolve().get();
        }
        catch (Exception exception) {
            System.out.println("WARNING: Cannot resolve: " + bOrd);
            return false;
        }
        ClassDoc classDoc = (ClassDoc)new BajadocParser().parse(bIFile.getInputStream());
        this.register(classDoc);
        this.register(classDoc.superClass());
        JavaType[] javaTypeArray = classDoc.interfaces();
        for (int i = 0; i < javaTypeArray.length; ++i) {
            this.register(javaTypeArray[i]);
        }
        return true;
    }

    private void register(ClassDoc classDoc) {
        PropertyDoc[] propertyDocArray = classDoc.properties();
        for (int i = 0; i < propertyDocArray.length; ++i) {
            this.register(propertyDocArray[i], this.properties);
        }
        ActionDoc[] actionDocArray = classDoc.actions();
        for (int i = 0; i < actionDocArray.length; ++i) {
            this.register(actionDocArray[i], this.actions);
        }
        TopicDoc[] topicDocArray = classDoc.topics();
        for (int i = 0; i < topicDocArray.length; ++i) {
            this.register(topicDocArray[i], this.topics);
        }
        MethodDoc[] methodDocArray = classDoc.methods();
        for (int i = 0; i < methodDocArray.length; ++i) {
            this.register(methodDocArray[i], this.methods);
        }
        FieldDoc[] fieldDocArray = classDoc.fields();
        for (int i = 0; i < fieldDocArray.length; ++i) {
            this.register(fieldDocArray[i], this.fields);
        }
    }

    private void register(MemberDoc memberDoc, HashMap hashMap) {
        String string = memberDoc.anchor();
        MemberDoc memberDoc2 = (MemberDoc)hashMap.get(string);
        if (memberDoc2 != null) {
            if (memberDoc2.description() == null || memberDoc2.description().length() == 1) {
                memberDoc2.setDescription(memberDoc.description());
            }
        } else {
            hashMap.put(string, memberDoc);
        }
    }
}

