/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ui.BBajadocOptions;
import com.tridium.help.bajadoc.ui.BBajadocViewer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;

public class BajadocCommands {
    static final BImage classIcon = BImage.make((String)"module://icons/x16/file.png");
    static final BImage moduleIcon = BImage.make((String)"module://icons/x16/module.png");
    public final BBajadocViewer viewer;
    public BajaOnlyToggle bajaOnly;
    public FlattenToggle flatten;
    public ExpandAll expandAll;
    public ExpandAll collapseAll;
    public Depends depends;

    public BajadocCommands(BBajadocViewer bBajadocViewer) {
        this.viewer = bBajadocViewer;
    }

    public void init() {
        this.bajaOnly = new BajaOnlyToggle();
        this.flatten = new FlattenToggle();
        this.expandAll = new ExpandAll(true);
        this.collapseAll = new ExpandAll(false);
        this.depends = new Depends();
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui.buildMenu("menu.bajadoc.label");
        bMenu.add("bajaOnly", (Command)this.bajaOnly);
        bMenu.add("flatten", (Command)this.flatten);
        bMenu.add("expandAll", (Command)this.expandAll);
        bMenu.add("collapseAll", (Command)this.collapseAll);
        bMenu.add("sep0", (BValue)new BSeparator());
        bMenu.add("depends", (Command)this.depends);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("bajaOnly", (Command)this.bajaOnly);
        bToolBar.add("flatten", (Command)this.flatten);
        bToolBar.add("depends", (Command)this.depends);
        return bToolBar;
    }

    void reflect(HashMap hashMap, Class clazz, boolean bl) {
        if (clazz == null) {
            return;
        }
        if (clazz == Void.TYPE) {
            return;
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return;
        }
        if (hashMap.get(clazz) != null) {
            return;
        }
        hashMap.put(clazz, clazz);
        this.reflect(hashMap, clazz.getSuperclass(), true);
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            this.reflect(hashMap, classArray[i], true);
        }
        if (!bl) {
            return;
        }
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            int n = constructor.getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            Class<?>[] classArray2 = constructor.getParameterTypes();
            for (int j = 0; j < classArray2.length; ++j) {
                this.reflect(hashMap, classArray2[j], false);
            }
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            this.reflect(hashMap, method.getReturnType(), false);
            Class<?>[] classArray3 = method.getParameterTypes();
            for (int j = 0; j < classArray3.length; ++j) {
                this.reflect(hashMap, classArray3[j], false);
            }
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
            this.reflect(hashMap, field.getType(), false);
        }
    }

    static class NoSelectionRenderer
    extends TableCellRenderer {
        NoSelectionRenderer() {
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }
    }

    static class ModuleModel
    extends TableModel {
        BModule[] modules;

        ModuleModel(BModule[] bModuleArray) {
            this.modules = bModuleArray;
        }

        public int getRowCount() {
            return this.modules.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Description";
                }
            }
            return "?";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.modules[n].getModuleName();
                }
                case 1: {
                    return this.modules[n].getDescription();
                }
            }
            return "?";
        }

        public BImage getRowIcon(int n) {
            return moduleIcon;
        }
    }

    static class ClassModel
    extends TableModel {
        Class[] classes;

        ClassModel(Class[] classArray) {
            this.classes = classArray;
        }

        public int getRowCount() {
            return this.classes.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
            }
            return "?";
        }

        public Object getValueAt(int n, int n2) {
            return this.classes[n].getName();
        }

        public BImage getRowIcon(int n) {
            return classIcon;
        }
    }

    public class Depends
    extends BajadocCommand {
        private boolean expand;

        public Depends() {
            super("commands.bajadoc.depends");
        }

        public CommandArtifact doInvoke() throws Exception {
            BModule bModule;
            ClassDoc classDoc = (ClassDoc)BajadocCommands.this.viewer.doc;
            String string = classDoc.module();
            String string2 = classDoc.qualifiedName();
            Class clazz = string == null ? Class.forName(string2) : Sys.loadClass((String)string, (String)string2);
            HashMap hashMap = new HashMap();
            BajadocCommands.this.reflect(hashMap, clazz, true);
            Object[] objectArray = hashMap.values().toArray(new Class[hashMap.size()]);
            SortUtil.sort((Object[])objectArray);
            HashMap<String, BModule> hashMap2 = new HashMap<String, BModule>();
            for (int i = 0; i < objectArray.length; ++i) {
                bModule = Sys.getModuleForClass((Class)objectArray[i]);
                if (bModule == null) continue;
                hashMap2.put(bModule.getModuleName(), bModule);
            }
            Object[] objectArray2 = hashMap2.values().toArray(new BModule[hashMap2.size()]);
            SortUtil.sort((Object[])objectArray2);
            bModule = new BTable((TableModel)new ModuleModel((BModule[])objectArray2));
            bModule.setCellRenderer((TableCellRenderer)new NoSelectionRenderer());
            BTable bTable = new BTable((TableModel)new ClassModel((Class[])objectArray));
            bTable.setCellRenderer((TableCellRenderer)new NoSelectionRenderer());
            BSplitPane bSplitPane = new BSplitPane(BOrientation.vertical, 30.0);
            bSplitPane.setWidget1((BWidget)BTitlePane.makePane((String)"Dependent Modules", (BTable)bModule));
            bSplitPane.setWidget2((BWidget)BTitlePane.makePane((String)"Dependent Classes", (BTable)bTable));
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bSplitPane);
            bConstrainedPane.setFixedSize(500.0, 500.0);
            BDialog.open((BWidget)this.getOwner(), (String)("Dependencies for " + string + ":" + string2), (Object)bConstrainedPane, (int)1);
            return null;
        }
    }

    public class ExpandAll
    extends BajadocCommand {
        private boolean expand;

        public ExpandAll(boolean bl) {
            super(bl ? "commands.bajadoc.expandAll" : "commands.bajadoc.collapseAll");
            this.expand = bl;
        }

        public CommandArtifact doInvoke() throws Exception {
            super.doInvoke();
            BajadocCommands.this.viewer.expandAll(this.expand);
            return null;
        }
    }

    public class FlattenToggle
    extends BajadocToggle {
        public FlattenToggle() {
            super("commands.bajadoc.flatten");
            this.setSelected(BBajadocOptions.make().getFlattenInheritance());
        }

        public CommandArtifact doInvoke() throws Exception {
            super.doInvoke();
            BBajadocOptions.make().setFlattenInheritance(this.isSelected());
            BajadocCommands.this.viewer.reloadViewer();
            return null;
        }
    }

    public class BajaOnlyToggle
    extends BajadocToggle {
        public BajaOnlyToggle() {
            super("commands.bajadoc.bajaOnly");
            this.setSelected(BBajadocOptions.make().getShowBajaOnly());
        }

        public CommandArtifact doInvoke() throws Exception {
            super.doInvoke();
            BBajadocOptions.make().setShowBajaOnly(this.isSelected());
            BajadocCommands.this.viewer.reloadViewer();
            return null;
        }
    }

    public class BajadocCommand
    extends Command {
        public BajadocCommand(String string) {
            super((BWidget)BajadocCommands.this.viewer.getShell(), UiLexicon.bajaui.module, string);
        }
    }

    public class BajadocToggle
    extends ToggleCommand {
        public BajadocToggle(String string) {
            super((BWidget)BajadocCommands.this.viewer.getShell(), UiLexicon.bajaui.module, string);
        }
    }
}

