/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.ui.BBajadocViewer;
import com.tridium.help.bajadoc.ui.BDocPane;
import com.tridium.help.bajadoc.ui.Segment;
import com.tridium.html.canvas.BHtmlCanvas;
import java.util.ArrayList;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BTitlePane
extends BDocPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$help$bajadoc$ui$BTitlePane == null ? (class$com$tridium$help$bajadoc$ui$BTitlePane = BTitlePane.class$("com.tridium.help.bajadoc.ui.BTitlePane")) : class$com$tridium$help$bajadoc$ui$BTitlePane));
    static /* synthetic */ Class class$com$tridium$help$bajadoc$ui$BTitlePane;

    public Type getType() {
        return TYPE;
    }

    public BTitlePane(BBajadocViewer bBajadocViewer, ModuleDoc moduleDoc) {
        super(bBajadocViewer, null, moduleDoc);
        ArrayList<BHtmlCanvas> arrayList = new ArrayList<BHtmlCanvas>();
        arrayList.add(this.buildModuleTitleLabel(moduleDoc));
        arrayList.add(this.buildGenericLabel("bajaVersion", moduleDoc.bajaVersion()));
        arrayList.add(this.buildGenericLabel("vendor", moduleDoc.vendor()));
        arrayList.add(this.buildGenericLabel("vendorVersion", moduleDoc.vendorVersion()));
        this.initLabels(arrayList);
    }

    public BTitlePane(BBajadocViewer bBajadocViewer, PackageDoc packageDoc) {
        super(bBajadocViewer, packageDoc.name(), packageDoc);
        ArrayList<BHtmlCanvas> arrayList = new ArrayList<BHtmlCanvas>();
        arrayList.add(this.buildPackageTitleLabel(packageDoc));
        arrayList.add(this.buildModuleLabel(packageDoc.module()));
        this.initLabels(arrayList);
    }

    public BTitlePane(BBajadocViewer bBajadocViewer, ClassDoc classDoc) {
        super(bBajadocViewer, classDoc.packageName(), classDoc);
        BHtmlCanvas bHtmlCanvas;
        ArrayList<BHtmlCanvas> arrayList = new ArrayList<BHtmlCanvas>();
        arrayList.add(this.buildClassTitleLabel(classDoc));
        arrayList.add(this.buildModuleLabel(classDoc.module()));
        arrayList.add(this.buildPackageLabel(classDoc.packageName()));
        BHtmlCanvas bHtmlCanvas2 = this.buildExtendsLabel(classDoc);
        if (bHtmlCanvas2 != null) {
            arrayList.add(bHtmlCanvas2);
        }
        if ((bHtmlCanvas = this.buildImplementsLabel(classDoc)) != null) {
            arrayList.add(bHtmlCanvas);
        }
        this.initLabels(arrayList);
    }

    public BHtmlCanvas buildModuleLabel(String string) {
        BOrd bOrd;
        if (string == null) {
            string = "JDK";
            bOrd = BOrd.make((String)"local:|module://docJdk/doc/module-index.bajadoc");
        } else {
            bOrd = BOrd.make((String)("local:|module://" + string + "/doc/module-index.bajadoc"));
        }
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        arrayList.add(new Segment("module  ", 1));
        arrayList.add(new Segment(string, 0, bOrd));
        return Segment.makeCanvas(arrayList, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    public BHtmlCanvas buildPackageLabel(String string) {
        BOrd bOrd = BOrd.make((String)"module:package-index.bajadoc");
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        arrayList.add(new Segment("package  ", 1));
        arrayList.add(new Segment(string, 0, bOrd));
        return Segment.makeCanvas(arrayList, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    public BHtmlCanvas buildModuleTitleLabel(ModuleDoc moduleDoc) {
        Segment[] segmentArray = new Segment[]{new Segment("module ", 3), new Segment(moduleDoc.name(), 3)};
        return Segment.makeCanvas(segmentArray, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    public BHtmlCanvas buildPackageTitleLabel(PackageDoc packageDoc) {
        Segment[] segmentArray = new Segment[]{new Segment("package ", 3), new Segment(packageDoc.name(), 3)};
        return Segment.makeCanvas(segmentArray, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    public BHtmlCanvas buildClassTitleLabel(ClassDoc classDoc) {
        String string = classDoc.modifiersToString();
        string = string + (classDoc.isInterface() ? "interface " : "class ");
        Segment[] segmentArray = new Segment[]{new Segment(string, 3), new Segment(classDoc.name(), 3)};
        return Segment.makeCanvas(segmentArray, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    public BHtmlCanvas buildExtendsLabel(ClassDoc classDoc) {
        if (classDoc.superClass() == null) {
            return null;
        }
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        arrayList.add(new Segment("extends ", 1));
        this.typeSegments(arrayList, classDoc.superClass());
        return Segment.makeCanvas(arrayList, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    public BHtmlCanvas buildImplementsLabel(ClassDoc classDoc) {
        JavaType[] javaTypeArray = classDoc.interfaces();
        if (javaTypeArray.length == 0) {
            return null;
        }
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        arrayList.add(new Segment("implements ", 1));
        for (int i = 0; i < javaTypeArray.length; ++i) {
            if (i > 0) {
                arrayList.add(new Segment(", ", 0));
            }
            this.typeSegments(arrayList, javaTypeArray[i]);
        }
        return Segment.makeCanvas(arrayList, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    public BHtmlCanvas buildGenericLabel(String string, String string2) {
        Segment[] segmentArray = new Segment[]{new Segment(string + " ", 1), new Segment(string2, 0)};
        return Segment.makeCanvas(segmentArray, this.viewer.getWbShell(), this.viewer.baseOrd);
    }

    protected double getInset() {
        return 4.0;
    }

    public void paint(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(BBajadocViewer.CLASS_BACKGROUND);
        graphics.fillRect(2.0, 2.0, d - 2.0, d2 - 2.0);
        super.paint(graphics);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

