/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.HelpSystem;
import com.tridium.help.Hierarchy;
import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.MemberDoc;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.TopicDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.bajadoc.ui.BBajadocOptions;
import com.tridium.help.bajadoc.ui.BClassInPackagePane;
import com.tridium.help.bajadoc.ui.BDocPane;
import com.tridium.help.bajadoc.ui.BHeaderBar;
import com.tridium.help.bajadoc.ui.BMemberPane;
import com.tridium.help.bajadoc.ui.BPackageInModulePane;
import com.tridium.help.bajadoc.ui.BTitlePane;
import com.tridium.help.bajadoc.ui.BajadocCommands;
import com.tridium.help.bajadoc.ui.Flattener;
import com.tridium.help.bajadoc.ui.HierarchyTreeModel;
import com.tridium.help.ui.HelpTreeController;
import com.tridium.html.canvas.BHtmlCanvas;
import javax.baja.file.BIFile;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BBajadocViewer
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$help$bajadoc$ui$BBajadocViewer == null ? (class$com$tridium$help$bajadoc$ui$BBajadocViewer = BBajadocViewer.class$("com.tridium.help.bajadoc.ui.BBajadocViewer")) : class$com$tridium$help$bajadoc$ui$BBajadocViewer));
    static BColor HEADER_BACKGROUND = BColor.make((int)0x666699);
    static BColor HEADER_BORDER = BColor.make((int)0x505050);
    static BColor HEADER_TEXT = BColor.white;
    static BColor CLASS_BACKGROUND = BColor.make((int)0xDDDDDD);
    BajadocCommands commands = new BajadocCommands(this);
    BIFile file;
    BOrd baseOrd;
    Doc doc;
    private String fragment;
    private BScrollPane scrollPane;
    static /* synthetic */ Class class$com$tridium$help$bajadoc$ui$BBajadocViewer;
    static /* synthetic */ Class class$com$tridium$help$bajadoc$ui$BDocPane;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.commands.init();
        this.file = (BIFile)bObject;
        this.baseOrd = this.getWbShell().getActiveOrd();
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(8, true);
        this.loadViewer();
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        switch (n) {
            case 6: {
                this.find();
                break;
            }
            case 8: {
                this.findNext();
                break;
            }
            case 7: {
                this.findPrev();
                break;
            }
            case 1: {
                this.copyFromCanvas((BWidget)this);
            }
        }
        return null;
    }

    private boolean copyFromCanvas(BWidget bWidget) {
        if (bWidget instanceof BHtmlCanvas && bWidget.hasFocus()) {
            try {
                ((BHtmlCanvas)bWidget).doCopy();
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            return true;
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (!this.copyFromCanvas(bWidgetArray[i])) continue;
            return true;
        }
        return false;
    }

    private void find() {
        System.out.println("BBajadocViewer.find");
        BDialog.message((BWidget)this, (Object)"Sorry - find not implemented yet");
    }

    private void findNext() {
        System.out.println("BBajadocViewer.findNext");
        BDialog.message((BWidget)this, (Object)"Sorry - find not implemented yet");
    }

    private void findPrev() {
        System.out.println("BBajadocViewer.findPrev");
        BDialog.message((BWidget)this, (Object)"Sorry - find not implemented yet");
    }

    public void paint(Graphics graphics) {
        if (this.fragment != null) {
            BMemberPane bMemberPane = this.findMember((BWidget)this.scrollPane, this.fragment);
            if (bMemberPane != null) {
                RectGeom rectGeom = this.scrollPane.getViewport();
                this.scrollPane.scrollToVisible(new RectGeom(0.0, bMemberPane.getY(), rectGeom.width, rectGeom.height));
                bMemberPane.canvas.selectAll();
            }
            this.fragment = null;
        } else {
            this.paintChildren(graphics);
        }
    }

    private BMemberPane findMember(BWidget bWidget, String string) {
        BWidget[] bWidgetArray;
        if (bWidget instanceof BMemberPane) {
            bWidgetArray = (BWidget[])bWidget;
            if (bWidgetArray.doc instanceof MemberDoc && bWidgetArray.getFragment().equals(string)) {
                return bWidgetArray;
            }
        }
        bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BMemberPane bMemberPane = this.findMember(bWidgetArray[i], string);
            if (bMemberPane == null) continue;
            return bMemberPane;
        }
        return null;
    }

    public void reloadViewer() {
        try {
            this.loadViewer();
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, null, (Object)"Cannot reload", (Throwable)exception);
        }
    }

    public void loadViewer() throws Exception {
        this.doc = new BajadocParser().parse(this.file.getInputStream());
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        if (this.doc instanceof ClassDoc) {
            this.buildClass(bGridPane, (ClassDoc)this.doc);
        } else if (this.doc instanceof PackageDoc) {
            this.buildPackage(bGridPane, (PackageDoc)this.doc);
        } else if (this.doc instanceof ModuleDoc) {
            this.buildModule(bGridPane, (ModuleDoc)this.doc);
        }
        bGridPane.add("spacer", (BValue)new BLabel(""));
        this.scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bGridPane, 5.0, 5.0, 5.0, 5.0));
        this.setContent((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT));
        this.commands.depends.setEnabled(this.doc instanceof ClassDoc);
    }

    private void buildModule(BGridPane bGridPane, ModuleDoc moduleDoc) {
        int n;
        Object[] objectArray;
        boolean bl = BBajadocOptions.make().getShowBajaOnly();
        bGridPane.add("module", (BValue)new BBorderPane((BWidget)new BTitlePane(this, moduleDoc), 0.0, 0.0, 5.0, 0.0));
        if (!bl) {
            bGridPane.add("packages", (BValue)new BHeaderBar(this, "Packages"));
            objectArray = moduleDoc.packagesSorted();
            for (n = 0; n < objectArray.length; ++n) {
                bGridPane.add("p" + n, (BValue)new BPackageInModulePane(this, (PackageDoc)objectArray[n]));
            }
        }
        if ((objectArray = moduleDoc.typesSorted()).length > 0) {
            bGridPane.add("types", (BValue)new BHeaderBar(this, "Types"));
            for (n = 0; n < objectArray.length; ++n) {
                bGridPane.add("t" + n, (BValue)new BClassInPackagePane(this, (ClassSummary)objectArray[n], false));
            }
        }
    }

    private void buildPackage(BGridPane bGridPane, PackageDoc packageDoc) {
        ClassSummary[] classSummaryArray;
        ClassSummary[] classSummaryArray2;
        bGridPane.add("package", (BValue)new BBorderPane((BWidget)new BTitlePane(this, packageDoc), 0.0, 0.0, 5.0, 0.0));
        ClassSummary[] classSummaryArray3 = packageDoc.interfacesSorted();
        if (classSummaryArray3.length > 0) {
            bGridPane.add("interfaces", (BValue)new BHeaderBar(this, "Interfaces"));
            for (int i = 0; i < classSummaryArray3.length; ++i) {
                bGridPane.add("i" + i, (BValue)new BClassInPackagePane(this, classSummaryArray3[i], true));
            }
        }
        if ((classSummaryArray2 = packageDoc.normalSorted()).length > 0) {
            bGridPane.add("classes", (BValue)new BHeaderBar(this, "Classes"));
            for (int i = 0; i < classSummaryArray2.length; ++i) {
                bGridPane.add("c" + i, (BValue)new BClassInPackagePane(this, classSummaryArray2[i], true));
            }
        }
        if ((classSummaryArray = packageDoc.exceptionsSorted()).length > 0) {
            bGridPane.add("exceptions", (BValue)new BHeaderBar(this, "Exceptions"));
            for (int i = 0; i < classSummaryArray.length; ++i) {
                bGridPane.add("e" + i, (BValue)new BClassInPackagePane(this, classSummaryArray[i], true));
            }
        }
    }

    private void buildClass(BGridPane bGridPane, ClassDoc classDoc) throws Exception {
        FieldDoc[] fieldDocArray;
        MethodDoc[] methodDocArray;
        BTree bTree;
        Object object;
        Object object2;
        boolean bl = BBajadocOptions.make().getShowBajaOnly();
        if (BBajadocOptions.make().getFlattenInheritance()) {
            classDoc = new Flattener().flatten(classDoc);
        }
        bGridPane.add("cls", (BValue)new BBorderPane((BWidget)new BTitlePane(this, classDoc), 0.0, 0.0, 5.0, 0.0));
        if (!classDoc.isInterface() && HelpSystem.exists()) {
            object2 = new Hierarchy.Entry(classDoc.module(), classDoc.packageName(), classDoc.name());
            if (Hierarchy.instance().hasSubEntries((Hierarchy.Entry)object2)) {
                bGridPane.add("subcls1", (BValue)new BHeaderBar(this, "Subclasses"));
                object = new HierarchyTreeModel((Hierarchy.Entry)object2);
                bTree = new BTree((TreeModel)object, (TreeController)new HelpTreeController());
                bTree.setNodeRenderer(new TreeNodeRenderer(){
                    private BFont font = BFont.make((String)Lexicon.make((String)"help").getText("bajadoc.viewer.font"));

                    public BFont getTextFont() {
                        return this.font;
                    }
                });
                bGridPane.add("subcls2", (BValue)bTree);
            }
        }
        if (((PropertyDoc[])(object2 = classDoc.propertiesSorted())).length > 0) {
            bGridPane.add("properties", (BValue)new BHeaderBar(this, "Properties"));
            for (int i = 0; i < ((PropertyDoc[])object2).length; ++i) {
                bGridPane.add("p" + i, (BValue)new BMemberPane(this, classDoc, object2[i]));
            }
        }
        if (((ActionDoc[])(object = classDoc.actionsSorted())).length > 0) {
            bGridPane.add("actions", (BValue)new BHeaderBar(this, "Actions"));
            for (int i = 0; i < ((ActionDoc[])object).length; ++i) {
                bGridPane.add("a" + i, (BValue)new BMemberPane(this, classDoc, object[i]));
            }
        }
        if (((TopicDoc[])(bTree = classDoc.topicsSorted())).length > 0) {
            bGridPane.add("topics", (BValue)new BHeaderBar(this, "Topics"));
            for (int i = 0; i < ((TopicDoc[])bTree).length; ++i) {
                bGridPane.add("t" + i, (BValue)new BMemberPane(this, classDoc, (TopicDoc)bTree[i]));
            }
        }
        if (bl) {
            return;
        }
        ConstructorDoc[] constructorDocArray = classDoc.constructors();
        if (constructorDocArray.length > 0) {
            bGridPane.add("constructors", (BValue)new BHeaderBar(this, "Constructors"));
            for (int i = 0; i < constructorDocArray.length; ++i) {
                bGridPane.add("c" + i, (BValue)new BMemberPane(this, classDoc, constructorDocArray[i]));
            }
        }
        if ((methodDocArray = classDoc.methodsSorted()).length > 0) {
            bGridPane.add("methods", (BValue)new BHeaderBar(this, "Methods"));
            for (int i = 0; i < methodDocArray.length; ++i) {
                bGridPane.add("m" + i, (BValue)new BMemberPane(this, classDoc, methodDocArray[i]));
            }
        }
        if ((fieldDocArray = classDoc.fieldsSorted()).length > 0) {
            bGridPane.add("fields", (BValue)new BHeaderBar(this, "Fields"));
            for (int i = 0; i < fieldDocArray.length; ++i) {
                bGridPane.add("f" + i, (BValue)new BMemberPane(this, classDoc, fieldDocArray[i]));
            }
        }
    }

    public String getDefaultOptionsId() {
        return "bajadoc";
    }

    public BMenu[] getViewMenus() {
        return this.commands.getViewMenus();
    }

    public BToolBar getViewToolBar() {
        return this.commands.getViewToolBar();
    }

    double getContentWidth() {
        return this.getWidth() - 30.0;
    }

    void expandAll(boolean bl) {
        BBorderPane bBorderPane = (BBorderPane)this.scrollPane.getContent();
        BGridPane bGridPane = (BGridPane)bBorderPane.getContent();
        BDocPane[] bDocPaneArray = (BDocPane[])bGridPane.getChildren(class$com$tridium$help$bajadoc$ui$BDocPane == null ? (class$com$tridium$help$bajadoc$ui$BDocPane = BBajadocViewer.class$("com.tridium.help.bajadoc.ui.BDocPane")) : class$com$tridium$help$bajadoc$ui$BDocPane);
        for (int i = 0; i < bDocPaneArray.length; ++i) {
            bDocPaneArray[i].setExpanded(bl);
            bDocPaneArray[i].relayout();
        }
        this.relayout();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

