/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.parser;

import com.tridium.help.bajadoc.ActionDoc;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.ConstructorDoc;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.FieldDoc;
import com.tridium.help.bajadoc.FrameworkDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.MethodDoc;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.Parameter;
import com.tridium.help.bajadoc.PropertyDoc;
import com.tridium.help.bajadoc.Returns;
import com.tridium.help.bajadoc.Tag;
import com.tridium.help.bajadoc.Throws;
import com.tridium.help.bajadoc.TopicDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.baja.sys.Flags;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class BajadocParser {
    public Doc parse(InputStream inputStream) throws Exception {
        return this.parse(XParser.make((InputStream)inputStream).parse(false));
    }

    public Doc parse(String string) throws Exception {
        return this.parse(XParser.make((String)string).parse());
    }

    private Doc parse(XElem xElem) throws Exception {
        if (!xElem.name().equals("bajadoc")) {
            throw new XException("Not bajadoc XML file", xElem);
        }
        if (!xElem.get("version").equals("1.0")) {
            throw new XException("Only version 1.0 supported", xElem);
        }
        if (xElem.contentSize() == 0) {
            throw new XException("No bajadoc elements!", xElem);
        }
        XElem xElem2 = xElem.elem(0);
        String string = xElem2.name();
        if (string.equals("class")) {
            return this.parseClass(xElem2);
        }
        if (string.equals("package")) {
            return this.parsePackage(xElem2);
        }
        if (string.equals("module")) {
            return this.parseModule(xElem2);
        }
        if (string.equals("framework")) {
            return this.parseFramework(xElem2);
        }
        throw new XException("Unknown bajadoc content: " + string, xElem2);
    }

    private FrameworkDoc parseFramework(XElem xElem) throws Exception {
        Tag[] tagArray;
        XElem[] xElemArray = xElem.elems("module");
        ModuleDoc[] moduleDocArray = new ModuleDoc[xElemArray.length];
        for (int i = 0; i < moduleDocArray.length; ++i) {
            tagArray = xElemArray[i].get("name");
            String string = xElemArray[i].string();
            moduleDocArray[i] = new ModuleDoc((String)tagArray, "", "", "", null, null, string, Tag.none);
        }
        String string = this.getDescription(xElem);
        tagArray = this.getTags(xElem);
        return new FrameworkDoc(moduleDocArray, string, tagArray);
    }

    private ModuleDoc parseModule(XElem xElem) throws Exception {
        Tag[] tagArray;
        ClassSummary[] classSummaryArray;
        String string = xElem.get("name");
        String string2 = xElem.get("bajaVersion");
        String string3 = xElem.get("vendor");
        String string4 = xElem.get("vendorVersion");
        XElem[] xElemArray = xElem.elems("package");
        PackageDoc[] packageDocArray = new PackageDoc[xElemArray.length];
        for (int i = 0; i < packageDocArray.length; ++i) {
            classSummaryArray = xElemArray[i];
            String string5 = classSummaryArray.get("name");
            tagArray = classSummaryArray.string();
            packageDocArray[i] = new PackageDoc(string, string5, new ClassSummary[0], (String)tagArray, Tag.none);
        }
        XElem[] xElemArray2 = xElem.elems("type");
        classSummaryArray = new ClassSummary[xElemArray2.length];
        for (int i = 0; i < classSummaryArray.length; ++i) {
            classSummaryArray[i] = this.parseClassSummary(xElemArray2[i]);
        }
        String string6 = this.getDescription(xElem);
        tagArray = this.getTags(xElem);
        return new ModuleDoc(string, string2, string3, string4, packageDocArray, classSummaryArray, string6, tagArray);
    }

    private PackageDoc parsePackage(XElem xElem) throws Exception {
        String string = xElem.get("module", null);
        String string2 = xElem.get("name");
        XElem[] xElemArray = xElem.elems("class");
        ClassSummary[] classSummaryArray = new ClassSummary[xElemArray.length];
        for (int i = 0; i < classSummaryArray.length; ++i) {
            classSummaryArray[i] = this.parseClassSummary(xElemArray[i]);
        }
        String string3 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new PackageDoc(string, string2, classSummaryArray, string3, tagArray);
    }

    private ClassSummary parseClassSummary(XElem xElem) throws Exception {
        String string = xElem.get("qualifiedName");
        int n = 0;
        String string2 = xElem.get("category", null);
        if (string2 != null) {
            n = ClassDoc.stringToCategory(string2);
        }
        String string3 = xElem.string();
        return new ClassSummary(string, n, string3);
    }

    private ClassDoc parseClass(XElem xElem) throws Exception {
        String string = xElem.get("module", null);
        String string2 = xElem.get("qualifiedName");
        int n = this.getModifiers(xElem);
        boolean bl = xElem.getb("innerClass", false);
        int n2 = 0;
        String string3 = xElem.get("category", null);
        if (string3 != null) {
            n2 = ClassDoc.stringToCategory(string3);
        }
        JavaType[] javaTypeArray = this.getExtraTypeInfo(xElem.elem("ancestors"));
        JavaType[] javaTypeArray2 = this.getExtraTypeInfo(xElem.elem("extenders"));
        JavaType[] javaTypeArray3 = this.getExtraTypeInfo(xElem.elem("implementors"));
        XElem xElem2 = xElem.elem("extends");
        JavaType javaType = null;
        if (xElem2 != null) {
            javaType = this.getType(xElem2);
        }
        XElem[] xElemArray = xElem.elems("implements");
        JavaType[] javaTypeArray4 = new JavaType[xElemArray.length];
        for (int i = 0; i < javaTypeArray4.length; ++i) {
            javaTypeArray4[i] = this.getType(xElemArray[i]);
        }
        XElem[] xElemArray2 = xElem.elems("property");
        PropertyDoc[] propertyDocArray = new PropertyDoc[xElemArray2.length];
        for (int i = 0; i < propertyDocArray.length; ++i) {
            propertyDocArray[i] = this.getProperty(xElemArray2[i]);
        }
        XElem[] xElemArray3 = xElem.elems("action");
        ActionDoc[] actionDocArray = new ActionDoc[xElemArray3.length];
        for (int i = 0; i < actionDocArray.length; ++i) {
            actionDocArray[i] = this.getAction(xElemArray3[i]);
        }
        XElem[] xElemArray4 = xElem.elems("topic");
        TopicDoc[] topicDocArray = new TopicDoc[xElemArray4.length];
        for (int i = 0; i < topicDocArray.length; ++i) {
            topicDocArray[i] = this.getTopic(xElemArray4[i]);
        }
        XElem[] xElemArray5 = xElem.elems("constructor");
        ConstructorDoc[] constructorDocArray = new ConstructorDoc[xElemArray5.length];
        for (int i = 0; i < constructorDocArray.length; ++i) {
            constructorDocArray[i] = this.getConstructor(xElemArray5[i]);
        }
        XElem[] xElemArray6 = xElem.elems("method");
        MethodDoc[] methodDocArray = new MethodDoc[xElemArray6.length];
        for (int i = 0; i < methodDocArray.length; ++i) {
            methodDocArray[i] = this.getMethod(xElemArray6[i]);
        }
        XElem[] xElemArray7 = xElem.elems("field");
        FieldDoc[] fieldDocArray = new FieldDoc[xElemArray7.length];
        for (int i = 0; i < fieldDocArray.length; ++i) {
            fieldDocArray[i] = this.getField(xElemArray7[i]);
        }
        String string4 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new ClassDoc(string, string2, n, javaType, javaTypeArray4, javaTypeArray, javaTypeArray2, javaTypeArray3, propertyDocArray, actionDocArray, topicDocArray, fieldDocArray, constructorDocArray, methodDocArray, new ClassDoc[0], n2, bl, string4, tagArray);
    }

    JavaType[] getExtraTypeInfo(XElem xElem) throws Exception {
        if (xElem == null) {
            return JavaType.NONE;
        }
        XElem[] xElemArray = xElem.elems("type");
        JavaType[] javaTypeArray = new JavaType[xElemArray.length];
        for (int i = 0; i < xElemArray.length; ++i) {
            javaTypeArray[i] = this.getType(xElemArray[i]);
        }
        return javaTypeArray;
    }

    private PropertyDoc getProperty(XElem xElem) throws Exception {
        String string = xElem.get("name");
        int n = Flags.decodeFromString((String)xElem.get("flags"));
        XElem xElem2 = xElem.elem("type");
        if (xElem2 == null) {
            throw new XException("Missing type element on property: " + string, xElem);
        }
        JavaType javaType = this.getType(xElem2);
        String string2 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new PropertyDoc(string, n, javaType, string2, tagArray);
    }

    private ActionDoc getAction(XElem xElem) throws Exception {
        String string = xElem.get("name");
        int n = Flags.decodeFromString((String)xElem.get("flags"));
        Parameter[] parameterArray = this.getParams(xElem);
        Parameter parameter = parameterArray.length == 0 ? null : parameterArray[0];
        Returns returns = this.getReturns(xElem);
        String string2 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new ActionDoc(string, n, parameter, returns, string2, tagArray);
    }

    private TopicDoc getTopic(XElem xElem) throws Exception {
        String string = xElem.get("name");
        int n = Flags.decodeFromString((String)xElem.get("flags"));
        XElem xElem2 = xElem.elem("eventType");
        if (xElem2 == null) {
            throw new XException("Missing eventType element on topic: " + string, xElem);
        }
        JavaType javaType = this.getType(xElem2);
        String string2 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new TopicDoc(string, n, javaType, string2, tagArray);
    }

    private ConstructorDoc getConstructor(XElem xElem) throws Exception {
        String string = xElem.get("name");
        int n = this.getModifiers(xElem);
        Parameter[] parameterArray = this.getParams(xElem);
        Throws[] throwsArray = this.getThrows(xElem);
        String string2 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new ConstructorDoc(string, n, parameterArray, throwsArray, string2, tagArray);
    }

    private MethodDoc getMethod(XElem xElem) throws Exception {
        String string = xElem.get("name");
        int n = this.getModifiers(xElem);
        Parameter[] parameterArray = this.getParams(xElem);
        Throws[] throwsArray = this.getThrows(xElem);
        Returns returns = this.getReturns(xElem);
        String string2 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new MethodDoc(string, n, parameterArray, throwsArray, returns, string2, tagArray);
    }

    private FieldDoc getField(XElem xElem) throws Exception {
        String string = xElem.get("name");
        int n = this.getModifiers(xElem);
        XElem xElem2 = xElem.elem("type");
        if (xElem2 == null) {
            throw new XException("Missing type element on field: " + string, xElem);
        }
        JavaType javaType = this.getType(xElem2);
        String string2 = this.getDescription(xElem);
        Tag[] tagArray = this.getTags(xElem);
        return new FieldDoc(string, n, javaType, string2, tagArray);
    }

    private Returns getReturns(XElem xElem) throws Exception {
        XElem xElem2 = xElem.elem("return");
        if (xElem2 == null) {
            throw new XException("Missing return element: " + xElem, xElem);
        }
        JavaType javaType = this.getType(xElem2);
        String string = xElem2.string();
        return new Returns(javaType, string);
    }

    private Parameter[] getParams(XElem xElem) throws Exception {
        XElem[] xElemArray = xElem.elems("parameter");
        Parameter[] parameterArray = new Parameter[xElemArray.length];
        for (int i = 0; i < parameterArray.length; ++i) {
            String string = xElemArray[i].get("name");
            JavaType javaType = this.getType(xElemArray[i]);
            String string2 = xElemArray[i].string();
            parameterArray[i] = new Parameter(string, javaType, string2);
        }
        return parameterArray;
    }

    private Throws[] getThrows(XElem xElem) throws Exception {
        XElem[] xElemArray = xElem.elems("throws");
        if (xElemArray.length == 0) {
            return Throws.none;
        }
        Throws[] throwsArray = new Throws[xElemArray.length];
        for (int i = 0; i < throwsArray.length; ++i) {
            JavaType javaType = this.getType(xElemArray[i]);
            String string = xElemArray[i].string();
            throwsArray[i] = new Throws(javaType, string);
        }
        return throwsArray;
    }

    private JavaType getType(XElem xElem) throws Exception {
        String string = xElem.get("module", null);
        String string2 = xElem.get("class");
        int n = xElem.geti("dimension", 0);
        return new JavaType(string, string2, n);
    }

    private int getModifiers(XElem xElem) throws Exception {
        int n = 0;
        if (xElem.getb("public", false)) {
            n |= 1;
        }
        if (xElem.getb("protected", false)) {
            n |= 4;
        }
        if (xElem.getb("private", false)) {
            n |= 2;
        }
        if (xElem.getb("abstract", false)) {
            n |= 0x400;
        }
        if (xElem.getb("static", false)) {
            n |= 8;
        }
        if (xElem.getb("final", false)) {
            n |= 0x10;
        }
        if (xElem.getb("interface", false)) {
            n |= 0x200;
        }
        if (xElem.getb("transient", false)) {
            n |= 0x80;
        }
        if (xElem.getb("native", false)) {
            n |= 0x100;
        }
        if (xElem.getb("synchronized", false)) {
            n |= 0x20;
        }
        return n;
    }

    private String getDescription(XElem xElem) {
        XElem xElem2 = xElem.elem("description");
        if (xElem2 != null) {
            return xElem2.string();
        }
        return null;
    }

    private Tag[] getTags(XElem xElem) throws XException {
        XElem[] xElemArray = xElem.elems("tag");
        if (xElemArray.length == 0) {
            return Tag.none;
        }
        Tag[] tagArray = new Tag[xElemArray.length];
        for (int i = 0; i < tagArray.length; ++i) {
            String string = xElemArray[i].get("name");
            String string2 = xElemArray[i].string();
            tagArray[i] = new Tag(string, string2);
        }
        return tagArray;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.out.println("usage: BajadocParser <bajadocFile>");
            return;
        }
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        ClassDoc classDoc = (ClassDoc)new BajadocParser().parse(fileInputStream);
        fileInputStream.close();
        classDoc.dump();
    }
}

