/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.html;

import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import javax.baja.nre.util.TextUtil;

public class UriPath {
    private static final String[] NO_NAMES = new String[0];
    private String body;
    private String[] names = NO_NAMES;

    public UriPath(String string) {
        this.body = string;
        if (string.charAt(0) != '/') {
            throw new IllegalStateException(string + " is not absolute.");
        }
        if (string.length() > 0) {
            this.names = TextUtil.split((String)string.substring(1), (char)'/');
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] != null && !this.names[i].equals("") && !this.names[i].equals(".") && !this.names[i].equals("..")) continue;
                throw new IllegalStateException(string + " is malformed.");
            }
        }
    }

    public static UriPath makeFrameworkURI() {
        return new UriPath("/framework.html");
    }

    public static UriPath makeModuleURI(String string, String string2) {
        return new UriPath("/" + (string == null ? "docJdk" : string) + "/" + string2);
    }

    public static UriPath makePackageURI(String string, String string2, String string3) {
        return new UriPath("/" + (string == null ? "docJdk" : string) + "/" + string2.replace('.', '/') + "/" + string3);
    }

    public static UriPath makeTypeURI(JavaType javaType) {
        if (!javaType.isResolved()) {
            return null;
        }
        return UriPath.makeTypeURI(javaType.module(), javaType.packageName(), javaType.name());
    }

    public static UriPath makeTypeURI(String string, String string2, String string3) {
        return new UriPath("/" + (string == null ? "docJdk" : string) + "/" + string2.replace('.', '/') + "/" + string3 + ".html");
    }

    public static UriPath makeDocURI(Doc doc) {
        if (doc instanceof ModuleDoc) {
            ModuleDoc moduleDoc = (ModuleDoc)doc;
            return UriPath.makeModuleURI(moduleDoc.name(), "module-index.html");
        }
        if (doc instanceof PackageDoc) {
            PackageDoc packageDoc = (PackageDoc)doc;
            return UriPath.makePackageURI(packageDoc.module(), packageDoc.name(), "package-index.html");
        }
        if (doc instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)doc;
            return UriPath.makeTypeURI(new JavaType(classDoc));
        }
        throw new IllegalStateException(doc.toString());
    }

    public String getFrameworkHref() {
        return this.getRelativePath(UriPath.makeFrameworkURI());
    }

    public String getModuleHref(String string, String string2) {
        return this.getRelativePath(UriPath.makeModuleURI(string, string2));
    }

    public String getPackageHref(String string, String string2, String string3) {
        return this.getRelativePath(UriPath.makePackageURI(string, string2, string3));
    }

    public String getTypeHref(JavaType javaType) {
        return this.getRelativePath(UriPath.makeTypeURI(javaType));
    }

    public String getTypeHref(String string, String string2, String string3) {
        return this.getRelativePath(UriPath.makeTypeURI(string, string2, string3));
    }

    private String getRelativePath(UriPath uriPath) {
        int n;
        int n2;
        if (this.body.equals(uriPath.body)) {
            if (this.body.equals("/")) {
                throw new IllegalStateException("Cannot get relative path from a root to itself");
            }
            return this.names[this.names.length - 1];
        }
        String[] stringArray = this.names;
        String[] stringArray2 = uriPath.names;
        int n3 = stringArray.length;
        int n4 = stringArray2.length;
        for (n2 = 0; n2 < n3 && n2 < n4 && stringArray[n2].equals(stringArray2[n2]); ++n2) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = n2 + 1; n < n3; ++n) {
            stringBuffer.append("../");
        }
        for (n = n2; n < n4; ++n) {
            if (n > n2) {
                stringBuffer.append("/");
            }
            stringBuffer.append(stringArray2[n]);
        }
        return stringBuffer.toString();
    }
}

