/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.HelpSystem;
import com.tridium.help.SearchResult;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;

public class Searcher {
    private static final String DELIM = "\t\n\r\f.,-?;:[](){}!'<>/#$|+=\\/*&\u00a9\u00ae`~@%^";
    public static final String WORDS = "words.dat";
    public static final String WORDDOCS = "worddocs.dat";
    public static final String POSTINGS = "postings.dat";
    public static final String DOCUMENTS = "documents.dat";
    public static final String VERSION = "3.0";
    public static Set stopWords = new HashSet();
    private static Searcher instance;
    private Module[] modules;

    public static Searcher getInstance() throws IOException {
        if (instance == null) {
            instance = new Searcher();
        }
        return instance;
    }

    private Searcher() throws IOException {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        String[] stringArray = HelpSystem.HELP.list();
        for (int i = 0; i < stringArray.length; ++i) {
            Module module;
            File file = new File(HelpSystem.HELP, stringArray[i]);
            if (!file.exists() || !file.isDirectory() || (module = this.loadModule(file.getName())) == null) continue;
            arrayList.add(module);
        }
        this.modules = arrayList.toArray(new Module[arrayList.size()]);
    }

    private Module loadModule(String string) throws IOException {
        String string2 = string + "/" + WORDS;
        File file = new File(HelpSystem.HELP, string2);
        if (!file.exists()) {
            return null;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        RandomAccessFile randomAccessFile = this.openFile(string2);
        long l = randomAccessFile.length();
        while (randomAccessFile.getFilePointer() < l) {
            hashMap.put(randomAccessFile.readUTF(), new Integer(randomAccessFile.readInt()));
        }
        randomAccessFile.close();
        return new Module(string, hashMap);
    }

    private RandomAccessFile openFile(String string) throws IOException {
        File file = new File(HelpSystem.HELP, string);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.readUTF();
        return randomAccessFile;
    }

    public SearchResult[] search(String string) throws IOException {
        int[] nArray;
        Object[] objectArray;
        HashMap<BOrd, int[]> hashMap = new HashMap<BOrd, int[]>();
        String[][] stringArray = this.tokenize(string);
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray = stringArray[i].length == 1 ? this.searchWord(stringArray[i][0]) : this.searchPhrase(stringArray[i]);
            for (int j = 0; j < objectArray.length; ++j) {
                nArray = (int[])hashMap.get(((WordResult)objectArray[j]).ord);
                if (nArray == null) {
                    nArray = new int[stringArray.length];
                    hashMap.put(((WordResult)objectArray[j]).ord, nArray);
                }
                nArray[i] = ((WordResult)objectArray[j]).len;
            }
        }
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        objectArray = hashMap.keySet().iterator();
        block2: while (objectArray.hasNext()) {
            BOrd bOrd = (BOrd)objectArray.next();
            nArray = (int[])hashMap.get(bOrd);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue block2;
            }
            arrayList.add(new SearchResult(bOrd, nArray));
        }
        objectArray = arrayList.toArray(new SearchResult[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private String[][] tokenize(String string) {
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(TextUtil.toLowerCase((String)string));
        for (n3 = 0; n3 < stringBuffer.length(); ++n3) {
            if (DELIM.indexOf(stringBuffer.charAt(n3)) == -1) continue;
            stringBuffer.setCharAt(n3, ' ');
        }
        n3 = 1;
        while (n3 < stringBuffer.length()) {
            if (stringBuffer.charAt(n3 - 1) == ' ') {
                if (stringBuffer.charAt(n3) == ' ') {
                    stringBuffer.deleteCharAt(n3);
                    continue;
                }
                ++n3;
                continue;
            }
            ++n3;
        }
        boolean bl = false;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (bl) {
                if (stringBuffer.charAt(i) == '\"') {
                    bl = false;
                    continue;
                }
                if (stringBuffer.charAt(i) != ' ') continue;
                stringBuffer.setCharAt(i, '_');
                continue;
            }
            if (stringBuffer.charAt(i) != '\"') continue;
            bl = true;
        }
        n3 = stringBuffer.indexOf("\"");
        while (n3 != -1) {
            stringBuffer.deleteCharAt(n3);
            n3 = stringBuffer.indexOf("\"");
        }
        String[] stringArray = TextUtil.split((String)stringBuffer.toString().trim(), (char)' ');
        String[][] stringArrayArray = new String[stringArray.length][];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArrayArray[n2] = TextUtil.split((String)stringArray[n2], (char)'_');
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < stringArrayArray[n2].length; ++n) {
                if (stopWords.contains(stringArrayArray[n2][n])) continue;
                arrayList.add(stringArrayArray[n2][n]);
            }
            stringArrayArray[n2] = arrayList.toArray(new String[arrayList.size()]);
        }
        n2 = 0;
        for (int i = 0; i < stringArrayArray.length; ++i) {
            if (stringArrayArray[i].length <= 0) continue;
            ++n2;
        }
        String[][] stringArray2 = new String[n2][];
        n3 = 0;
        for (n = 0; n < stringArrayArray.length; ++n) {
            if (stringArrayArray[n].length <= 0) continue;
            stringArray2[n3++] = stringArrayArray[n];
        }
        return stringArray2;
    }

    private WordResult[] searchWord(String string) throws IOException {
        ArrayList<WordResult> arrayList = new ArrayList<WordResult>();
        string = TextUtil.toLowerCase((String)string);
        for (int i = 0; i < this.modules.length; ++i) {
            WordResult[] wordResultArray = this.searchModuleForWord(this.modules[i], string, false);
            for (int j = 0; j < wordResultArray.length; ++j) {
                arrayList.add(wordResultArray[j]);
            }
        }
        return arrayList.toArray(new WordResult[arrayList.size()]);
    }

    private WordResult[] searchPhrase(String[] stringArray) throws IOException {
        int n;
        Object object;
        int n2;
        String string;
        ArrayList<WordResult> arrayList = new ArrayList<WordResult>();
        HashMap<BOrd, int[][]> hashMap = new HashMap<BOrd, int[][]>();
        for (int i = 0; i < stringArray.length; ++i) {
            string = TextUtil.toLowerCase((String)stringArray[i]);
            for (n2 = 0; n2 < this.modules.length; ++n2) {
                object = this.searchModuleForWord(this.modules[n2], string, true);
                for (n = 0; n < ((int[][])object).length; ++n) {
                    Object object2 = (int[][])hashMap.get(((WordResult)object[n]).ord);
                    if (object2 == null) {
                        object2 = new int[stringArray.length][];
                        hashMap.put(((WordResult)object[n]).ord, (int[][])object2);
                    }
                    object2[i] = ((WordResult)object[n]).wnum;
                }
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        block3: while (iterator.hasNext()) {
            string = (BOrd)iterator.next();
            n2 = 0;
            object = (int[][])hashMap.get(string);
            for (n = 0; n < stringArray.length; ++n) {
                if (object[n] == null) continue block3;
            }
            for (n = 0; n < object[0].length; ++n) {
                int n3 = object[0][n];
                int n4 = 0;
                for (int i = 1; i < stringArray.length; ++i) {
                    for (int j = 0; j < object[i].length; ++j) {
                        if (object[i][j] != n3 + i) continue;
                        ++n4;
                    }
                }
                if (n4 != stringArray.length - 1) continue;
                ++n2;
            }
            if (n2 <= 0) continue;
            arrayList.add(new WordResult((BOrd)string, n2, null));
        }
        return arrayList.toArray(new WordResult[arrayList.size()]);
    }

    private WordResult[] searchModuleForWord(Module module, String string, boolean bl) throws IOException {
        ArrayList<WordResult> arrayList = new ArrayList<WordResult>();
        Integer n = (Integer)module.wordMap.get(string);
        if (n == null) {
            return new WordResult[0];
        }
        RandomAccessFile randomAccessFile = this.openFile(module.name + "/" + WORDDOCS);
        RandomAccessFile randomAccessFile2 = bl ? this.openFile(module.name + "/" + POSTINGS) : null;
        RandomAccessFile randomAccessFile3 = this.openFile(module.name + "/" + DOCUMENTS);
        randomAccessFile.seek(n.intValue());
        int n2 = randomAccessFile.readShort();
        for (int i = 0; i < n2; ++i) {
            int n3 = randomAccessFile.readInt();
            int n4 = randomAccessFile.readInt();
            int n5 = randomAccessFile.readShort();
            randomAccessFile3.seek(n3);
            String string2 = randomAccessFile3.readUTF();
            int[] nArray = null;
            if (bl) {
                randomAccessFile2.seek(n4);
                nArray = new int[n5];
                for (int j = 0; j < n5; ++j) {
                    nArray[j] = randomAccessFile2.readShort();
                }
            }
            arrayList.add(new WordResult(BOrd.make((String)("module://" + module.name + "/" + string2)), n5, nArray));
        }
        randomAccessFile.close();
        if (bl) {
            randomAccessFile2.close();
        }
        randomAccessFile3.close();
        return arrayList.toArray(new WordResult[arrayList.size()]);
    }

    static {
        stopWords.add("the");
        stopWords.add("of");
        stopWords.add("a");
        stopWords.add("is");
        stopWords.add("to");
        stopWords.add("this");
        stopWords.add("and");
        stopWords.add("in");
        stopWords.add("for");
        stopWords.add("if");
        stopWords.add("be");
        stopWords.add("see");
        stopWords.add("an");
        stopWords.add("that");
        stopWords.add("or");
        stopWords.add("not");
        stopWords.add("by");
        stopWords.add("with");
        stopWords.add("are");
        stopWords.add("as");
        stopWords.add("name");
        stopWords.add("from");
        stopWords.add("will");
        stopWords.add("it");
        stopWords.add("which");
        stopWords.add("on");
        stopWords.add("since");
        instance = null;
    }

    private class WordResult {
        private BOrd ord;
        private int len;
        private int[] wnum;

        private WordResult(BOrd bOrd, int n, int[] nArray) {
            this.ord = bOrd;
            this.len = n;
            this.wnum = nArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TextUtil.padLeft((String)Integer.toString(this.len), (int)6));
            stringBuffer.append("  ").append(this.ord.toString());
            if (this.wnum != null) {
                stringBuffer.append("\n        [");
                for (int i = 0; i < this.wnum.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.wnum[i]);
                }
                stringBuffer.append("]");
            }
            return stringBuffer.toString();
        }
    }

    private static class Module {
        private String name;
        private Map wordMap;

        private Module(String string, Map map) {
            this.name = string;
            this.wordMap = map;
        }
    }
}

