/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.BajadocFinder;
import com.tridium.help.HelpSystem;
import com.tridium.help.HierarchyBuilder;
import com.tridium.help.SearchBuilder;
import com.tridium.help.Searcher;
import com.tridium.help.bajadoc.parser.BajadocParser;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.FileUtil;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.util.UiLexicon;

public class SearchLoader
extends BProgressDialog.Worker {
    private Map bajadocEntries = new TreeMap();
    private static final String WORDS = "doc/words.dat";
    private static final String WORDDOCS = "doc/worddocs.dat";
    private static final String POSTINGS = "doc/postings.dat";
    private static final String DOCUMENTS = "doc/documents.dat";
    static boolean succeeded = false;
    private int totalTasks;
    private int currentTask;
    private boolean isAlive;
    private HierarchyBuilder hbuilder = new HierarchyBuilder();

    public void doRun() {
        try {
            this.isAlive = true;
            this.initProgress();
            if (!this.isAlive) {
                return;
            }
            this.createSearch();
            if (!this.isAlive) {
                return;
            }
            this.persist();
            if (!this.isAlive) {
                return;
            }
            succeeded = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doCancel() {
        this.isAlive = false;
    }

    private void initProgress() throws Exception {
        this.updateProgress(UiLexicon.bajaui.getText("help.load.scanning"));
        this.currentTask = 0;
        this.totalTasks = 1;
        String[] stringArray = HelpSystem.MODULES.list();
        for (int i = 0; this.isAlive && i < stringArray.length; ++i) {
            File file = new File(HelpSystem.MODULES, stringArray[i]);
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            ++this.totalTasks;
        }
    }

    private void updateProgressBar() {
        if (this.getDialog() == null) {
            return;
        }
        ++this.currentTask;
        double d = (double)this.currentTask / (double)this.totalTasks;
        this.updateProgress((int)(d * 100.0));
    }

    private void saveBajadocEntry(String string, String string2) {
        String string3 = this.makeEntryName(string, string2);
        ArrayList<BajadocFinder.Entry> arrayList = (ArrayList<BajadocFinder.Entry>)this.bajadocEntries.get(string3);
        if (arrayList == null) {
            arrayList = new ArrayList<BajadocFinder.Entry>();
            this.bajadocEntries.put(string3, arrayList);
        }
        arrayList.add(this.makeEntry(string, string2));
    }

    private String makeEntryName(String string, String string2) {
        if (string2.endsWith("module-index.bajadoc")) {
            return string;
        }
        if (string2.endsWith("package-index.bajadoc")) {
            return string2.substring(4, string2.lastIndexOf(47)).replace('/', '.');
        }
        return string2.substring(string2.lastIndexOf(47) + 1, string2.length() - ".bajadoc".length());
    }

    private BajadocFinder.Entry makeEntry(String string, String string2) {
        if (string2.endsWith("module-index.bajadoc")) {
            return new BajadocFinder.Entry(string, null, null);
        }
        if (string2.endsWith("package-index.bajadoc")) {
            String string3 = string2.substring(4, string2.lastIndexOf(47)).replace('/', '.');
            return new BajadocFinder.Entry(string, string3, null);
        }
        int n = string2.lastIndexOf(47);
        String string4 = string2.substring(4, n).replace('/', '.');
        String string5 = string2.substring(n + 1, string2.length() - ".bajadoc".length());
        return new BajadocFinder.Entry(string, string4, string5);
    }

    private void persistBajadocEntries() throws Exception {
        File file = new File(HelpSystem.HELP, "bajadoc.dat");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        Iterator iterator = this.bajadocEntries.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)this.bajadocEntries.get(string);
            bufferedWriter.write(string);
            bufferedWriter.write("|");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    bufferedWriter.write(";");
                }
                bufferedWriter.write(list.get(i).toString());
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
    }

    private void transfer(JarInputStream jarInputStream, File file, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(file, string));
        byte[] byArray = new byte[1024];
        int n = jarInputStream.read(byArray, 0, 1024);
        while (n > 0) {
            fileOutputStream.write(byArray, 0, n);
            n = jarInputStream.read(byArray);
        }
        fileOutputStream.close();
    }

    private void traverseStream(String string, JarInputStream jarInputStream, File file, boolean bl) throws Exception {
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (this.isAlive && jarEntry != null) {
            if (bl) {
                if (jarEntry.getName().equals(WORDS)) {
                    this.transfer(jarInputStream, file, "words.dat");
                } else if (jarEntry.getName().equals(WORDDOCS)) {
                    this.transfer(jarInputStream, file, "worddocs.dat");
                } else if (jarEntry.getName().equals(POSTINGS)) {
                    this.transfer(jarInputStream, file, "postings.dat");
                } else if (jarEntry.getName().equals(DOCUMENTS)) {
                    this.transfer(jarInputStream, file, "documents.dat");
                }
            }
            if (jarEntry.getName().endsWith(".bajadoc")) {
                this.hbuilder.loadBajadoc(new BajadocParser().parse(new BufferedInputStream(jarInputStream)));
                this.saveBajadocEntry(string, jarEntry.getName());
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
    }

    private void decompress(String string, File file) throws Exception {
        File file2 = new File(HelpSystem.HELP, string);
        file2.mkdirs();
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
        ZipEntry zipEntry = new ZipFile(file).getEntry(WORDS);
        if (zipEntry == null) {
            this.traverseStream(string, jarInputStream, file2, false);
            new SearchBuilder().build(file2, file);
        } else {
            this.traverseStream(string, jarInputStream, file2, true);
        }
    }

    private void createSearch() throws Exception {
        FileUtil.delete((File)HelpSystem.HELP);
        HelpSystem.HELP.mkdirs();
        String[] stringArray = HelpSystem.MODULES.list();
        for (int i = 0; this.isAlive && i < stringArray.length; ++i) {
            File file = new File(HelpSystem.MODULES, stringArray[i]);
            String string = file.getName();
            if (file.isFile() && string.endsWith(".jar")) {
                this.decompress(string.substring(0, string.length() - 4), file);
            }
            this.updateProgressBar();
        }
    }

    private void persist() throws Exception {
        this.hbuilder.persist();
        this.persistBajadocEntries();
        Searcher.getInstance();
    }
}

