/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.Searcher;
import com.tridium.html.util.HtmlTokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.baja.nre.util.TextUtil;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SearchBuilder {
    private static final String DELIM = " \"\t\n\r\f.,-?;:[](){}!'<>/#$|+=\\/*&\u00a9\u00ae`~@%^";
    private Map words = new HashMap();
    private Integer docId;
    private int wnum;
    private HtmlParser htmlParser = new HtmlParser();

    public void build(File file, File file2) throws Exception {
        this.makeIndex(file, file2);
        this.persist(file);
    }

    private void persist(File file) throws Exception {
        RandomAccessFile randomAccessFile = this.createRandomAccessFile(file, "words.dat");
        RandomAccessFile randomAccessFile2 = this.createRandomAccessFile(file, "worddocs.dat");
        RandomAccessFile randomAccessFile3 = this.createRandomAccessFile(file, "postings.dat");
        Iterator iterator = this.words.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = (Map)this.words.get(string);
            randomAccessFile.writeUTF(string);
            randomAccessFile.writeInt((int)randomAccessFile2.length());
            randomAccessFile2.writeShort(map.size());
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                Integer n = (Integer)iterator2.next();
                List list = (List)map.get(n);
                randomAccessFile2.writeInt(n);
                randomAccessFile2.writeInt((int)randomAccessFile3.length());
                randomAccessFile2.writeShort(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    randomAccessFile3.writeShort((Integer)list.get(i));
                }
            }
        }
        randomAccessFile.close();
        randomAccessFile2.close();
        randomAccessFile3.close();
        this.words = null;
        System.gc();
    }

    private RandomAccessFile createRandomAccessFile(File file, String string) throws Exception {
        File file2 = new File(file, string);
        if (file2.exists()) {
            file2.delete();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        randomAccessFile.writeUTF("3.0");
        return randomAccessFile;
    }

    private void loadWord(String string) {
        if (Searcher.stopWords.contains(string)) {
            return;
        }
        HashMap hashMap = (HashMap)this.words.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.words.put(string, hashMap);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            hashMap.put(this.docId, arrayList);
            arrayList.add(new Integer(this.wnum++));
        } else {
            ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap.get(this.docId);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                hashMap.put(this.docId, arrayList);
            }
            arrayList.add(new Integer(this.wnum++));
        }
    }

    private void loadBajadocElement(XElem xElem) throws Exception {
        String string = xElem.string();
        if (string != null) {
            this.htmlParser.parse(string);
        }
        for (int i = 0; i < xElem.attrSize(); ++i) {
            String string2 = xElem.attrName(i);
            if (!string2.equals("name") && !string2.equals("class") && !string2.equals("qualifiedName")) continue;
            this.htmlParser.parse(xElem.attrValue(i));
        }
        XElem[] xElemArray = xElem.elems();
        for (int i = 0; i < xElemArray.length; ++i) {
            this.loadBajadocElement(xElemArray[i]);
        }
    }

    private void loadBajadoc(InputStream inputStream) throws Exception {
        XElem xElem = XParser.make((InputStream)inputStream).parse(false);
        XElem[] xElemArray = xElem.elems();
        for (int i = 0; i < xElemArray.length; ++i) {
            this.loadBajadocElement(xElemArray[i]);
        }
    }

    private void loadText(InputStream inputStream) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(TextUtil.toLowerCase((String)HtmlTokenizer.replaceLiterals((String)string)), DELIM);
            while (stringTokenizer.hasMoreTokens()) {
                this.loadWord(stringTokenizer.nextToken());
            }
        }
    }

    private void makeIndex(File file, File file2) throws Exception {
        RandomAccessFile randomAccessFile = this.createRandomAccessFile(file, "documents.dat");
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file2));
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            String string = jarEntry.getName();
            if (string.endsWith(".html") || string.endsWith(".bajadoc") || string.endsWith(".java") || string.endsWith(".txt")) {
                this.docId = this.storeDocument(randomAccessFile, string);
                this.wnum = 0;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(jarInputStream);
                if (string.endsWith(".html")) {
                    this.htmlParser.parse(bufferedInputStream, false);
                } else if (string.endsWith(".bajadoc")) {
                    this.loadBajadoc(bufferedInputStream);
                } else if (string.endsWith(".java") || string.endsWith(".txt")) {
                    this.loadText(bufferedInputStream);
                }
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
        randomAccessFile.close();
    }

    private Integer storeDocument(RandomAccessFile randomAccessFile, String string) throws Exception {
        Integer n = new Integer((int)randomAccessFile.length());
        randomAccessFile.writeUTF(string);
        return n;
    }

    private class HtmlParser
    extends HtmlTokenizer {
        private HtmlParser() {
        }

        public void handleText(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(TextUtil.toLowerCase((String)HtmlParser.replaceLiterals((String)string)), SearchBuilder.DELIM);
            while (stringTokenizer.hasMoreTokens()) {
                SearchBuilder.this.loadWord(stringTokenizer.nextToken());
            }
        }

        public void handleComment(String string) {
        }

        public void handleStartTag(int n, String string, Map map) {
        }

        public void handleEndTag(int n, String string) {
        }
    }
}

