/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.HelpSystem;
import com.tridium.html.util.HtmlTokenizer;
import com.tridium.util.Href2Ord;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.baja.naming.BOrd;

public abstract class HtmlChecker {
    private static void checkJar(String string, File file) throws Exception {
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
        JarEntry jarEntry = jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarInputStream);
            if (jarEntry.getName().endsWith(".html")) {
                String string2 = "module://" + string + "/" + jarEntry.getName();
                new HtmlParser(string2).parse(bufferedInputStream, false);
            }
            jarEntry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
        System.gc();
    }

    private static void usage() throws Exception {
        System.out.println("usage: ");
        System.out.println("  HtmlChecker <module>");
        System.out.println("  use 'all' to check every module");
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println();
        if (stringArray.length != 1) {
            HtmlChecker.usage();
        }
        if (stringArray[0].equals("all")) {
            boolean bl = false;
            String[] stringArray2 = HelpSystem.MODULES.list();
            for (int i = 0; i < stringArray2.length; ++i) {
                int n;
                File file = new File(HelpSystem.MODULES, stringArray2[i]);
                String string = file.getName();
                if (!string.substring(n = string.length() - 4).equals(".jar")) continue;
                HtmlChecker.checkJar(string.substring(0, n), file);
            }
        } else {
            File file = new File(HelpSystem.MODULES, stringArray[0] + ".jar");
            if (file.exists()) {
                HtmlChecker.checkJar(stringArray[0], file);
            } else {
                System.out.println("Module '" + stringArray[0] + "' does not exist.");
                System.exit(-1);
            }
        }
    }

    private static class HtmlParser
    extends HtmlTokenizer {
        private BOrd base;
        private Href2Ord conv;

        private HtmlParser(String string) {
            this.base = BOrd.make((String)string);
            this.conv = new Href2Ord(this.base);
        }

        public void handleStartTag(int n, String string, Map map) {
            String string2;
            if (string.equals("A") && (string2 = (String)map.get("HREF")) != null) {
                if (string2.startsWith("http:") || string2.startsWith("mailto:")) {
                    System.out.println("WARNING in " + this.base + ": found '" + string2 + "', near line " + n);
                } else {
                    BOrd bOrd = null;
                    try {
                        bOrd = this.conv.hrefToOrd(string2);
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR in " + this.base + ": could not create Ord for '" + string2 + "', near line " + n);
                    }
                    try {
                        bOrd.resolve();
                    }
                    catch (Exception exception) {
                        System.out.println("ERROR in " + this.base + ": could not resolve Ord for '" + string2 + "', near line " + n);
                    }
                }
            }
        }

        public void handleText(String string) {
        }

        public void handleComment(String string) {
        }

        public void handleEndTag(int n, String string) {
        }
    }
}

