/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.SearchLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.baja.file.FileUtil;
import javax.baja.gx.BImage;
import javax.baja.sys.Sys;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.util.UiLexicon;

public abstract class HelpSystem {
    static final File HELP = new File(Sys.getBajaHome(), "help");
    static final File MODULES = new File(Sys.getBajaHome(), "modules");
    private static final File REGISTRY_CHK = new File(Sys.getBajaHome(), "registry/registry.chk");

    public static void load(BWidget bWidget) {
        SearchLoader searchLoader = new SearchLoader();
        BProgressDialog.open((BWidget)bWidget, (String)UiLexicon.bajaui.getText("help.load.title"), (BProgressDialog.Worker)searchLoader, (BImage)BImage.make((String)"module://icons/x32/question.png"));
        if (!SearchLoader.succeeded) {
            try {
                FileUtil.delete((File)HELP);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static boolean exists() {
        return HELP.exists();
    }

    public static boolean upToDate() {
        if (!REGISTRY_CHK.exists()) {
            return false;
        }
        return REGISTRY_CHK.lastModified() < HELP.lastModified();
    }

    public static String[] getModulesHavingFile(String string) {
        int n;
        Object[] objectArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            objectArray = MODULES.list();
            for (n = 0; n < objectArray.length; ++n) {
                JarFile jarFile;
                JarEntry jarEntry;
                File file = new File(MODULES, objectArray[n]);
                String string2 = file.getName();
                int n2 = string2.length() - 4;
                if (n2 <= 0 || !string2.substring(n2).equals(".jar") || (jarEntry = (jarFile = new JarFile(file)).getJarEntry(string)) == null) continue;
                arrayList.add(string2.substring(0, n2));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        objectArray = new String[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            objectArray[n] = (String)arrayList.get(n);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static BufferedInputStream getJarEntryInputStream(String string, String string2) {
        try {
            File file = new File(MODULES, string + ".jar");
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                if (jarEntry.getName().equals(string2)) {
                    return new BufferedInputStream(jarInputStream);
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
            jarInputStream.close();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

