/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platUsbmon;

import com.tridium.platUsbmon.BUsbMonitorPlatformService;
import com.tridium.platform.qnx.QnxNativeUtil;
import com.tridium.platform.qnx.WaitPidResponse;
import com.tridium.usbmon.BUsbFlashDrive;
import com.tridium.usbmon.BUsbFsTypeEnum;
import com.tridium.usbmon.UsbmonException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.baja.sys.BInteger;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUsbMonitorPlatformServiceQnx
extends BUsbMonitorPlatformService {
    public static final Type TYPE;
    boolean nativesLoaded;
    static /* synthetic */ Class class$com$tridium$platUsbmon$BUsbMonitorPlatformServiceQnx;

    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return false;
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        try {
            log.trace("Loading libusbmon.so...");
            System.loadLibrary("usbmon");
            this.nativesLoaded = true;
        }
        catch (Throwable throwable) {
            log.error("Unable load usbmon native", throwable);
        }
        return this.nativesLoaded;
    }

    public void doStationStarted(BStation bStation) {
        super.doStationStarted(bStation);
        this.register0();
    }

    protected void mount(BUsbFlashDrive bUsbFlashDrive) {
        int n;
        block16: {
            Object object = null;
            int n2 = -1;
            n = -1;
            int n3 = -1;
            int n4 = -1;
            String string = "usb" + this.toHexString(bUsbFlashDrive.getPath(), 2) + this.toHexString(bUsbFlashDrive.getDevno(), 2);
            log.trace("mounting device " + string);
            StringBuffer stringBuffer = new StringBuffer("/proc/boot/devb-umass umass ");
            stringBuffer.append("vid=0x").append(Integer.toHexString(bUsbFlashDrive.getVid()));
            stringBuffer.append(",did=0x").append(Integer.toHexString(bUsbFlashDrive.getDid()));
            stringBuffer.append(",busno=0x").append(Integer.toHexString(bUsbFlashDrive.getPath()));
            stringBuffer.append(",devno=0x").append(Integer.toHexString(bUsbFlashDrive.getDevno()));
            stringBuffer.append(" disk name=").append(string).append("_");
            stringBuffer.append(" dos hidden=dot,vollabel=show,exe=none");
            log.trace("  umass cmd: " + stringBuffer.toString());
            try {
                n = QnxNativeUtil.spawn((String)stringBuffer.toString());
                if (n > 0) {
                    Object object2;
                    int n5 = 0;
                    File file = new File("/dev");
                    UsbFilenameFilter usbFilenameFilter = new UsbFilenameFilter(string + '_');
                    n5 = 0;
                    while (n5 < 10) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                        object2 = file.list(usbFilenameFilter);
                        if (((String[])object2).length > 1) {
                            Arrays.sort(object2);
                            if (((String)object2[1]).indexOf(116) > 0) {
                                n2 = Integer.parseInt(((String)object2[1]).substring(((String)object2[1]).indexOf(116) + 1));
                                object = object2[1];
                                bUsbFlashDrive.setFsType(this.getFsTypeFromTypeNum(n2));
                                break;
                            }
                        }
                        ++n5;
                    }
                    if (n5 == 10) {
                        log.message("usb flashdrive " + string + " does not have any valid partition info");
                        this.terminate(n, 2000);
                        return;
                    }
                    if (bUsbFlashDrive.getFsType() == BUsbFsTypeEnum.unknown) {
                        log.message("usb flashdrive " + string + " does not have a supported partition");
                        this.terminate(n, 2000);
                        return;
                    }
                    stringBuffer = new StringBuffer("/proc/boot/mount");
                    stringBuffer.append(" -t ").append(bUsbFlashDrive.getFsType().toString().toLowerCase());
                    stringBuffer.append(" /dev/" + object);
                    object2 = Sys.getStationHome();
                    stringBuffer.append(" ").append(object2 + '/' + string);
                    log.trace("mount cmd: " + stringBuffer.toString());
                    n3 = QnxNativeUtil.spawn((String)stringBuffer.toString());
                    if (n3 <= 0) {
                        this.terminate(n, 2000);
                        throw new UsbmonException("error launching mount command");
                    }
                    QnxNativeUtil.waitFor((File)new File(object2 + '/' + string), (int)10);
                    bUsbFlashDrive.setMountPoint(object2 + '/' + string);
                    if (bUsbFlashDrive.getFsType() == BUsbFsTypeEnum.qnx4) {
                        stringBuffer = new StringBuffer("/proc/boot/chkfsys");
                        stringBuffer.append(" -Pqs ");
                        stringBuffer.append(bUsbFlashDrive.getMountPoint());
                    } else {
                        stringBuffer = new StringBuffer("/proc/boot/chkdosfs");
                        stringBuffer.append(" -puy ");
                        stringBuffer.append(bUsbFlashDrive.getMountPoint());
                    }
                    log.trace("disk check cmd: " + stringBuffer.toString());
                    n4 = QnxNativeUtil.spawn((String)stringBuffer.toString());
                    if (n4 < 0) {
                        this.terminate(n4, 2000);
                        throw new UsbmonException("error launching disk check command");
                    }
                    WaitPidResponse waitPidResponse = QnxNativeUtil.waitPid((int)n4, (int)0);
                    if (waitPidResponse.getRc() == -1 || waitPidResponse.WEXITSTATUS() != 0) {
                        throw new UsbmonException("error running disk check: " + waitPidResponse.toString());
                    }
                    break block16;
                }
                throw new UsbmonException("unable to launch devb-umass driver");
            }
            catch (Exception exception) {
                log.trace("unable to mount flashdrive", (Throwable)exception);
                if (n > 0) {
                    this.terminate(n, 2000);
                }
                return;
            }
        }
        bUsbFlashDrive.add("pid", (BValue)BInteger.make((int)n), 7);
    }

    protected void umount(BUsbFlashDrive bUsbFlashDrive) {
        log.trace("unmounting device " + bUsbFlashDrive.summaryString());
        BInteger bInteger = (BInteger)bUsbFlashDrive.get("pid");
        if (bInteger != null && bInteger.getInt() > 0) {
            this.terminate(bInteger.getInt(), 2000);
        }
    }

    private final BUsbFsTypeEnum getFsTypeFromTypeNum(int n) {
        switch (n) {
            case 77: 
            case 78: 
            case 79: {
                return BUsbFsTypeEnum.qnx4;
            }
            case 1: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                return BUsbFsTypeEnum.dos;
            }
        }
        return BUsbFsTypeEnum.unknown;
    }

    private final void terminate(int n, int n2) {
        long l = Clock.ticks();
        int n3 = n2 < 500 ? n2 : 500;
        QnxNativeUtil.kill((int)n, (int)15);
        while (Clock.ticks() - l < (long)n2) {
            WaitPidResponse waitPidResponse = QnxNativeUtil.waitPid((int)n, (int)65);
            if (waitPidResponse.getRc() == n) {
                return;
            }
            try {
                Thread.sleep(n3);
            }
            catch (Exception exception) {}
        }
        QnxNativeUtil.kill((int)n, (int)9);
    }

    private final native void register0();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.nativesLoaded = false;
    }

    public BUsbMonitorPlatformServiceQnx() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platUsbmon$BUsbMonitorPlatformServiceQnx;
        if (clazz == null) {
            clazz = class$com$tridium$platUsbmon$BUsbMonitorPlatformServiceQnx = BUsbMonitorPlatformServiceQnx.class("[Lcom.tridium.platUsbmon.BUsbMonitorPlatformServiceQnx;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UsbFilenameFilter
    implements FilenameFilter {
        private String mask;

        public boolean accept(File file, String string) {
            return string.startsWith(this.mask);
        }

        public UsbFilenameFilter(String string) {
            this.mask = string;
        }
    }
}

