/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pacman.api;

import com.tridium.pacman.api.XLicense;
import com.tridium.pacman.api.XMessage;
import com.tridium.sys.NreLib;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class PacmanApi {
    public static final BIpHost HOST = new BIpHost("pacman.tridium.com");
    public static final BModule module = Sys.loadModule((String)"pacmanApi");
    public static final Version version = module.getVendorVersion();
    public static final String myHostId = NreLib.getHostId();

    public static XLicense getLicense(String string) throws Exception {
        XMessage xMessage = new XMessage("/api30/getLicense");
        xMessage.body.addAttr("hostId", string);
        XMessage xMessage2 = PacmanApi.post(xMessage);
        XElem xElem = xMessage2.body.elem("license");
        if (xElem == null) {
            return null;
        }
        return XLicense.decode(xElem);
    }

    public static XLicense submitLicense(XLicense xLicense, boolean bl) throws Exception {
        XMessage xMessage = new XMessage("/api30/submitLicense");
        xMessage.body.addAttr("hostId", xLicense.hostId);
        xMessage.body.addAttr("emailIfActive", "" + bl);
        xMessage.body.addContent((XContent)xLicense.encode("license"));
        XMessage xMessage2 = PacmanApi.post(xMessage);
        XElem xElem = xMessage2.body.elem("license");
        if (xElem == null) {
            return null;
        }
        return XLicense.decode(xElem);
    }

    public static XMessage get(String string) throws Exception {
        HttpConnection httpConnection = new HttpConnection((BHost)HOST, 80, string);
        httpConnection.connect();
        httpConnection.checkOk();
        byte[] byArray = httpConnection.readContent();
        return new XMessage(string).fromBytes(byArray);
    }

    public static XMessage post(XMessage xMessage) throws Exception {
        byte[] byArray = xMessage.toBytes();
        HttpConnection httpConnection = new HttpConnection((BHost)HOST, 80);
        httpConnection.post(xMessage.uri, "text/xml", byArray);
        httpConnection.checkOk();
        byte[] byArray2 = httpConnection.readContent();
        XMessage xMessage2 = new XMessage(xMessage.uri).fromBytes(byArray2);
        return xMessage2;
    }
}

