/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.user.BUserServicePasswordConfiguration;
import com.tridium.workbench.user.BConfirmPasswordFE;
import com.tridium.workbench.util.WbUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public class BUserPasswordFE
extends BConfirmPasswordFE {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$user$BUserPasswordFE == null ? (class$com$tridium$workbench$user$BUserPasswordFE = BUserPasswordFE.class$("com.tridium.workbench.user.BUserPasswordFE")) : class$com$tridium$workbench$user$BUserPasswordFE));
    static final Lexicon lex = UiLexicon.bajaui;
    static /* synthetic */ Class class$com$tridium$workbench$user$BUserPasswordFE;
    static /* synthetic */ Class class$com$tridium$user$BUserServicePasswordConfiguration;
    static /* synthetic */ Class class$com$tridium$user$BUserPasswordConfiguration;

    public Type getType() {
        return TYPE;
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        BPassword bPassword = (BPassword)super.doSaveValue(bObject, context);
        BUserService bUserService = (BUserService)WbUtil.findService((BWidget)this, (Type)BUserService.TYPE);
        if (bUserService != null) {
            bUserService.lease();
        }
        if (bUserService != null) {
            bUserService.checkPassword(bPassword.getValue());
            BUser bUser = (BUser)WbUtil.findAncenstorViaWidgetTree((BWidget)this, (Type)BUser.TYPE);
            if (bUser != null && bUserService.canUsePasswordFeatures(bUser)) {
                BUserPasswordFE.checkPasswordHistory(bUser, bPassword, bUserService);
            }
        }
        return bPassword;
    }

    public static void checkPasswordHistory(BUser bUser, BPassword bPassword, BUserService bUserService) throws Exception {
        if (bUserService == null || !bUserService.canUsePasswordFeatures(bUser)) {
            return;
        }
        int n = Integer.MAX_VALUE;
        bUserService.lease();
        BUserServicePasswordConfiguration[] bUserServicePasswordConfigurationArray = (BUserServicePasswordConfiguration[])bUserService.getChildren(class$com$tridium$user$BUserServicePasswordConfiguration == null ? (class$com$tridium$user$BUserServicePasswordConfiguration = BUserPasswordFE.class$("com.tridium.user.BUserServicePasswordConfiguration")) : class$com$tridium$user$BUserServicePasswordConfiguration);
        if (bUserServicePasswordConfigurationArray.length > 0) {
            bUserServicePasswordConfigurationArray[0].lease();
            n = bUserServicePasswordConfigurationArray[0].getPasswordHistoryLength();
        }
        bUser.lease();
        BUserPasswordConfiguration[] bUserPasswordConfigurationArray = (BUserPasswordConfiguration[])bUser.getChildren(class$com$tridium$user$BUserPasswordConfiguration == null ? (class$com$tridium$user$BUserPasswordConfiguration = BUserPasswordFE.class$("com.tridium.user.BUserPasswordConfiguration")) : class$com$tridium$user$BUserPasswordConfiguration);
        if (bUserPasswordConfigurationArray.length > 0) {
            bUserPasswordConfigurationArray[0].lease();
            if (bUserPasswordConfigurationArray[0].getPasswordHistory().contains(bUser.getUsername(), bPassword, n)) {
                throw new LocalizableException("baja", "user.strongPassword.alreadyUsed");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

