/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.workbench.nav.NavMonitor;
import com.tridium.workbench.user.BPermissionGrid;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.view.BWbComponentView;

public class BPermissionsBrowser
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$user$BPermissionsBrowser == null ? (class$com$tridium$workbench$user$BPermissionsBrowser = BPermissionsBrowser.class$("com.tridium.workbench.user.BPermissionsBrowser")) : class$com$tridium$workbench$user$BPermissionsBrowser));
    boolean[] visible;
    int visibleSize;
    int[] viewIdx;
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$user$BPermissionsBrowser == null ? (class$com$tridium$workbench$user$BPermissionsBrowser = BPermissionsBrowser.class$("com.tridium.workbench.user.BPermissionsBrowser")) : class$com$tridium$workbench$user$BPermissionsBrowser));
    BTreeTable table;
    Model model;
    Array roots = new Array(class$com$tridium$workbench$user$BPermissionsBrowser$Node == null ? (class$com$tridium$workbench$user$BPermissionsBrowser$Node = BPermissionsBrowser.class$("com.tridium.workbench.user.BPermissionsBrowser$Node")) : class$com$tridium$workbench$user$BPermissionsBrowser$Node);
    BUserService userService;
    BCategoryService catService;
    BUser[] users;
    BPermissionsMap[] permissions;
    boolean[] dirty;
    static /* synthetic */ Class class$com$tridium$workbench$user$BPermissionsBrowser;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;
    static /* synthetic */ Class class$com$tridium$workbench$user$BPermissionsBrowser$Node;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public Type getType() {
        return TYPE;
    }

    public BPermissionsBrowser() {
        this.autoRegisterForComponentEvents = false;
        this.table = new BTreeTable();
        this.table.setMultipleSelection(false);
        this.model = new Model();
        this.table.setModel((TableModel)this.model);
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setController((TableController)new Controller());
        this.setContent((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT));
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this.model);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this.model);
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui.buildMenu("CategoryBrowser");
        bMenu.add(null, (Command)new ShowConfigured());
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)new ShowConfigured());
        return bToolBar;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.userService = (BUserService)bObject;
        this.registerForComponentEvents((BComponent)this.userService, 2);
        this.catService = (BCategoryService)BOrd.make((String)"service:baja:CategoryService").resolve((BObject)this.userService).get();
        this.registerForComponentEvents((BComponent)this.catService, 1);
        BComponent bComponent = this.userService.getComponentSpace().getRootComponent();
        Node node = new Node(this.model, (BINavNode)bComponent);
        this.roots = new Array(class$com$tridium$workbench$user$BPermissionsBrowser$Node == null ? (class$com$tridium$workbench$user$BPermissionsBrowser$Node = BPermissionsBrowser.class$("com.tridium.workbench.user.BPermissionsBrowser$Node")) : class$com$tridium$workbench$user$BPermissionsBrowser$Node);
        this.roots.add((Object)node);
        this.users = (BUser[])this.userService.getChildren(class$javax$baja$user$BUser == null ? (class$javax$baja$user$BUser = BPermissionsBrowser.class$("javax.baja.user.BUser")) : class$javax$baja$user$BUser);
        this.permissions = new BPermissionsMap[this.users.length];
        this.dirty = new boolean[this.users.length];
        for (int i = 0; i < this.users.length; ++i) {
            this.permissions[i] = this.users[i].getPermissions();
        }
        this.addRoot((BINavNode)BOrd.make((String)"file:").get(bObject));
        this.addRoot((BINavNode)BOrd.make((String)"history:").get(bObject));
        this.loadVisible(this.users.length);
        if (!this.model.needsInitialization()) {
            this.model.updateTreeTable(true);
        }
    }

    private void addRoot(BINavNode bINavNode) {
        try {
            if (bINavNode instanceof BIProtected) {
                this.roots.add((Object)new Node(this.model, bINavNode));
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot add root: " + bINavNode.getNavOrd());
            System.out.println("  " + exception);
        }
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception {
        for (int i = 0; i < this.users.length; ++i) {
            if (!this.dirty[i]) continue;
            this.users[i].setPermissions(this.permissions[i]);
        }
        return this.userService;
    }

    private void updateVisible() {
        this.visibleSize = 0;
        for (int i = 0; i < this.visible.length; ++i) {
            if (!this.visible[i]) continue;
            this.viewIdx[this.visibleSize++] = i;
        }
    }

    private void loadVisible(int n) {
        this.visible = new boolean[n];
        this.viewIdx = new int[n];
        this.visibleSize = n;
        for (int i = 0; i < n; ++i) {
            this.visible[i] = true;
            this.viewIdx[i] = i;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConfigureColumns
    extends Command {
        ConfigureColumns(boolean bl) {
            super((BWidget)BPermissionsBrowser.this, lex.getText("permission.show"));
        }

        public CommandArtifact doInvoke() {
            int n;
            BCheckList bCheckList = new BCheckList();
            for (n = 0; n < BPermissionsBrowser.this.users.length; ++n) {
                bCheckList.addItem((Object)BPermissionsBrowser.this.users[n].getDisplayName(null));
            }
            bCheckList.getSelection().deselectAll();
            for (n = 0; n < BPermissionsBrowser.this.users.length; ++n) {
                if (!BPermissionsBrowser.this.visible[n]) continue;
                bCheckList.getSelection().select(n);
            }
            BDialog.open((BWidget)BPermissionsBrowser.this, (String)lex.getText("permission.users"), (Object)bCheckList, (int)1);
            for (n = 0; n < BPermissionsBrowser.this.users.length; ++n) {
                BPermissionsBrowser.this.visible[n] = bCheckList.getSelection().isSelected(n);
            }
            BPermissionsBrowser.this.updateVisible();
            BPermissionsBrowser.this.table.relayout();
            return null;
        }
    }

    class ShowAllColumns
    extends Command {
        boolean show;

        ShowAllColumns(boolean bl) {
            super((BWidget)BPermissionsBrowser.this, bl ? lex.getText("permission.showAll") : lex.getText("permission.hideAll"));
            this.show = bl;
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < BPermissionsBrowser.this.visible.length; ++i) {
                BPermissionsBrowser.this.visible[i] = this.show;
            }
            BPermissionsBrowser.this.updateVisible();
            BPermissionsBrowser.this.table.relayout();
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            if (n2 == 0) {
                super.cellDoubleClicked(bMouseEvent, n, n2);
            } else {
                BUser bUser;
                if (BPermissionsBrowser.this.permissions[BPermissionsBrowser.this.viewIdx[n2 - 1]].isSuperUser()) {
                    BDialog.warning((BWidget)BPermissionsBrowser.this, (String)lex.getText("permission.generic", new Object[]{BPermissionsBrowser.this.users[BPermissionsBrowser.this.viewIdx[n2 - 1]].getDisplayName(null)}), (Object)lex.getText("permission.cannotModifySuperUser"));
                    return;
                }
                BPermissionsMap bPermissionsMap = BPermissionsMap.SUPER_USER;
                Context context = BPermissionsBrowser.this.getCurrentContext();
                BString bString = (BString)context.getFacet("username");
                if (bString != null && (bUser = ((BUserService)BPermissionsBrowser.this.getCurrentValue()).getUser(bString.toString())) != null) {
                    bPermissionsMap = bUser.getPermissions();
                }
                if ((bUser = BPermissionGrid.open(BPermissionsBrowser.this.getWbShell(), BPermissionsBrowser.this.permissions[BPermissionsBrowser.this.viewIdx[n2 - 1]], bPermissionsMap, lex.getText("permission.generic", new Object[]{BPermissionsBrowser.this.users[BPermissionsBrowser.this.viewIdx[n2 - 1]].getDisplayName(null)}))) != null) {
                    BPermissionsBrowser.this.permissions[BPermissionsBrowser.this.viewIdx[n2 - 1]] = bUser;
                    BPermissionsBrowser.this.dirty[BPermissionsBrowser.this.viewIdx[n2 - 1]] = true;
                    BPermissionsBrowser.this.setModified();
                    BPermissionsBrowser.this.repaint();
                }
            }
        }

        protected BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)new ShowAllColumns(true));
            bMenu.add(null, (Command)new ShowAllColumns(false));
            bMenu.add(null, (Command)new ConfigureColumns(false));
            return bMenu;
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        BBrush CONFIGURED = BColor.make((int)0xFFFFBB).toBrush();
        BBrush EXPANDER_BRUSH = BColor.black.toBrush();
        BBrush CONNECTING_BRUSH = BColor.make((int)192, (int)192, (int)192).toBrush();
        BBrush DISABLED = BColor.make((String)"#666").toBrush();

        Renderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                return super.getForeground(cell);
            }
            if (BPermissionsBrowser.this.permissions[BPermissionsBrowser.this.viewIdx[cell.column - 1]].isSuperUser()) {
                return Theme.widget().getControlShadow();
            }
            return super.getForeground(cell);
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            Node node = (Node)BPermissionsBrowser.this.model.rowToNode(cell.row);
            if (!node.inherited()) {
                return this.CONFIGURED;
            }
            return super.getBackground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            this.paintCellBackground(graphics, cell);
            BBrush bBrush = graphics.getBrush();
            if (cell.column == 0) {
                String string;
                BImage bImage;
                double d;
                TreeTableTheme treeTableTheme = Theme.treeTable();
                Node node = (Node)BPermissionsBrowser.this.model.rowToNode(cell.row);
                int n = node.getDepth();
                double d2 = treeTableTheme.getIndent(n);
                if (BPermissionsBrowser.this.model.isDepthExpandable(n)) {
                    if (node.hasChildren()) {
                        int n2 = node.isExpanded() ? 2 : 1;
                        d = (cell.height - treeTableTheme.getExpanderHeight()) / 2.0;
                        this.paintExpander(graphics, treeTableTheme, d2, d, n2);
                    }
                    d2 += treeTableTheme.getExpanderWidth() + 5.0;
                }
                if ((bImage = BPermissionsBrowser.this.model.getRowIcon(cell.row)) != null) {
                    d = (cell.height - 16.0) / 2.0;
                    if (node.inherited()) {
                        graphics.drawImage(bImage.getDisabledImage(), d2, d);
                    } else {
                        graphics.drawImage(bImage, d2, d);
                    }
                    d2 += 18.0;
                }
                if ((string = this.getCellText(cell)) != null && string.length() > 0) {
                    BFont bFont = Theme.table().getCellFont();
                    if (node.inherited()) {
                        graphics.setBrush(this.DISABLED);
                    } else {
                        graphics.setBrush(bBrush);
                    }
                    graphics.setFont(bFont);
                    graphics.drawString(string, d2, bFont.getAscent() + 2.0);
                }
            } else {
                Node node = (Node)BPermissionsBrowser.this.model.rowToNode(cell.row);
                String string = this.getCellText(cell);
                if (string != null && string.length() > 0) {
                    BFont bFont = Theme.table().getCellFont();
                    if (node.inherited()) {
                        graphics.setBrush(this.DISABLED);
                    } else {
                        graphics.setBrush(bBrush);
                    }
                    graphics.setFont(bFont);
                    graphics.drawString(string, 2.0, bFont.getAscent() + 2.0);
                }
            }
            this.paintVerticalLine(graphics, cell);
        }

        private void paintExpander(Graphics graphics, TreeTableTheme treeTableTheme, double d, double d2, int n) {
            BBrush bBrush = graphics.getBrush();
            graphics.setBrush(this.CONNECTING_BRUSH);
            double d3 = treeTableTheme.getExpanderWidth();
            double d4 = treeTableTheme.getExpanderHeight();
            graphics.strokeLine(d, d2, d + d3 - 1.0, d2);
            graphics.strokeLine(d, d2, d, d2 + d3 - 1.0);
            graphics.strokeLine(d + d3 - 1.0, d2, d + d3 - 1.0, d2 + d4 - 1.0);
            graphics.strokeLine(d, d2 + d4 - 1.0, d + d3 - 1.0, d2 + d4 - 1.0);
            graphics.setBrush(this.EXPANDER_BRUSH);
            if (n != 0) {
                graphics.strokeLine(d + 2.0, d2 + 4.0, d + 6.0, d2 + 4.0);
            }
            if (n == 1) {
                graphics.strokeLine(d + 4.0, d2 + 2.0, d + 4.0, d2 + 6.0);
            }
            graphics.setBrush(bBrush);
        }
    }

    class Node
    extends TreeTableNode {
        BINavNode nav;
        BOrd categorizableOrd;
        String categorizableOrdRelStr;
        String navOrdRelStr;
        Node[] kids;
        BImage icon;
        BCategoryMask mask;
        boolean isRoot;
        boolean performFullLoad = false;
        boolean buildChildren = false;

        Node(Model model, BINavNode bINavNode) {
            super((TreeTableModel)model);
            this.nav = bINavNode;
            this.isRoot = true;
            this.init();
            if (this.mask == null) {
                this.mask = BCategoryMask.make((String)"1");
            }
        }

        Node(Node node, BINavNode bINavNode) {
            super((TreeTableNode)node);
            this.nav = bINavNode;
            this.isRoot = false;
            this.init();
        }

        void init() {
            if (!(this.nav instanceof BIProtected)) {
                throw new IllegalStateException(this.nav.getClass().getName() + " is not BIProtected");
            }
            boolean bl = this.nav instanceof BVirtualComponent;
            BOrd bOrd = this.nav.getNavOrd();
            BOrd bOrd2 = bOrd.relativizeToSession();
            this.categorizableOrd = bl ? ((BVirtualComponent)this.nav).getCategorizableOrd().relativizeToSession() : bOrd2;
            this.categorizableOrdRelStr = this.categorizableOrd.toString();
            this.navOrdRelStr = bOrd2.toString();
            this.icon = BImage.make((BIcon)this.nav.getNavIcon());
            this.mask = this.nav instanceof BComponent && !bl ? ((BIProtected)this.nav).getCategoryMask() : BPermissionsBrowser.this.catService.getOrdMap().getCategoryMask(this.categorizableOrd);
        }

        public Object getSubject() {
            return this.nav;
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                return this.nav.getNavDisplayName(null);
            }
            return BPermissionsBrowser.this.permissions[BPermissionsBrowser.this.viewIdx[n - 1]].getPermissions(this.applied());
        }

        public BImage getIcon() {
            return this.icon;
        }

        public boolean hasChildren() {
            if (this.kids == null) {
                return true;
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            this.build();
            return this.kids.length;
        }

        public TreeTableNode getChild(int n) {
            this.build();
            return this.kids[n];
        }

        boolean inherited() {
            return this.mask == null || this.mask.isNull();
        }

        BCategoryMask applied() {
            if (this.inherited()) {
                return ((Node)this.getParent()).applied();
            }
            return this.mask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build() {
            if (this.buildChildren || this.kids == null) {
                this.buildChildren = false;
                BPermissionsBrowser.this.enterBusy();
                try {
                    BINavNode[] bINavNodeArray = this.nav.getNavChildren();
                    Array array = new Array(class$com$tridium$workbench$user$BPermissionsBrowser$Node == null ? (class$com$tridium$workbench$user$BPermissionsBrowser$Node = BPermissionsBrowser.class$("com.tridium.workbench.user.BPermissionsBrowser$Node")) : class$com$tridium$workbench$user$BPermissionsBrowser$Node);
                    for (int i = 0; i < bINavNodeArray.length; ++i) {
                        if (!(bINavNodeArray[i] instanceof BIProtected)) continue;
                        array.add((Object)new Node(this, bINavNodeArray[i]));
                    }
                    this.kids = (Node[])array.trim();
                }
                finally {
                    BPermissionsBrowser.this.exitBusy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expanded() {
            NavMonitor navMonitor;
            if (this.performFullLoad) {
                this.performFullLoad = false;
                this.buildChildren = true;
            }
            if ((navMonitor = NavMonitor.get()) != null) {
                NavMonitor navMonitor2 = navMonitor;
                synchronized (navMonitor2) {
                    navMonitor.notify();
                }
            }
        }
    }

    class Model
    extends TreeTableModel
    implements NavListener {
        Model() {
        }

        public int getRootCount() {
            return BPermissionsBrowser.this.roots.size();
        }

        public TreeTableNode getRoot(int n) {
            return (Node)((Object)BPermissionsBrowser.this.roots.get(n));
        }

        public int getColumnCount() {
            return BPermissionsBrowser.this.visibleSize + 1;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "";
            }
            return BPermissionsBrowser.this.users[BPermissionsBrowser.this.viewIdx[n - 1]].getDisplayName(null);
        }

        public void navEvent(NavEvent navEvent) {
            Node node;
            if (navEvent.getId() == 2 && (node = this.eventToNode(navEvent)) != null && node.nav instanceof BComponent) {
                BComponent bComponent = (BComponent)node.nav;
                if (bComponent instanceof BVirtualGateway) {
                    try {
                        bComponent = ((BVirtualGateway)bComponent).getVirtualSpace().getRootComponent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                    node.performFullLoad = true;
                }
            }
        }

        Node eventToNode(NavEvent navEvent) {
            BOrd bOrd = navEvent.getParentOrd();
            if (bOrd == null) {
                return null;
            }
            String string = bOrd.relativizeToSession().toString();
            Node node = null;
            for (int i = 0; i < BPermissionsBrowser.this.roots.size() && (node = this.findNodeByNavOrd(string, (Node)((Object)BPermissionsBrowser.this.roots.get(i)))) == null; ++i) {
            }
            return node;
        }

        Node findNodeByNavOrd(String string, Node node) {
            Node[] nodeArray;
            if (string.equals(node.navOrdRelStr)) {
                return node;
            }
            if (string.startsWith(node.navOrdRelStr) && (nodeArray = node.kids) != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node node2 = this.findNodeByNavOrd(string, nodeArray[i]);
                    if (node2 == null) continue;
                    return node2;
                }
            }
            return null;
        }
    }

    class ShowConfigured
    extends Command {
        ShowConfigured() {
            super((BWidget)BPermissionsBrowser.this, lex, "category.showConfigured");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            BPermissionsBrowser.this.enterBusy();
            try {
                int n;
                BOrd bOrd = BOrd.make((String)"station:|slot:/|bql:select navOrd from baja:Component where not categoryMask.isNull");
                BITable bITable = ((BICollection)bOrd.resolve((BObject)BPermissionsBrowser.this.userService).get()).toTable();
                Column column = bITable.getColumns().get(0);
                TableCursor tableCursor = (TableCursor)bITable.cursor();
                Array array = new Array(class$javax$baja$naming$BOrd == null ? (class$javax$baja$naming$BOrd = BPermissionsBrowser.class$("javax.baja.naming.BOrd")) : class$javax$baja$naming$BOrd);
                while (tableCursor.next()) {
                    array.add((Object)BOrd.make((String)tableCursor.get(column).toString(null)).relativizeToSession());
                }
                BOrd[] bOrdArray = (BOrd[])array.trim();
                new BatchResolve(bOrdArray).resolve((BObject)BPermissionsBrowser.this.userService);
                for (int i = 0; i < bOrdArray.length; ++i) {
                    String string = bOrdArray[i].toString();
                    for (n = 0; n < BPermissionsBrowser.this.roots.size(); ++n) {
                        this.checkNode(string, (Node)((Object)BPermissionsBrowser.this.roots.get(n)));
                    }
                }
                BOrdToCategoryMap bOrdToCategoryMap = BPermissionsBrowser.this.catService.getOrdMap();
                int n2 = bOrdToCategoryMap.size();
                for (n = 0; n < n2; ++n) {
                    String string = bOrdToCategoryMap.getOrd(n).relativizeToSession().toString();
                    for (int i = 0; i < BPermissionsBrowser.this.roots.size(); ++i) {
                        this.checkNode(string, (Node)((Object)BPermissionsBrowser.this.roots.get(i)));
                    }
                }
            }
            finally {
                BPermissionsBrowser.this.exitBusy();
            }
            return null;
        }

        private void checkNode(String string, Node node) {
            if (string.equals(node.categorizableOrdRelStr)) {
                if (!node.isRoot) {
                    this.expandToRoot((Node)node.getParent());
                }
            } else if (string.startsWith(node.categorizableOrdRelStr)) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.checkNode(string, (Node)node.getChild(i));
                }
            }
        }

        private void expandToRoot(Node node) {
            node.setExpanded(true);
            if (!node.isRoot) {
                this.expandToRoot((Node)node.getParent());
            }
        }
    }
}

