/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.category.Category;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BPermissionGrid
extends BWidget {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$user$BPermissionGrid == null ? (class$com$tridium$workbench$user$BPermissionGrid = BPermissionGrid.class$("com.tridium.workbench.user.BPermissionGrid")) : class$com$tridium$workbench$user$BPermissionGrid));
    static final int CHECK_COUNT = 6;
    static final double CHECKW = 20.0;
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$user$BPermissionGrid == null ? (class$com$tridium$workbench$user$BPermissionGrid = BPermissionGrid.class$("com.tridium.workbench.user.BPermissionGrid")) : class$com$tridium$workbench$user$BPermissionGrid));
    static final String lexTitle = lex.getText("permission.permissions");
    static final String lexCategory = lex.getText("category.category");
    static final String lexOperator = UiLexicon.bajaui.getText("security.operator");
    static final String lexAdmin = UiLexicon.bajaui.getText("security.admin");
    static final String[] lexPermissions = new String[]{UiLexicon.bajaui.getText("security.r").trim(), UiLexicon.bajaui.getText("security.w").trim(), UiLexicon.bajaui.getText("security.i").trim(), UiLexicon.bajaui.getText("security.r").trim(), UiLexicon.bajaui.getText("security.w").trim(), UiLexicon.bajaui.getText("security.i").trim()};
    protected static final BBrush headerGrid = BColor.make((int)50, (int)50, (int)50).toBrush();
    protected static final BBrush gridColor = Theme.table().getGridBrush();
    protected static final BBrush impliedColor = BColor.make((int)-6710887).toBrush();
    static final int OR = 0;
    static final int OW = 1;
    static final int OI = 2;
    static final int AR = 3;
    static final int AW = 4;
    static final int AI = 5;
    Model model;
    protected BTable table;
    BPermissionsMap map;
    protected Row[] rows;
    protected double blockWidth = 0.0;
    static /* synthetic */ Class class$com$tridium$workbench$user$BPermissionGrid;

    public Type getType() {
        return TYPE;
    }

    public static BPermissionsMap open(BWbShell bWbShell, BPermissionsMap bPermissionsMap, BPermissionsMap bPermissionsMap2) {
        return BPermissionGrid.open(bWbShell, bPermissionsMap, bPermissionsMap2, lexTitle);
    }

    public static BPermissionsMap open(BWbShell bWbShell, BPermissionsMap bPermissionsMap, BPermissionsMap bPermissionsMap2, String string) {
        try {
            Category[] categoryArray = Category.load((BWbShell)bWbShell, (int)bPermissionsMap.size()).categories;
            BPermissionGrid bPermissionGrid = new BPermissionGrid(categoryArray, bPermissionsMap, bPermissionsMap2);
            int n = BDialog.open((BWidget)bWbShell, (String)string, (Object)((Object)bPermissionGrid), (int)3);
            if (n != 1) {
                return null;
            }
            return bPermissionGrid.save();
        }
        catch (Throwable throwable) {
            BDialog.error((BWidget)bWbShell, (String)BDialog.TITLE_ERROR, (Object)"Cannot config permissions", (Throwable)throwable);
            return null;
        }
    }

    public BPermissionGrid() {
        throw new IllegalStateException();
    }

    public BPermissionGrid(Category[] categoryArray, BPermissionsMap bPermissionsMap, BPermissionsMap bPermissionsMap2) {
        this.map = bPermissionsMap;
        this.model = new Model();
        this.table = new BTable((TableModel)this.model);
        this.table.setHeaderRenderer((TableHeaderRenderer)new HeaderRenderer());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.table.setController((TableController)new Controller());
        this.table.setOptionsButtonVisible(false);
        this.rows = new Row[categoryArray.length];
        for (int i = 1; i < this.rows.length; ++i) {
            BPermissions bPermissions = BPermissions.all;
            if (bPermissionsMap2 != null && bPermissionsMap2.getPermissions(i) != null) {
                bPermissions = bPermissionsMap2.getPermissions(i);
            }
            this.rows[i] = new Row(categoryArray[i], bPermissionsMap.getPermissions(i), bPermissions);
        }
        this.add("table", (BValue)this.table);
    }

    public BPermissionsMap save() {
        BPermissions[] bPermissionsArray = new BPermissions[this.rows.length];
        for (int i = 1; i < bPermissionsArray.length; ++i) {
            bPermissionsArray[i] = BPermissions.make((int)this.rows[i].toMask());
        }
        return BPermissionsMap.make((BPermissions[])bPermissionsArray);
    }

    public Row[] getSelectedRows() {
        int[] nArray = this.table.getSelection().getRows();
        Row[] rowArray = new Row[nArray.length];
        for (int i = 0; i < rowArray.length; ++i) {
            rowArray[i] = this.rows[nArray[i] + 1];
        }
        return rowArray;
    }

    public void computePreferredSize() {
        this.blockWidth = 20.0;
        BFont bFont = Theme.table().getHeaderFont();
        double d = Math.max(bFont.width(lexOperator), bFont.width(lexAdmin)) + 10.0;
        this.blockWidth = Math.max(this.blockWidth, (double)((int)(d / 3.0)));
        BFont bFont2 = Theme.table().getCellFont();
        double d2 = 0.0;
        for (int i = 0; i < lexPermissions.length; ++i) {
            d2 = Math.max(d2, bFont2.width(lexPermissions[i]) + 10.0);
        }
        this.blockWidth = Math.max(this.blockWidth, d2);
        this.table.computePreferredSize();
        double d3 = this.table.getPreferredWidth();
        if (d3 > 800.0) {
            d3 = 800.0;
        }
        if (d3 < 300.0) {
            d3 = 300.0;
        }
        this.setPreferredSize(d3, 300.0);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.table.setBounds(0.0, 0.0, d, d2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Row {
        public BPermissions max;
        public int index;
        public String display;
        public boolean[] enabled = new boolean[6];
        public boolean[] checks = new boolean[6];
        public boolean[] implied = new boolean[6];

        public Row(Category category, BPermissions bPermissions, BPermissions bPermissions2) {
            this.index = category.index;
            this.display = category.display;
            this.max = bPermissions2;
            this.setPermissions(bPermissions);
        }

        public String toString() {
            return this.display;
        }

        public int toMask() {
            int n = 0;
            if (this.checks[0]) {
                n |= 1;
            }
            if (this.checks[1]) {
                n |= 2;
            }
            if (this.checks[2]) {
                n |= 4;
            }
            if (this.checks[3]) {
                n |= 0x10;
            }
            if (this.checks[4]) {
                n |= 0x20;
            }
            if (this.checks[5]) {
                n |= 0x40;
            }
            return n;
        }

        public void setPermissions(BPermissions bPermissions) {
            this.checks[0] = bPermissions.hasOperatorRead();
            this.checks[1] = bPermissions.hasOperatorWrite();
            this.checks[2] = bPermissions.hasOperatorInvoke();
            this.checks[3] = bPermissions.hasAdminRead();
            this.checks[4] = bPermissions.hasAdminWrite();
            this.checks[5] = bPermissions.hasAdminInvoke();
            this.enabled[0] = this.max.hasOperatorRead() || this.max.hasAdminRead() || bPermissions.hasOperatorRead();
            this.enabled[1] = this.max.hasOperatorWrite() || this.max.hasAdminWrite() || bPermissions.hasOperatorWrite();
            this.enabled[2] = this.max.hasOperatorInvoke() || this.max.hasAdminInvoke() || bPermissions.hasOperatorInvoke();
            this.enabled[3] = this.max.hasAdminRead() || bPermissions.hasAdminRead();
            this.enabled[4] = this.max.hasAdminWrite() || bPermissions.hasAdminWrite();
            this.enabled[5] = this.max.hasAdminInvoke() || bPermissions.hasAdminInvoke();
            this.calculateImplied();
        }

        public void setCheck(int n, boolean bl) {
            if (this.enabled[n]) {
                this.checks[n] = bl;
            }
            this.calculateImplied();
        }

        public void calculateImplied() {
            int n;
            for (n = 0; n < this.implied.length; ++n) {
                this.implied[n] = false;
            }
            if (this.checks[1]) {
                this.implied[0] = true;
            }
            if (this.checks[3]) {
                this.implied[0] = true;
            }
            if (this.checks[4]) {
                this.implied[3] = true;
                this.implied[1] = true;
                this.implied[0] = true;
            }
            if (this.checks[5]) {
                this.implied[2] = true;
            }
            for (n = 0; n < this.implied.length; ++n) {
                if (!this.implied[n]) continue;
                this.checks[n] = false;
            }
        }
    }

    protected class Controller
    extends TableController {
        protected Controller() {
        }

        protected void headerPressed(BMouseEvent bMouseEvent, int n) {
            if (n != 1) {
                super.headerPressed(bMouseEvent, n);
                return;
            }
            RectGeom rectGeom = BPermissionGrid.this.table.getHeaderBounds(n);
            double d = bMouseEvent.getX() - rectGeom.x;
            double d2 = bMouseEvent.getY() - rectGeom.y;
            if (d2 < 18.0) {
                return;
            }
            int n2 = (int)(d / BPermissionGrid.this.blockWidth);
            if (n2 >= 6) {
                return;
            }
            Row[] rowArray = BPermissionGrid.this.getSelectedRows();
            if (rowArray.length == 0) {
                return;
            }
            boolean bl = !rowArray[0].checks[n2];
            for (int i = 0; i < rowArray.length; ++i) {
                rowArray[i].setCheck(n2, bl);
            }
            BPermissionGrid.this.repaint();
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            if (n2 != 1) {
                super.cellPressed(bMouseEvent, n, n2);
                return;
            }
            RectGeom rectGeom = BPermissionGrid.this.table.getCellBounds(n, n2);
            double d = bMouseEvent.getX() - rectGeom.x;
            int n3 = (int)(d / BPermissionGrid.this.blockWidth);
            if (n3 >= 6) {
                return;
            }
            Row row = BPermissionGrid.this.rows[n + 1];
            boolean bl = !row.checks[n3];
            row.setCheck(n3, bl);
            BPermissionGrid.this.repaint();
        }
    }

    protected class CellRenderer
    extends TableCellRenderer {
        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            Row row = (Row)cell.value;
            if (cell.column == 1) {
                return BPermissionGrid.this.blockWidth * 6.0;
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            Row row = (Row)cell.value;
            BTable bTable = this.getTable();
            BBrush bBrush = Theme.table().getTextBrush((IStylable)bTable);
            BBrush bBrush2 = Theme.table().getControlBackground((IStylable)bTable);
            if (cell.column == 0 && cell.selected) {
                bBrush = Theme.table().getSelectionForeground((IStylable)bTable);
                bBrush2 = Theme.table().getSelectionBackground((IStylable)bTable);
            }
            graphics.setBrush(bBrush2);
            graphics.fillRect(0.0, 0.0, cell.width, cell.height);
            graphics.setBrush(bBrush);
            graphics.setFont(Theme.table().getCellFont());
            if (cell.column == 0) {
                graphics.drawString(row.display, 3.0, cell.height - 3.0);
            } else if (cell.column == 1) {
                this.paintPermission(graphics, cell, row);
            }
        }

        public void paintPermission(Graphics graphics, TableCellRenderer.Cell cell, Row row) {
            for (int i = 0; i < row.checks.length; ++i) {
                double d = (double)i * BPermissionGrid.this.blockWidth;
                boolean bl = row.checks[i];
                boolean bl2 = row.implied[i];
                boolean bl3 = row.enabled[i];
                if (!bl3) {
                    BBrush bBrush = this.getTable().getGridBrush();
                    if (!bBrush.isNull()) {
                        graphics.setBrush(bBrush);
                    } else {
                        graphics.setBrush(Theme.table().getGridBrush());
                    }
                    graphics.fillRect(d + 1.0, 0.0, BPermissionGrid.this.blockWidth - 1.0, BPermissionGrid.this.blockWidth);
                }
                if (bl || bl2) {
                    if (bl2) {
                        graphics.setBrush(impliedColor);
                    } else {
                        graphics.setBrush(BColor.make((int)-16744448));
                    }
                    double d2 = d + (BPermissionGrid.this.blockWidth - 6.0) / 2.0;
                    double d3 = 5.0;
                    graphics.strokeLine(d2, d3 + 4.0, d2 + 2.0, d3 + 6.0);
                    graphics.strokeLine(d2 + 1.0, d3 + 4.0, d2 + 2.0, d3 + 5.0);
                    graphics.strokeLine(d2 + 1.0, d3 + 3.0, d2 + 3.0, d3 + 5.0);
                    graphics.strokeLine(d2 + 2.0, d3 + 4.0, d2 + 6.0, d3);
                    graphics.strokeLine(d2 + 2.0, d3 + 5.0, d2 + 6.0, d3 + 1.0);
                    graphics.strokeLine(d2 + 3.0, d3 + 5.0, d2 + 7.0, d3 + 1.0);
                }
                graphics.setBrush(gridColor);
                graphics.strokeLine(d + BPermissionGrid.this.blockWidth, 0.0, d + BPermissionGrid.this.blockWidth, cell.height);
            }
        }
    }

    protected class HeaderRenderer
    extends TableHeaderRenderer {
        protected HeaderRenderer() {
        }

        public double getHeaderHeight() {
            return 35.0;
        }

        public double getPreferredHeaderWidth(TableHeaderRenderer.Header header) {
            if (header.column == 1) {
                return BPermissionGrid.this.blockWidth * 6.0;
            }
            return super.getPreferredHeaderWidth(header) + 20.0;
        }

        public void paintHeader(Graphics graphics, TableHeaderRenderer.Header header) {
            Theme.table().paintHeaderBackground(graphics, header, this.getBackground(header));
            BFont bFont = Theme.table().getHeaderFont();
            graphics.setFont(bFont);
            BBrush bBrush = this.getForeground(header);
            graphics.setBrush(bBrush);
            if (header.column == 0) {
                graphics.drawString(lexCategory, 5.0, 22.0);
                if (this.getTable().getSortColumn() == header.column) {
                    boolean bl = this.getTable().isSortAscending();
                    Theme.table().paintSortIcon(graphics, header, bl);
                }
            } else {
                double d = bFont.width(lexOperator);
                graphics.drawString(lexOperator, (BPermissionGrid.this.blockWidth * 3.0 - d) / 2.0, 15.0);
                d = bFont.width(lexAdmin);
                graphics.drawString(lexAdmin, BPermissionGrid.this.blockWidth * 3.0 + (BPermissionGrid.this.blockWidth * 3.0 - d) / 2.0, 15.0);
                for (int i = 0; i < 6; ++i) {
                    double d2 = BPermissionGrid.this.blockWidth * (double)i;
                    String string = lexPermissions[i];
                    d = bFont.width(string);
                    graphics.setBrush(bBrush);
                    graphics.drawString(string, d2 + 2.0 + (BPermissionGrid.this.blockWidth - d) / 2.0, 31.0);
                    graphics.setBrush(headerGrid);
                    graphics.strokeLine(d2 + BPermissionGrid.this.blockWidth + 1.0, 19.0, d2 + BPermissionGrid.this.blockWidth + 1.0, 31.0);
                }
                graphics.setBrush(headerGrid);
                graphics.strokeLine(BPermissionGrid.this.blockWidth * 3.0 + 1.0, 3.0, BPermissionGrid.this.blockWidth * 3.0 + 1.0, 31.0);
            }
        }
    }

    protected class Model
    extends TableModel {
        protected Model() {
        }

        public int getRowCount() {
            return BPermissionGrid.this.rows.length - 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return "?";
        }

        public Object getSubject(int n) {
            return BPermissionGrid.this.rows[n + 1];
        }

        public Object getValueAt(int n, int n2) {
            return BPermissionGrid.this.rows[n + 1];
        }
    }
}

