/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.metadata;

import javax.baja.data.BIDataValue;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public class BMetadataJob
extends BSimpleJob {
    public static final Property command = BMetadataJob.newProperty((int)5, (int)0, null);
    public static final Property navOrds = BMetadataJob.newProperty((int)5, (BValue)BOrdList.NULL, null);
    public static final Property propName = BMetadataJob.newProperty((int)5, (String)"", null);
    public static final Property metadataValue = BMetadataJob.newProperty((int)5, (BValue)BString.DEFAULT, null);
    public static final Property addOrSet = BMetadataJob.newProperty((int)5, (boolean)true, null);
    public static final Property applyDescendants = BMetadataJob.newProperty((int)5, (boolean)true, null);
    public static final Property propFlags = BMetadataJob.newProperty((int)5, (int)16384, null);
    public static final Property propFacets = BMetadataJob.newProperty((int)5, (BValue)BFacets.NULL, null);
    public static final Property username = BMetadataJob.newProperty((int)5, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$metadata$BMetadataJob == null ? (class$com$tridium$workbench$metadata$BMetadataJob = BMetadataJob.class$("com.tridium.workbench.metadata.BMetadataJob")) : class$com$tridium$workbench$metadata$BMetadataJob));
    static final Lexicon lex = Lexicon.make((Class)(class$com$tridium$workbench$metadata$BMetadataBrowser == null ? (class$com$tridium$workbench$metadata$BMetadataBrowser = BMetadataJob.class$("com.tridium.workbench.metadata.BMetadataBrowser")) : class$com$tridium$workbench$metadata$BMetadataBrowser));
    static final BIcon icon = BIcon.std((String)"gears.png");
    static final BIcon addIcon = BIcon.make((String)lex.getText("metadataBrowser.commands.slotAdd.icon"));
    static final BIcon editIcon = BIcon.make((String)lex.getText("metadataBrowser.commands.slotEdit.icon"));
    static final BIcon removeIcon = BIcon.make((String)lex.getText("metadataBrowser.commands.slotRemove.icon"));
    static final int ADD_METADATA = 0;
    static final int EDIT_METADATA = 1;
    static final int REMOVE_METADATA = 2;
    BINavNode[] nodes = null;
    volatile boolean canceled = false;
    static /* synthetic */ Class class$com$tridium$workbench$metadata$BMetadataJob;
    static /* synthetic */ Class class$com$tridium$workbench$metadata$BMetadataBrowser;

    public int getCommand() {
        return this.getInt(command);
    }

    public void setCommand(int n) {
        this.setInt(command, n, null);
    }

    public BOrdList getNavOrds() {
        return (BOrdList)this.get(navOrds);
    }

    public void setNavOrds(BOrdList bOrdList) {
        this.set(navOrds, (BValue)bOrdList, null);
    }

    public String getPropName() {
        return this.getString(propName);
    }

    public void setPropName(String string) {
        this.setString(propName, string, null);
    }

    public BValue getMetadataValue() {
        return this.get(metadataValue);
    }

    public void setMetadataValue(BValue bValue) {
        this.set(metadataValue, bValue, null);
    }

    public boolean getAddOrSet() {
        return this.getBoolean(addOrSet);
    }

    public void setAddOrSet(boolean bl) {
        this.setBoolean(addOrSet, bl, null);
    }

    public boolean getApplyDescendants() {
        return this.getBoolean(applyDescendants);
    }

    public void setApplyDescendants(boolean bl) {
        this.setBoolean(applyDescendants, bl, null);
    }

    public int getPropFlags() {
        return this.getInt(propFlags);
    }

    public void setPropFlags(int n) {
        this.setInt(propFlags, n, null);
    }

    public BFacets getPropFacets() {
        return (BFacets)this.get(propFacets);
    }

    public void setPropFacets(BFacets bFacets) {
        this.set(propFacets, (BValue)bFacets, null);
    }

    public String getUsername() {
        return this.getString(username);
    }

    public void setUsername(String string) {
        this.setString(username, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMetadataJob() {
    }

    public BMetadataJob(int n, BINavNode[] bINavNodeArray, String string, BValue bValue, boolean bl, boolean bl2, Context context) {
        this(n, bINavNodeArray, string, bValue, bl, bl2, 16384, null, context);
    }

    public BMetadataJob(int n, BINavNode[] bINavNodeArray, String string, BValue bValue, boolean bl, boolean bl2, int n2, BFacets bFacets, Context context) {
        this.setCommand(n);
        int n3 = bINavNodeArray != null ? bINavNodeArray.length : 0;
        BOrd[] bOrdArray = new BOrd[n3];
        for (int i = 0; i < n3; ++i) {
            bOrdArray[i] = bINavNodeArray[i].getNavOrd().relativizeToSession();
        }
        this.setNavOrds(BOrdList.make((BOrd[])bOrdArray));
        if (string != null) {
            this.setPropName(string);
        }
        if (bValue != null) {
            this.setMetadataValue(bValue.newCopy(true));
        }
        this.setAddOrSet(bl);
        this.setApplyDescendants(bl2);
        this.setPropFlags(n2);
        if (bFacets != null) {
            this.setPropFacets(bFacets);
        }
        if (context != null) {
            BUser bUser = context.getUser();
            if (bUser != null) {
                this.setUsername(bUser.getUsername());
            } else {
                BObject bObject = context.getFacet("username");
                if (bObject instanceof BString) {
                    this.setUsername(((BString)bObject).getString());
                }
            }
        }
    }

    public void doCancel(Context context) {
        this.canceled = true;
        super.doCancel(context);
    }

    public void run(Context context) throws Exception {
        int n;
        this.retrieveNavNodes();
        int n2 = n = this.nodes != null ? this.nodes.length : 0;
        if (this.getCommand() < 0 || n < 1) {
            return;
        }
        double d = 100.0 / (double)n;
        Exception exception = null;
        Context context2 = this.makeUserContext(context);
        switch (this.getCommand()) {
            case 0: {
                this.log().message("wbutil", "metadataBrowser.job.addSummary", new String[]{this.getPropName(), this.getMetadataValue().toString(context2)});
                for (int i = 0; i < n; ++i) {
                    Exception exception2 = this.addMeta(this.nodes[i], d * (double)i, d * (double)(i + 1), context2);
                    if (this.canceled) {
                        throw new JobCancelException();
                    }
                    if (exception != null) continue;
                    exception = exception2;
                }
                this.log().message("wbutil", "metadataBrowser.job.commandComplete");
                break;
            }
            case 1: {
                this.log().message("wbutil", "metadataBrowser.job.editSummary", new String[]{this.getPropName(), this.getMetadataValue().toString(context2)});
                for (int i = 0; i < n; ++i) {
                    Exception exception3 = this.editMeta(this.nodes[i], d * (double)i, d * (double)(i + 1), context2);
                    if (this.canceled) {
                        throw new JobCancelException();
                    }
                    if (exception != null) continue;
                    exception = exception3;
                }
                this.log().message("wbutil", "metadataBrowser.job.commandComplete");
                break;
            }
            case 2: {
                this.log().message("wbutil", "metadataBrowser.job.removeSummary", new String[]{this.getPropName()});
                for (int i = 0; i < n; ++i) {
                    Exception exception4 = this.deleteMeta(this.nodes[i], d * (double)i, d * (double)(i + 1), context2);
                    if (this.canceled) {
                        throw new JobCancelException();
                    }
                    if (exception != null) continue;
                    exception = exception4;
                }
                this.log().message("wbutil", "metadataBrowser.job.commandComplete");
            }
        }
        this.progress(100);
        if (exception != null) {
            throw exception;
        }
    }

    Exception addMeta(BINavNode bINavNode, double d, double d2, Context context) {
        int n;
        BINavNode[] bINavNodeArray;
        Exception exception;
        block19: {
            if (this.canceled) {
                throw new JobCancelException();
            }
            exception = null;
            try {
                if (!(bINavNode instanceof BIPropertyContainer)) break block19;
                bINavNodeArray = (BINavNode[])bINavNode;
                Property property = bINavNodeArray.getProperty(this.getPropName());
                BFacets bFacets = this.getPropFacets().isNull() ? null : this.getPropFacets();
                BUser bUser = context != null ? context.getUser() : null;
                n = 1;
                if (property == null) {
                    if (bUser != null && bINavNode instanceof BIProtected) {
                        try {
                            bUser.check((BIProtected)bINavNode, BPermissions.adminWrite);
                        }
                        catch (PermissionException permissionException) {
                            n = 0;
                        }
                    }
                    if (n != 0) {
                        bINavNodeArray.add(this.getPropName(), this.getMetadataValue().newCopy(true), this.getPropFlags() | 0x4000, bFacets, context);
                        this.log().success("wbutil", "metadataBrowser.job.added", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)});
                    }
                    break block19;
                }
                if (!this.getAddOrSet() || (bINavNodeArray.getFlags((Slot)property) & 0x4000) == 0) break block19;
                if (bUser != null && bINavNode instanceof BIProtected) {
                    try {
                        if ((bINavNodeArray.getFlags((Slot)property) & 0x100) != 0) {
                            bUser.check((BIProtected)bINavNode, BPermissions.operatorWrite);
                        } else {
                            bUser.check((BIProtected)bINavNode, BPermissions.adminWrite);
                        }
                    }
                    catch (PermissionException permissionException) {
                        n = 0;
                    }
                }
                if (n != 0) {
                    bINavNodeArray.set(property, this.getMetadataValue().newCopy(true), context);
                    bINavNodeArray.setFlags((Slot)property, 0x4000 | this.getPropFlags(), context);
                    if (bFacets != null && !property.isFrozen()) {
                        bINavNodeArray.setFacets((Slot)property, bFacets, context);
                    }
                    this.log().success("wbutil", "metadataBrowser.job.set", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)});
                }
            }
            catch (DuplicateSlotException duplicateSlotException) {
                this.log().message("wbutil", "metadataBrowser.job.alreadyExists", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)});
            }
            catch (Exception exception2) {
                this.log().failed("wbutil", "metadataBrowser.job.addFail", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)}, (Throwable)exception2);
                exception = exception2;
            }
        }
        if (this.getApplyDescendants()) {
            int n2;
            bINavNodeArray = this.findChildren(bINavNode);
            int n3 = n2 = bINavNodeArray != null ? bINavNodeArray.length : 0;
            if (n2 > 0) {
                double d3 = (d2 - d) / (double)n2;
                for (n = 0; n < bINavNodeArray.length; ++n) {
                    if (!this.acceptChild(bINavNodeArray[n])) continue;
                    Exception exception3 = this.addMeta(bINavNodeArray[n], d + d3 * (double)n, d + d3 * (double)(n + 1), context);
                    if (exception != null) continue;
                    exception = exception3;
                }
            }
        }
        this.progress((int)d2);
        return exception;
    }

    Exception editMeta(BINavNode bINavNode, double d, double d2, Context context) {
        BINavNode[] bINavNodeArray;
        Exception exception;
        block17: {
            if (this.canceled) {
                throw new JobCancelException();
            }
            exception = null;
            try {
                if (!(bINavNode instanceof BIPropertyContainer)) break block17;
                bINavNodeArray = (BINavNode[])bINavNode;
                Property property = bINavNodeArray.getProperty(this.getPropName());
                BUser bUser = context != null ? context.getUser() : null;
                boolean bl = true;
                if (property != null) {
                    if ((bINavNodeArray.getFlags((Slot)property) & 0x4000) == 0) break block17;
                    if (bUser != null && bINavNode instanceof BIProtected) {
                        try {
                            if ((bINavNodeArray.getFlags((Slot)property) & 0x100) != 0) {
                                bUser.check((BIProtected)bINavNode, BPermissions.operatorWrite);
                            } else {
                                bUser.check((BIProtected)bINavNode, BPermissions.adminWrite);
                            }
                        }
                        catch (PermissionException permissionException) {
                            bl = false;
                        }
                    }
                    if (bl) {
                        bINavNodeArray.set(property, this.getMetadataValue().newCopy(true), context);
                        bINavNodeArray.setFlags((Slot)property, bINavNodeArray.getFlags((Slot)property) | 0x4000, context);
                        this.log().success("wbutil", "metadataBrowser.job.set", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)});
                    }
                    break block17;
                }
                if (!this.getAddOrSet()) break block17;
                if (bUser != null && bINavNode instanceof BIProtected) {
                    try {
                        bUser.check((BIProtected)bINavNode, BPermissions.adminWrite);
                    }
                    catch (PermissionException permissionException) {
                        bl = false;
                    }
                }
                if (bl) {
                    bINavNodeArray.add(this.getPropName(), this.getMetadataValue().newCopy(true), 16384, null, context);
                    this.log().success("wbutil", "metadataBrowser.job.added", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)});
                }
            }
            catch (Exception exception2) {
                this.log().failed("wbutil", "metadataBrowser.job.setFail", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)}, (Throwable)exception2);
                exception = exception2;
            }
        }
        if (this.getApplyDescendants()) {
            int n;
            bINavNodeArray = this.findChildren(bINavNode);
            int n2 = n = bINavNodeArray != null ? bINavNodeArray.length : 0;
            if (n > 0) {
                double d3 = (d2 - d) / (double)n;
                for (int i = 0; i < bINavNodeArray.length; ++i) {
                    if (!this.acceptChild(bINavNodeArray[i])) continue;
                    Exception exception3 = this.editMeta(bINavNodeArray[i], d + d3 * (double)i, d + d3 * (double)(i + 1), context);
                    if (exception != null) continue;
                    exception = exception3;
                }
            }
        }
        this.progress((int)d2);
        return exception;
    }

    Exception deleteMeta(BINavNode bINavNode, double d, double d2, Context context) {
        BINavNode[] bINavNodeArray;
        Exception exception;
        block11: {
            if (this.canceled) {
                throw new JobCancelException();
            }
            exception = null;
            try {
                Property property;
                if (!(bINavNode instanceof BIPropertyContainer) || (property = (bINavNodeArray = (BINavNode[])bINavNode).getProperty(this.getPropName())) == null || (bINavNodeArray.getFlags((Slot)property) & 0x4000) == 0) break block11;
                BUser bUser = context != null ? context.getUser() : null;
                boolean bl = true;
                if (bUser != null && bINavNode instanceof BIProtected) {
                    try {
                        bUser.check((BIProtected)bINavNode, BPermissions.adminWrite);
                    }
                    catch (PermissionException permissionException) {
                        bl = false;
                    }
                }
                if (bl) {
                    bINavNodeArray.remove(this.getPropName(), context);
                    this.log().success("wbutil", "metadataBrowser.job.removed", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)});
                }
            }
            catch (NoSuchSlotException noSuchSlotException) {
                this.log().message("wbutil", "metadataBrowser.job.notExists", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)});
            }
            catch (Exception exception2) {
                this.log().failed("wbutil", "metadataBrowser.job.removeFail", new String[]{this.getPropName(), this.getNodeDisplayString(bINavNode, context)}, (Throwable)exception2);
                exception = exception2;
            }
        }
        if (this.getApplyDescendants()) {
            int n;
            bINavNodeArray = this.findChildren(bINavNode);
            int n2 = n = bINavNodeArray != null ? bINavNodeArray.length : 0;
            if (n > 0) {
                double d3 = (d2 - d) / (double)n;
                for (int i = 0; i < bINavNodeArray.length; ++i) {
                    if (!this.acceptChild(bINavNodeArray[i])) continue;
                    Exception exception3 = this.deleteMeta(bINavNodeArray[i], d + d3 * (double)i, d + d3 * (double)(i + 1), context);
                    if (exception != null) continue;
                    exception = exception3;
                }
            }
        }
        this.progress((int)d2);
        return exception;
    }

    String getNodeDisplayString(BINavNode bINavNode, Context context) {
        if (bINavNode == null) {
            return null;
        }
        BOrd bOrd = bINavNode.getNavOrd();
        if (bOrd == null || bOrd.isNull()) {
            SlotPath slotPath;
            if (bINavNode instanceof BComponent && (slotPath = ((BComponent)bINavNode).getSlotPath()) != null) {
                return slotPath.toDisplayString();
            }
            if (bINavNode instanceof BIPropertyContainer) {
                return ((BIPropertyContainer)bINavNode).getDisplayName(context);
            }
            return null;
        }
        return bOrd.relativizeToSession().toString(context);
    }

    boolean acceptChild(BINavNode bINavNode) {
        if (bINavNode instanceof BComponent && !((BComponent)bINavNode).isMounted()) {
            return false;
        }
        int n = this.nodes.length;
        for (int i = 0; i < n; ++i) {
            if (bINavNode != this.nodes[i]) continue;
            return false;
        }
        return true;
    }

    BINavNode[] findChildren(BINavNode bINavNode) {
        if (bINavNode instanceof BComponent) {
            return (BINavNode[])((BComponent)bINavNode).getChildComponents();
        }
        return bINavNode.getNavChildren();
    }

    BINavNode[] retrieveNavNodes() {
        BOrdList bOrdList = this.getNavOrds();
        int n = bOrdList.size();
        this.nodes = new BINavNode[n];
        for (int i = 0; i < n; ++i) {
            this.nodes[i] = (BINavNode)bOrdList.get(i).get((BObject)this);
        }
        return this.nodes;
    }

    static BPermissions getPermissionsFor(Object object, Context context) {
        try {
            if (object instanceof BIProtected) {
                return ((BIProtected)object).getPermissions(context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BPermissions.all;
    }

    Context makeUserContext(Context context) {
        String string = this.getUsername();
        if (string == null || string.length() < 1) {
            return context;
        }
        BUserService bUserService = BUserService.getService();
        BUser bUser = bUserService.getUser(string);
        if (bUser == null) {
            return context;
        }
        return new MetadataContext(context, bUser);
    }

    public BIcon getIcon() {
        switch (this.getCommand()) {
            case 0: {
                return addIcon;
            }
            case 1: {
                return editIcon;
            }
            case 2: {
                return removeIcon;
            }
        }
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class MetadataContext
    implements Context {
        BUser user;
        Context cx;

        public MetadataContext(Context context, BUser bUser) {
            this.user = bUser;
            this.cx = bUser != null ? new BasicContext(context, BFacets.make((String)"username", (BIDataValue)BString.make((String)bUser.getUsername()))) : context;
        }

        public Context getBase() {
            return this.cx;
        }

        public BUser getUser() {
            if (this.user != null) {
                return this.user;
            }
            if (this.cx != null) {
                return this.cx.getUser();
            }
            return null;
        }

        public BFacets getFacets() {
            if (this.cx != null) {
                return this.cx.getFacets();
            }
            return BFacets.NULL;
        }

        public BObject getFacet(String string) {
            return this.getFacets().get(string);
        }

        public String getLanguage() {
            if (this.cx != null) {
                return this.cx.getLanguage();
            }
            if (this.user != null) {
                return this.user.getLanguage();
            }
            return null;
        }
    }
}

